# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelSimple,
    cached_property,
)

from typing import ClassVar


class WidgetChangeType(ModelSimple):
    """
    Show the absolute or the relative change.

    :param value: Must be one of ["absolute", "relative"].
    :type value: str
    """

    allowed_values = {
        "absolute",
        "relative",
    }
    ABSOLUTE: ClassVar["WidgetChangeType"]
    RELATIVE: ClassVar["WidgetChangeType"]

    @cached_property
    def openapi_types(_):
        return {
            "value": (str,),
        }


WidgetChangeType.ABSOLUTE = WidgetChangeType("absolute")
WidgetChangeType.RELATIVE = WidgetChangeType("relative")
