# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
)


class UsageSyntheticsResponse(ModelNormal):
    @cached_property
    def openapi_types(_):
        from datadog_api_client.v1.model.usage_synthetics_hour import UsageSyntheticsHour

        return {
            "usage": ([UsageSyntheticsHour],),
        }

    attribute_map = {
        "usage": "usage",
    }

    def __init__(self_, *args, **kwargs):
        """
        Response containing the number of Synthetics API tests run for each hour for a given organization.

        :param usage: Array with the number of hourly Synthetics test run for a given organization.
        :type usage: [UsageSyntheticsHour], optional
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)
