# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
    datetime,
)


class UsageProfilingHour(ModelNormal):
    @cached_property
    def openapi_types(_):
        return {
            "avg_container_agent_count": (int,),
            "host_count": (int,),
            "hour": (datetime,),
            "org_name": (str,),
            "public_id": (str,),
        }

    attribute_map = {
        "avg_container_agent_count": "avg_container_agent_count",
        "host_count": "host_count",
        "hour": "hour",
        "org_name": "org_name",
        "public_id": "public_id",
    }

    def __init__(self_, *args, **kwargs):
        """
        The number of profiled hosts for each hour for a given organization.

        :param avg_container_agent_count: Get average number of container agents for that hour.
        :type avg_container_agent_count: int, optional

        :param host_count: Contains the total number of profiled hosts reporting during a given hour.
        :type host_count: int, optional

        :param hour: The hour for the usage.
        :type hour: datetime, optional

        :param org_name: The organization name.
        :type org_name: str, optional

        :param public_id: The organization public ID.
        :type public_id: str, optional
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)
