# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
)


class NotebookUpdateRequest(ModelNormal):
    @cached_property
    def openapi_types(_):
        from datadog_api_client.v1.model.notebook_update_data import NotebookUpdateData

        return {
            "data": (NotebookUpdateData,),
        }

    attribute_map = {
        "data": "data",
    }

    def __init__(self_, data, *args, **kwargs):
        """
        The description of a notebook update request.

        :param data: The data for a notebook update request.
        :type data: NotebookUpdateData
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)

        self_.data = data
