# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
)


class ListStreamWidgetDefinition(ModelNormal):
    validations = {
        "requests": {
            "max_items": 1,
            "min_items": 1,
        },
    }

    @cached_property
    def openapi_types(_):
        from datadog_api_client.v1.model.list_stream_widget_request import ListStreamWidgetRequest
        from datadog_api_client.v1.model.widget_time import WidgetTime
        from datadog_api_client.v1.model.widget_text_align import WidgetTextAlign
        from datadog_api_client.v1.model.list_stream_widget_definition_type import ListStreamWidgetDefinitionType

        return {
            "legend_size": (str,),
            "requests": ([ListStreamWidgetRequest],),
            "show_legend": (bool,),
            "time": (WidgetTime,),
            "title": (str,),
            "title_align": (WidgetTextAlign,),
            "title_size": (str,),
            "type": (ListStreamWidgetDefinitionType,),
        }

    attribute_map = {
        "legend_size": "legend_size",
        "requests": "requests",
        "show_legend": "show_legend",
        "time": "time",
        "title": "title",
        "title_align": "title_align",
        "title_size": "title_size",
        "type": "type",
    }

    def __init__(self_, requests, type, *args, **kwargs):
        """
        The list stream visualization displays a table of recent events in your application that
        match a search criteria using user-defined columns.

        :param legend_size: Available legend sizes for a widget. Should be one of "0", "2", "4", "8", "16", or "auto".
        :type legend_size: str, optional

        :param requests: Request payload used to query items.
        :type requests: [ListStreamWidgetRequest]

        :param show_legend: Whether or not to display the legend on this widget.
        :type show_legend: bool, optional

        :param time: Time setting for the widget.
        :type time: WidgetTime, optional

        :param title: Title of the widget.
        :type title: str, optional

        :param title_align: How to align the text on the widget.
        :type title_align: WidgetTextAlign, optional

        :param title_size: Size of the title.
        :type title_size: str, optional

        :param type: Type of the list stream widget.
        :type type: ListStreamWidgetDefinitionType
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)

        self_.requests = requests
        self_.type = type
