# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelSimple,
    cached_property,
)

from typing import ClassVar


class IFrameWidgetDefinitionType(ModelSimple):
    """
    Type of the iframe widget.

    :param value: If omitted defaults to "iframe". Must be one of ["iframe"].
    :type value: str
    """

    allowed_values = {
        "iframe",
    }
    IFRAME: ClassVar["IFrameWidgetDefinitionType"]

    @cached_property
    def openapi_types(_):
        return {
            "value": (str,),
        }


IFrameWidgetDefinitionType.IFRAME = IFrameWidgetDefinitionType("iframe")
