# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
)


class ApiKeyListResponse(ModelNormal):
    @cached_property
    def openapi_types(_):
        from datadog_api_client.v1.model.api_key import ApiKey

        return {
            "api_keys": ([ApiKey],),
        }

    attribute_map = {
        "api_keys": "api_keys",
    }

    def __init__(self_, *args, **kwargs):
        """
        List of API and application keys available for a given organization.

        :param api_keys: Array of API keys.
        :type api_keys: [ApiKey], optional
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)
