/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

public class AbstractBitSet {
    private final int mask;
    private final long[] units;

    public AbstractBitSet(int bits) {
        this.mask = -1 >>> 32 - bits;
        this.units = new long[1 << bits - 6];
    }

    protected int getMask() {
        return this.mask;
    }

    public void set(int value) {
        int mvalue = this.mask & value;
        long mask = 1L << (mvalue & 0x3F);
        int n = mvalue >> 6;
        this.units[n] = this.units[n] | mask;
    }

    public boolean contains(int value) {
        int mvalue = this.mask & value;
        long mask = 1L << (mvalue & 0x3F);
        return 0L != (this.units[mvalue >> 6] & mask);
    }

    public int indexOf(int value) {
        int mvalue = this.mask & value;
        int div64 = mvalue >> 6;
        int mod64 = mvalue & 0x3F;
        int count = 0;
        int i = 0;
        while (i < div64) {
            count += Long.bitCount(this.units[i]);
            ++i;
        }
        long bitMask = 1L << mod64;
        long andMask = -1L >>> 64 - mod64;
        long curValue = this.units[div64];
        return 0L != (curValue & bitMask) ? count : -(count += Long.bitCount(curValue & andMask)) - 1;
    }

    public int get(int index) {
        int unit = 0;
        int count = Long.bitCount(this.units[unit]);
        int before = 0;
        while (before + count <= index && unit + 1 < this.units.length) {
            before += count;
            count = Long.bitCount(this.units[++unit]);
        }
        if (before + count <= index || index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        long cur = this.units[unit];
        int clear = index - before;
        int i = 0;
        while (i < clear) {
            cur ^= Long.lowestOneBit(cur);
            ++i;
        }
        return (unit << 6) + Long.numberOfTrailingZeros(cur);
    }

    public long byteLength() {
        return 8L * (long)this.units.length;
    }
}

