/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse.util;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginUtil {
    public static <N extends Number, A> boolean allZeroInFirstColumn(NumberArrayOperations<N, A> naops, A[] matrix) {
        BooleanUnaryOperator<N, A> isZero = naops.getNumberOperators().booleanUnary(BooleanUnaryOperator.Id.isZero);
        boolean allZero = true;
        int r = 0;
        while (allZero && r < matrix.length) {
            allZero &= isZero.booleanOperate(matrix[r], 0);
            ++r;
        }
        return allZero;
    }

    public static <N extends Number, A> A[] addOriginRow(NumberArrayOperations<N, A> naops, A[] mx) {
        NumberOperators<N, A> nops = naops.getNumberOperators();
        ArrayOperations<A> aops = naops.getArrayOperations();
        NullaryOperator<N, A> zero = nops.nullary(NullaryOperator.Id.zero);
        NullaryOperator<N, A> one = nops.nullary(NullaryOperator.Id.one);
        int rows = aops.getRowCount(mx);
        int cols = aops.getColumnCount(mx);
        A[] merged = naops.getArrayOperations().newMatrix(rows + 1, cols);
        one.operate(merged[0], 0);
        int c = 1;
        while (c < cols) {
            zero.operate(merged[0], c);
            ++c;
        }
        aops.copyMatrixElements(mx, 0, 0, merged, 1, 0, rows, cols);
        return merged;
    }

    private OriginUtil() {
    }
}

