/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse.util;

import ch.javasoft.math.NumberMatrixConverter;
import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticConverter<N extends Number, A>
implements NumberMatrixConverter<A> {
    private final NumberArrayOperations<N, A> naops;
    private final ArrayOperations<A> aops;
    private final ConvertingUnaryOperator<Number, Number[], N, A> converter;

    public ArithmeticConverter(Arithmetic<N, A> arithmetic, Zero zero) {
        this.naops = arithmetic.getLinAlgOperations(zero).getNumberArrayOperations();
        this.aops = this.naops.getArrayOperations();
        this.converter = this.naops.getNumberOperators().converter();
    }

    @Override
    public A[] newMatrix(int rows, int cols) {
        return this.aops.newMatrix(rows, cols);
    }

    @Override
    public void copy(Number number, A[] dstMatrix, int row, int col) {
        Number val = (Number)this.converter.operate(number);
        this.naops.set(dstMatrix, row, col, val);
    }
}

