/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.config;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.factory.FactoryNotFoundException;
import ch.javasoft.factory.IllegalFactoryException;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultArrayOperations;
import ch.javasoft.math.array.impl.DefaultNumberArrayOperations;
import ch.javasoft.math.array.impl.DoubleArrayOperations;
import ch.javasoft.math.linalg.DefaultLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.linalg.impl.BigFractionGaussPivoting;
import ch.javasoft.math.linalg.impl.BigIntegerGaussPivoting;
import ch.javasoft.math.linalg.impl.DoubleGaussPivoting;
import ch.javasoft.math.operator.impl.BigFractionOperators;
import ch.javasoft.math.operator.impl.BigIntegerOperators;
import ch.javasoft.math.operator.impl.DoubleOperators;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.math.varint.array.VarIntGaussPivoting;
import ch.javasoft.math.varint.array.VarIntOperators;
import ch.javasoft.polco.Numeric;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.config.NumericFactory;
import ch.javasoft.polco.config.XmlAttribute;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.XmlUtil;
import ch.javasoft.xml.factory.XmlConfiguredFactory;
import java.math.BigInteger;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Arithmetic<N extends Number, A> {
    public static final Arithmetic<Double, double[]> DOUBLE = new Arithmetic<Double, double[]>("double"){

        @Override
        public Class<Double> getNumberClass() {
            return Double.class;
        }

        @Override
        public Class<double[]> getNumberArrayClass() {
            return double[].class;
        }

        @Override
        public LinAlgOperations<Double, double[]> getLinAlgOperations(Zero zero) {
            GaussPivotingFactory<Double, double[]> pivoting = DoubleGaussPivoting.ABS_G;
            return new DefaultLinAlgOperations<Double, double[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<double[]> getArrayOperations() {
            return DoubleArrayOperations.INSTANCE;
        }

        @Override
        public NumberOperators<Double, double[]> getNumberOperators(Zero zero) {
            return zero.mZeroPos == 0.0 ? DoubleOperators.DEFAULT : new DoubleOperators(zero);
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero();
        }
    };
    public static final Arithmetic<BigFraction, BigFraction[]> FRACTIONAL = new Arithmetic<BigFraction, BigFraction[]>("fractional"){

        @Override
        public Class<BigFraction[]> getNumberArrayClass() {
            return BigFraction[].class;
        }

        @Override
        public Class<BigFraction> getNumberClass() {
            return BigFraction.class;
        }

        @Override
        public LinAlgOperations<BigFraction, BigFraction[]> getLinAlgOperations(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            GaussPivotingFactory<BigFraction, BigFraction[]> pivoting = BigFractionGaussPivoting.LEN_PRODUCT_L;
            return new DefaultLinAlgOperations<BigFraction, BigFraction[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<BigFraction[]> getArrayOperations() {
            return new DefaultArrayOperations((Class<C[]>)BigFraction[].class);
        }

        @Override
        public NumberOperators<BigFraction, BigFraction[]> getNumberOperators(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            return BigFractionOperators.INSTANCE;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }
    };
    public static final Arithmetic<BigInteger, BigInteger[]> BIGINT = new Arithmetic<BigInteger, BigInteger[]>("bigint"){

        @Override
        public Class<BigInteger[]> getNumberArrayClass() {
            return BigInteger[].class;
        }

        @Override
        public Class<BigInteger> getNumberClass() {
            return BigInteger.class;
        }

        @Override
        public LinAlgOperations<BigInteger, BigInteger[]> getLinAlgOperations(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            GaussPivotingFactory<BigInteger, BigInteger[]> pivoting = BigIntegerGaussPivoting.LEN_L;
            return new DefaultLinAlgOperations<BigInteger, BigInteger[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<BigInteger[]> getArrayOperations() {
            return new DefaultArrayOperations((Class<C[]>)BigInteger[].class);
        }

        @Override
        public NumberOperators<BigInteger, BigInteger[]> getNumberOperators(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            return BigIntegerOperators.EXACT_DIVISION_INSTANCE;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }
    };
    public static final Arithmetic<BigInteger, BigInteger[]> RAWINT = new Arithmetic<BigInteger, BigInteger[]>("rawint"){

        @Override
        public Class<BigInteger[]> getNumberArrayClass() {
            return BigInteger[].class;
        }

        @Override
        public Class<BigInteger> getNumberClass() {
            return BigInteger.class;
        }

        @Override
        public LinAlgOperations<BigInteger, BigInteger[]> getLinAlgOperations(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            GaussPivotingFactory<BigInteger, BigInteger[]> pivoting = BigIntegerGaussPivoting.LEN_L;
            return new DefaultLinAlgOperations<BigInteger, BigInteger[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<BigInteger[]> getArrayOperations() {
            return new DefaultArrayOperations((Class<C[]>)BigInteger[].class);
        }

        @Override
        public NumberOperators<BigInteger, BigInteger[]> getNumberOperators(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            return BigIntegerOperators.EXACT_DIVISION_INSTANCE;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }
    };
    public static final Arithmetic<VarIntNumber, VarIntNumber[]> VARINT = new Arithmetic<VarIntNumber, VarIntNumber[]>("varint"){

        @Override
        public Class<VarIntNumber[]> getNumberArrayClass() {
            return VarIntNumber[].class;
        }

        @Override
        public Class<VarIntNumber> getNumberClass() {
            return VarIntNumber.class;
        }

        @Override
        public LinAlgOperations<VarIntNumber, VarIntNumber[]> getLinAlgOperations(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            GaussPivotingFactory<VarIntNumber, VarIntNumber[]> pivoting = VarIntGaussPivoting.LEN_L;
            return new DefaultLinAlgOperations<VarIntNumber, VarIntNumber[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<VarIntNumber[]> getArrayOperations() {
            return new DefaultArrayOperations((Class<C[]>)VarIntNumber[].class);
        }

        @Override
        public NumberOperators<VarIntNumber, VarIntNumber[]> getNumberOperators(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            return VarIntOperators.EXACT_DIVISION_INSTANCE;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }
    };
    public static final Arithmetic<VarIntNumber, VarIntNumber[]> ZIPINT = new Arithmetic<VarIntNumber, VarIntNumber[]>("zipint"){

        @Override
        public Class<VarIntNumber[]> getNumberArrayClass() {
            return VarIntNumber[].class;
        }

        @Override
        public Class<VarIntNumber> getNumberClass() {
            return VarIntNumber.class;
        }

        @Override
        public LinAlgOperations<VarIntNumber, VarIntNumber[]> getLinAlgOperations(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            GaussPivotingFactory<VarIntNumber, VarIntNumber[]> pivoting = VarIntGaussPivoting.LEN_L;
            return new DefaultLinAlgOperations<VarIntNumber, VarIntNumber[]>(this.getNumberArrayOperations(zero), pivoting);
        }

        @Override
        public ArrayOperations<VarIntNumber[]> getArrayOperations() {
            return new DefaultArrayOperations((Class<C[]>)VarIntNumber[].class);
        }

        @Override
        public NumberOperators<VarIntNumber, VarIntNumber[]> getNumberOperators(Zero zero) {
            if (zero.mZeroPos != 0.0) {
                throw new IllegalArgumentException("zero must be true zero: " + zero);
            }
            return VarIntOperators.EXACT_DIVISION_INSTANCE;
        }

        @Override
        public Zero getDefaultZero() {
            return new Zero(0.0);
        }
    };
    public static final Arithmetic[] VALUES = new Arithmetic[]{DOUBLE, FRACTIONAL, BIGINT, RAWINT, VARINT, ZIPINT};
    private final String name;

    private Arithmetic(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public abstract LinAlgOperations<N, A> getLinAlgOperations(Zero var1);

    public abstract ArrayOperations<A> getArrayOperations();

    public abstract Zero getDefaultZero();

    public NumberArrayOperations<N, A> getNumberArrayOperations(Zero zero) {
        return new DefaultNumberArrayOperations<N, A>(this.getNumberOperators(zero), this.getArrayOperations());
    }

    public abstract NumberOperators<N, A> getNumberOperators(Zero var1);

    public abstract Class<N> getNumberClass();

    public abstract Class<A> getNumberArrayClass();

    public <R> R callback(ArithmeticCallback<R> callback) throws Exception {
        return callback.callback(this);
    }

    public <U extends Numeric, T extends U> T createNumeric(Class<U> clazz, Element config) throws IllegalFactoryException, ConfigException, FactoryNotFoundException {
        Class<NumericFactory> numFacClass;
        Class<?> factoryClass;
        String factoryClassName = config.attributeValue(XmlAttribute.factory.getXmlName());
        if (factoryClassName == null) {
            throw new ConfigException("factory class-name attribute not found: " + XmlAttribute.factory.getXmlName(), XmlUtil.getElementPath(config, true));
        }
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new FactoryNotFoundException(factoryClassName, e);
        }
        try {
            numFacClass = factoryClass.asSubclass(NumericFactory.class);
        }
        catch (ClassCastException e) {
            throw new IllegalFactoryException("not an instance of " + NumericFactory.class.getName() + ": " + factoryClass.getName());
        }
        return this.createNumeric(clazz, numFacClass, config);
    }

    public <U extends Numeric, T extends U> T createNumeric(Class<U> clazz, Class<? extends NumericFactory> factoryClass, Element config) throws IllegalFactoryException, ConfigException {
        NumericFactory factory;
        try {
            factory = factoryClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalFactoryException("could not instantiated factory " + factoryClass.getName() + ", e=" + e, e);
        }
        catch (InstantiationException e) {
            throw new IllegalFactoryException("could not instantiated factory " + factoryClass.getName() + ", e=" + e, e);
        }
        return this.createNumeric(clazz, factory, config);
    }

    public <U extends Numeric, T extends U> T createNumeric(Class<U> clazz, NumericFactory factory, Element config) throws ConfigException, IllegalFactoryException {
        XmlConfiguredFactory typedFactory = factory.createTypedFactory(this);
        Numeric numeric = typedFactory.create(config);
        try {
            return (T)((Numeric)clazz.cast(numeric));
        }
        catch (ClassCastException e) {
            throw new IllegalFactoryException("factory " + factory + " created not an instance of " + clazz.getName() + ": " + numeric);
        }
    }

    /* synthetic */ Arithmetic(String string, Arithmetic arithmetic) {
        this(string);
    }
}

