/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.Annotateable;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentMetabolicNetwork;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import ch.javasoft.metabolic.compartment.CompartmentMetaboliteRatio;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.util.genarr.ArrayIterable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbmlParser {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String SBML_SCHEMA2_URL = "http://www.sbml.org/sbml/level2";
    public final String compartmentName;
    public final boolean compartmentOnly;
    public final boolean validateSbml;

    public SbmlParser() {
        this("external", false, true);
    }

    public SbmlParser(String externalCompartmentName) {
        this(externalCompartmentName, false, true);
    }

    public SbmlParser(String externalCompartmentName, boolean validateSbmlSchema) {
        this(externalCompartmentName, false, validateSbmlSchema);
    }

    public SbmlParser(String externalCompartmentName, boolean parseCompartmentOnly, boolean validateSbmlSchema) {
        this.compartmentName = externalCompartmentName;
        this.compartmentOnly = parseCompartmentOnly;
        this.validateSbml = validateSbmlSchema;
    }

    public MetabolicNetwork parse(File file) throws DocumentException, IOException, FileNotFoundException {
        return this.parse(this.createSAXReader(this.validateSbml).read(file));
    }

    public MetabolicNetwork parse(InputStream in) throws DocumentException, IOException {
        return this.parse(this.createSAXReader(this.validateSbml).read(in));
    }

    public MetabolicNetwork parse(URL url) throws DocumentException, IOException {
        return this.parse(this.createSAXReader(this.validateSbml).read(url));
    }

    public MetabolicNetwork parse(File file, String modelName) throws DocumentException, IOException, FileNotFoundException {
        return this.parse(this.createSAXReader(this.validateSbml).read(file), modelName);
    }

    public MetabolicNetwork parse(InputStream in, String modelName) throws DocumentException, IOException {
        return this.parse(this.createSAXReader(this.validateSbml).read(in), modelName);
    }

    public MetabolicNetwork parse(URL url, String modelName) throws DocumentException, IOException {
        return this.parse(this.createSAXReader(this.validateSbml).read(url), modelName);
    }

    public MetabolicNetwork parse(Document sbml) throws DocumentException {
        return this.parse(sbml, null);
    }

    protected SAXReader createSAXReader(boolean validate) {
        if (!validate) {
            return new SAXReader(validate);
        }
        return new SAXReader(validate){

            protected XMLReader createXMLReader() throws SAXException {
                XMLReader reader = super.createXMLReader();
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                try {
                    reader.setProperty(SbmlParser.JAXP_SCHEMA_LANGUAGE, SbmlParser.W3C_XML_SCHEMA);
                    reader.setProperty(SbmlParser.JAXP_SCHEMA_SOURCE, new URL(SbmlParser.SBML_SCHEMA2_URL).openStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return reader;
            }
        };
    }

    public MetabolicNetwork parse(Document sbml, String modelName) throws DocumentException {
        Element model;
        Element root = sbml.getRootElement();
        if (modelName == null) {
            model = root.element("model");
        } else {
            Node node = root.selectSingleNode("model[@name=\"" + modelName + "\"]");
            if (node instanceof Element) {
                model = (Element)node;
            } else {
                throw new IllegalArgumentException("model not found: " + modelName);
            }
        }
        LinkedHashMap<Annotateable, Map<String, String>> annotations = new LinkedHashMap<Annotateable, Map<String, String>>();
        Map<String, CompartmentMetabolite> metas = this.parseMetabolites(model.element("listOfSpecies"), annotations);
        Set<CompartmentReaction> reacts = SbmlParser.parseReactions(model.element("listOfReactions"), metas, annotations);
        return this.createNetwork(model, metas, reacts, annotations);
    }

    private Map<String, CompartmentMetabolite> parseMetabolites(Element elMetas, Map<Annotateable, Map<String, String>> annotations) throws DocumentException {
        LinkedHashMap<String, CompartmentMetabolite> metas = new LinkedHashMap<String, CompartmentMetabolite>();
        Iterator it = elMetas.elementIterator("species");
        while (it.hasNext()) {
            CompartmentMetabolite meta;
            Element el = (Element)it.next();
            String metaId = el.attributeValue("id");
            String metaName = el.attributeValue("name");
            String compartment = el.attributeValue("compartment");
            CompartmentMetabolite compartmentMetabolite = meta = metaName == null ? new CompartmentMetabolite(metaId, compartment) : new CompartmentMetabolite(metaId, metaName, compartment);
            if (metas.put(metaId, meta) != null) {
                throw new DocumentException("duplicate metabolite: " + metaId);
            }
            SbmlParser.parseAnnotations(el, meta, annotations);
        }
        return metas;
    }

    private static Set<CompartmentReaction> parseReactions(Element elReacts, Map<String, CompartmentMetabolite> metas, Map<Annotateable, Map<String, String>> annotations) throws DocumentException {
        LinkedHashSet<CompartmentReaction> reacts = new LinkedHashSet<CompartmentReaction>();
        Iterator<Element> it = SbmlParser.elementIterator(elReacts, "reaction");
        while (it.hasNext()) {
            boolean any = false;
            Element el = it.next();
            String reactId = el.attributeValue("id");
            String reactName = el.attributeValue("name");
            boolean reversible = !Boolean.FALSE.toString().equalsIgnoreCase(el.attributeValue("reversible"));
            ArrayList<CompartmentMetaboliteRatio> ratios = new ArrayList<CompartmentMetaboliteRatio>();
            Iterator<Element> eduIt = SbmlParser.elementIterator(el.element("listOfReactants"), "speciesReference");
            any |= eduIt.hasNext();
            while (eduIt.hasNext()) {
                Element edu = eduIt.next();
                CompartmentMetaboliteRatio ratio = SbmlParser.parseMetaboliteRatio(el, edu, metas, true);
                ratios.add(ratio);
            }
            Iterator<Element> proIt = SbmlParser.elementIterator(el.element("listOfProducts"), "speciesReference");
            any |= proIt.hasNext();
            while (proIt.hasNext()) {
                Element pro = proIt.next();
                CompartmentMetaboliteRatio ratio = SbmlParser.parseMetaboliteRatio(el, pro, metas, false);
                ratios.add(ratio);
            }
            if (!any) {
                throw new DocumentException("reaction has neither educts nor products: " + reactId + "/" + reactName);
            }
            CompartmentReaction reac = new CompartmentReaction(reactId, reactName, ratios, reversible);
            if (!reacts.add(reac)) {
                throw new DocumentException("duplicate reaction: " + reactId);
            }
            SbmlParser.parseAnnotations(el, reac, annotations);
        }
        return reacts;
    }

    private static CompartmentMetaboliteRatio parseMetaboliteRatio(Element elReact, Element elRatio, Map<String, CompartmentMetabolite> metas, boolean educt) throws DocumentException {
        String metaId = elRatio.attributeValue("species");
        String sStoich = elRatio.attributeValue("stoichiometry");
        double stoich = sStoich == null ? 1.0 : Double.parseDouble(sStoich);
        CompartmentMetabolite meta = metas.get(metaId);
        if (meta == null) {
            throw new DocumentException("metabolite '" + metaId + "' not found for reaction: " + elReact.attributeValue("id"));
        }
        return new CompartmentMetaboliteRatio(meta, educt ? -stoich : stoich);
    }

    private static void parseAnnotations(Element element, Annotateable annotateable, Map<Annotateable, Map<String, String>> annotations) throws DocumentException {
        Iterator noteIt = element.elementIterator("notes");
        while (noteIt.hasNext()) {
            Element notes = (Element)noteIt.next();
            Iterator htmlpIt = notes.elementIterator("html:p");
            while (htmlpIt.hasNext()) {
                Element note = (Element)htmlpIt.next();
                String txt = note.getText();
                String[] keyVal = txt.trim().split(":");
                if (keyVal.length != 2) {
                    throw new DocumentException("invalid annotation format: " + txt);
                }
                String key = keyVal[0].trim();
                String val = keyVal[1].trim();
                SbmlParser.getAnnotationMap(annotations, annotateable, true).put(key, val);
            }
        }
    }

    private CompartmentMetabolicNetwork createNetwork(Element model, Map<String, CompartmentMetabolite> metas, Set<CompartmentReaction> reactions, Map<Annotateable, Map<String, String>> annotations) throws DocumentException {
        CompartmentMetabolicNetwork net;
        if (this.compartmentOnly) {
            LinkedHashSet<CompartmentMetabolite> cMetas = new LinkedHashSet<CompartmentMetabolite>();
            LinkedHashSet cReacts = new LinkedHashSet();
            for (CompartmentMetabolite meta : metas.values()) {
                if (!this.compartmentName.equals(meta.getCompartment()) || cMetas.add(meta)) continue;
                throw new DocumentException("duplicate metabolite: " + meta.getName());
            }
            for (CompartmentReaction react : reactions) {
                CompartmentReaction cReact;
                CompartmentReaction xReact;
                CompartmentMetaboliteRatio ratio;
                CompartmentMetabolite cMeta;
                ArrayIterable<? extends CompartmentMetaboliteRatio> ratios = react.getMetabolieRatiosForCompartment(this.compartmentName);
                if (ratios.isEmpty()) continue;
                ArrayList<? extends CompartmentMetaboliteRatio> newRatios = new ArrayList<CompartmentMetaboliteRatio>(ratios.toGenericArray(false));
                if (!react.getEductRatiosExcludeCompartment(this.compartmentName).isEmpty()) {
                    cMeta = new CompartmentMetabolite(SbmlParser.getExchangeMetaboliteName(react, false), this.compartmentName);
                    ratio = new CompartmentMetaboliteRatio(cMeta, -1.0);
                    xReact = SbmlParser.createExchangeReaction(cMeta, true, react.getConstraints().isReversible());
                    newRatios.add(ratio);
                    if (!cMetas.add(cMeta)) {
                        throw new DocumentException("duplicate metabolite: " + cMeta.getName());
                    }
                    if (!cReacts.add(xReact)) {
                        throw new DocumentException("duplicate reaction: " + xReact.getName());
                    }
                }
                if (!react.getProductRatiosExcludeCompartment(this.compartmentName).isEmpty()) {
                    cMeta = new CompartmentMetabolite(SbmlParser.getExchangeMetaboliteName(react, true), this.compartmentName);
                    ratio = new CompartmentMetaboliteRatio(cMeta, 1.0);
                    xReact = SbmlParser.createExchangeReaction(cMeta, false, react.getConstraints().isReversible());
                    newRatios.add(ratio);
                    if (!cMetas.add(cMeta)) {
                        throw new DocumentException("duplicate metabolite: " + cMeta.getName());
                    }
                    if (!cReacts.add(xReact)) {
                        throw new DocumentException("duplicate reaction: " + xReact.getName());
                    }
                }
                if (cReacts.add(cReact = new CompartmentReaction(react.getName(), react.getFullName(), newRatios, react.getConstraints().isReversible()))) continue;
                throw new DocumentException("duplicate reaction: " + cReact.getName());
            }
            net = new CompartmentMetabolicNetwork((Iterable<? extends CompartmentMetabolite>)cMetas, cReacts);
        } else {
            for (CompartmentMetabolite meta : metas.values()) {
                CompartmentReaction react;
                if (!this.compartmentName.equals(meta.getCompartment()) || reactions.add(react = SbmlParser.createExchangeReaction(meta, false, true))) continue;
                throw new DocumentException("duplicate reaction: " + react.getName());
            }
            net = new CompartmentMetabolicNetwork((Iterable<? extends CompartmentMetabolite>)metas.values(), (Iterable<? extends CompartmentReaction>)reactions);
        }
        Element elCmps = model.element("listOfCompartments");
        for (Element elCmp : elCmps.elements("compartment")) {
            String cmpName = elCmp.attributeValue("id");
            String cmpFullName = elCmp.attributeValue("name");
            if (cmpFullName == null || cmpFullName.equals(cmpName)) continue;
            net.setCompartmentFullName(cmpName, cmpFullName);
        }
        SbmlParser.parseAnnotations(model, net, annotations);
        for (Annotateable elem : annotations.keySet()) {
            for (Map.Entry<String, String> annot : annotations.get(elem).entrySet()) {
                net.addAnnotation(elem, annot.getKey(), annot.getValue());
            }
        }
        return net;
    }

    private static CompartmentReaction createExchangeReaction(CompartmentMetabolite meta, boolean uptake, boolean reversible) {
        CompartmentMetaboliteRatio ratio = new CompartmentMetaboliteRatio(meta, uptake ? 1.0 : -1.0);
        String reactName = SbmlParser.getExchangeReactionName(meta);
        String reactFullName = SbmlParser.getExchangeReactionFullName(meta);
        return new CompartmentReaction(reactName, reactFullName, new CompartmentMetaboliteRatio[]{ratio}, reversible);
    }

    private static String getExchangeReactionName(Metabolite meta) {
        return "xchg_" + meta.getName();
    }

    private static String getExchangeReactionFullName(Metabolite meta) {
        return "exchange reaction for " + meta.getName();
    }

    private static String getExchangeMetaboliteName(Reaction reac, boolean product) {
        return String.valueOf(product ? "xpro_" : "xedu_") + reac.getName();
    }

    private static Map<String, String> getAnnotationMap(Map<Annotateable, Map<String, String>> annotations, Annotateable element, boolean createIfNeeded) {
        Map<String, String> elMap = annotations.get(element);
        if (elMap == null && createIfNeeded) {
            elMap = new LinkedHashMap<String, String>();
            annotations.put(element, elMap);
        }
        return elMap;
    }

    private static Iterator<Element> elementIterator(Element parent, String childName) {
        return parent == null ? Collections.emptyList().iterator() : parent.elementIterator(childName);
    }
}

