/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import ch.javasoft.metabolic.compartment.CompartmentMetaboliteRatio;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.parse.LogPkg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PalssonParser {
    private final boolean checkConsistency;
    private static final Logger LOG = LogPkg.LOGGER;
    private static final String P_TAB = "\\t";
    private static final String P_NAME = "\"([^\\t^\"]*)\"";
    private static final String P_LINE_3 = "\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\".*";
    private static final String P_LINE_2 = "\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\".*";
    private static Pattern PAT_LINE_3 = Pattern.compile("\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\".*");
    private static Pattern PAT_LINE_2 = Pattern.compile("\"([^\\t^\"]*)\"\\t\"([^\\t^\"]*)\".*");
    private static final Pattern PTN_META = Pattern.compile("([^\\[\\]]+)\\[([^\\[\\]]+)\\]");

    public PalssonParser() {
        this(true);
    }

    public PalssonParser(boolean checkConsistency) {
        this.checkConsistency = checkConsistency;
    }

    public CompartmentReaction[] parseReactions(File file) throws IOException {
        return this.parseReactions(file, null);
    }

    public CompartmentReaction[] parseReactions(InputStream in) throws IOException {
        return this.parseReactions(new InputStreamReader(in));
    }

    public CompartmentReaction[] parseReactions(Reader reader) throws IOException {
        return this.parseReactions(reader, null);
    }

    public CompartmentReaction[] parseReactions(InputStream in, Pattern ptnExternalMetabolite) throws IOException {
        return this.parseReactions(new InputStreamReader(in), ptnExternalMetabolite);
    }

    public CompartmentReaction[] parseReactions(File file, Pattern ptnExternalMetabolite) throws IOException {
        return this.parseReactions(new FileReader(file), ptnExternalMetabolite);
    }

    public CompartmentReaction[] parseReactions(Reader reader, Pattern ptnExternalMetabolite) throws IOException {
        return this.parseReactions(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader), ptnExternalMetabolite);
    }

    public CompartmentReaction[] parseReactions(BufferedReader reader, Pattern ptnExternalMetabolite) throws IOException {
        ArrayList<CompartmentReaction> reacts = new ArrayList<CompartmentReaction>();
        int lineNo = 0;
        String line = reader.readLine();
        ++lineNo;
        while (line != null) {
            String formula;
            String shortName;
            Matcher matcher = PAT_LINE_3.matcher(line);
            if (matcher.matches()) {
                shortName = matcher.group(1);
                formula = matcher.group(3);
            } else {
                matcher = PAT_LINE_2.matcher(line);
                if (!matcher.matches()) {
                    throw new IOException("syntax error on line " + lineNo + ": " + line);
                }
                shortName = matcher.group(1);
                formula = matcher.group(2);
            }
            CompartmentReaction react = PalssonParser.parseReaction(shortName, formula, lineNo);
            reacts.add(react);
            line = reader.readLine();
            ++lineNo;
        }
        PalssonParser.addExchangeReactions(reacts, ptnExternalMetabolite);
        if (this.checkConsistency) {
            PalssonParser.checkConsistency(reacts);
        }
        CompartmentReaction[] result = new CompartmentReaction[reacts.size()];
        reacts.toArray(result);
        return result;
    }

    private static void addExchangeReactions(List<CompartmentReaction> reactions, Pattern ptnExternalMetabolite) throws IOException {
        if (ptnExternalMetabolite == null) {
            return;
        }
        LOG.info("adding exchange reactions for metabolite pattern: " + ptnExternalMetabolite.toString());
        HashSet<CompartmentMetabolite> xtMetas = new HashSet<CompartmentMetabolite>();
        for (CompartmentReaction react : reactions) {
            for (CompartmentMetaboliteRatio compartmentMetaboliteRatio : react.getMetaboliteRatios()) {
                if (!ptnExternalMetabolite.matcher(compartmentMetaboliteRatio.getMetabolite().getName()).matches()) continue;
                xtMetas.add(compartmentMetaboliteRatio.getMetabolite());
            }
        }
        for (CompartmentMetabolite meta : xtMetas) {
            String string = "ex_" + meta.getName();
            CompartmentReaction reac = new CompartmentReaction(string, string, new CompartmentMetaboliteRatio[]{new CompartmentMetaboliteRatio(meta, 1.0)}, true);
            reactions.add(reac);
            LOG.fine("added exchange reaction '" + reac.getName() + "': " + reac);
        }
    }

    private static CompartmentReaction parseReaction(String name, String formula, int lineNo) throws IOException {
        boolean parseProds;
        String[] reacTypeRev = new String[]{"<-->", "<==>", "<->", "<=>"};
        String[] reacTypeIrrevFw = new String[]{"-->", "==>", "->", "=>"};
        String[] reacTypeIrrevBw = new String[]{"<--", "<==", "<-", "<="};
        String[] locationPrefixes = new String[]{"[c]", "[e]", "[g]", "[m]", "[n]", "[r]", "[v]", "[x]", ""};
        Pattern[] locationPatterns = new Pattern[]{Pattern.compile("\\[c\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[e\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[g\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[m\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[n\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[r\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[v\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("\\[x\\][\\s]*:?[\\s]*(.*)[\\s]*"), Pattern.compile("[\\s]*(.*)[\\s]*")};
        ReactionConstraints constraints = null;
        String reacType = null;
        boolean backwards = false;
        int ii = 0;
        while (constraints == null && ii < reacTypeRev.length) {
            if (formula.contains(reacTypeRev[ii])) {
                constraints = DefaultReactionConstraints.DEFAULT_REVERSIBLE;
                reacType = reacTypeRev[ii];
                backwards = false;
            } else if (formula.contains(reacTypeIrrevFw[ii])) {
                constraints = DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
                reacType = reacTypeIrrevFw[ii];
                backwards = false;
            } else if (formula.contains(reacTypeIrrevBw[ii])) {
                constraints = DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
                reacType = reacTypeIrrevBw[ii];
                backwards = true;
            }
            ++ii;
        }
        if (constraints == null) {
            throw new IOException("not an irreversible, nor a reversible reaction at line " + lineNo + ": " + formula);
        }
        String loc = null;
        int ii2 = 0;
        while (loc == null && ii2 < locationPatterns.length) {
            Matcher matcher = locationPatterns[ii2].matcher(formula);
            if (matcher.matches()) {
                loc = locationPrefixes[ii2];
                formula = matcher.group(1);
            }
            ++ii2;
        }
        if (loc == null) {
            throw new IOException("none of the reaction patterns matches at line " + lineNo + ": " + formula);
        }
        ArrayList<CompartmentMetaboliteRatio> ratios = new ArrayList<CompartmentMetaboliteRatio>();
        HashMap<String, CompartmentMetabolite> metas = new HashMap<String, CompartmentMetabolite>();
        String[] parts = formula.split("[\\s]*" + reacType + "[\\s]*");
        if (parts.length == 2 && parts[0].length() == 0) {
            parts = new String[]{parts[1]};
        }
        boolean bl = parseProds = !backwards;
        if (parts.length == 2) {
            PalssonParser.parseRatios(ratios, metas, loc, parts[0], !parseProds, lineNo);
            PalssonParser.parseRatios(ratios, metas, loc, parts[1], parseProds, lineNo);
        } else if (parts.length == 1) {
            if (formula.matches(".*" + reacType + "[\\s]*")) {
                PalssonParser.parseRatios(ratios, metas, loc, parts[0], !parseProds, lineNo);
            } else {
                PalssonParser.parseRatios(ratios, metas, loc, parts[0], parseProds, lineNo);
            }
        } else {
            throw new IOException("expected substrates and/or products, but found " + parts.length + " parts at line " + lineNo + ": " + formula);
        }
        CompartmentMetaboliteRatio[] arrRatios = new CompartmentMetaboliteRatio[ratios.size()];
        ratios.toArray(arrRatios);
        return new CompartmentReaction(name, name, arrRatios, constraints);
    }

    private static void parseRatios(List<CompartmentMetaboliteRatio> result, Map<String, CompartmentMetabolite> metas, String locPostfix, String formula, boolean products, int lineNo) throws IOException {
        String[] stringArray;
        if (formula.contains("+")) {
            stringArray = formula.split("[\\s]+\\+[\\s]+");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = formula;
        }
        String[] parts = stringArray;
        int ii = 0;
        while (ii < parts.length) {
            double coeff;
            String metaName;
            String part = parts[ii].replaceAll("[\\s]+", " ").trim();
            int spaceIndex = part.indexOf(32);
            if (spaceIndex == -1) {
                metaName = String.valueOf(part) + locPostfix;
                coeff = 1.0;
            } else {
                metaName = String.valueOf(part.substring(spaceIndex + 1)) + locPostfix;
                String stoich = part.substring(0, spaceIndex);
                if (stoich.startsWith("(") && stoich.endsWith(")")) {
                    stoich = stoich.substring(1, stoich.length() - 1);
                }
                coeff = PalssonParser.parseRatio(stoich, lineNo);
            }
            CompartmentMetabolite meta = PalssonParser.getMetabolite(metas, metaName);
            CompartmentMetaboliteRatio ratio = new CompartmentMetaboliteRatio(meta, products ? coeff : -coeff);
            result.add(ratio);
            ++ii;
        }
    }

    private static CompartmentMetabolite getMetabolite(Map<String, CompartmentMetabolite> metas, String name) throws IOException {
        CompartmentMetabolite meta = metas.get(name);
        if (meta == null) {
            String[] rawNameCmpName = PalssonParser.getNameCompartmentForMetabolite(name);
            meta = new CompartmentMetabolite(name, rawNameCmpName[1]);
            metas.put(name, meta);
        }
        return meta;
    }

    private static double parseRatio(String str, int lineNo) throws IOException {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception ex) {
            throw new IOException("cannot parse stoichiometric quantity '" + str + "' at line " + lineNo + ", e=" + ex);
        }
    }

    private static String[] getNameCompartmentForMetabolite(String name) throws IOException {
        String cmpName;
        String rawName;
        Matcher matcher = PTN_META.matcher(name);
        if (matcher.matches()) {
            rawName = matcher.group(1);
            cmpName = matcher.group(2);
        } else {
            rawName = name;
            cmpName = "default";
            LOG.finest("cannot parse compartment metabolite: " + name);
        }
        return new String[]{rawName, cmpName};
    }

    private static void checkConsistency(Iterable<CompartmentReaction> reacts) throws IOException {
        TreeMap map = new TreeMap(Collator.getInstance());
        for (CompartmentReaction compartmentReaction : reacts) {
            for (CompartmentMetaboliteRatio compartmentMetaboliteRatio : compartmentReaction.getMetaboliteRatios()) {
                ArrayList<CompartmentReaction> cmpList;
                CompartmentMetabolite meta = compartmentMetaboliteRatio.getMetabolite();
                String[] nameCmp = PalssonParser.getNameCompartmentForMetabolite(meta.getName());
                String rawName = nameCmp[0];
                String cmpName = nameCmp[1];
                TreeMap<Object, ArrayList<CompartmentReaction>> metaMap = (TreeMap<Object, ArrayList<CompartmentReaction>>)map.get(rawName);
                if (metaMap == null) {
                    metaMap = new TreeMap<Object, ArrayList<CompartmentReaction>>(Collator.getInstance());
                    map.put(rawName, metaMap);
                }
                if ((cmpList = (ArrayList<CompartmentReaction>)metaMap.get(cmpName)) == null) {
                    cmpList = new ArrayList<CompartmentReaction>();
                    metaMap.put(cmpName, cmpList);
                }
                cmpList.add(compartmentReaction);
            }
        }
        for (String string : map.keySet()) {
            for (String string2 : ((TreeMap)map.get(string)).keySet()) {
                if (((List)((TreeMap)map.get(string)).get(string2)).size() >= 2) continue;
                CompartmentReaction reac = (CompartmentReaction)((List)((TreeMap)map.get(string)).get(string2)).get(0);
                LOG.warning("[DEAD-END-META] " + string + '[' + string2 + "] / " + reac.getFullName() + ": " + reac);
            }
        }
        for (String string : map.keySet()) {
            if (((TreeMap)map.get(string)).keySet().size() < 2) continue;
            ArrayList arrayList = new ArrayList(((TreeMap)map.get(string)).keySet());
            int cmp1 = 0;
            while (cmp1 < arrayList.size()) {
                int cmp2 = cmp1 + 1;
                while (cmp2 < arrayList.size()) {
                    String cmpName1 = (String)arrayList.get(cmp1);
                    String cmpName2 = (String)arrayList.get(cmp2);
                    boolean hasTransport = false;
                    for (CompartmentReaction react : (List)((TreeMap)map.get(string)).get(cmpName1)) {
                        if (!((List)((TreeMap)map.get(string)).get(cmpName2)).contains(react)) continue;
                        hasTransport = true;
                        break;
                    }
                    if (!hasTransport) {
                        LOG.warning("[NO-TRANSPORT] " + string + "[" + cmpName1 + "] <--> [" + cmpName2 + "]");
                        for (CompartmentReaction react : (List)((TreeMap)map.get(string)).get(cmpName1)) {
                            if (react.isCompartmentInternal()) {
                                LOG.info("\t" + react.getName() + "[" + cmpName1 + "]: " + react);
                                continue;
                            }
                            LOG.warning("\t" + react.getName() + "[" + cmpName1 + "]: " + react);
                        }
                        for (CompartmentReaction react : (List)((TreeMap)map.get(string)).get(cmpName2)) {
                            if (react.isCompartmentInternal()) {
                                LOG.info("\t" + react.getName() + "[" + cmpName2 + "]: " + react);
                                continue;
                            }
                            LOG.warning("\t" + react.getName() + "[" + cmpName2 + "]: " + react);
                        }
                    }
                    ++cmp2;
                }
                ++cmp1;
            }
        }
    }

    private static String getReactionNames(Iterable<CompartmentReaction> reacts) {
        StringBuilder sb = new StringBuilder();
        for (CompartmentReaction react : reacts) {
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            sb.append(react.getName());
        }
        return sb.toString();
    }
}

