/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.canonical.AbstractCanonicalColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.CanonicalUtil;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalFractionalColumnInspectorModifier
extends AbstractCanonicalColumnInspectorModifier<BigFraction, BigFraction[]> {
    @Override
    protected BigFraction[] copyOf(BigFraction[] numericVals) {
        return Arrays.copyOf(numericVals, numericVals.length);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<BigFraction, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, BigFraction[] numericVals, IterationStateModel iteration) {
        ReadableMatrix<BigFraction> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperIndex = iteration.getHyperplaneIndex();
        BigFraction val = (BigFraction)CanonicalUtil.getInequalityValue(stoich, (int)hyperIndex, (Number[])numericVals, (int[])model.getReactionSorting());
        return val.signum();
    }

    @Override
    public BigFraction[] mergeNumeric(ColumnHome<BigFraction, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, BigFraction[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, BigFraction[] numericValsCol2, IterationStepModel iteration) {
        ReadableMatrix<BigFraction> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperplaneIndex = iteration.getCurrentState().getHyperplaneIndex();
        BigFraction mulCol1 = (BigFraction)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol2, (int[])model.getReactionSorting());
        BigFraction mulCol2 = (BigFraction)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol1, (int[])model.getReactionSorting());
        NumberOperations<BigFraction> numOps = columnHome.getNumberOperations();
        return (BigFraction[])ColumnUtil.mergeNumeric((EfmModel)model, numOps, (Number)mulCol1, (Number[])numericValsCol1, (Number)mulCol2, (Number[])numericValsCol2, (boolean)false);
    }
}

