/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.impl;

import ch.javasoft.lang.management.JVMTimer;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.CompressionUtil;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.impl.LogPkg;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.EfmModelFactory;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.util.MatrixUtil;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleDescriptionImpl
implements ElementaryFluxModes.Impl {
    private static final Logger LOG = LogPkg.LOGGER;
    private Config mConfig;
    private EfmModelFactory mEfmModelFactory;
    private MemoryFactory mMemoryFactory;

    public AbstractDoubleDescriptionImpl(Config config, EfmModelFactory modelFactory, MemoryFactory memoryFactory) {
        this.mConfig = config;
        this.mEfmModelFactory = modelFactory;
        this.mMemoryFactory = memoryFactory;
    }

    @Override
    public Config getConfig() {
        return this.mConfig;
    }

    protected MemoryFactory getMemoryFactory() {
        return this.mMemoryFactory;
    }

    protected abstract <N extends Number, Col extends Column> IterableMemory<Col> iterate(ColumnHome<N, Col> var1, NetworkEfmModel var2, AppendableMemory<Col> var3) throws IOException;

    @Override
    public void calculateEfms(MetabolicNetwork metabolicNetwork, EfmOutputCallback callback) {
        try {
            this.calculateEfms(this.mConfig.getArithmetic().getColumnHome(), metabolicNetwork, callback);
        }
        catch (RuntimeException ex) {
            LOG.severe("exception caught, ex=" + ex);
            ex.printStackTrace(new LogPrintWriter(LOG, Level.SEVERE));
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe("exception caught, ex=" + ex);
            ex.printStackTrace(new LogPrintWriter(LOG, Level.SEVERE));
            throw new RuntimeException(ex);
        }
    }

    private <N extends Number, Col extends Column> void calculateEfms(ColumnHome<N, Col> columnHome, MetabolicNetwork metabolicNetwork, EfmOutputCallback callback) throws IOException {
        IterableMemory<Col> results;
        long tStart = System.currentTimeMillis();
        NetworkEfmModel efmModel = this.preprocess(columnHome, metabolicNetwork, callback);
        AppendableMemory<Col> memory = efmModel.createInitialMemory(columnHome, this.mMemoryFactory);
        if (!this.mConfig.parseOnly()) {
            long tCpuStart = JVMTimer.getProcessCpuTimeMS();
            JVMTimer timer = null;
            if (LOG.isLoggable(Level.FINER)) {
                timer = new JVMTimer(100L);
                timer.start();
            }
            long tItStart = System.currentTimeMillis();
            results = this.iterate(columnHome, efmModel, memory);
            long tEnd = System.currentTimeMillis();
            long tCpuEnd = JVMTimer.getProcessCpuTimeMS();
            LOG.info("TIME iterate: " + (tEnd - tItStart) + "ms");
            LOG.fine("TIME jvm (total): " + (tCpuEnd - tCpuStart) + "ms");
            LOG.fine("TIME jvm (per core): " + (tCpuEnd - tCpuStart) / (long)this.getConfig().getMaxThreads() + "ms");
            if (timer != null) {
                timer.stop();
                LOG.finer("TIME java (threads): cpu=" + timer.getTotalCpuTimeMS() + "ms, user=" + timer.getTotalUserTimeMS() + "ms, system=" + timer.getTotalSystemTimeMS() + "ms");
            }
        } else {
            results = this.mMemoryFactory.createReadWriteMemory(columnHome, efmModel, efmModel.getIterationCount(), null);
        }
        this.postprocess(columnHome, efmModel, results, callback);
        long tEnd = System.currentTimeMillis();
        LOG.info("overall computation time: " + (tEnd - tStart) + "ms");
    }

    protected <N extends Number, Col extends Column> NetworkEfmModel preprocess(ColumnHome<N, Col> columnHome, MetabolicNetwork metaNet, EfmOutputCallback callback) {
        long tStart = System.currentTimeMillis();
        this.logOptions(metaNet, callback);
        LogPkg.logNetwork(metaNet, Level.FINEST);
        LogPkg.infoNetworkSize("original network: ", metaNet);
        if (this.mConfig.compressNetwork(true)) {
            boolean preprocessDupl = this.mConfig.getPreprocessDuplicateGenes();
            if (preprocessDupl && CompressionMethod.DuplicateGene.containedIn(this.mConfig.getCompressionMethods(true))) {
                metaNet = CompressionUtil.compressDuplicateGeneReactions(metaNet, this.mConfig.zero(), this.mConfig.getCompressionMethods(true));
                LogPkg.infoNetworkSize("duplicate-free network size: ", metaNet);
            }
            if (this.mConfig.compressNetwork(!preprocessDupl)) {
                metaNet = CompressionUtil.compress(metaNet, this.mConfig.getCompressionMethods(!preprocessDupl), this.mConfig.getReactionsToSuppress(), this.mConfig.zero());
                LogPkg.infoNetworkSize("compressed network: ", metaNet);
            }
        } else if (!(metaNet instanceof FractionNumberStoichMetabolicNetwork)) {
            metaNet = new FractionNumberStoichMetabolicNetwork(metaNet.getMetaboliteNames(), metaNet.getReactionNames(), MatrixUtil.convertToBigIntegerRationalMatrix(metaNet.getStoichiometricMatrix(), this.zero(), false), metaNet.getReactionReversibilities());
        }
        NetworkEfmModel efmModel = this.mEfmModelFactory.createEfmModel(columnHome, this.mConfig, metaNet);
        efmModel.log(columnHome, LOG);
        long tEnd = System.currentTimeMillis();
        LOG.info("TIME preprocessing: " + (tEnd - tStart) + "ms");
        return efmModel;
    }

    protected <N extends Number, Col extends Column> void postprocess(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, IterableMemory<Col> memory, EfmOutputCallback callback) throws IOException {
        long efmCount;
        LOG.info("efm count before postprocessing: " + memory.getColumnCount());
        long tStart = System.currentTimeMillis();
        if (!this.mConfig.parseOnly()) {
            memory = this.filterModes(columnHome, efmModel, memory);
            efmCount = this.getRealEfmCount(columnHome, efmModel, memory);
        } else {
            efmCount = 0L;
        }
        LOG.info("efm count after filtering/consolidation: " + efmCount);
        LOG.info("uncompressing modes (can take a while)");
        EfmOutputEvent evtPre = new EfmOutputEvent(EfmOutputEvent.Kind.PRE, efmModel.getMetabolicNetwork(), efmCount);
        callback.callback(evtPre);
        if (!this.mConfig.parseOnly() && callback.getGranularity() != CallbackGranularity.Null) {
            efmModel.getColumnToFluxDistributionConverter(columnHome).writeColumnsToCallback(this.mConfig, efmModel, memory, callback);
        }
        callback.callback(new EfmOutputEvent(EfmOutputEvent.Kind.POST, efmModel.getMetabolicNetwork(), efmCount));
        long tEnd = System.currentTimeMillis();
        LOG.info("TIME postprocessing: " + (tEnd - tStart) + "ms");
    }

    private <N extends Number, Col extends Column> long getRealEfmCount(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, IterableMemory<Col> memory) throws IOException {
        long efmCount = memory.getColumnCount();
        for (Reaction reaction : efmModel.getMetabolicNetwork().getReactions()) {
            if (!reaction.isUptake() || !reaction.isExtract()) continue;
            ++efmCount;
            if (!reaction.getConstraints().isReversible()) continue;
            ++efmCount;
        }
        return efmCount;
    }

    protected <N extends Number, Col extends Column> IterableMemory<Col> filterModes(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, IterableMemory<Col> memory) throws IOException {
        int finalIteration = efmModel.getIterationCount() + 1;
        AppendableMemory<Column> filtered = this.mMemoryFactory.createConcurrentAppendableMemory(columnHome, efmModel, finalIteration, PartId.FLT);
        ReactionMapping rmap = new ReactionMapping(this.mConfig, efmModel.getMetabolicNetwork(), efmModel.getReactionSorting());
        DefaultIterationStepModel itModel = DefaultIterationStepModel.getFinal(efmModel);
        for (Column col : memory) {
            if (!efmModel.getColumnFilter().keepColumn(col, this.mConfig, rmap)) continue;
            col = col.convert(columnHome, efmModel, itModel, false);
            filtered.appendColumn(col);
        }
        return filtered;
    }

    @Override
    public String getImplName() {
        return this.getClass().getSimpleName();
    }

    private void logOptions(MetabolicNetwork metaNet, EfmOutputCallback callback) {
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        LOG.info("Elemetary flux mode computation");
        LOG.info("Implementation:");
        LOG.info("..algorithm name   : " + this.getImplName());
        LOG.info("..model type       : " + AbstractDoubleDescriptionImpl.getFactoryName(this.mEfmModelFactory));
        LOG.info("..memory type      : " + AbstractDoubleDescriptionImpl.getFactoryName(this.mMemoryFactory));
        LOG.info("..output type      : " + AbstractDoubleDescriptionImpl.getCallbackName(callback));
        LOG.info("System:");
        LOG.info("..hostname         : " + AbstractDoubleDescriptionImpl.getHostName());
        LOG.info("..operating system : " + osBean.getArch() + "/" + osBean.getName() + "/" + osBean.getVersion());
        LOG.info("..processors       : " + osBean.getAvailableProcessors());
        LOG.info("..vm               : " + rtBean.getVmVendor() + "/" + rtBean.getVmName() + "/" + rtBean.getVmVersion());
        LOG.info("..vm-spec          : " + rtBean.getSpecVendor() + "/" + rtBean.getSpecName() + "/" + rtBean.getSpecVersion());
        LOG.info("..vm arguments     : " + rtBean.getInputArguments());
        LOG.info("..memory, commited : " + memBean.getHeapMemoryUsage().getCommitted() / 1000L / 1000L + "M");
        LOG.info("..memory, used     : " + memBean.getHeapMemoryUsage().getUsed() / 1000L / 1000L + "M");
        this.mConfig.log(LOG, Level.INFO);
    }

    private static String getFactoryName(Object factory) {
        return AbstractDoubleDescriptionImpl.getSuffixFree("Factory", factory);
    }

    private static String getCallbackName(Object factory) {
        return AbstractDoubleDescriptionImpl.getSuffixFree("OutputCallback", factory);
    }

    private static String getSuffixFree(String suffix, Object instance) {
        if (instance == null) {
            return "<none>";
        }
        String className = instance.getClass().getSimpleName();
        if (className.endsWith(suffix)) {
            return className.substring(0, className.length() - suffix.length());
        }
        return className;
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    protected Zero zero() {
        return this.mConfig.zero();
    }

    private void traceEfms(Iterable<?> efms) {
        int i = 0;
        for (Object o : efms) {
            LOG.finest("[" + i + "]: " + o);
            ++i;
        }
    }
}

