/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.range;

import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.range.AbstractRectangularRange;
import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.RectangularRange;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCellRange
extends AbstractRectangularRange
implements CellRange {
    @Override
    public boolean contains(int bornColumn, int dieRow) {
        return dieRow == this.getDieRow() && bornColumn == this.getBornColumn();
    }

    @Override
    public int getDieRowFrom() {
        return this.getDieRow();
    }

    @Override
    public int getDieRowTo() {
        return this.getDieRow() + 1;
    }

    @Override
    public int getBornColumnFrom() {
        return this.getBornColumn();
    }

    @Override
    public int getBornColumnTo() {
        return this.getBornColumn() + 1;
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    @Override
    public <Col extends Column> AppendableMemory<Col> getForAppending(BornDieMatrix<Col> matrix) throws IllegalStateException, IOException {
        return matrix.getForAppending(this.getBornColumn(), this.getDieRow());
    }

    @Override
    public <Col extends Column> SortableMemory<Col> getNegForGenerating(BornDieMatrix<Col> matrix) throws IllegalStateException, IOException {
        return matrix.getNegForGenerating(this.getBornColumn(), this.getDieRow());
    }

    @Override
    public <Col extends Column> SortableMemory<Col> getPosForGenerating(BornDieMatrix<Col> matrix, int dieRow) throws IllegalStateException, IOException {
        return matrix.getPosForGenerating(this.getBornColumn(), this.getDieRow(), dieRow);
    }

    @Override
    public Iterator<CellRange> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public int hashCode() {
        return this.getBornColumn() & this.getDieRow();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CellRange) {
            CellRange other = (CellRange)obj;
            return this.getBornColumn() == other.getBornColumn() && this.getDieRow() == other.getDieRow();
        }
        if (obj instanceof RectangularRange) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[b=" + this.getBornColumn() + ", d=" + this.getDieRow() + "]";
    }
}

