/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank.dbl;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.metabolic.efm.rankup.RankUpRoot;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.numeric.Zero;

public class DoublePreprocessedMatrix
implements PreprocessedMatrix {
    private final double[][] matrix;
    private final int rank;
    private final IBitSet unusedBits;

    public DoublePreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root, DoubleMatrix stoich) {
        int stopRank = Math.min(stoich.getRowCount(), stoich.getColumnCount());
        int[] colmap = root.getColMapping();
        IBitSet bits = BitSetUtil.factory().create(colmap.length);
        int i = 0;
        while (i < colmap.length) {
            bits.set(i);
            ++i;
        }
        this.matrix = DoublePreprocessedMatrix.toArray(stoich);
        this.rank = DoublePreprocessedMatrix.computeRank(root.zero(), this.matrix, 0, stopRank, 0, colmap, bits, bits, owner.nodeCutSet);
        this.unusedBits = bits;
    }

    public DoublePreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root, DoublePreprocessedMatrix parentProcessed) {
        this.matrix = DoublePreprocessedMatrix.deepClone(parentProcessed.matrix);
        this.unusedBits = parentProcessed.unusedBits.clone();
        int stopRank = root.getStoichRank();
        int[] colmap = root.getColMapping();
        this.rank = DoublePreprocessedMatrix.computeRank(root.zero(), this.matrix, 0, stopRank, parentProcessed.rank, colmap, this.unusedBits, this.unusedBits, owner.nodeCutSet);
    }

    public boolean hasRequiredRank(RankUpRoot root, IBitSet intersectionSet) {
        int reqRank = root.getRequiredRank() - intersectionSet.cardinality();
        int[] colmap = root.getColMapping();
        return reqRank <= this.rank || reqRank <= DoublePreprocessedMatrix.computeRank(root.zero(), this.matrix, reqRank, reqRank, this.rank, colmap, this.unusedBits, null, intersectionSet);
    }

    public DoublePreprocessedMatrix clone() {
        return this;
    }

    public String toString() {
        return "preprocessed(" + this.rank + ")=" + this.matrix;
    }

    private static double[][] getRemainingMatrix(double[][] mx, int stoichRank, int rank, int[] fixcolmap, IBitSet unusedBits, IBitSet setToCompute) {
        int rows = mx.length - rank;
        int cols = fixcolmap.length;
        int[] colmap = new int[cols];
        int colsAct = 0;
        int bit = unusedBits.nextSetBit(0);
        while (bit >= 0) {
            if (!setToCompute.get(bit)) {
                colmap[colsAct] = fixcolmap[bit];
                ++colsAct;
            }
            bit = unusedBits.nextSetBit(bit + 1);
        }
        double[][] arr = new double[rows][colsAct];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < colsAct) {
                arr[row][col] = mx[row + rank][colmap[col]];
                ++col;
            }
            ++row;
        }
        return arr;
    }

    private static int computeRank(Zero zero, double[][] mx, int requireRank, int stopRank, int rank, int[] fixcolmap, IBitSet unusedBits, IBitSet unusedBitsOut, IBitSet setToCompute) {
        int bits = fixcolmap.length;
        int[] colmap = new int[bits];
        int[] bitmap = new int[bits];
        int colsAct = rank;
        int colsPas = bits;
        int bit = unusedBits.nextSetBit(0);
        while (bit >= 0) {
            if (!setToCompute.get(bit)) {
                bitmap[colsAct] = bit;
                colmap[colsAct] = fixcolmap[bit];
                ++colsAct;
            } else {
                colmap[--colsPas] = fixcolmap[bit];
            }
            bit = unusedBits.nextSetBit(bit + 1);
        }
        if (requireRank > colsAct) {
            return rank;
        }
        if (colsPas != colsAct) {
            throw new RuntimeException("internal error, colsPas should be same as colsAct: " + colsPas + "!=" + colsAct);
        }
        int colsTot = unusedBits == null ? colsAct : bits;
        int rows = mx.length;
        int pivs = Math.min(stopRank, Math.min(rows, colsAct));
        int ipiv = rank;
        while (ipiv < pivs) {
            int prow = ipiv;
            int picol = ipiv;
            double piv = 0.0;
            int row = ipiv;
            while (row < rows) {
                int icol = ipiv;
                while (icol < colsAct) {
                    int col = colmap[icol];
                    double abs = Math.abs(mx[row][col]);
                    if (abs > piv) {
                        prow = row;
                        picol = icol;
                        piv = abs;
                    }
                    ++icol;
                }
                ++row;
            }
            if (zero.isZero(piv)) {
                DoublePreprocessedMatrix.trace("rank=" + ipiv + ":unused-new", bits, unusedBits);
                return ipiv;
            }
            if (prow != ipiv) {
                Arrays.swap((Object[])mx, prow, ipiv);
            }
            if (picol != ipiv) {
                IntArray.swap(colmap, picol, ipiv);
                IntArray.swap(bitmap, picol, ipiv);
            }
            if (unusedBitsOut != null) {
                unusedBitsOut.clear(bitmap[ipiv]);
            }
            int pivrow = ipiv;
            int pivcol = colmap[ipiv];
            IntArray pivCols = new IntArray();
            double pval = 1.0 / mx[pivrow][pivcol];
            int icol = ipiv + 1;
            while (icol < colsTot) {
                int col = colmap[icol];
                if (zero.isNonZero(mx[pivrow][col])) {
                    mx[pivrow][col] = mx[pivrow][col] * pval;
                    pivCols.add(col);
                }
                ++icol;
            }
            mx[pivrow][pivcol] = 1.0;
            int row2 = ipiv + 1;
            while (row2 < rows) {
                double rpiv = mx[row2][pivcol];
                mx[row2][pivcol] = 0.0;
                int icol2 = 0;
                while (icol2 < pivCols.length()) {
                    int col = pivCols.get(icol2);
                    double sub = mx[pivrow][col];
                    double[] dArray = mx[row2];
                    int n = col;
                    dArray[n] = dArray[n] - sub * rpiv;
                    ++icol2;
                }
                ++row2;
            }
            ++ipiv;
        }
        return pivs;
    }

    private static int getRank(Zero zero, double[][] arr, int reqRank) {
        int rows;
        int cols = (rows = arr.length) == 0 ? 0 : arr[0].length;
        int fullRank = Math.min(rows, cols);
        if (reqRank > fullRank) {
            return 0;
        }
        double max = 0.0;
        int pcol = -1;
        int prow = -1;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double absVal = Math.abs(arr[row][col]);
                if (absVal > max) {
                    max = absVal;
                    pcol = col;
                    prow = row;
                }
                ++col;
            }
            ++row;
        }
        int pivot = 0;
        while (pivot < reqRank) {
            if (zero.isZero(max)) {
                return pivot;
            }
            if (prow != pivot) {
                Arrays.swapRow(arr, prow, pivot);
            }
            if (pcol != pivot) {
                Arrays.swapCol(arr, pcol, pivot);
            }
            double pivotInv = 1.0 / arr[pivot][pivot];
            arr[pivot][pivot] = 1.0;
            int col = pivot + 1;
            while (col < cols) {
                double[] dArray = arr[pivot];
                int n = col++;
                dArray[n] = dArray[n] * pivotInv;
            }
            max = 0.0;
            prow = -1;
            pcol = -1;
            int row2 = pivot + 1;
            while (row2 < rows) {
                double pivColVal = arr[row2][pivot];
                arr[row2][pivot] = 0.0;
                int col2 = pivot + 1;
                while (col2 < cols) {
                    double[] dArray = arr[row2];
                    int n = col2;
                    dArray[n] = dArray[n] - pivColVal * arr[pivot][col2];
                    double absVal = Math.abs(arr[row2][col2]);
                    if (absVal > max) {
                        max = absVal;
                        pcol = col2;
                        prow = row2;
                    }
                    ++col2;
                }
                ++row2;
            }
            ++pivot;
        }
        return pivot;
    }

    private static double[][] deepClone(double[][] mx) {
        double[][] clone = new double[mx.length][];
        int i = 0;
        while (i < clone.length) {
            clone[i] = new double[mx[i].length];
            System.arraycopy(mx[i], 0, clone[i], 0, clone[i].length);
            ++i;
        }
        return clone;
    }

    private static double[][] toArray(DoubleMatrix stoich) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        double[][] arr = new double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                arr[row][col] = stoich.getDoubleValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return arr;
    }

    private static void trace(String what, int len, IBitSet ... sets) {
    }

    private static void traceAlways(String what, int len, IBitSet ... sets) {
        String[] whats = what.split(":");
        int w = 0;
        if (whats.length > sets.length) {
            System.out.println(whats[0]);
            w = 1;
        }
        IBitSet[] iBitSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IBitSet set = iBitSetArray[n2];
            System.out.print(String.valueOf(whats[w++]) + "=");
            int i = 0;
            while (i < len) {
                System.out.print(set.get(i) ? (char)'1' : '0');
                ++i;
            }
            System.out.println();
            ++n2;
        }
    }
}

