/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterNode<T>
extends Node<T> {
    public final Node<T> child0;
    public final Node<T> child1;

    protected InterNode(TreeFactory<T> treeFactory, SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        super(Node.calculateUnionPattern(cols, iStart, iEnd));
        int median;
        while ((median = AbstractColumn.partition(cols, iStart, iEnd, selectiveBits[++prevSelBitIndex])) == iStart || median == iEnd) {
        }
        this.child0 = treeFactory.createNode(cols, selectiveBits, prevSelBitIndex, iStart, median);
        this.child1 = treeFactory.createNode(cols, selectiveBits, prevSelBitIndex, median, iEnd);
    }

    @Override
    public void addAdjacentPairs(T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> partner, boolean thisIsPos, Queue<ColumnPair> adjacentPairs) throws IOException {
        if (root.enterIfCandidates(token, this, partner)) {
            if (partner instanceof InterNode) {
                InterNode interPartner = (InterNode)partner;
                this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
            } else {
                this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
            }
            root.leave(token, this, partner);
        }
    }

    @Override
    public IBitSet filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> cols, AdjCandidates<Column> adjCandidates) throws IOException {
        if (filterCutPattern != null && filterCutPattern.isSubSetOf(this.child0.unionPattern)) {
            filterCutPattern = this.child0.filterAdjacentPairs(filterCutPattern, cols, adjCandidates);
        }
        if (filterCutPattern != null && filterCutPattern.isSubSetOf(this.child1.unionPattern)) {
            filterCutPattern = this.child1.filterAdjacentPairs(filterCutPattern, cols, adjCandidates);
        }
        return filterCutPattern;
    }
}

