/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.AbstractAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.adj.incore.RankAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRankTestAdjacencyEnumerator
extends AbstractAdjacencyEnumerator
implements RankAdjacencyEnumerator {
    public static final String NAME = "rank";
    protected final boolean mIsMinCardinalityTested;
    protected int[] mColMapping;
    protected double[][] mStoichRed;

    public DefaultRankTestAdjacencyEnumerator() {
        this(false);
    }

    public DefaultRankTestAdjacencyEnumerator(boolean isMinCardinalityTested) {
        this.mIsMinCardinalityTested = isMinCardinalityTested;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public <Col extends Column, N extends Number> void initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel model) {
        super.initialize(columnHome, config, model);
        int[] colMapping = DefaultRankTestAdjacencyEnumerator.getInitialColMapping(model.getStoichRational().getColumnCount());
        this.mStoichRed = this.getReducedStoichMatrix(config.zero(), model.getStoichRational(), colMapping);
        int[] newMapping = new int[colMapping.length];
        int ii = 0;
        while (ii < newMapping.length) {
            newMapping[ii] = colMapping[model.getReactionSorting()[ii]];
            ++ii;
        }
        this.mColMapping = newMapping;
        this.mModel = model;
    }

    @Override
    public void adjacentPairs(Queue<ColumnPair> adjacentPairs, SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols) throws IOException {
        for (Column colP : posCols) {
            for (Column colN : negCols) {
                ColumnPair<Column> pair = new ColumnPair<Column>(colP, colN);
                IBitSet and = pair.intersectBitValues();
                if (!this.hasRequiredRank(null, and)) continue;
                adjacentPairs.add(pair);
            }
        }
    }

    public int getRequiredZeroBitCount() {
        return this.getRequiredRank() - this.mStoichRed.length;
    }

    public int getRequiredRank() {
        int rows = this.mStoichRed.length;
        if (rows == 0) {
            return 0;
        }
        return this.mStoichRed[0].length - 2;
    }

    @Override
    public boolean hasRequiredZeroBitCount(IBitSet zeroColumns) {
        return zeroColumns.cardinality() >= this.getRequiredZeroBitCount();
    }

    @Override
    public boolean isRequiredZeroBitCount(int count) {
        return count >= this.getRequiredZeroBitCount();
    }

    @Override
    public boolean hasRequiredRank(IBitSet zeroColumns) {
        int reqRank = this.getRequiredRank();
        if (this.mIsMinCardinalityTested) {
            int[] rankPtr = new int[1];
            double[][] mx = this.getRemainingMatrix(zeroColumns, rankPtr);
            int rankSoFar = rankPtr[0];
            boolean hasRank = this.isRankGaussFullPivoting(mx, rankSoFar, reqRank);
            return hasRank;
        }
        if (zeroColumns.cardinality() >= this.getRequiredZeroBitCount()) {
            int[] rankPtr = new int[1];
            double[][] mx = this.getRemainingMatrix(zeroColumns, rankPtr);
            int rankSoFar = rankPtr[0];
            boolean hasRank = this.isRankGaussFullPivoting(mx, rankSoFar, reqRank);
            return hasRank;
        }
        return false;
    }

    public boolean hasRequiredRank(long[] timers, IBitSet zeroColumns) {
        int reqRank = this.getRequiredRank();
        if (reqRank > 0) {
            long t1 = 0L;
            long t2 = 0L;
            if (timers != null) {
                t1 = System.currentTimeMillis();
            }
            if (timers != null) {
                t2 = System.currentTimeMillis();
            }
            if (timers != null) {
                timers[0] = timers[0] + (t2 - t1);
            }
            if (zeroColumns.cardinality() >= this.getRequiredZeroBitCount()) {
                int[] rankPtr = new int[1];
                double[][] mx = this.getRemainingMatrix(zeroColumns, rankPtr);
                int rankSoFar = rankPtr[0];
                if (timers != null) {
                    t1 = System.currentTimeMillis();
                }
                if (timers != null) {
                    timers[1] = timers[1] + (t1 - t2);
                }
                boolean hasRank = this.isRankGaussFullPivoting(mx, rankSoFar, reqRank);
                if (timers != null) {
                    t2 = System.currentTimeMillis();
                }
                if (timers != null) {
                    timers[2] = timers[2] + (t2 - t1);
                }
                return hasRank;
            }
            return false;
        }
        return true;
    }

    private double[][] getReducedStoichMatrix(Zero zero, ReadableMatrix<? extends Number> stoich, int[] colMapping) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        DefaultDoubleMatrix mx = new DefaultDoubleMatrix(rows, cols);
        int col = 0;
        while (col < cols) {
            int row = 0;
            while (row < rows) {
                double val = stoich.getNumberValueAt(row, col).doubleValue();
                mx.setValueAt(row, col, val);
                ++row;
            }
            ++col;
        }
        return DefaultRankTestAdjacencyEnumerator.reduce(zero, mx, colMapping);
    }

    private static double[][] subMatrixToArray(DoubleMatrix mx, int rows) {
        int cols = mx.getColumnCount();
        double[][] vals = new double[rows][cols];
        int ii = 0;
        while (ii < rows) {
            int jj = 0;
            while (jj < cols) {
                vals[ii][jj] = mx.getDoubleValueAt(ii, jj);
                ++jj;
            }
            ++ii;
        }
        return vals;
    }

    private static int[] getInitialColMapping(int cols) {
        int[] res = new int[cols];
        int col = 0;
        while (col < cols) {
            res[col] = col;
            ++col;
        }
        return res;
    }

    private static void invertColMapping(int[] colMapping) {
        int[] orig = (int[])colMapping.clone();
        int ii = 0;
        while (ii < orig.length) {
            colMapping[orig[ii]] = ii;
            ++ii;
        }
    }

    private static double[][] reduce(Zero zero, DoubleMatrix mx, int[] colMapping) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        int fullRank = Math.min(rows, cols);
        int pivot = 0;
        while (pivot < fullRank) {
            double max = 0.0;
            int pcol = -1;
            int prow = -1;
            int row = pivot;
            while (row < rows) {
                int col = pivot;
                while (col < cols) {
                    double val = mx.getDoubleValueAt(row, col);
                    if (Math.abs(val) > max) {
                        max = Math.abs(val);
                        pcol = col;
                        prow = row;
                    }
                    ++col;
                }
                ++row;
            }
            if (zero.isZero(max)) {
                DefaultRankTestAdjacencyEnumerator.invertColMapping(colMapping);
                return DefaultRankTestAdjacencyEnumerator.subMatrixToArray(mx, pivot);
            }
            if (prow != pivot) {
                mx.swapRows(prow, pivot);
            }
            if (pcol != pivot) {
                mx.swapColumns(pcol, pivot);
                Arrays.swap(colMapping, pcol, pivot);
            }
            double pivotInv = 1.0 / mx.getDoubleValueAt(pivot, pivot);
            mx.setValueAt(pivot, pivot, 1.0);
            int col = pivot + 1;
            while (col < cols) {
                mx.multiply(pivot, col, pivotInv);
                ++col;
            }
            int row2 = 0;
            while (row2 < rows) {
                if (row2 != pivot) {
                    double pivColVal = mx.getDoubleValueAt(row2, pivot);
                    mx.setValueAt(row2, pivot, 0.0);
                    int col2 = pivot + 1;
                    while (col2 < cols) {
                        double subtract = pivColVal * mx.getDoubleValueAt(pivot, col2);
                        mx.add(row2, col2, -subtract);
                        ++col2;
                    }
                }
                ++row2;
            }
            ++pivot;
        }
        DefaultRankTestAdjacencyEnumerator.invertColMapping(colMapping);
        return DefaultRankTestAdjacencyEnumerator.subMatrixToArray(mx, fullRank);
    }

    protected double[][] getRemainingMatrix(IBitSet zeroColumns, int[] rankSoFarPtr) {
        Zero zero = this.mConfig.zero();
        int stoichRows = this.mStoichRed.length;
        int stoichCols = stoichRows == 0 ? 0 : this.mStoichRed[0].length;
        int zeroCnt = 0;
        int[] keptCols = new int[stoichCols];
        int keptColCnt = 0;
        int[] keptRows = new int[stoichRows];
        int keptRowCnt = 0;
        int ii = 0;
        while (ii < stoichCols) {
            int col = this.mColMapping[ii];
            if (zeroColumns.get(ii)) {
                if (col < stoichRows) {
                    keptRows[keptRowCnt++] = col;
                }
                ++zeroCnt;
            } else {
                keptCols[keptColCnt++] = col;
            }
            ++ii;
        }
        double[][] arr = new double[keptRowCnt][keptColCnt];
        int zeroCols = 0;
        int newCol = 0;
        int iCol = 0;
        while (iCol < keptColCnt) {
            int col = keptCols[iCol];
            boolean any = false;
            int iRow = 0;
            while (iRow < keptRowCnt) {
                double val;
                int row = keptRows[iRow];
                arr[iRow][newCol] = val = this.mStoichRed[row][col];
                any |= zero.isNonZero(val);
                ++iRow;
            }
            if (any) {
                ++newCol;
            } else {
                ++zeroCols;
            }
            ++iCol;
        }
        rankSoFarPtr[0] = stoichRows + zeroCnt - keptRowCnt;
        if (zeroCols > 0) {
            double[][] zarr = new double[keptRowCnt][keptColCnt - zeroCols];
            int i = 0;
            while (i < zarr.length) {
                System.arraycopy(arr[i], 0, zarr[i], 0, zarr[i].length);
                ++i;
            }
            return zarr;
        }
        return arr;
    }

    protected boolean isRankGaussFullPivoting(double[][] arr, int rankSoFar, int rank) {
        int rows;
        Zero zero = this.mConfig.zero();
        int stopRank = rank - rankSoFar;
        int cols = (rows = arr.length) == 0 ? 0 : arr[0].length;
        int fullRank = Math.min(rows, cols);
        if (stopRank > fullRank) {
            return false;
        }
        double max = 0.0;
        int pcol = -1;
        int prow = -1;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double absVal = Math.abs(arr[row][col]);
                if (absVal > max) {
                    max = absVal;
                    pcol = col;
                    prow = row;
                }
                ++col;
            }
            ++row;
        }
        int pivot = 0;
        while (pivot < stopRank) {
            if (zero.isZero(max)) {
                return pivot + rankSoFar >= rank;
            }
            if (prow != pivot) {
                Arrays.swapRow(arr, prow, pivot);
            }
            if (pcol != pivot) {
                Arrays.swapCol(arr, pcol, pivot);
            }
            double pivotInv = 1.0 / arr[pivot][pivot];
            arr[pivot][pivot] = 1.0;
            int col = pivot + 1;
            while (col < cols) {
                double[] dArray = arr[pivot];
                int n = col++;
                dArray[n] = dArray[n] * pivotInv;
            }
            max = 0.0;
            prow = -1;
            pcol = -1;
            int row2 = pivot + 1;
            while (row2 < rows) {
                double pivColVal = arr[row2][pivot];
                arr[row2][pivot] = 0.0;
                int col2 = pivot + 1;
                while (col2 < cols) {
                    double[] dArray = arr[row2];
                    int n = col2;
                    dArray[n] = dArray[n] - pivColVal * arr[pivot][col2];
                    double absVal = Math.abs(arr[row2][col2]);
                    if (absVal > max) {
                        max = absVal;
                        pcol = col2;
                        prow = row2;
                    }
                    ++col2;
                }
                ++row2;
            }
            ++pivot;
        }
        return pivot + rankSoFar >= rank;
    }
}

