/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj;

import ch.javasoft.metabolic.efm.adj.AdjEnum;
import ch.javasoft.metabolic.efm.adj.LogPkg;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.config.XmlAttribute;
import ch.javasoft.metabolic.efm.config.XmlElement;
import ch.javasoft.metabolic.efm.dist.DistributedAdjEnum;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;

public class AdjMethodFactory {
    private final Config config;
    public static final String DEFAULT_ADJ_METHOD = "pattern-tree-minzero";
    private final Map<String, AdjEnum> adjacencyEnums = new HashMap<String, AdjEnum>();
    private final Map<String, DistributedAdjEnum> distAdjEnums = new HashMap<String, DistributedAdjEnum>();

    public AdjMethodFactory(Config config) throws XmlConfigException, IOException {
        this.config = config;
        this.init(config.getXmlConfig());
    }

    public AdjEnum createAdjEnumFromConfig() {
        return this.createAdjEnum(this.config.getAdjMethod());
    }

    public AdjEnum createAdjEnum(String adjMethod) {
        int index = adjMethod.indexOf(58);
        String name = index == -1 ? adjMethod : adjMethod.substring(0, index);
        AdjEnum enu = this.adjacencyEnums.get(name);
        if (enu == null) {
            throw new RuntimeException("adjacency enumerator '" + name + "' not found");
        }
        return enu;
    }

    public DistributedAdjEnum createDistributedAdjEnumFromConfig() {
        return this.createDistributedAdjEnum(this.config.getAdjMethod());
    }

    public DistributedAdjEnum createDistributedAdjEnum(String adjMethod) {
        String name = adjMethod.substring(adjMethod.indexOf(58) + 1);
        DistributedAdjEnum enu = this.distAdjEnums.get(name);
        if (enu == null) {
            throw new RuntimeException("distributed out core adjacency enumerator '" + name + "' not found");
        }
        return enu;
    }

    private void addAdjEnum(AdjEnum enu) {
        this.adjacencyEnums.put(enu.name(), enu);
    }

    private void addDistributedAdjEnum(DistributedAdjEnum enu) {
        this.distAdjEnums.put(enu.name(), enu);
    }

    private void init(XmlConfig xmlConfig) throws XmlConfigException {
        Element impConfig = Config.getConfigEfmImplConfig(xmlConfig);
        Element adjConfig = XmlUtil.getRequiredSingleChildElement(impConfig, XmlElement.adjacency_method);
        Element facConfig = XmlUtil.getRequiredSingleChildElement(adjConfig, XmlElement.factories);
        Iterator<Element> it = XmlUtil.getChildElements(facConfig, XmlElement.clazz);
        while (it.hasNext()) {
            Element el = it.next();
            String className = XmlUtil.getRequiredAttributeValue(el, XmlAttribute.name);
            try {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.newInstance();
                int cnt = 0;
                if (instance instanceof AdjEnum) {
                    this.addAdjEnum((AdjEnum)instance);
                    ++cnt;
                    LogPkg.LOGGER.finer("registered adjacency-method: " + className);
                }
                if (instance instanceof DistributedAdjEnum) {
                    this.addDistributedAdjEnum((DistributedAdjEnum)instance);
                    ++cnt;
                    LogPkg.LOGGER.finer("registered distributed adjacency-method: " + className);
                }
                if (cnt != 0) continue;
                LogPkg.LOGGER.warning("not a recognized adjacency-method: " + className);
            }
            catch (Exception ex) {
                LogPkg.LOGGER.warning("cannot instantiate adjacency-method '" + className + "', e=" + ex);
            }
        }
    }
}

