/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.ops.AbstractNumberOps;
import ch.javasoft.util.numeric.BigIntegerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerOperations
extends AbstractNumberOps<BigInteger> {
    private static BigIntegerOperations sInstance;

    public static BigIntegerOperations instance() {
        if (sInstance == null) {
            sInstance = new BigIntegerOperations();
        }
        return sInstance;
    }

    @Override
    public Class<BigInteger> numberClass() {
        return BigInteger.class;
    }

    public BigInteger[] newArray(int size) {
        return new BigInteger[size];
    }

    public BigInteger[][] newArray(int rows, int cols) {
        return new BigInteger[rows][cols];
    }

    @Override
    public BigInteger valueOf(String s) {
        return new BigInteger(s);
    }

    @Override
    public BigInteger valueOf(Number number) {
        return BigIntegerUtil.valueOf(number);
    }

    @Override
    public BigInteger valueOf(long value) {
        return BigInteger.valueOf(value);
    }

    @Override
    public BigInteger valueOf(double value) {
        return this.valueOf(String.valueOf(value));
    }

    @Override
    public BigInteger abs(BigInteger number) {
        return number.abs();
    }

    @Override
    public BigInteger add(BigInteger numA, BigInteger numB) {
        return numA.add(numB);
    }

    @Override
    public BigInteger divide(BigInteger numA, BigInteger numB) {
        return numA.divide(numB);
    }

    @Override
    public BigInteger invert(BigInteger number) {
        return BigInteger.ONE.divide(number);
    }

    @Override
    public boolean isOne(BigInteger number) {
        return BigInteger.ONE.equals(number);
    }

    @Override
    public boolean isZero(BigInteger number) {
        return number.signum() == 0;
    }

    @Override
    public BigInteger multiply(BigInteger numA, BigInteger numB) {
        return numA.multiply(numB);
    }

    @Override
    public BigInteger negate(BigInteger number) {
        return number.negate();
    }

    @Override
    public BigInteger one() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger subtract(BigInteger numA, BigInteger numB) {
        return numA.subtract(numB);
    }

    @Override
    public BigInteger zero() {
        return BigInteger.ZERO;
    }

    @Override
    public int compare(BigInteger o1, BigInteger o2) {
        return o1.compareTo(o2);
    }

    @Override
    public BigInteger reduce(BigInteger number) {
        return number;
    }

    public BigInteger[] reduceVector(boolean cloneOnChange, BigInteger ... vector) {
        BigInteger gcd = BigIntegerUtil.gcd(vector).abs();
        if (!this.isOne(gcd) && gcd.signum() != 0) {
            if (cloneOnChange) {
                vector = (BigInteger[])vector.clone();
            }
            int i = 0;
            while (i < vector.length) {
                vector[i] = vector[i].divide(gcd);
                ++i;
            }
        }
        return vector;
    }

    @Override
    public int signum(BigInteger number) {
        return number.signum();
    }

    @Override
    public BigInteger pow(BigInteger numA, BigInteger numB) {
        int expSign = numB.signum();
        if (expSign == 0) {
            return BigInteger.ONE;
        }
        if (BigInteger.ONE.equals(numA)) {
            return BigInteger.ONE;
        }
        if (expSign < 0) {
            return BigInteger.ZERO;
        }
        if (numB.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new ArithmeticException("exponent too large, only integer range supported: " + numB + " > " + Integer.MAX_VALUE);
        }
        return numA.pow(numB.intValue());
    }

    @Override
    public byte[] toByteArray(BigInteger number) {
        return number.toByteArray();
    }

    @Override
    public void writeTo(BigInteger number, DataOutput out) throws IOException {
        byte[] num = number.toByteArray();
        out.writeInt(num.length);
        out.write(num);
    }

    @Override
    public BigInteger fromByteArray(byte[] bytes) {
        return new BigInteger(bytes);
    }

    @Override
    public BigInteger readFrom(DataInput in) throws IOException {
        int numLen = in.readInt();
        byte[] num = new byte[numLen];
        in.readFully(num);
        return new BigInteger(num);
    }

    @Override
    public int byteLength() {
        return -1;
    }
}

