/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.AbstractNumberOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigFractionOperations
extends AbstractNumberOps<BigFraction> {
    private static BigFractionOperations sInstance;

    public static BigFractionOperations instance() {
        if (sInstance == null) {
            sInstance = new BigFractionOperations();
        }
        return sInstance;
    }

    @Override
    public Class<BigFraction> numberClass() {
        return BigFraction.class;
    }

    public BigFraction[] newArray(int size) {
        return new BigFraction[size];
    }

    public BigFraction[][] newArray(int rows, int cols) {
        return new BigFraction[rows][cols];
    }

    @Override
    public BigFraction valueOf(String s) {
        return BigFraction.valueOf(s);
    }

    @Override
    public BigFraction valueOf(Number number) {
        return BigFraction.valueOf(number);
    }

    @Override
    public BigFraction valueOf(long value) {
        return BigFraction.valueOf(value);
    }

    @Override
    public BigFraction valueOf(double value) {
        return BigFraction.valueOf(value);
    }

    @Override
    public BigFraction abs(BigFraction number) {
        return number.abs();
    }

    @Override
    public BigFraction add(BigFraction numA, BigFraction numB) {
        return numA.add(numB);
    }

    @Override
    public BigFraction divide(BigFraction numA, BigFraction numB) {
        return numA.divide(numB);
    }

    @Override
    public BigFraction invert(BigFraction number) {
        return number.invert();
    }

    @Override
    public boolean isOne(BigFraction number) {
        return number.isOne();
    }

    @Override
    public boolean isZero(BigFraction number) {
        return number.isZero();
    }

    @Override
    public BigFraction multiply(BigFraction numA, BigFraction numB) {
        return numA.multiply(numB);
    }

    @Override
    public BigFraction negate(BigFraction number) {
        return number.negate();
    }

    @Override
    public BigFraction one() {
        return BigFraction.ONE;
    }

    @Override
    public BigFraction subtract(BigFraction numA, BigFraction numB) {
        return numA.subtract(numB);
    }

    @Override
    public BigFraction zero() {
        return BigFraction.ZERO;
    }

    @Override
    public int compare(BigFraction o1, BigFraction o2) {
        return o1.compareTo(o2);
    }

    @Override
    public BigFraction reduce(BigFraction number) {
        return number.reduce();
    }

    public BigFraction[] reduceVector(boolean cloneOnChange, BigFraction ... vector) {
        BigFraction gcd = BigFraction.gcd(vector).abs();
        if (!gcd.isOne() && !gcd.isZero()) {
            if (cloneOnChange) {
                vector = (BigFraction[])vector.clone();
            }
            int i = 0;
            while (i < vector.length) {
                vector[i] = vector[i].divide(gcd).reduce();
                ++i;
            }
        }
        return vector;
    }

    @Override
    public int signum(BigFraction number) {
        return number.signum();
    }

    @Override
    public BigFraction pow(BigFraction numA, BigFraction numB) {
        int expSign = numB.signum();
        if (expSign == 0) {
            return BigFraction.ONE;
        }
        if (numA.isOne()) {
            return BigFraction.ONE;
        }
        if ((numB = numB.reduce()).isInteger()) {
            if (expSign > 0 && numB.getNumerator().compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new ArithmeticException("exponent too large, only integer range supported: " + numB.getNumerator() + " > " + Integer.MAX_VALUE);
            }
            if (expSign < 0 && numB.getNumerator().compareTo(BigInteger.valueOf(-2147483647L)) < 0) {
                throw new ArithmeticException("exponent too small, only integer range supported: " + numB.getNumerator() + " < " + Integer.MIN_VALUE);
            }
            return numA.pow(numB.getNumerator().intValue());
        }
        throw new ArithmeticException("non-integer exponent not supported");
    }

    @Override
    public byte[] toByteArray(BigFraction number) {
        byte[] num = number.getNumerator().toByteArray();
        byte[] den = number.getDenominator().toByteArray();
        byte[] bytes = new byte[num.length + den.length + 4];
        bytes[0] = (byte)(num.length >>> 24);
        bytes[1] = (byte)(num.length >>> 16);
        bytes[2] = (byte)(num.length >>> 8);
        bytes[3] = (byte)(num.length >>> 0);
        System.arraycopy(num, 0, bytes, 4, num.length);
        System.arraycopy(den, 0, bytes, 4 + num.length, den.length);
        return bytes;
    }

    @Override
    public void writeTo(BigFraction number, DataOutput out) throws IOException {
        byte[] num = number.getNumerator().toByteArray();
        byte[] den = number.getDenominator().toByteArray();
        out.writeInt(num.length);
        out.write(num);
        out.writeInt(den.length);
        out.write(den);
    }

    @Override
    public BigFraction fromByteArray(byte[] bytes) {
        int numLen = (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + (bytes[3] << 0);
        byte[] num = new byte[numLen];
        byte[] den = new byte[bytes.length - numLen - 4];
        System.arraycopy(bytes, 4, num, 0, numLen);
        System.arraycopy(bytes, 4 + numLen, den, 0, den.length);
        return BigFraction.valueOf(new BigInteger(num), new BigInteger(den));
    }

    @Override
    public BigFraction readFrom(DataInput in) throws IOException {
        int numLen = in.readInt();
        byte[] num = new byte[numLen];
        in.readFully(num);
        int denLen = in.readInt();
        byte[] den = new byte[denLen];
        in.readFully(den);
        return BigFraction.valueOf(new BigInteger(num), new BigInteger(den));
    }

    @Override
    public int byteLength() {
        return -1;
    }
}

