/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.compose;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.operator.compose.TempArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryNullaryOperator<T extends Number, A>
extends AbstractUnaryOperator<T, A> {
    private final BinaryOperator<T, A> operator;
    private final UnaryOperator<T, A> operand1;
    private final NullaryOperator<T, A> operand2;
    private final TempArray<A> temp;

    public UnaryNullaryOperator(ArrayOperations<A> ops, BinaryOperator<T, A> operator, UnaryOperator<T, A> operand1, NullaryOperator<T, A> operand2) {
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.temp = new TempArray<A>(ops, 2);
    }

    @Override
    public T operate(T operand) {
        Number operated1 = (Number)this.operand1.operate(operand);
        Number operated2 = (Number)this.operand2.operate();
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public T operate(A src, int srcIndex) {
        Number operated1 = (Number)this.operand1.operate(src, srcIndex);
        Number operated2 = (Number)this.operand2.operate();
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public void operate(A src, int srcIndex, A dst, int dstIndex) {
        A tmp = this.temp.get();
        this.operand1.operate(src, srcIndex, tmp, 0);
        this.operand2.operate(tmp, 1);
        this.operator.operate(tmp, 0, tmp, 1, dst, dstIndex);
    }
}

