/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultNumberArrayOperations;
import ch.javasoft.math.linalg.DefaultBasicLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivoting;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.TernaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinAlgOperations<N extends Number, A>
extends DefaultBasicLinAlgOperations<N, A>
implements LinAlgOperations<N, A> {
    private final GaussPivotingFactory<N, A> gaussPivotingFactory;
    private final UnaryOperator<N, A> negater;
    private final BinaryOperator<N, A> multiplier;
    private final BinaryOperator<N, A> divider;
    private final BinaryOperator<N, A> multiplierNormalizer;
    private final BinaryOperator<N, A> dividerNormalizer;
    private final TernaryOperator<N, A> pivotRowMultipleSubtracter;

    public DefaultLinAlgOperations(NumberOperators<N, A> numberOps, ArrayOperations<A> arrayOps, GaussPivotingFactory<N, A> gaussPivotingFactory) {
        this(new DefaultNumberArrayOperations<N, A>(numberOps, arrayOps), gaussPivotingFactory);
    }

    public DefaultLinAlgOperations(NumberArrayOperations<N, A> numberArrayOps, GaussPivotingFactory<N, A> gaussPivotingFactory) {
        super(numberArrayOps);
        this.gaussPivotingFactory = gaussPivotingFactory;
        this.negater = this.expressionComposer.neg();
        this.multiplier = this.expressionComposer.mul();
        this.divider = this.expressionComposer.div();
        this.multiplierNormalizer = this.expressionComposer.normalize(this.expressionComposer.mul());
        this.dividerNormalizer = this.expressionComposer.normalize(this.expressionComposer.div());
        this.pivotRowMultipleSubtracter = this.expressionComposer.normalize(this.expressionComposer.subFromFree(this.expressionComposer.mul()));
    }

    @Override
    public A[] kernel(A[] matrix, int[] rowmap, int[] colmap, int[] ptrNullity) {
        boolean isDivSup;
        int cols = this.arrayOps.getColumnCount(matrix);
        int[] ptrRank = new int[1];
        if (colmap == null) {
            colmap = new int[cols];
        }
        A[] rref = this.rowEchelon(matrix, true, rowmap, colmap, ptrRank);
        int rank = ptrRank[0];
        int ndim = cols - rank;
        A[] ker = this.numberArrayOps.newZeroMatrix(cols, ndim);
        boolean bl = isDivSup = this.numberOps.getDivisionSupport().isSufficientlyExact() && !this.numberOps.getDivisionSupport().mightCauseException();
        if (isDivSup) {
            int i = 0;
            while (i < ndim) {
                this.numberArrayOps.set(ker, colmap[i + rank], i, this.numberOps.one());
                ++i;
            }
            int row = 0;
            while (row < rank) {
                int col = 0;
                while (col < ndim) {
                    this.arrayOps.copyMatrixElement(rref, row, col + rank, ker, colmap[row], col);
                    this.negater.operate(ker[colmap[row]], col, ker[colmap[row]], col);
                    ++col;
                }
                ++row;
            }
        } else {
            int col;
            AggregatingUnaryOperator gcdOp = this.numberOps.aggregatingUnary(AggregatingUnaryOperator.Id.normDivisor);
            Object tmp = this.arrayOps.newVector(2);
            int row = 0;
            while (row < rank) {
                this.arrayOps.copyMatrixRowElementsToVector(rref, row, row, tmp, 0, 1);
                gcdOp.operate(rref[row], rank, ndim, tmp, 1);
                gcdOp.operate(tmp, 0, 2, tmp, 0);
                if (!this.isOne(tmp, 0)) {
                    Object gcd = this.numberArrayOps.get(tmp, 0);
                    UnaryOperator divOp = this.expressionComposer.divFreeBy(this.expressionComposer.constant(gcd));
                    divOp.operate(rref[row], row, rref[row], row);
                    col = 0;
                    while (col < ndim) {
                        divOp.operate(rref[row], col + rank, rref[row], col + rank);
                        ++col;
                    }
                }
                ++row;
            }
            this.numberArrayOps.set(tmp, 0, this.numberOps.one());
            row = 0;
            while (row < rank) {
                this.arrayOps.copyMatrixRowElementsToVector(rref, row, row, tmp, 1, 1);
                gcdOp.operate(tmp, 0, 2, tmp, 1);
                this.multiplier.operate(tmp, 0, rref[row], row, tmp, 0);
                this.divider.operate(tmp, 0, tmp, 1, tmp, 0);
                ++row;
            }
            Object lcm = this.numberArrayOps.get(tmp, 0);
            int row2 = 0;
            while (row2 < rank) {
                UnaryOperator mulOp = this.expressionComposer.div(this.expressionComposer.mul(this.expressionComposer.constant(lcm)), this.expressionComposer.constant(this.numberArrayOps.get(rref, row2, row2)));
                mulOp.operate(rref[row2], row2, rref[row2], row2);
                int i = 0;
                while (i < ndim) {
                    this.numberArrayOps.set(ker, colmap[i + rank], i, lcm);
                    ++i;
                }
                col = 0;
                while (col < ndim) {
                    mulOp.operate(rref[row2], col + rank, rref[row2], col + rank);
                    this.arrayOps.copyMatrixElement(rref, row2, col + rank, ker, colmap[row2], col);
                    this.negater.operate(ker[colmap[row2]], col, ker[colmap[row2]], col);
                    ++col;
                }
                ++row2;
            }
        }
        if (ptrNullity != null) {
            ptrNullity[0] = ndim;
        }
        return ker;
    }

    @Override
    public A[] invertMatrix(A[] matrix, int[] rowmap, int[] colmap) {
        if (rowmap == null) {
            int rows = this.arrayOps.getRowCount(matrix);
            int cols = this.arrayOps.getColumnCount(matrix);
            rowmap = new int[rows];
            colmap = new int[cols];
            DefaultLinAlgOperations.initializeMapping(rows, rowmap);
            DefaultLinAlgOperations.initializeMapping(cols, colmap);
        }
        return this.invertMaximalSubmatrixInternal(matrix, rowmap, colmap, null, true);
    }

    @Override
    public A[] invertMaximalSubmatrix(A[] matrix, int[] rowmap, int[] colmap, int[] ptrRank) {
        return this.invertMaximalSubmatrixInternal(matrix, rowmap, colmap, ptrRank, false);
    }

    private A[] invertMaximalSubmatrixInternal(A[] matrix, int[] rowmap, int[] colmap, int[] ptrRank, boolean square) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        if (square && rows != cols) {
            throw new IllegalArgumentException("matrix must be square to be invertible: " + rows + "x" + cols);
        }
        A[] rref = this.arrayOps.newMatrix(rows, rows + cols);
        this.arrayOps.copyMatrixElements(matrix, 0, 0, rref, 0, 0, rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < rows) {
                this.numberArrayOps.set(rref, row, cols + col, this.numberOps.zero());
                ++col;
            }
            this.numberArrayOps.set(rref, row, cols + row, this.numberOps.one());
            ++row;
        }
        int rank = this.rowEchelon(rref, rref, true, rowmap, colmap);
        if (ptrRank != null) {
            ptrRank[0] = rank;
        }
        if (square && rank < Math.min(rows, cols)) {
            throw new ArithmeticException("singular matrix, rank < size: " + rank + " < " + rows);
        }
        A[] inv = this.arrayOps.newMatrix(rank, rank);
        int row2 = 0;
        while (row2 < rank) {
            int dstRow = square ? colmap[row2] : row2;
            int col = 0;
            while (col < rank) {
                int dstCol = square ? rowmap[col] : col;
                this.arrayOps.copyMatrixElement(rref, row2, cols + rowmap[col], inv, dstRow, dstCol);
                ++col;
            }
            ++row2;
        }
        return inv;
    }

    @Override
    public int nullity(A[] matrix) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A[] res = this.arrayOps.newMatrix(rows, cols);
        return cols - this.rowEchelon(matrix, res, false, null, null);
    }

    @Override
    public int rank(A[] matrix) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A[] res = this.arrayOps.newMatrix(rows, cols);
        return this.rowEchelon(matrix, res, false, null, null);
    }

    @Override
    public A[] rowEchelon(A[] matrix, boolean reduced, int[] rowmap, int[] colmap, int[] ptrRank) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A[] res = this.arrayOps.newMatrix(rows, cols);
        int rank = this.rowEchelon(matrix, res, reduced, rowmap, colmap);
        if (ptrRank != null && ptrRank.length > 0) {
            ptrRank[0] = rank;
        }
        return res;
    }

    @Override
    public int rowEchelon(A[] src, A[] dst, boolean reduced, int[] rowmap, int[] colmap) {
        boolean isDivSup = this.numberOps.getDivisionSupport().isSufficientlyExact() && !this.numberOps.getDivisionSupport().mightCauseException();
        int rows = this.arrayOps.getRowCount(dst);
        int cols = this.arrayOps.getColumnCount(dst);
        if (src != dst) {
            this.arrayOps.copyMatrixElements(src, 0, 0, dst, 0, 0, rows, cols);
        }
        int prows = DefaultLinAlgOperations.initializeMapping(rows, rowmap);
        int pcols = DefaultLinAlgOperations.initializeMapping(cols, colmap);
        int pivs = Math.min(prows, pcols);
        IntArray prowNonZeroIndices = new IntArray(cols);
        int pivot = 0;
        while (pivot < pivs) {
            int col;
            int i;
            int pcol;
            int col2;
            GaussPivoting<N, A> pivoting = this.gaussPivotingFactory.getGaussPivoting(this.numberArrayOps, pivot);
            int row = pivot;
            while (row < prows) {
                int rowResult = pivoting.checkCandidateRow(dst, pivot, row);
                boolean cont = true;
                col2 = pivot;
                while (col2 < pcols && cont) {
                    if (this.isNonZero(dst, row, col2)) {
                        cont = pivoting.checkCandidateCol(dst, pivot, row, col2, rowResult);
                    }
                    ++col2;
                }
                ++row;
            }
            int prow = pivoting.getPivotRow();
            if (this.isZero(dst, prow, pcol = pivoting.getPivotCol())) {
                return pivot;
            }
            if (prow != pivot) {
                this.arrayOps.swapMatrixRows(dst, prow, pivot);
                if (rowmap != null) {
                    IntArray.swap(rowmap, prow, pivot);
                }
            }
            if (pcol != pivot) {
                this.arrayOps.swapMatrixColumns(dst, pcol, pivot);
                if (colmap != null) {
                    IntArray.swap(colmap, pcol, pivot);
                }
            }
            prowNonZeroIndices.clear();
            if (isDivSup) {
                boolean divide = !this.isOne(dst, pivot, pivot);
                col2 = pivot + 1;
                while (col2 < cols) {
                    if (this.isNonZero(dst, pivot, col2)) {
                        if (divide) {
                            this.divide(dst, pivot, col2, pivot, pivot);
                        }
                        prowNonZeroIndices.add(col2);
                    }
                    ++col2;
                }
                this.numberArrayOps.set(dst, pivot, pivot, this.numberOps.one());
            } else {
                boolean negate = this.isNeg(dst, pivot, pivot);
                col2 = pivot + 1;
                while (col2 < cols) {
                    if (this.isNonZero(dst, pivot, col2)) {
                        if (negate) {
                            this.negate(dst, pivot, col2);
                        }
                        prowNonZeroIndices.add(col2);
                    }
                    ++col2;
                }
                if (negate) {
                    this.negate(dst, pivot, pivot);
                }
            }
            int row2 = pivot + 1;
            while (row2 < rows) {
                if (this.isNonZero(dst, row2, pivot)) {
                    if (isDivSup) {
                        i = 0;
                        while (i < prowNonZeroIndices.length()) {
                            col = prowNonZeroIndices.get(i);
                            this.subtractPivotRowMultiple(dst, row2, col, pivot);
                            ++i;
                        }
                    } else {
                        i = 0;
                        col = pivot + 1;
                        while (col < cols) {
                            if (i < prowNonZeroIndices.length() && prowNonZeroIndices.get(i) == col) {
                                ++i;
                                this.multiply(dst, row2, col, pivot, pivot, false);
                                this.subtractPivotRowMultiple(dst, row2, col, pivot);
                            } else {
                                this.multiply(dst, row2, col, pivot, pivot, true);
                            }
                            ++col;
                        }
                    }
                    this.numberArrayOps.set(dst, row2, pivot, this.numberOps.zero());
                }
                ++row2;
            }
            if (reduced) {
                row2 = 0;
                while (row2 < pivot) {
                    if (this.isNonZero(dst, row2, pivot)) {
                        if (isDivSup) {
                            i = 0;
                            while (i < prowNonZeroIndices.length()) {
                                col = prowNonZeroIndices.get(i);
                                this.subtractPivotRowMultiple(dst, row2, col, pivot);
                                ++i;
                            }
                        } else {
                            i = 0;
                            col = pivot + 1;
                            while (col < cols) {
                                if (i < prowNonZeroIndices.length() && prowNonZeroIndices.get(i) == col) {
                                    ++i;
                                    this.multiply(dst, row2, col, pivot, pivot, false);
                                    this.subtractPivotRowMultiple(dst, row2, col, pivot);
                                } else {
                                    this.multiply(dst, row2, col, pivot, pivot, true);
                                }
                                ++col;
                            }
                            this.multiply(dst, row2, row2, pivot, pivot, true);
                        }
                        this.numberArrayOps.set(dst, row2, pivot, this.numberOps.zero());
                    }
                    ++row2;
                }
            }
            ++pivot;
        }
        return pivs;
    }

    private boolean isZero(A[] matrix, int row, int col) {
        return this.numberOps.booleanUnary(BooleanUnaryOperator.Id.isZero).booleanOperate(matrix[row], col);
    }

    private boolean isNonZero(A[] matrix, int row, int col) {
        return this.numberOps.booleanUnary(BooleanUnaryOperator.Id.isNonZero).booleanOperate(matrix[row], col);
    }

    private boolean isOne(A[] matrix, int row, int col) {
        return this.numberOps.booleanUnary(BooleanUnaryOperator.Id.isOne).booleanOperate(matrix[row], col);
    }

    private boolean isOne(A vec, int index) {
        return this.numberOps.booleanUnary(BooleanUnaryOperator.Id.isOne).booleanOperate(vec, index);
    }

    private boolean isNeg(A[] matrix, int row, int col) {
        return this.numberOps.booleanUnary(BooleanUnaryOperator.Id.isNegative).booleanOperate(matrix[row], col);
    }

    private void negate(A[] matrix, int row, int col) {
        this.negater.operate(matrix[row], col, matrix[row], col);
    }

    private void divide(A[] matrix, int row, int col, int divRow, int divCol) {
        this.dividerNormalizer.operate(matrix[row], col, matrix[divRow], divCol, matrix[row], col);
    }

    private void multiply(A[] matrix, int row, int col, int mulRow, int mulCol, boolean normalize) {
        if (normalize) {
            this.multiplierNormalizer.operate(matrix[row], col, matrix[mulRow], mulCol, matrix[row], col);
        } else {
            this.multiplier.operate(matrix[row], col, matrix[mulRow], mulCol, matrix[row], col);
        }
    }

    private void subtractPivotRowMultiple(A[] matrix, int row, int col, int piv) {
        this.pivotRowMultipleSubtracter.operate(matrix[row], col, matrix[row], piv, matrix[piv], col, matrix[row], col);
    }

    private static int initializeMapping(int size, int[] map) {
        if (map == null) {
            return size;
        }
        int i = 0;
        while (i < map.length) {
            map[i] = i;
            ++i;
        }
        return Math.min(size, map.length);
    }
}

