/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.impl;

import ch.javasoft.math.array.ArrayOperations;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArrayOperations<A>
implements ArrayOperations<A> {
    private final Class<A> arrayClass;

    public AbstractArrayOperations(Class<A> arrayClass) {
        this.arrayClass = arrayClass;
    }

    @Override
    public Class<A> arrayClass() {
        return this.arrayClass;
    }

    @Override
    public A newVector(int size) {
        return (A)Array.newInstance(this.arrayClass.getComponentType(), size);
    }

    @Override
    public A[] newMatrix(int rows, int columns) {
        return (Object[])Array.newInstance(this.arrayClass.getComponentType(), rows, columns);
    }

    @Override
    public int getRowCount(A[] matrix) {
        return matrix.length;
    }

    @Override
    public int getColumnCount(A[] matrix) {
        return matrix.length == 0 ? 0 : this.getLength(matrix[0]);
    }

    @Override
    public String getAsString(A[] matrix, int row, int column) {
        return this.getAsString(matrix[row], column);
    }

    @Override
    public String getVectorSignatureString(String name, A vector, boolean rowvec) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printVectorSignature(pw, name, vector, rowvec, false);
        pw.flush();
        return sw.toString();
    }

    @Override
    public String getMatrixSignatureString(String name, A[] matrix) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printMatrixSignature(pw, name, matrix, false);
        pw.flush();
        return sw.toString();
    }

    @Override
    public void copyVector(A src, A dst) {
        int len = this.getLength(src);
        System.arraycopy(src, 0, dst, 0, len);
    }

    @Override
    public void copyVectorElements(A src, int srcStart, A dst, int dstStart, int length) {
        System.arraycopy(src, srcStart, dst, dstStart, length);
    }

    @Override
    public void copyVectorElementsToMatrixRow(A src, int srcStart, A[] dst, int dstRow, int dstColStart, int length) {
        this.copyVectorElements(src, srcStart, dst[dstRow], dstColStart, length);
    }

    @Override
    public void copyMatrix(A[] src, A[] dst) {
        int rows = this.getRowCount(src);
        int cols = this.getColumnCount(src);
        int r = 0;
        while (r < rows) {
            System.arraycopy(src[r], 0, dst[r], 0, cols);
            ++r;
        }
    }

    @Override
    public void copyMatrixElements(A[] src, int srcRowStart, int srcColStart, A[] dst, int dstRowStart, int dstColStart, int rows, int cols) {
        int i = 0;
        while (i < rows) {
            this.copyMatrixRowElements(src, srcRowStart + i, srcColStart, dst, dstRowStart + i, dstColStart, cols);
            ++i;
        }
    }

    @Override
    public void copyMatrixRowElements(A[] src, int srcRow, int srcColStart, A[] dst, int dstRow, int dstColStart, int length) {
        this.copyVectorElements(src[srcRow], srcColStart, dst[dstRow], dstColStart, length);
    }

    @Override
    public void copyMatrixRowElementsToVector(A[] src, int srcRow, int srcColStart, A dst, int dstStart, int length) {
        this.copyVectorElements(src[srcRow], srcColStart, dst, dstStart, length);
    }

    @Override
    public A copyOfVector(A vector) {
        return this.copyOfVectorRange(vector, 0, this.getLength(vector));
    }

    @Override
    public A copyOfVector(A vector, int newLength) {
        return this.copyOfVectorRange(vector, 0, newLength);
    }

    @Override
    public A copyOfVectorRange(A vector, int from, int to) {
        int len = to - from;
        A copy = this.newVector(len);
        System.arraycopy(vector, from, copy, 0, len);
        return copy;
    }

    @Override
    public A[] copyOfMatrix(A[] matrix) {
        int rows = this.getRowCount(matrix);
        int cols = this.getColumnCount(matrix);
        A[] copy = this.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            System.arraycopy(matrix[r], 0, copy[r], 0, cols);
            ++r;
        }
        return copy;
    }

    @Override
    public A copyOfMatrixRow(A[] matrix, int row) {
        return this.copyOfVector(matrix[row]);
    }

    @Override
    public A copyOfMatrixRowRange(A[] matrix, int row, int colFrom, int colTo) {
        return this.copyOfVectorRange(matrix[row], colFrom, colTo);
    }

    @Override
    public A[] copyOfRowSubMatrix(A[] matrix, int ... rowIndices) {
        if (rowIndices == null) {
            return this.copyOfMatrix(matrix);
        }
        int rows = rowIndices.length;
        int cols = this.getColumnCount(matrix);
        A[] copy = this.newMatrix(rows, cols);
        int i = 0;
        while (i < rowIndices.length) {
            System.arraycopy(matrix[rowIndices[i]], 0, copy[i], 0, cols);
            ++i;
        }
        return copy;
    }

    @Override
    public void printVectorSignature(PrintWriter writer, String name, A vector, boolean rowvec, boolean newLine) {
        int len = this.getLength(vector);
        writer.print(name);
        writer.print(':');
        writer.print(rowvec ? 1 : len);
        writer.print('x');
        writer.print(rowvec ? len : 1);
        if (newLine) {
            writer.println();
        }
    }

    @Override
    public void printMatrixSignature(PrintWriter writer, String name, A[] matrix, boolean newLine) {
        int rows = this.getRowCount(matrix);
        int cols = this.getColumnCount(matrix);
        writer.print(name);
        writer.print(':');
        writer.print(rows);
        writer.print('x');
        writer.print(cols);
        if (newLine) {
            writer.println();
        }
    }

    @Override
    public void printVector(PrintWriter writer, String name, A vector, boolean newLine) {
        int len = this.getLength(vector);
        writer.print(name);
        writer.print(" = [");
        int i = 0;
        while (i < len) {
            writer.write(i == 0 ? " " : " , ");
            writer.write(this.getAsString(vector, i));
            ++i;
        }
        writer.print(" ]");
        if (newLine) {
            writer.println();
            writer.flush();
        }
    }

    @Override
    public void printMatrix(PrintWriter writer, String name, A[] matrix) {
        int rows = this.getRowCount(matrix);
        int cols = this.getColumnCount(matrix);
        this.printMatrixSignature(writer, name, matrix, false);
        writer.println(" {");
        int r = 0;
        while (r < rows) {
            writer.print("\t[");
            int c = 0;
            while (c < cols) {
                writer.write(c == 0 ? " " : " , ");
                writer.write(this.getAsString(matrix, r, c));
                ++c;
            }
            writer.println(" ]");
            ++r;
        }
        writer.println("}");
        writer.flush();
    }
}

