/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigFraction
extends Number
implements Comparable<BigFraction>,
Serializable {
    private static final long serialVersionUID = 1744509112026609387L;
    private static final double LOG10_OF_2 = Math.log10(2.0);
    private final BigInteger mNumerator;
    private final BigInteger mDenominator;
    private static Map<Class<? extends Number>, ValueOf> sValueOfMap = new HashMap<Class<? extends Number>, ValueOf>();
    public static final BigFraction ZERO;
    public static final BigFraction ONE;
    public static final BigFraction TWO;
    public static final BigFraction TEN;

    static {
        sValueOfMap.put(BigFraction.class, new ValueOf<BigFraction>(){

            @Override
            public BigFraction valueOf(BigFraction val) {
                return val;
            }
        });
        sValueOfMap.put(BigInteger.class, new ValueOf<BigInteger>(){

            @Override
            public BigFraction valueOf(BigInteger val) {
                return BigFraction.valueOf(val);
            }
        });
        sValueOfMap.put(BigDecimal.class, new ValueOf<BigDecimal>(){

            @Override
            public BigFraction valueOf(BigDecimal val) {
                return BigFraction.valueOf(val);
            }
        });
        sValueOfMap.put(Long.class, new ValueOf<Long>(){

            @Override
            public BigFraction valueOf(Long val) {
                return BigFraction.valueOf(val);
            }
        });
        sValueOfMap.put(AtomicLong.class, new ValueOf<AtomicLong>(){

            @Override
            public BigFraction valueOf(AtomicLong val) {
                return BigFraction.valueOf(val.longValue());
            }
        });
        sValueOfMap.put(Integer.class, new ValueOf<Integer>(){

            @Override
            public BigFraction valueOf(Integer val) {
                return BigFraction.valueOf(val.longValue());
            }
        });
        sValueOfMap.put(AtomicInteger.class, new ValueOf<AtomicInteger>(){

            @Override
            public BigFraction valueOf(AtomicInteger val) {
                return BigFraction.valueOf(val.longValue());
            }
        });
        sValueOfMap.put(Short.class, new ValueOf<Short>(){

            @Override
            public BigFraction valueOf(Short val) {
                return BigFraction.valueOf(val.longValue());
            }
        });
        sValueOfMap.put(Byte.class, new ValueOf<Byte>(){

            @Override
            public BigFraction valueOf(Byte val) {
                return BigFraction.valueOf(val.longValue());
            }
        });
        sValueOfMap.put(Double.class, new ValueOf<Double>(){

            @Override
            public BigFraction valueOf(Double val) {
                return BigFraction.valueOf(val);
            }
        });
        sValueOfMap.put(Float.class, new ValueOf<Float>(){

            @Override
            public BigFraction valueOf(Float val) {
                return BigFraction.valueOf(val.doubleValue());
            }
        });
        sValueOfMap.put(Number.class, new ValueOf<Number>(){

            @Override
            public BigFraction valueOf(Number val) {
                return BigFraction.valueOf(val.toString());
            }
        });
        ZERO = new BigFraction(BigInteger.ZERO, BigInteger.ONE);
        ONE = new BigFraction(BigInteger.ONE, BigInteger.ONE);
        TWO = new BigFraction(BigInteger.valueOf(2L), BigInteger.ONE);
        TEN = new BigFraction(BigInteger.TEN, BigInteger.ONE);
    }

    public BigFraction(long numerator, long denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public BigFraction(BigInteger numerator, BigInteger denominator) {
        if (numerator == null) {
            throw new NullPointerException("null numerator not allowed");
        }
        if (denominator == null) {
            throw new NullPointerException("null denominator not allowed");
        }
        if (denominator.signum() == 0) {
            if (numerator.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        this.mNumerator = numerator;
        this.mDenominator = denominator;
    }

    public BigFraction(String s) {
        this(BigFraction.valueOf(s));
    }

    private BigFraction(BigFraction copy) {
        this(copy.mNumerator, copy.mDenominator);
    }

    public BigInteger getNumerator() {
        return this.mNumerator;
    }

    public BigInteger getDenominator() {
        return this.mDenominator;
    }

    @Override
    public double doubleValue() {
        return BigFraction.toDouble(this.mNumerator, this.mDenominator);
    }

    @Override
    public float floatValue() {
        return BigFraction.toFloat(this.mNumerator, this.mDenominator);
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public BigInteger toBigInteger() {
        return this.mNumerator.divide(this.mDenominator);
    }

    public BigInteger toBigInteger(RoundingMode roundingMode) {
        return this.toBigDecimal(0, roundingMode).toBigIntegerExact();
    }

    public BigInteger toBigIntegerExact() {
        return this.toBigInteger(RoundingMode.UNNECESSARY);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.mNumerator).divide(new BigDecimal(this.mDenominator));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return new BigDecimal(this.mNumerator).divide(new BigDecimal(this.mDenominator), mc);
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode roundingMode) {
        return new BigDecimal(this.mNumerator).divide(new BigDecimal(this.mDenominator), scale, roundingMode);
    }

    public int hashCode() {
        return this.mNumerator.hashCode() ^ this.mDenominator.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            BigFraction other = (BigFraction)obj;
            return this.mNumerator.equals(other.mNumerator) && this.mDenominator.equals(other.mDenominator);
        }
        return false;
    }

    @Override
    public int compareTo(BigFraction other) {
        if (other == this) {
            return 0;
        }
        if (this.mDenominator.compareTo(other.mDenominator) == 0) {
            return this.mNumerator.compareTo(other.mNumerator);
        }
        BigInteger mulThis = this.mNumerator.multiply(other.mDenominator);
        BigInteger mulOther = other.mNumerator.multiply(this.mDenominator);
        return mulThis.compareTo(mulOther);
    }

    public int signum() {
        return this.mNumerator.signum() * this.mDenominator.signum();
    }

    public BigFraction abs() {
        int sgnDenominator;
        int sgnNumerator = this.mNumerator.signum();
        if (sgnNumerator * (sgnDenominator = this.mDenominator.signum()) < 0) {
            if (sgnDenominator < 0) {
                return new BigFraction(this.mNumerator, this.mDenominator.negate());
            }
            return new BigFraction(this.mNumerator.negate(), this.mDenominator);
        }
        return this;
    }

    public BigFraction negate() {
        int sgnNumerator = this.mNumerator.signum();
        if (sgnNumerator == 0) {
            return ZERO;
        }
        int sgnDenominator = this.mDenominator.signum();
        if (sgnDenominator < 0) {
            return new BigFraction(this.mNumerator, this.mDenominator.negate());
        }
        return new BigFraction(this.mNumerator.negate(), this.mDenominator);
    }

    public BigFraction invert() {
        int sgn = this.mNumerator.signum();
        if (sgn == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (sgn < 0) {
            return new BigFraction(this.mDenominator.negate(), this.mNumerator.negate());
        }
        if (this.isOne()) {
            return ONE;
        }
        return new BigFraction(this.mDenominator, this.mNumerator);
    }

    public BigFraction add(BigFraction val) {
        if (this.signum() == 0) {
            return val;
        }
        if (val.signum() == 0) {
            return this;
        }
        if (this.mDenominator.equals(val.mDenominator)) {
            return new BigFraction(this.mNumerator.add(val.mNumerator), this.mDenominator);
        }
        return BigFraction.valueOf(this.mNumerator.multiply(val.mDenominator).add(val.mNumerator.multiply(this.mDenominator)), this.mDenominator.multiply(val.mDenominator));
    }

    public BigFraction subtract(BigFraction val) {
        if (this.signum() == 0) {
            return val.negate();
        }
        if (val.signum() == 0) {
            return this;
        }
        if (this.mDenominator.equals(val.mDenominator)) {
            return new BigFraction(this.mNumerator.subtract(val.mNumerator), this.mDenominator);
        }
        return new BigFraction(this.mNumerator.multiply(val.mDenominator).subtract(val.mNumerator.multiply(this.mDenominator)), this.mDenominator.multiply(val.mDenominator));
    }

    public BigFraction multiply(BigFraction val) {
        if (this.signum() == 0 || val.signum() == 0) {
            return ZERO;
        }
        if (val.isOne()) {
            return this;
        }
        if (this.isOne()) {
            return val;
        }
        return new BigFraction(this.mNumerator.multiply(val.mNumerator), this.mDenominator.multiply(val.mDenominator));
    }

    public BigFraction divide(BigFraction by) {
        int sgn = this.signum();
        if (by.signum() == 0) {
            if (sgn == 0) {
                throw new ArithmeticException("Division undefined: 0/0");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (sgn == 0) {
            return ZERO;
        }
        if (by.isOne()) {
            return this;
        }
        if (this.isOne()) {
            return BigFraction.valueOf(by.mDenominator, by.mNumerator);
        }
        return BigFraction.valueOf(this.mNumerator.multiply(by.mDenominator), this.mDenominator.multiply(by.mNumerator));
    }

    public BigFraction pow(int exponent) {
        if (this.mNumerator.signum() == 0) {
            if (exponent == 0) {
                return ONE;
            }
            if (exponent < 0) {
                throw new ArithmeticException("Division by zero");
            }
            return ZERO;
        }
        if (exponent == 0 || this.isOne()) {
            return ONE;
        }
        if (exponent < 0) {
            if (-exponent < 0) {
                throw new ArithmeticException("exponent to small: " + exponent);
            }
            return new BigFraction(this.mDenominator.pow(-exponent), this.mNumerator.pow(-exponent));
        }
        return new BigFraction(this.mNumerator.pow(exponent), this.mDenominator.pow(exponent));
    }

    public BigFraction shiftLeft(int n) {
        if (this.isZero()) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        int shiftDen = Math.min(n, Math.max(0, this.mDenominator.getLowestSetBit()));
        int shiftNom = Math.max(0, n - shiftDen);
        return new BigFraction(this.mNumerator.shiftLeft(shiftNom), this.mDenominator.shiftRight(shiftDen));
    }

    public BigFraction shiftRight(int n) {
        if (this.isZero()) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        int shiftNom = Math.min(n, Math.max(0, this.mNumerator.getLowestSetBit()));
        int shiftDen = Math.max(0, n - shiftNom);
        return new BigFraction(this.mNumerator.shiftRight(shiftNom), this.mDenominator.shiftLeft(shiftDen));
    }

    public BigFraction max(BigFraction with) {
        if (this.compareTo(with) < 0) {
            return with;
        }
        return this;
    }

    public BigFraction min(BigFraction with) {
        if (this.compareTo(with) > 0) {
            return with;
        }
        return this;
    }

    public BigFraction reduce() {
        int sgnNumerator = this.mNumerator.signum();
        if (sgnNumerator == 0) {
            return ZERO;
        }
        if (this.mDenominator.equals(BigInteger.ONE)) {
            return this;
        }
        BigInteger gcd = this.mNumerator.gcd(this.mDenominator);
        if (this.mDenominator.signum() < 0) {
            gcd = gcd.negate();
        } else if (gcd.equals(BigInteger.ONE)) {
            return this;
        }
        return BigFraction.valueOf(this.mNumerator.divide(gcd), this.mDenominator.divide(gcd));
    }

    public BigFraction gcd(BigFraction val) {
        int sgnThis = this.signum();
        int sgnOther = this.signum();
        if (sgnThis == 0 && sgnOther == 0) {
            return ZERO;
        }
        BigInteger num = this.mNumerator.gcd(val.mNumerator);
        BigInteger den = this.mDenominator.gcd(val.mDenominator);
        if (sgnThis < 0 && sgnOther < 0) {
            return BigFraction.valueOf(num.negate(), den);
        }
        return BigFraction.valueOf(num, den);
    }

    public static BigFraction gcd(BigFraction ... values) {
        if (values.length == 0) {
            return ONE;
        }
        int allSgn = values[0].signum();
        BigInteger num = values[0].mNumerator;
        BigInteger den = allSgn == 0 ? BigInteger.ZERO : values[0].mDenominator;
        int i = 1;
        while (i < values.length) {
            BigFraction val = values[i];
            if (allSgn != val.signum()) {
                allSgn = 1;
            }
            if (num.equals(BigInteger.ONE) && den.equals(BigInteger.ONE)) break;
            num = num.gcd(val.mNumerator);
            if (val.signum() != 0) {
                den = den.gcd(val.mDenominator);
            }
            ++i;
        }
        if (allSgn == 0) {
            return ZERO;
        }
        if (allSgn < 0) {
            return BigFraction.valueOf(num.negate(), den);
        }
        return BigFraction.valueOf(num, den);
    }

    public boolean isZero() {
        return this.mNumerator.signum() == 0;
    }

    public boolean isReduced() {
        if (BigInteger.ONE.equals(this.mDenominator)) {
            return true;
        }
        return BigInteger.ONE.equals(this.mNumerator.gcd(this.mDenominator));
    }

    public boolean isNonZero() {
        return this.mNumerator.signum() != 0;
    }

    public boolean isNegative() {
        return this.signum() < 0;
    }

    public boolean isNonNegative() {
        return this.signum() >= 0;
    }

    public boolean isPositive() {
        return this.signum() > 0;
    }

    public boolean isNonPositive() {
        return this.signum() <= 0;
    }

    public boolean isOne() {
        return this == ONE || this.mNumerator.equals(this.mDenominator);
    }

    public boolean isInteger() {
        if (this.mNumerator.equals(this.mDenominator)) {
            return true;
        }
        if (this.mDenominator.equals(BigInteger.ONE)) {
            return true;
        }
        return BigInteger.ZERO.equals(this.mNumerator.remainder(this.mDenominator.abs()));
    }

    public boolean equalsNumerically(BigFraction other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return this.mDenominator.compareTo(BigInteger.ONE) == 0 ? this.mNumerator.toString() : this.mNumerator + "/" + this.mDenominator;
    }

    public static BigFraction valueOf(String s) throws NumberFormatException {
        int slashIndex;
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if ((slashIndex = s.indexOf(47)) < 0) {
            int dotIndex = s.indexOf(46);
            if (dotIndex < 0) {
                return BigFraction.valueOf(new BigInteger(s), BigInteger.ONE);
            }
            return BigFraction.valueOf(new BigDecimal(s));
        }
        return BigFraction.valueOf(new BigInteger(s.substring(0, slashIndex)), new BigInteger(s.substring(slashIndex + 1)));
    }

    public static BigFraction valueOf(BigInteger val) {
        return BigFraction.valueOf(val, BigInteger.ONE);
    }

    public static BigFraction valueOf(BigDecimal val) {
        int scale = val.scale();
        if (scale > 0) {
            return BigFraction.valueOf(val.unscaledValue(), BigInteger.TEN.pow(val.scale()));
        }
        return BigFraction.valueOf(val.toBigIntegerExact());
    }

    public static BigFraction valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val == 1L) {
            return ONE;
        }
        if (val == 2L) {
            return TWO;
        }
        return BigFraction.valueOf(val, 1L);
    }

    public static BigFraction valueOf(double val) {
        return BigFraction.valueOf(BigDecimal.valueOf(val));
    }

    public static BigFraction valueOf(long numerator, long denominator) {
        if (denominator == 1L) {
            if (numerator == 0L) {
                return ZERO;
            }
            if (numerator == 1L) {
                return ONE;
            }
            if (numerator == 2L) {
                return TWO;
            }
            if (numerator == 10L) {
                return TEN;
            }
            return new BigFraction(BigInteger.valueOf(numerator), BigInteger.ONE);
        }
        return new BigFraction(numerator, denominator);
    }

    public static BigFraction valueOf(BigInteger numerator, BigInteger denominator) {
        if (denominator.equals(BigInteger.ONE)) {
            if (numerator.signum() == 0) {
                return ZERO;
            }
            if (numerator.equals(BigInteger.ONE)) {
                return ONE;
            }
            if (numerator.equals(BigInteger.TEN)) {
                return TEN;
            }
            return new BigFraction(numerator, BigInteger.ONE);
        }
        return new BigFraction(numerator, denominator);
    }

    public static BigFraction valueOf(Number val) {
        ValueOf valOf = sValueOfMap.get(val.getClass());
        if (valOf == null) {
            valOf = sValueOfMap.get(Number.class);
        }
        return valOf.valueOf(val);
    }

    public static BigFraction valueOfAdjusted(double val) {
        return BigFraction.valueOfAdjusted(val, 0.0);
    }

    public static BigFraction valueOfAdjusted(double val, double tolerance) {
        int sgn;
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            throw new ArithmeticException("cannot convert double into fraction number: " + val);
        }
        if (tolerance < 0.0 || Double.isNaN(tolerance) || Double.isInfinite(tolerance)) {
            throw new IllegalArgumentException("illegal tolerance value: " + tolerance);
        }
        if (val < 0.0) {
            sgn = -1;
            val = -val;
        } else {
            sgn = 1;
        }
        long powOfTen = 1L;
        long ratioLargeSmall = 1L;
        do {
            long powOfSmall = 1L;
            while (powOfSmall <= ratioLargeSmall) {
                long powOfLarge = ratioLargeSmall * powOfSmall;
                if (powOfTen / powOfLarge <= 1L) {
                    long l = Math.round(val * (double)powOfTen);
                    if (Math.abs(val - (double)l / (double)powOfTen) <= tolerance) {
                        return BigFraction.valueOf((long)sgn * l, powOfTen);
                    }
                    powOfTen *= 10L;
                }
                if (powOfLarge / powOfSmall == ratioLargeSmall) {
                    long diffL;
                    double guess;
                    double large = val * (double)powOfLarge;
                    double small = val * (double)powOfSmall;
                    double diff = Math.abs(large - small);
                    if (diff <= 9.223372036854776E18 && Math.abs((guess = (double)(diffL = Math.round(diff)) / (double)(powOfLarge - powOfSmall)) - val) <= tolerance) {
                        return BigFraction.valueOf((long)sgn * diffL, powOfLarge - powOfSmall);
                    }
                    powOfSmall <<= 1;
                    continue;
                }
                powOfSmall = ratioLargeSmall + 1L;
            }
        } while ((ratioLargeSmall <<= 1) > 0L);
        return BigFraction.valueOf((double)sgn * val);
    }

    public static double toDouble(BigInteger numerator, BigInteger denominator) {
        int numBits = numerator.bitLength();
        int denBits = denominator.bitLength();
        int scale = (int)((double)(52 - numBits + denBits + 2) * LOG10_OF_2) + 1;
        return new BigDecimal(numerator).divide(new BigDecimal(denominator), scale, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static float toFloat(BigInteger numerator, BigInteger denominator) {
        int numBits = numerator.bitLength();
        int denBits = denominator.bitLength();
        int scale = (int)((double)(23 - numBits + denBits + 2) * LOG10_OF_2) + 1;
        return new BigDecimal(numerator).divide(new BigDecimal(denominator), scale, RoundingMode.HALF_EVEN).floatValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ValueOf<N extends Number> {
        public BigFraction valueOf(N var1);
    }
}

