/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat;

import ch.javasoft.jsmat.MatWriter;
import ch.javasoft.jsmat.ReservedComplexWriter;
import ch.javasoft.jsmat.ReservedWriter;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedMatrixWriter<A>
extends ReservedWriter {
    private final MatReservedMatrix<A> mReservedMatrix;
    private int mWrittenLength = 0;

    public ReservedMatrixWriter(ReservedComplexWriter complexWriter, MatReservedMatrix<A> reservedMatrix) {
        super(complexWriter, reservedMatrix);
        this.mReservedMatrix = reservedMatrix;
    }

    public ReservedMatrixWriter(MatWriter<? extends DataOutput> writer, MatReservedMatrix<A> reservedMatrix) {
        super(writer, reservedMatrix);
        this.mReservedMatrix = reservedMatrix;
    }

    public void append(A data) throws IOException {
        if (this.mWrittenLength < 0) {
            throw new IOException("reserved writer has already been closed");
        }
        this.mWrittenLength += this.mReservedMatrix.appendData(this.mDataOutput, data);
        if (this.mWrittenLength > this.mReservedMatrix.getDimLength()) {
            throw new IOException("appended more data than reserved size permits: " + this.mWrittenLength + " > " + this.mReservedMatrix.getDimLength());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWrittenLength != this.mReservedMatrix.getDimLength()) {
            throw new IOException("appended data length differs from reserved size: " + this.mWrittenLength + " != " + this.mReservedMatrix.getDimLength());
        }
        this.mWrittenLength = -1;
        super.close();
    }
}

