/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.marshal;

import ch.javasoft.jbase.FixedWidthMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PrimitiveMarshallers {
    public static final FixedWidthMarshaller<Byte> BYTE = new FixedWidthMarshaller<Byte>(){

        @Override
        public void writeTo(Byte entity, DataOutput out) throws IOException {
            out.writeByte(entity.byteValue());
        }

        @Override
        public Byte readFrom(DataInput in) throws IOException {
            return in.readByte();
        }

        @Override
        public int getByteWidth() {
            return 1;
        }
    };
    public static final FixedWidthMarshaller<Short> SHORT = new FixedWidthMarshaller<Short>(){

        @Override
        public void writeTo(Short entity, DataOutput out) throws IOException {
            out.writeInt(entity.shortValue());
        }

        @Override
        public Short readFrom(DataInput in) throws IOException {
            return in.readShort();
        }

        @Override
        public int getByteWidth() {
            return 2;
        }
    };
    public static final FixedWidthMarshaller<Integer> INTEGER = new FixedWidthMarshaller<Integer>(){

        @Override
        public void writeTo(Integer entity, DataOutput out) throws IOException {
            out.writeInt(entity);
        }

        @Override
        public Integer readFrom(DataInput in) throws IOException {
            return in.readInt();
        }

        @Override
        public int getByteWidth() {
            return 4;
        }
    };
    public static final FixedWidthMarshaller<Long> LONG = new FixedWidthMarshaller<Long>(){

        @Override
        public void writeTo(Long entity, DataOutput out) throws IOException {
            out.writeLong(entity);
        }

        @Override
        public Long readFrom(DataInput in) throws IOException {
            return in.readLong();
        }

        @Override
        public int getByteWidth() {
            return 8;
        }
    };
    public static final FixedWidthMarshaller<Float> FLOAT = new FixedWidthMarshaller<Float>(){

        @Override
        public void writeTo(Float entity, DataOutput out) throws IOException {
            out.writeFloat(entity.floatValue());
        }

        @Override
        public Float readFrom(DataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }

        @Override
        public int getByteWidth() {
            return 4;
        }
    };
    public static final FixedWidthMarshaller<Double> DOUBLE = new FixedWidthMarshaller<Double>(){

        @Override
        public void writeTo(Double entity, DataOutput out) throws IOException {
            out.writeDouble(entity);
        }

        @Override
        public Double readFrom(DataInput in) throws IOException {
            return in.readDouble();
        }

        @Override
        public int getByteWidth() {
            return 8;
        }
    };
    public static final FixedWidthMarshaller<Boolean> BOOLEAN = new FixedWidthMarshaller<Boolean>(){

        @Override
        public void writeTo(Boolean entity, DataOutput out) throws IOException {
            out.writeBoolean(entity);
        }

        @Override
        public Boolean readFrom(DataInput in) throws IOException {
            return in.readBoolean();
        }

        @Override
        public int getByteWidth() {
            return 1;
        }
    };
    public static final FixedWidthMarshaller<Character> CHARACTER = new FixedWidthMarshaller<Character>(){

        @Override
        public void writeTo(Character entity, DataOutput out) throws IOException {
            out.writeChar(entity.charValue());
        }

        @Override
        public Character readFrom(DataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }

        @Override
        public int getByteWidth() {
            return 2;
        }
    };

    private PrimitiveMarshallers() {
    }
}

