/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.ByteArray;
import ch.javasoft.jbase.FixedWidthMarshaller;
import ch.javasoft.jbase.concurrent.Stateful;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FixedTableRow
implements FixedWidthMarshaller<FixedTableRow>,
Stateful {
    final byte[] bytes;
    final int[] ints;
    private boolean indexOnlyMode = false;

    public FixedTableRow(int byteArrayLength, int intCount) {
        this.bytes = new byte[byteArrayLength];
        this.ints = new int[intCount];
    }

    public static FixedTableRow getByTotalByteWidth(int width, int indexCount) {
        return new FixedTableRow(width - indexCount * 4, indexCount);
    }

    public static FixedTableRow getByByteArrayLength(int byteArrayLength, int indexCount) {
        return new FixedTableRow(byteArrayLength, indexCount);
    }

    public int getByteArrayLength() {
        return this.bytes.length;
    }

    @Override
    public int getByteWidth() {
        return this.bytes.length + this.ints.length * 4;
    }

    public boolean isIndexOnlyMode() {
        return this.indexOnlyMode;
    }

    public void setIndexOnlyMode(boolean indexOnly) {
        this.indexOnlyMode = indexOnly;
    }

    @Override
    public void writeTo(FixedTableRow entity, DataOutput out) throws IOException {
        int i = 0;
        while (i < this.ints.length) {
            out.writeInt(this.ints[i]);
            ++i;
        }
        if (!this.indexOnlyMode) {
            out.write(this.bytes);
        }
    }

    @Override
    public FixedTableRow readFrom(DataInput in) throws IOException {
        int i = 0;
        while (i < this.ints.length) {
            this.ints[i] = in.readInt();
            ++i;
        }
        if (!this.indexOnlyMode) {
            in.readFully(this.bytes);
        }
        return this;
    }

    public void putBytesTo(ByteArray byteArray) {
        byteArray.write(this.bytes);
    }

    public int getBytesFrom(ByteArray byteArray) {
        return byteArray.copyTo(this.bytes);
    }

    public int getInt(int index) {
        return this.ints[index];
    }

    public void setInt(int index, int value) {
        this.ints[index] = value;
    }

    public String toString() {
        return "{" + Arrays.toString(this.ints) + Arrays.toString(this.bytes) + "}";
    }

    @Override
    public FixedTableRow createReadCopy(ReadWriteLock lock) throws IOException {
        FixedTableRow clone = new FixedTableRow(this.bytes.length, this.ints.length);
        System.arraycopy(this.bytes, 0, clone.bytes, 0, this.bytes.length);
        System.arraycopy(this.ints, 0, clone.ints, 0, this.ints.length);
        clone.indexOnlyMode = this.indexOnlyMode;
        return clone;
    }
}

