/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.BitSetOps;
import ch.javasoft.bitset.GenericBitSet;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedBitSet<B extends GenericBitSet<B>>
implements GenericBitSet<WrappedBitSet<B>> {
    protected final B bitSet;

    public WrappedBitSet(B pBitSet) {
        this.bitSet = pBitSet;
    }

    @Override
    public void set(int bit) {
        this.bitSet.set(bit);
    }

    @Override
    public void clear(int bit) {
        this.bitSet.clear(bit);
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public void flip(int bit) {
        this.bitSet.flip(bit);
    }

    @Override
    public boolean get(int bit) {
        return this.bitSet.get(bit);
    }

    @Override
    public boolean isSubSetOf(WrappedBitSet<B> of) {
        return this.bitSet.isSubSetOf(of.bitSet);
    }

    @Override
    public void and(WrappedBitSet<B> with) {
        this.bitSet.and(with.bitSet);
    }

    @Override
    public void or(WrappedBitSet<B> with) {
        this.bitSet.or(with.bitSet);
    }

    @Override
    public int length() {
        return this.bitSet.length();
    }

    @Override
    public int cardinality() {
        return this.bitSet.cardinality();
    }

    @Override
    public int cardinality(int fromBit, int toBit) {
        return this.bitSet.cardinality(fromBit, toBit);
    }

    @Override
    public int nextSetBit(int from) {
        return this.nextSetBit(from);
    }

    @Override
    public int nextClearBit(int from) {
        return this.nextClearBit(from);
    }

    @Override
    public WrappedBitSet<B> clone() {
        return new WrappedBitSet(this.bitSet.clone());
    }

    @Override
    public BitSet toBitSet() {
        return this.bitSet.toBitSet();
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    @Override
    public int hashCodeObj() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedBitSet) {
            return this.bitSet.equals(((WrappedBitSet)obj).bitSet);
        }
        return false;
    }

    @Override
    public BitSetFactory<WrappedBitSet<B>> factory() {
        return new Factory(this);
    }

    @Override
    public BitSetOps<WrappedBitSet<B>> ops() {
        return new Ops();
    }

    @Override
    public long[] toLongArray() {
        return this.bitSet.toLongArray();
    }

    @Override
    public long[] toLongArray(long[] arr, int offset) {
        return this.bitSet.toLongArray(arr, offset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory<BB extends GenericBitSet<BB>>
    implements BitSetFactory<WrappedBitSet<BB>> {
        protected final BitSetFactory<BB> factory;

        public Factory(BitSetFactory<BB> pFactory) {
            this.factory = pFactory;
        }

        public Factory(BB bitSet) {
            this((BB)bitSet.factory());
        }

        public Factory(WrappedBitSet<BB> bitSet) {
            this((BB)bitSet.bitSet.factory());
        }

        public WrappedBitSet<BB>[] createArray(int size) {
            return new WrappedBitSet[size];
        }

        public WrappedBitSet<BB> createBitSet() {
            return new WrappedBitSet<GenericBitSet>(this.factory.createBitSet());
        }

        public WrappedBitSet<BB> createBitSetBeingEqualForSameInstanceOnly() {
            return new WrappedBitSet<BB>(this.factory.createBitSet()){

                @Override
                public boolean equals(Object other) {
                    return this == other;
                }

                @Override
                public int hashCode() {
                    return this.hashCodeObj();
                }
            };
        }

        public WrappedBitSet<BB> createBitSet(BitSet bits) {
            return new WrappedBitSet<GenericBitSet>(this.factory.createBitSet(bits));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ops<BB extends GenericBitSet<BB>>
    implements BitSetOps<WrappedBitSet<BB>> {
        @Override
        public WrappedBitSet<BB> and(WrappedBitSet<BB> opA, WrappedBitSet<BB> opB) {
            return new WrappedBitSet(opA.bitSet.ops().and(opA.bitSet, opB.bitSet));
        }

        public WrappedBitSet<BB> and(WrappedBitSet<BB>[] operands) {
            if (operands.length < 1) {
                throw new IndexOutOfBoundsException("0 operands not supported");
            }
            GenericBitSet[] bOperands = operands[0].bitSet.factory().createArray(operands.length);
            int ii = 0;
            while (ii < bOperands.length) {
                bOperands[ii] = operands[ii].bitSet;
                ++ii;
            }
            return new WrappedBitSet<GenericBitSet>(operands[0].bitSet.ops().and(bOperands));
        }

        @Override
        public WrappedBitSet<BB> or(WrappedBitSet<BB> opA, WrappedBitSet<BB> opB) {
            return new WrappedBitSet(opA.bitSet.ops().or(opA.bitSet, opB.bitSet));
        }
    }
}

