/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.BitSetOps;
import ch.javasoft.bitset.GenericBitSet;
import ch.javasoft.util.numeric.IntegerUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLongBitSet
implements GenericBitSet<SimpleLongBitSet> {
    public static final BitSetFactory<SimpleLongBitSet> FACTORY = new BitSetFactory<SimpleLongBitSet>(){

        public SimpleLongBitSet createBitSet() {
            return new SimpleLongBitSet();
        }

        public SimpleLongBitSet createBitSetBeingEqualForSameInstanceOnly() {
            return new SimpleLongBitSet(){

                public boolean equals(Object obj) {
                    return this == obj;
                }

                public int hashCode() {
                    return this.hashCodeObj();
                }
            };
        }

        public SimpleLongBitSet[] createArray(int size) {
            return new SimpleLongBitSet[size];
        }

        public SimpleLongBitSet createBitSet(BitSet bits) {
            return new SimpleLongBitSet(bits);
        }
    };
    public static final BitSetOps<SimpleLongBitSet> OPS = new BitSetOps<SimpleLongBitSet>(){

        @Override
        public SimpleLongBitSet and(SimpleLongBitSet opA, SimpleLongBitSet opB) {
            return SimpleLongBitSet.getAnd(opA, opB);
        }

        public SimpleLongBitSet and(SimpleLongBitSet[] operands) {
            return SimpleLongBitSet.getAnd(operands);
        }

        @Override
        public SimpleLongBitSet or(SimpleLongBitSet opA, SimpleLongBitSet opB) {
            return SimpleLongBitSet.getOr(opA, opB);
        }
    };
    private static final int BITS_PER_UNIT = 64;
    private long[] mUnits;

    public SimpleLongBitSet() {
        this(64);
    }

    public SimpleLongBitSet(int bitCapacity) {
        this.mUnits = new long[1 + (bitCapacity - 1) / 64];
    }

    public SimpleLongBitSet(BitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public SimpleLongBitSet(GenericBitSet<? extends GenericBitSet> bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public SimpleLongBitSet(String bitString) {
        this(bitString.length());
        int ii = 0;
        while (ii < bitString.length()) {
            if (bitString.charAt(ii) == '1') {
                this.set(ii);
            }
            ++ii;
        }
    }

    public SimpleLongBitSet(long[] units, boolean cloneArray) {
        this.mUnits = cloneArray ? (long[])units.clone() : units;
    }

    private void ensureCapacity(int unitLen) {
        if (this.mUnits.length < unitLen) {
            long[] newUnits = new long[unitLen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, this.mUnits.length);
            this.mUnits = newUnits;
        }
    }

    public void set(int bit, boolean value) {
        if (value) {
            this.set(bit);
        } else {
            this.clear(bit);
        }
    }

    @Override
    public void set(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = this.mUnits[n] | mask;
    }

    @Override
    public void clear(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        int n = unit;
        this.mUnits[n] = this.mUnits[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear() {
        int ii = 0;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0L;
            ++ii;
        }
    }

    @Override
    public void flip(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = this.mUnits[n] ^ this.mUnits[unit] & mask;
    }

    @Override
    public boolean get(int bit) {
        int unit = bit / 64;
        if (unit >= this.mUnits.length) {
            return false;
        }
        int index = bit % 64;
        long mask = 1L << index;
        return 0L != (this.mUnits[unit] & mask);
    }

    @Override
    public boolean isSubSetOf(SimpleLongBitSet of) {
        if (this == of) {
            return true;
        }
        int min = Math.min(this.mUnits.length, of.mUnits.length);
        int ii = 0;
        while (ii < min) {
            long and = this.mUnits[ii] & of.mUnits[ii];
            if (and != this.mUnits[ii]) {
                return false;
            }
            ++ii;
        }
        int i = min;
        while (i < this.mUnits.length) {
            if (this.mUnits[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void and(SimpleLongBitSet with) {
        if (this == with) {
            return;
        }
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int ii = 0;
        while (ii < len) {
            int n = ii;
            this.mUnits[n] = this.mUnits[n] & with.mUnits[ii];
            ++ii;
        }
        ii = len;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0L;
            ++ii;
        }
    }

    @Override
    public void or(SimpleLongBitSet with) {
        if (this == with) {
            return;
        }
        if (with.mUnits.length > this.mUnits.length) {
            long[] newUnits = new long[with.mUnits.length];
            int i = 0;
            while (i < this.mUnits.length) {
                newUnits[i] = this.mUnits[i] | with.mUnits[i];
                ++i;
            }
            i = this.mUnits.length;
            while (i < with.mUnits.length) {
                newUnits[i] = with.mUnits[i];
                ++i;
            }
            this.mUnits = newUnits;
        } else {
            int len = Math.min(this.mUnits.length, with.mUnits.length);
            int i = 0;
            while (i < len) {
                int n = i;
                this.mUnits[n] = this.mUnits[n] | with.mUnits[i];
                ++i;
            }
        }
    }

    public void xor(SimpleLongBitSet with) {
        int newlen = Math.max(this.mUnits.length, with.mUnits.length);
        if (this.mUnits.length == with.mUnits.length) {
            while (newlen > 0 && 0L == (this.mUnits[newlen - 1] ^ with.mUnits[newlen - 1])) {
                --newlen;
            }
        }
        if (newlen != this.mUnits.length) {
            long[] newUnits = new long[newlen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, Math.min(newlen, this.mUnits.length));
            this.mUnits = newUnits;
        }
        int len = Math.min(with.mUnits.length, newlen);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = this.mUnits[n] ^ with.mUnits[i];
            ++i;
        }
    }

    public void andNot(SimpleLongBitSet with) {
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = this.mUnits[n] & (with.mUnits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public static SimpleLongBitSet getXor(SimpleLongBitSet setA, SimpleLongBitSet setB) {
        SimpleLongBitSet res;
        if (setA.mUnits.length > setB.mUnits.length) {
            res = setA.clone();
            res.xor(setB);
        } else {
            res = setB.clone();
            res.xor(setA);
        }
        return res;
    }

    public static int getXorCardinality(SimpleLongBitSet setA, SimpleLongBitSet setB) {
        int card = 0;
        int minLen = Math.min(setA.mUnits.length, setB.mUnits.length);
        int i = 0;
        while (i < minLen) {
            card += IntegerUtil.bitCount((long)(setA.mUnits[i] ^ setB.mUnits[i]));
            ++i;
        }
        i = minLen;
        while (i < setA.mUnits.length) {
            card += IntegerUtil.bitCount((long)setA.mUnits[i]);
            ++i;
        }
        i = minLen;
        while (i < setB.mUnits.length) {
            card += IntegerUtil.bitCount((long)setB.mUnits[i]);
            ++i;
        }
        return card;
    }

    public static SimpleLongBitSet getOr(SimpleLongBitSet setA, SimpleLongBitSet setB) {
        SimpleLongBitSet smaller;
        SimpleLongBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        long[] units = new long[larger.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = smaller.mUnits[i] | larger.mUnits[i];
            ++i;
        }
        return new SimpleLongBitSet(units, false);
    }

    public static SimpleLongBitSet getAnd(SimpleLongBitSet setA, SimpleLongBitSet setB) {
        SimpleLongBitSet smaller;
        SimpleLongBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        long[] units = new long[smaller.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = smaller.mUnits[i] & larger.mUnits[i];
            ++i;
        }
        return new SimpleLongBitSet(units, false);
    }

    public static SimpleLongBitSet getAndNot(SimpleLongBitSet setA, SimpleLongBitSet setB) {
        long[] units = new long[setA.mUnits.length];
        int i = 0;
        while (i < setB.mUnits.length) {
            units[i] = setA.mUnits[i] & (setA.mUnits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
        i = setB.mUnits.length;
        while (i < setA.mUnits.length) {
            units[i] = setA.mUnits[i];
            ++i;
        }
        return new SimpleLongBitSet(units, false);
    }

    public static SimpleLongBitSet getAnd(SimpleLongBitSet ... bitSets) {
        if (bitSets.length == 0) {
            return new SimpleLongBitSet();
        }
        if (bitSets.length == 1) {
            return bitSets[0].clone();
        }
        if (bitSets.length == 2) {
            return SimpleLongBitSet.getAnd(bitSets[0], bitSets[1]);
        }
        int smallest = 0;
        int i = 1;
        while (i < bitSets.length) {
            if (bitSets[i].length() < bitSets[smallest].length()) {
                smallest = i;
            }
            ++i;
        }
        SimpleLongBitSet result = bitSets[smallest].clone();
        int i2 = 0;
        while (i2 < bitSets.length) {
            if (i2 != smallest) {
                result.and(bitSets[i2]);
            }
            ++i2;
        }
        return result;
    }

    private int unitLength() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index + 1;
    }

    @Override
    public int length() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index < 0 ? 0 : index * 64 + SimpleLongBitSet.bitLenL(this.mUnits[index]);
    }

    private static int bitLenL(long l) {
        int high = (int)(l >>> 32);
        int low = (int)l;
        return high == 0 ? SimpleLongBitSet.bitLenI(low) : 32 + SimpleLongBitSet.bitLenI(high);
    }

    private static int bitLenI(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0L) {
        }
        return index < 0;
    }

    @Override
    public SimpleLongBitSet clone() {
        return new SimpleLongBitSet((long[])this.mUnits.clone(), false);
    }

    @Override
    public int cardinality() {
        int card = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            card += IntegerUtil.bitCount((long)this.mUnits[ii]);
            ++ii;
        }
        return card;
    }

    @Override
    public int cardinality(int fromBit, int toBit) {
        int fromUnit = fromBit / 64;
        int toUnit = (toBit + 64 - 1) / 64;
        int unitStart = Math.max(0, fromUnit);
        int unitLen = Math.min(this.mUnits.length, toUnit);
        int card = 0;
        int ii = unitStart;
        while (ii < unitLen) {
            if (this.mUnits[ii] != 0L) {
                int bit;
                long unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    bit = fromBit % 64;
                    unit &= -1L >>> bit;
                }
                if (ii == toUnit - 1) {
                    bit = fromBit % 64;
                    unit &= -1L << 64 - bit;
                }
                card += Long.bitCount(unit);
            }
            ++ii;
        }
        return card;
    }

    public int hashCode() {
        int code = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            code = (int)((long)code ^ 0xFFFFFFFFL & this.mUnits[ii]);
            code = (int)((long)code ^ 0xFFFFFFFFL & this.mUnits[ii] >>> 32);
            ++ii;
        }
        return code;
    }

    @Override
    public int hashCodeObj() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleLongBitSet) {
            SimpleLongBitSet bitSet = (SimpleLongBitSet)obj;
            int len = Math.min(this.mUnits.length, bitSet.mUnits.length);
            int ii = 0;
            while (ii < len) {
                if (this.mUnits[ii] != bitSet.mUnits[ii]) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < this.mUnits.length) {
                if (this.mUnits[ii] != 0L) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < bitSet.mUnits.length) {
                if (bitSet.mUnits[ii] != 0L) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int unitLen = this.unitLength();
        int ii = 0;
        while (ii < unitLen) {
            int len;
            int n = len = ii == unitLen - 1 ? 1 + (this.length() - 1) % 64 : 64;
            if (this.mUnits[ii] != 0L) {
                long bit = 1L;
                int jj = 0;
                while (jj < len) {
                    if ((this.mUnits[ii] & bit) != 0L) {
                        sb.append('1');
                    } else {
                        sb.append('0');
                    }
                    ++jj;
                    bit <<= 1;
                }
            } else {
                sb.append("0000000000000000000000000000000000000000000000000000000000000000", 0, len);
            }
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int nextSetBit(int from) {
        int fromBit = from % 64;
        int fromUnit = from / 64;
        int ii = Math.max(0, fromUnit);
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != 0L) {
                long unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    unit &= -1L << fromBit;
                }
                if (unit != 0L) {
                    return ii * 64 + Long.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return -1;
    }

    @Override
    public int nextClearBit(int from) {
        int fromUnit;
        int fromBit = from % 64;
        int ii = fromUnit = from / 64;
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != -1L) {
                long unit = this.mUnits[ii] ^ 0xFFFFFFFFFFFFFFFFL;
                if (ii == fromUnit) {
                    unit &= -1L << fromBit;
                }
                if (unit != 0L) {
                    return ii * 64 + Long.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return Math.max(from, this.length());
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.length());
        int bit = this.nextSetBit(0);
        while (bit >= 0) {
            bitSet.set(bit);
            bit = this.nextSetBit(bit + 1);
        }
        return bitSet;
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutput dout = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        dout.writeInt(this.mUnits.length);
        int i = 0;
        while (i < this.mUnits.length) {
            dout.writeLong(this.mUnits[i]);
            ++i;
        }
    }

    public static SimpleLongBitSet readFrom(InputStream in) throws IOException {
        DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        int len = din.readInt();
        long[] units = new long[len];
        int i = 0;
        while (i < len) {
            units[i] = din.readLong();
            ++i;
        }
        return new SimpleLongBitSet(units, false);
    }

    public byte[] compress() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.compress(out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toByteArray();
    }

    public void compress(OutputStream out) throws IOException {
        ZipOutputStream zOut = new ZipOutputStream(out);
        zOut.putNextEntry(new ZipEntry("A"));
        DataOutputStream dOut = new DataOutputStream(zOut);
        dOut.writeInt(this.mUnits.length);
        int ii = 0;
        while (ii < this.mUnits.length) {
            dOut.writeLong(this.mUnits[ii]);
            ++ii;
        }
        dOut.flush();
        zOut.closeEntry();
        zOut.flush();
    }

    public static SimpleLongBitSet uncompress(byte[] bytes) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        try {
            return SimpleLongBitSet.uncompress(byteIn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static SimpleLongBitSet uncompress(InputStream in) throws IOException {
        ZipInputStream zIn = new ZipInputStream(in);
        zIn.getNextEntry();
        DataInputStream dIn = new DataInputStream(zIn);
        int unitLen = dIn.readInt();
        long[] units = new long[unitLen];
        int ii = 0;
        while (ii < unitLen) {
            units[ii] = dIn.readLong();
            ++ii;
        }
        return new SimpleLongBitSet(units, false);
    }

    @Override
    public BitSetFactory<SimpleLongBitSet> factory() {
        return FACTORY;
    }

    @Override
    public BitSetOps<SimpleLongBitSet> ops() {
        return OPS;
    }

    @Override
    public long[] toLongArray() {
        return this.toLongArray(null, 0);
    }

    @Override
    public long[] toLongArray(long[] arr, int offset) {
        int len = this.unitLength();
        if (arr == null || arr.length < len + offset) {
            arr = new long[len + offset];
        }
        System.arraycopy(this.mUnits, 0, arr, offset, len);
        return arr;
    }

    public static void main(String[] args) {
        Random rnd = new Random();
        SimpleLongBitSet set = new SimpleLongBitSet("10000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000001");
        System.out.println(String.valueOf(set.length()) + "/" + set.cardinality());
        System.out.println("uncompressed: " + set.mUnits.length * 8 + 8);
        System.out.println("compressed: " + set.compress().length);
        System.out.println(set);
        System.out.println(SimpleLongBitSet.uncompress(set.compress()));
        int cnt = 32;
        int ii = 0;
        while (ii < 32) {
            if (rnd.nextInt(5) <= 3) {
                set.set(ii);
            }
            ++ii;
        }
        System.out.println(String.valueOf(set.length()) + "/" + set.cardinality());
        System.out.println("uncompressed: " + set.mUnits.length * 8 + 8);
        System.out.println("compressed: " + set.compress().length);
        System.out.println(set.equals(SimpleLongBitSet.uncompress(set.compress())));
    }
}

