/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.GenericBitSet;
import ch.javasoft.bitset.GenericBitSetPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGenericBitSetPair<B extends GenericBitSet<B>>
implements GenericBitSetPair<B> {
    private final B mSetA;
    private final B mSetB;
    private transient B mIntersection;

    public DefaultGenericBitSetPair(B setA, B setB) {
        this.mSetA = setA;
        this.mSetB = setB;
    }

    @Override
    public B setA() {
        return this.mSetA;
    }

    @Override
    public B setB() {
        return this.mSetB;
    }

    @Override
    public final B intersect() {
        if (this.mIntersection == null) {
            this.mIntersection = this.createIntersection();
        }
        return this.mIntersection;
    }

    protected B createIntersection() {
        return (B)this.mSetA.ops().and(this.mSetA, this.mSetB);
    }

    @Override
    public boolean isSuperSet(B superCandidate) {
        return !superCandidate.equals(this.mSetA) && !superCandidate.equals(this.mSetB) && this.intersect().isSubSetOf(superCandidate);
    }

    @Override
    public boolean existsSuperSet(Iterable<B> superCandidates) {
        for (GenericBitSet cand : superCandidates) {
            if (cand.equals(this.mSetA) || cand.equals(this.mSetB) || !this.intersect().isSubSetOf((GenericBitSet)cand)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{a=");
        sb.append(this.setA());
        sb.append(", b=");
        sb.append(this.setB());
        sb.append(", a^b=");
        sb.append(this.intersect());
        sb.append("}");
        return sb.toString();
    }
}

