# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CoreApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_deployment_requests_batch_delete(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment requests  # noqa: E501

         ### Description Delete multiple batch deployment requests. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_delete(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_batch_delete_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Delete multiple batch deployment requests  # noqa: E501

         ### Description Delete multiple batch deployment requests. If one of the given batch deployment requests does not exist, an error message is given and no request is deleted. A maximum of 250 deployment requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_delete_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_batch_get(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_last_updated\": \"2020-06-29T08:09:10.729+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_last_updated\": \"2020-03-25T09:37:17.765+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_get(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_batch_get_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_batch_get_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch deployment request results  # noqa: E501

         ### Description Retrieve multiple batch deployment requests. If one of the given batch deployment requests does not exist, an error message is given and no request is returned. A maximum of 250 deployment requests can be retrieved with this method. The deployment requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2f909aeb-5c7e-4974-970d-cd0a6a073aca\", \"85711124-54db-4794-b83d-24492247c6e1\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [   {     \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-29T08:09:10.729+00:00\",     \"time_last_updated\": \"2020-06-29T08:09:10.729+00:00\",     \"request_data\": {       \"input\": 82.2     },     \"result\": null,     \"error_message\": null   },   {     \"id\": \"85711124-54db-4794-b83d-24492247c6e1\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-06-25T09:37:17.765+00:00\",     \"time_last_updated\": \"2020-03-25T09:37:17.765+00:00\",     \"request_data\": {       \"input\": 52.4     },     \"result\": null,     \"error_message\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_batch_get_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param object data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create batch deployment requests  # noqa: E501

         ### Description Request multiple predictions from a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per bulk call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[DeploymentRequestCreate] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def batch_deployment_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create batch deployment requests  # noqa: E501

         ### Description Request multiple predictions from a deployment. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the deployment request collect methods. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  If one of the requests is faulty, all requests are denied. The maximum number of requests per bulk call is 250.  ### Required Parameters  In case of structured input deployment: A list of dictionaries, where each dictionary contains the input fields of the deployment as keys. It is also possible to send a single dictionary as input. In case of plain input deployment: A list of strings. It is also possible to send a single string as input.  #### Request Examples  ``` [   {     \"input-field-1\": 5.0,     \"input-field-2\": \"N\",     \"input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"input-field-1\": 3.0,     \"input-field-2\": \"S\",     \"input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  ### Response Structure  A list of dictionaries containing the details of the created deployment requests with the following fields:  - `id`: Unique identifier for the deployment request, which can be used to collect the result  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param list[DeploymentRequestCreate] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_delete(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch deployment requests  # noqa: E501

         ### Description Delete a batch deployment request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_delete(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def batch_deployment_requests_delete_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Delete batch deployment requests  # noqa: E501

         ### Description Delete a batch deployment request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_delete_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_requests_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch/{request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_get(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch deployment request  # noqa: E501

         ### Description Get a batch request for a deployment. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_last_updated\": \"2020-03-29T08:09:10.729+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_get(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDeploymentRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_get_with_http_info(project_name, deployment_name, request_id, version, **kwargs)  # noqa: E501

    def batch_deployment_requests_get_with_http_info(self, project_name, deployment_name, request_id, version, **kwargs):  # noqa: E501
        """Get batch deployment request  # noqa: E501

         ### Description Get a batch request for a deployment. With this method, the result of a batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the deployment request with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `result`: Deployment request result value. NULL if the request is 'pending', 'processing' or 'failed'.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` {   \"id\": \"2f909aeb-5c7e-4974-970d-cd0a6a073aca\",   \"status\": \"pending\",   \"success\": false,   \"time_created\": \"2020-03-29T08:09:10.729+00:00\",   \"time_last_updated\": \"2020-03-29T08:09:10.729+00:00\",   \"request_data\": {     \"input\": 82.3   },   \"result\": null,   \"error_message\": null } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_get_with_http_info(project_name, deployment_name, request_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str request_id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDeploymentRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'request_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `batch_deployment_requests_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'request_id' in local_var_params:
            path_params['request_id'] = local_var_params['request_id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch/{request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDeploymentRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_deployment_requests_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List batch deployment requests  # noqa: E501

         ### Description List all requests for a version  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchDeploymentRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_deployment_requests_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def batch_deployment_requests_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List batch deployment requests  # noqa: E501

         ### Description List all requests for a version  ### Optional Parameters The following parameters should be given as Query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed' - `success`: A boolean value that indicates whether the deployment request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the deployment requests with the following fields:  - `id`: Unique identifier for the deployment request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the deployment request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_deployment_requests_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchDeploymentRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_deployment_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_deployment_requests_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `batch_deployment_requests_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `batch_deployment_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchDeploymentRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_batch_delete(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline requests  # noqa: E501

         ### Description Delete multiple batch pipeline requests. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_delete(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_batch_delete_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Delete multiple batch pipeline requests  # noqa: E501

         ### Description Delete multiple batch pipeline requests. If one of the given batch pipeline requests does not exist, an error message is given and no request is deleted. A maximum of 100 pipeline requests can be deleted with this method.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_delete_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_batch_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_batch_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch-delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_batch_get(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline request results  # noqa: E501

         ### Description Retrieve multiple batch pipeline requests. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [     {       \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",       \"status\": \"pending\",       \"success\": false,       \"time_created\": \"2020-063-28T20:00:26.613+00:00\",       \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",       \"request_data\": {         \"input_field\": 23.5       },       \"deployment_requests\": [],       \"error_message\": null     },     {       \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",       \"status\": \"pending\",       \"success\": false,       \"time_created\": \"2020-063-28T20:00:26.613+00:00\",       \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",       \"request_data\": {         \"input_field\": 23.5       },       \"deployment_requests\": [],       \"error_message\": null     } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_get(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_batch_get_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Retrieve multiple batch pipeline request results  # noqa: E501

         ### Description Retrieve multiple batch pipeline requests. If one of the given batch pipeline requests does not exist, an error message is given and no request is returned. A maximum of 100 pipeline requests can be retrieved with this method. The pipeline requests are NOT returned in the order they are given in.  ### Required Parameters  A list of ids for the batch requests  #### Request Examples  ``` [\"2521378e-263e-4e2e-85e9-a96254b36536\", \"69eca481-8576-49e8-8e20-ea56f2005bcb\"] ```  ### Response Structure  A list of dictionaries containing the details of the retrieved pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests to the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples  ``` [     {       \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",       \"status\": \"pending\",       \"success\": false,       \"time_created\": \"2020-063-28T20:00:26.613+00:00\",       \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",       \"request_data\": {         \"input_field\": 23.5       },       \"deployment_requests\": [],       \"error_message\": null     },     {       \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",       \"status\": \"pending\",       \"success\": false,       \"time_created\": \"2020-063-28T20:00:26.613+00:00\",       \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",       \"request_data\": {         \"input_field\": 23.5       },       \"deployment_requests\": [],       \"error_message\": null     } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_batch_get_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param object data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_batch_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_batch_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch-collect', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create batch pipeline requests  # noqa: E501

         ### Description Request multiple predictions from a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[PipelineRequestCreate] data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestCreateResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def batch_pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create batch pipeline requests  # noqa: E501

         ### Description Request multiple predictions from a pipeline. The request follows an asynchronous method, as the requests are queued in our back-end and can be collected at a later time using the pipeline request collect methods.  The maximum number of requests that can be created per batch is 100.  ### Required Parameters  In case of structured input pipeline: A list of dictionaries, where each dictionary contains the input fields of the pipeline as keys. It is also possible to send a single dictionary as input. In case of plain input pipeline: A list of strings. It is also possible to send a single string as input.  #### Request Examples  ``` [   {     \"pipeline-input-field-1\": 5.0,     \"pipeline-input-field-2\": \"N\",     \"pipeline-input-field-3\": [0.25, 0.25, 2.1, 16.3]   },   {     \"pipeline-input-field-1\": 3.0,     \"pipeline-input-field-2\": \"S\",     \"pipeline-input-field-3\": [4.23, 3.27, 2.41, 12.4]   } ] ```  ### Response Structure  A list of dictionaries containing the details of the created pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request, which can be used to collect the result  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `time_created`: Server time that the request was made (current time)    #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"pending\",     \"time_created\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param list[PipelineRequestCreate] data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestCreateResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `batch_pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestCreateResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_delete(self, project_name, pipeline_name, pipeline_request_id, **kwargs):  # noqa: E501
        """Delete batch pipeline requests  # noqa: E501

         ### Description Delete a batch pipeline request. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_delete(project_name, pipeline_name, pipeline_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str pipeline_request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_delete_with_http_info(project_name, pipeline_name, pipeline_request_id, **kwargs)  # noqa: E501

    def batch_pipeline_requests_delete_with_http_info(self, project_name, pipeline_name, pipeline_request_id, **kwargs):  # noqa: E501
        """Delete batch pipeline requests  # noqa: E501

         ### Description Delete a batch pipeline request. This action cancels all the deployment requests in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_delete_with_http_info(project_name, pipeline_name, pipeline_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str pipeline_request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'pipeline_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_request_id' is set
        if self.api_client.client_side_validation and ('pipeline_request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_request_id` when calling `batch_pipeline_requests_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'pipeline_request_id' in local_var_params:
            path_params['pipeline_request_id'] = local_var_params['pipeline_request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch/{pipeline_request_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_get(self, project_name, pipeline_name, pipeline_request_id, **kwargs):  # noqa: E501
        """Get batch pipeline request  # noqa: E501

         ### Description Get a batch request for a pipeline. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_get(project_name, pipeline_name, pipeline_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str pipeline_request_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchPipelineRequestSingleDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_get_with_http_info(project_name, pipeline_name, pipeline_request_id, **kwargs)  # noqa: E501

    def batch_pipeline_requests_get_with_http_info(self, project_name, pipeline_name, pipeline_request_id, **kwargs):  # noqa: E501
        """Get batch pipeline request  # noqa: E501

         ### Description Get a batch request for a pipeline. With this method, the result of the batch request may be retrieved.  ### Response Structure  A dictionary containing the details of the pipeline request with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  - `request_data`: A dictionary containing the data that was sent when the request was created  - `deployment_requests`: A list of requests of the deployments in the pipeline. This field is empty when the request is initialized and is updated when all the deployment requests in the pipeline are completed.  - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  - `created_by`: The email of the user that created the request. In case the request is created by a service, the field will have a \"UbiOps\" value.  #### Response Examples  ``` {   \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",   \"status\": \"pending\",   \"success\": true,   \"time_created\": \"2020-03-28T20:00:26.613+00:00\",   \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\",   \"request_data\": {     \"input_field\": 23.5   },   \"deployment_requests\": [],   \"error_message\": null,   \"created_by\": \"my.example.user@ubiops.com\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_get_with_http_info(project_name, pipeline_name, pipeline_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str pipeline_request_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchPipelineRequestSingleDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'pipeline_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_get`")  # noqa: E501
        # verify the required parameter 'pipeline_request_id' is set
        if self.api_client.client_side_validation and ('pipeline_request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_request_id` when calling `batch_pipeline_requests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'pipeline_request_id' in local_var_params:
            path_params['pipeline_request_id'] = local_var_params['pipeline_request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch/{pipeline_request_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchPipelineRequestSingleDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_pipeline_requests_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List batch pipeline requests  # noqa: E501

         ### Description List all requests for a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BatchPipelineRequestList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.batch_pipeline_requests_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def batch_pipeline_requests_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List batch pipeline requests  # noqa: E501

         ### Description List all requests for a pipeline  ### Optional Parameters The following parameters should be given as query parameters:  - `status`: Status of the request. Can be 'pending', 'processing', 'failed' or 'completed'. - `success`: A boolean value that indicates whether the pipeline request was successful - `limit`: The maximum number of requests given back, default is 50 - `offset`: The number which forms the starting point of the requests given back. If offset equals 2, then the first 2 requests will be omitted from the list. - `sort`: Direction of sorting, can be 'asc' or 'desc'. The default sorting is done in descending order.  ### Response Structure  A list of dictionaries containing the details of the pipeline requests with the following fields:  - `id`: Unique identifier for the pipeline request  - `status`: Status of the request. Always 'pending' when initialised, later it can be 'processing', 'failed' or 'completed'.  - `success`: A boolean value that indicates whether the pipeline request was successful  - `time_created`: Server time that the request was made (current time)  - `time_last_updated`: Server time that the request was last updated  #### Response Examples  ``` [   {     \"id\": \"69eca481-8576-49e8-8e20-ea56f2005bcb\",     \"status\": \"pending\",     \"success\": false,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   },   {     \"id\": \"2521378e-263e-4e2e-85e9-a96254b36536\",     \"status\": \"completed\",     \"success\": true,     \"time_created\": \"2020-03-28T20:00:26.613+00:00\",     \"time_last_updated\": \"2020-03-28T20:00:26.613+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_pipeline_requests_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str status:
        :param bool success:
        :param int limit:
        :param int offset:
        :param str sort:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BatchPipelineRequestList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'status', 'success', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_pipeline_requests_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `batch_pipeline_requests_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `batch_pipeline_requests_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'success' in local_var_params and local_var_params['success'] is not None:  # noqa: E501
            query_params.append(('success', local_var_params['success']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request-batch', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BatchPipelineRequestList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_create(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The returned blob_id may be passed in a deployment or pipeline request as input.  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BlobList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_create_with_http_info(project_name, file, **kwargs)  # noqa: E501

    def blobs_create_with_http_info(self, project_name, file, **kwargs):  # noqa: E501
        """Upload a blob  # noqa: E501

         ### Description  Upload a blob to a project. The returned blob_id may be passed in a deployment or pipeline request as input.  The uploaded blob file can be retrieved by passing the blob_id as well.   ### Optional Parameters  These parameters should be given in the header. - `blob-ttl`: The Blob-TTL parameter designates the time to live of the blob in seconds. The default value is 259200 seconds (or 72 hours), the minimum value is 900 seconds and the maximum value is 259200 seconds.   ### Response Structure  The details of the uploaded blob - `id`: Unique identifier for the blob (UUID) - `creation_date`: Time the blob was created - `filename`: Original filename of the blob - `size`: Size of the uploaded blob in bytes - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` {   \"id\": \"b58fb853-9311-4583-9688-abed61830abc\",   \"creation_date\": \"2020-05-18T11:26:57.904+00:00\",   \"filename\": \"original-filename.jpg\",   \"size\": 3439,   \"ttl\": 259200 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_create_with_http_info(project_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param file file: (required)
        :param int blob_ttl:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BlobList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'file', 'blob_ttl']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_create`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `blobs_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'blob_ttl' in local_var_params:
            header_params['blob-ttl'] = local_var_params['blob_ttl']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlobList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_delete(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_delete_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_delete_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Delete a blob  # noqa: E501

         ### Description  Delete a blob from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_delete_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_delete`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_get(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_get_with_http_info(project_name, blob_id, **kwargs)  # noqa: E501

    def blobs_get_with_http_info(self, project_name, blob_id, **kwargs):  # noqa: E501
        """Get a blob  # noqa: E501

         ### Description  Download a blob file in a project  ### Response Structure  - `file`: Blob file   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_get_with_http_info(project_name, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str blob_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_get`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if self.api_client.client_side_validation and ('blob_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['blob_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `blob_id` when calling `blobs_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blob_id'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs/{blob_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blobs_list(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-13T14:39:50.149+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T08:35:18.796+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 259200   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BlobList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.blobs_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def blobs_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List blobs  # noqa: E501

         ### Description  List all blobs in a project  ### Optional Parameters  These parameters should be given as GET parameters. - `range`: Number of blobs to be returned. It may be a positive or a negative value. If it is positive, blobs uploaded starting from the creation_date towards the present time are returned. Otherwise, blobs uploaded towards the past are returned. The default value is -50.  - `creation_date`: Get the blobs uploaded starting from this date. If it is not provided, the uploaded blobs are returned according to the *range* parameter. It should be provided in year-month-day hour:minute:second format.  ### Response Structure A list of details of the blobs in the project  - `id`: Unique identifier for the blob (UUID)  - `creation_date`: Time the blob was created  - `filename`: Original filename of the blob  - `size`: Size of the uploaded blob in bytes  - `ttl`: Time to live of the blob in seconds  #### Response Examples ``` [   {     \"id\": \"ecb39626-2a14-4224-a57a-592a51567e17\",     \"creation_date\": \"2020-05-13T14:39:50.149+00:00\",     \"filename\": \"original-filename.jpg\",     \"size\": 562,     \"ttl\": 12338   },   {     \"id\": \"f629a052-a827-44d9-97cf-3902504edc79\",     \"creation_date\": \"2020-05-18T08:35:18.796+00:00\",     \"filename\": \"original-filename2.jpg\",     \"size\": 3439,     \"ttl\": 259200   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.blobs_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param int range:
        :param str creation_date:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BlobList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'range', 'creation_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blobs_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `blobs_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'range' in local_var_params and local_var_params['range'] is not None:  # noqa: E501
            query_params.append(('range', local_var_params['range']))  # noqa: E501
        if 'creation_date' in local_var_params and local_var_params['creation_date'] is not None:  # noqa: E501
            query_params.append(('creation_date', local_var_params['creation_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/blobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlobList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_audit_events_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_audit_events_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_audit_events_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List audit events for a deployment  # noqa: E501

         ### Description  List all audit events for a deployment including versions  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a deployment - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"25750859-e082-44df-bde9-cd85ca3f869c\",     \"date\": \"2020-10-23T12:03:55.675+00:00\",     \"action\": \"delete\",     \"user\": \"user@example.com\",     \"event\": \"Deleted environment variable ENV_VAR for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   },   {     \"id\": \"ce81814d-b00c-4094-a483-814afdb80875\",     \"date\": \"2020-10-23T12:04:28.645+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created version v1 for deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"audit-deployment\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_audit_events_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_audit_events_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_copy(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the object from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_copy_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Copy deployment environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the deployment. Variables of the deployment with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the object from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"deployment_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_copy_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_copy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create deployment environment variable  # noqa: E501

         ### Description Create an environment variable for the deployment. This variable will be inherited by all versions of this deployment. Variables inherited from the project can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some_value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` { \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\", \"name\": \"deployment_variable_a\", \"value\": \"some_value\", \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_delete(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Delete deployment environment variable  # noqa: E501

         ### Description Delete an environment variable of the deployment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_delete_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_get(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, **kwargs)  # noqa: E501

    def deployment_environment_variables_get_with_http_info(self, project_name, deployment_name, id, **kwargs):  # noqa: E501
        """Get deployment environment variable  # noqa: E501

         ### Description Retrieve details of a deployment environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_get_with_http_info(project_name, deployment_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployment_environment_variables_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List deployment environment variables  # noqa: E501

         ### Description List the environment variables defined for the deployment. Includes environment variables defined at project level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project` or null if the variable was defined for the deployment directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the deployment directly  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_environment_variables_update(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, **kwargs)  # noqa: E501

    def deployment_environment_variables_update_with_http_info(self, project_name, deployment_name, id, data, **kwargs):  # noqa: E501
        """Update deployment environment variable  # noqa: E501

         ### Description Update an environment variable for the deployment. This cannot be used to update inherited variables; to change an inherited variable for a specific deployment you can create a variable with the same name for the deployment.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"7c28a2be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"deployment_variable_a\",   \"value\": \"some new value\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_environment_variables_update_with_http_info(project_name, deployment_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `deployment_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_environment_variables_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployment_requests_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment requests  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for a specific version of a deployment. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters A dictionary which contains the input fields of the deployment as keys  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  ### Response Structure  Details of the created deployment request - `request_id`: Unique identifier for the deployment request - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"request_id\": \"edcf07b5-ae15-46e6-ba29-daeed53eaa61\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"request_id\": \"b98a6d68-3173-409a-9e6e-a56804045a9c\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentRequestCreate data: (required)
        :param int timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployment_requests_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def deployment_requests_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create deployment requests  # noqa: E501

         ### Description  Request a prediction from a deployment. Deployment requests are made for a specific version of a deployment. It is only possible to make a request if a deployment file is uploaded for that version and the deployment build has succeeded (meaning that the version is in available state). In case of a **blob** field, the uuid of a previously uploaded blob must be provided.  ### Required Parameters A dictionary which contains the input fields of the deployment as keys  ### Optional Parameters These parameters should be given as GET parameters - `timeout`: Timeout for the deployment request in seconds. The maximum allowed value is 3600 and the default value is 300.  #### Request Examples ``` {   \"input-field-1\": 5.0,   \"input-field-2\": \"N\",   \"input-field-3\": [0.25, 0.25, 2.1, 16.3] } ```  ``` {   \"input-field-1\": 5.0,   \"blob-input-field\": \"f52ff875-4980-4d71-9798-a469ef8cece2\" } ```  ### Response Structure  Details of the created deployment request - `request_id`: Unique identifier for the deployment request - `success`: A boolean value that indicates whether the deployment request was successful - `result`: Deployment request result value. NULL if the request failed. - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.  #### Response Examples A failed deployment request ``` {   \"request_id\": \"edcf07b5-ae15-46e6-ba29-daeed53eaa61\",   \"success\": false,   \"result\": None,   \"error_message\": \"Asset ID not supported\" } ```  A successful deployment request ``` {   \"request_id\": \"b98a6d68-3173-409a-9e6e-a56804045a9c\",   \"success\": true,   \"result\": {     \"output-field-1\": \"2.1369\",     \"output-field-2\": \"5.5832\",   },   \"error_message\": None } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployment_requests_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param DeploymentRequestCreate data: (required)
        :param int timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployment_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `deployment_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployment_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create a deployment  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\",   \"number_of_versions\": 0 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def deployments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create a deployment  # noqa: E501

         ### Description  Create a deployment by defining the input/output type and input/output fields. In case of **plain** type of input or output, input and output fields should not be given or passed as an empty list.  Possible data types for the input and output fields are: - **int**: integer - **string**: string - **double**: double precision floating point - **bool**: boolean value (False/True) - **timestamp**: timestamp - **array_int**: an array of integers - **array_double**: an array of double precision floating points - **array_string**: an array of strings - **blob**: a blob field. This type of field can be used to pass blobs to the deployment. In deployment and pipeline requests, the uuid of a previously uploaded blob must be provided for this field.  ### Required Parameters  - `name`: Name of the deployment. It is unique within a project. - `input_type`: Type of the input of the deployment. It can be either structured or plain. - `output_type`: Type of the output of the deployment. It can be either structured or plain. - `input_fields`: The list of required deployment input fields. It must contain the fields: name and data_type. The name of an input field is unique for a deployment. - `output_fields`: The list of required deployment output fields. It must contain the fields: name and data_type. The name of an output field is unique for a deployment.  ### Optional Parameters - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples A deployment with structured input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input type ``` {   \"name\": \"deployment-1\",   \"description\": \"Deployment one\"   \"input_type\": \"plain\",   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ] } ```  A deployment with plain input and output type ``` {   \"name\": \"deployment-1\",   \"input_type\": \"plain\",   \"output_type\": \"plain\"   \"labels\": {     \"type\": \"deployment\"   } } ```  ### Response Structure  Details of the created deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is created - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-18T08:32:14.876451Z\",   \"number_of_versions\": 0 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param DeploymentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_delete(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_delete_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_delete_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Delete a deployment  # noqa: E501

         ### Description  Delete a deployment. If any of the versions of the deployment are referenced in a pipeline, the deployment cannot be deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_delete_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_get(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"number_of_versions\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_get_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def deployments_get_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """Get details of deployment  # noqa: E501

         ### Description  Retrieve details of a single deployment in a project  ### Response Structure  Details of a deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"deployment-1\",   \"project\": \"project-1\",   \"description\": \"\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"number_of_versions\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_get_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_list(self, project_name, **kwargs):  # noqa: E501
        """List deployments in project  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"number_of_versions\": 1   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\",     \"number_of_versions\": 2   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"number_of_versions\": 1   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DeploymentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def deployments_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List deployments in project  # noqa: E501

         ### Description  Deployments can be filtered according to the labels they have by giving labels as a query parameter. Deployments that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the deployment. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the deployments in the project - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type. It is empty in case of plain input type deployments. - `output_fields`: The list of deployment output fields containing name and data_type. It is empty in case of plain output type deployments. - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples  ``` [   {     \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",     \"name\": \"deployment-1\",     \"project\": \"project-1\",     \"description\": \"Temperature deployment\",     \"input_type\": \"structured\",     \"output_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"input-field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"input-field-2\",         \"data_type\": \"double\"       }     ],     \"output_fields\": [       {         \"name\": \"output-field\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"number_of_versions\": 1   },   {     \"id\": \"5f4e942f-d5b8-4d62-99b2-870c15a82127\",     \"name\": \"deployment-2\",     \"project\": \"project-1\",     \"description\": \"Deployment two\",     \"input_type\": \"structured\",     \"output_type\": \"plain\",     \"input_fields\": [       {         \"name\": \"input-field\",         \"data_type\": \"int\"       }     ],     \"output_fields\": [],     \"labels\": {       \"type\": \"deployment\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\",     \"number_of_versions\": 2   },   {     \"id\": \"bd3fae9d-aeec-4cf3-8ef0-5f9224d41904\",     \"name\": \"deployment-3\",     \"description\": \"\",     \"project\": \"project-1\",     \"input_type\": \"plain\",     \"output_type\": \"plain\",     \"input_fields\": [],     \"output_fields\": [],     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"number_of_versions\": 1   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DeploymentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DeploymentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deployments_update(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment. It is only possible to update the name, description and labels fields. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"number_of_versions\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deployments_update_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def deployments_update_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Update a deployment  # noqa: E501

         ### Description  Update a deployment. It is only possible to update the name, description and labels fields. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the deployment - `description`: New description for the deployment - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples ``` {   \"name\": \"new-deployment-name\" } ```  ### Response Structure  Details of the updated deployment - `id`: Unique identifier for the deployment (UUID) - `name`: Name of the deployment - `project`: Project name in which the deployment is defined - `input_type`: Type of the input of the deployment - `output_type`: Type of the output of the deployment - `input_fields`: The list of deployment input fields containing name and data_type - `output_fields`: The list of deployment output fields containing name and data_type - `description`: Description of the deployment - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the deployment was created - `last_updated`: The date when the deployment was last updated - `number_of_versions`: Number of versions that this deployment has  #### Response Examples ``` {   \"id\": \"903ccd12-81d1-46e1-9ac9-b9d70af118de\",   \"name\": \"new-deployment-name\",   \"project\": \"project-1\",   \"description\": \"New deployment description\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"input-field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"input-field-2\",       \"data_type\": \"double\"     }   ],   \"output_fields\": [     {       \"name\": \"output-field\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"type\": \"deployment\"   },   \"creation_date\": \"2020-06-18T08:32:14.876451Z\",   \"last_updated\": \"2020-06-19T10:52:23.124784Z\",   \"number_of_versions\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deployments_update_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param DeploymentUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeploymentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deployments_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `deployments_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `deployments_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeploymentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def metrics_get(self, project_name, metric, start_time, end_time, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline   Metrics on version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Time in seconds for a request to complete  - `instances`: Number of active deployment instances  - `gb_seconds`: Usage of GB seconds, calculated by multiplying the deployment memory sizes in GB by the number of seconds the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_time`: Starting time for the metric values to be returned. It should be provided in datetime isoformat. - `end_time`: Ending time for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `version` or `pipeline`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`.  ### Response Structure  - `start_time`: Timestamp denoting the start of the period over which the metric was measured - `end_time`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 12:03:00 ``` [   {     \"start_time\": \"2019-11-13T12:00:00+00:00\",     \"end_time\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_time\": \"2019-11-13T12:01:00+00:00\",     \"end_time\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_time\": \"2019-11-13T12:02:00+00:00\",     \"end_time\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 14:00:00 ``` [   {    \"start_time\": \"2019-11-13T12:00:00+00:00\",    \"end_time\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_time\": \"2019-11-13T13:00:00+00:00\",     \"end_time\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_time\": \"2019-11-13T14:00:00+00:00\",     \"end_time\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```   With interval as day, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-14 12:00:00 ``` [   {    \"start_time\": \"2019-11-13T00:00:00+00:00\",    \"end_time\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_time\": \"2019-11-14T00:00:00+00:00\",     \"end_time\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```   With interval as month, start_time as 2019-11-13 12:00:00 and end_time as 2019-12-13 12:00:00 ``` [   {    \"start_time\": \"2019-11-01T00:00:00+00:00\",    \"end_time\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get(project_name, metric, start_time, end_time, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_time: (required)
        :param str end_time: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Metrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.metrics_get_with_http_info(project_name, metric, start_time, end_time, object_type, **kwargs)  # noqa: E501

    def metrics_get_with_http_info(self, project_name, metric, start_time, end_time, object_type, **kwargs):  # noqa: E501
        """Get metrics  # noqa: E501

         ### Description  Get metrics for the project or a specified object. The following metrics are available:  Metrics on pipeline level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `object_requests`: Number of requests made to objects in the pipeline   Metrics on version level:   - `requests`: Number of requests made to the object  - `failed_requests`: Number of failed requests made to the object  - `input_volume`: Volume of incoming data in bytes  - `output_volume`: Volume of outgoing data in bytes  - `outputs`: Number of outgoing data items   - `compute`: Time in seconds for a request to complete  - `instances`: Number of active deployment instances  - `gb_seconds`: Usage of GB seconds, calculated by multiplying the deployment memory sizes in GB by the number of seconds the deployments are running  - `active_time`: Time in seconds that the deployment is active  ### Required Parameters  - `start_time`: Starting time for the metric values to be returned. It should be provided in datetime isoformat. - `end_time`: Ending time for the metric values to be returned. It should be provided in datetime isoformat. - `object_type`: The type of the object for which the metrics are requested. It can be either `version` or `pipeline`.  ### Optional Parameters  - `interval`: Interval for the metric value. It can be minute, hour, day or month. The metric values will be aggregated according to this interval. The default value is hour. - `object_id`: Uuid of the specific object for which the metrics are requested. When it is not provided, the metrics are aggregated for the given `object_type`.  ### Response Structure  - `start_time`: Timestamp denoting the start of the period over which the metric was measured - `end_time`: Timestamp denoting the end of the period over which the metric was measured - `value`: Aggregated metric value for the given interval  #### Response Examples With interval as minute, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 12:03:00 ``` [   {     \"start_time\": \"2019-11-13T12:00:00+00:00\",     \"end_time\": \"2019-11-13T12:01:00+00:00\",     \"value\": 100   },   {     \"start_time\": \"2019-11-13T12:01:00+00:00\",     \"end_time\": \"2019-11-13T12:02:00+00:00\",     \"value\": 134   },   {     \"start_time\": \"2019-11-13T12:02:00+00:00\",     \"end_time\": \"2019-11-13T12:03:00+00:00\",     \"value\": 112   } ]  ```  With interval as hour, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-13 14:00:00 ``` [   {    \"start_time\": \"2019-11-13T12:00:00+00:00\",    \"end_time\": \"2019-11-13T13:00:00+00:00\",    \"value\": 92   },   {     \"start_time\": \"2019-11-13T13:00:00+00:00\",     \"end_time\": \"2019-11-13T14:00:00+00:00\",     \"value\": 120   },   {     \"start_time\": \"2019-11-13T14:00:00+00:00\",     \"end_time\": \"2019-11-13T15:00:00+00:00\",     \"value\": 0   } ] ```   With interval as day, start_time as 2019-11-13 12:00:00 and end_time as 2019-11-14 12:00:00 ``` [   {    \"start_time\": \"2019-11-13T00:00:00+00:00\",    \"end_time\": \"2019-11-14T00:00:00+00:00\",    \"value\": 528   },   {     \"start_time\": \"2019-11-14T00:00:00+00:00\",     \"end_time\": \"2019-11-15T00:00:00+00:00\",     \"value\": 342   } ] ```   With interval as month, start_time as 2019-11-13 12:00:00 and end_time as 2019-12-13 12:00:00 ``` [   {    \"start_time\": \"2019-11-01T00:00:00+00:00\",    \"end_time\": \"2019-12-01T00:00:00+00:00\",    \"value\": 1983   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metrics_get_with_http_info(project_name, metric, start_time, end_time, object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str metric: (required)
        :param str start_time: (required)
        :param str end_time: (required)
        :param str object_type: (required)
        :param str interval:
        :param str object_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Metrics], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'metric', 'start_time', 'end_time', 'object_type', 'interval', 'object_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metrics_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'metric' is set
        if self.api_client.client_side_validation and ('metric' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `metrics_get`")  # noqa: E501
        # verify the required parameter 'object_type' is set
        if self.api_client.client_side_validation and ('object_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['object_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `object_type` when calling `metrics_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'metric' in local_var_params:
            path_params['metric'] = local_var_params['metric']  # noqa: E501

        query_params = []
        if 'interval' in local_var_params and local_var_params['interval'] is not None:  # noqa: E501
            query_params.append(('interval', local_var_params['interval']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('start_time', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('end_time', local_var_params['end_time']))  # noqa: E501
        if 'object_type' in local_var_params and local_var_params['object_type'] is not None:  # noqa: E501
            query_params.append(('object_type', local_var_params['object_type']))  # noqa: E501
        if 'object_id' in local_var_params and local_var_params['object_id'] is not None:  # noqa: E501
            query_params.append(('object_id', local_var_params['object_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/metrics/{metric}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Metrics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_usage_details_get(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage details  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per day.  ### Optional Parameters  - `month`: date indicating the month to fetch usage data for, formatted `YYYY-MM`. If omitted defaults to the current month  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `day`: Timestamp denoting the start of the day      - `value`: Aggregated metric value for the given unit over the given day  #### Response Examples ``` [   {     \"object_type\": \"version\",     \"metric\": \"gb_seconds\",     \"usage\": [       {         \"day\": \"2020-07-29T00:00:00Z\",         \"value\": 4200       },       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 840       },       {         \"day\": \"2020-07-30T00:00:00Z\",         \"value\": 960       }     ]   },   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 1098       },       {         \"day\": \"2020-07-06T00:00:00Z\",         \"value\": 18       },       {         \"day\": \"2020-07-16T00:00:00Z\",         \"value\": 9       },       {         \"day\": \"2020-07-15T00:00:00Z\",         \"value\": 117       },       {         \"day\": \"2020-07-08T00:00:00Z\",         \"value\": 90       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_details_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str month:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UsagePerDay]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_usage_details_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_usage_details_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage details  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per day.  ### Optional Parameters  - `month`: date indicating the month to fetch usage data for, formatted `YYYY-MM`. If omitted defaults to the current month  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `day`: Timestamp denoting the start of the day      - `value`: Aggregated metric value for the given unit over the given day  #### Response Examples ``` [   {     \"object_type\": \"version\",     \"metric\": \"gb_seconds\",     \"usage\": [       {         \"day\": \"2020-07-29T00:00:00Z\",         \"value\": 4200       },       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 840       },       {         \"day\": \"2020-07-30T00:00:00Z\",         \"value\": 960       }     ]   },   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"day\": \"2020-07-28T00:00:00Z\",         \"value\": 1098       },       {         \"day\": \"2020-07-06T00:00:00Z\",         \"value\": 18       },       {         \"day\": \"2020-07-16T00:00:00Z\",         \"value\": 9       },       {         \"day\": \"2020-07-15T00:00:00Z\",         \"value\": 117       },       {         \"day\": \"2020-07-08T00:00:00Z\",         \"value\": 90       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_details_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str month:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UsagePerDay], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'month']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_usage_details_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_usage_details_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []
        if 'month' in local_var_params and local_var_params['month'] is not None:  # noqa: E501
            query_params.append(('month', local_var_params['month']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/usage/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UsagePerDay]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_usage_get(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str start_month:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UsagePerMonth]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_usage_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_usage_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the organization. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_usage_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str start_month:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UsagePerMonth], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'start_month']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_usage_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_usage_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []
        if 'start_month' in local_var_params and local_var_params['start_month'] is not None:  # noqa: E501
            query_params.append(('start_month', local_var_params['start_month']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UsagePerMonth]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_create(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_create_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organization_users_create_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Add a user to an organization  # noqa: E501

         ### Description Add a user to an organization as admin or normal user. The user making the request must be admin of the organization. The user can later be assigned roles in the projects defined in the scope the organization, such as project-admin, project-viewer etc.  ### Required Parameters - `email`: Email of the user   - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"admin\": false } ```  ### Response Structure  Details of the added user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_create_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUserCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_delete(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_delete_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_delete_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Delete a user from an organization  # noqa: E501

         ### Description  Delete a user from an organization. The user making the request must be admin of the organization. It is not possible to delete the last admin of an organization.  **When a user is deleted from an organization, all his roles from all projects defined in the scope of the organization are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_delete_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_get(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_get_with_http_info(organization_name, user_id, **kwargs)  # noqa: E501

    def organization_users_get_with_http_info(self, organization_name, user_id, **kwargs):  # noqa: E501
        """Get details of a user in an organization  # noqa: E501

         ### Description  Get the details of a user in an organization. The user making the request must be admin of the organization.  ### Response Structure  Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_get_with_http_info(organization_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_get`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_list(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationUserDetail]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_list_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organization_users_list_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List the users in an organization  # noqa: E501

         ### Description  List users and their details in an organization  ### Response Structure  List of details of users - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples ``` [   {     \"id\": \"54977bc3-2c3b-4d8f-97c7-aff89a95bf21\",     \"email\": \"user@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": true   },   {     \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",     \"email\": \"user2@example.com\",     \"name\": \"user\",     \"surname\": \"name\",     \"admin\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_list_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationUserDetail], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationUserDetail]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organization_users_update(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organization_users_update_with_http_info(organization_name, user_id, data, **kwargs)  # noqa: E501

    def organization_users_update_with_http_info(self, organization_name, user_id, data, **kwargs):  # noqa: E501
        """Update details of a user in an organization  # noqa: E501

         ### Description  Update the admin status of a user in an organization. The user making the request must be admin of the organization. It is not possible to change the last admin of an organization to a regular user.  ### Required Parameters - `admin`: Boolean value indicating whether the user is added as an admin of the organization or not    #### Request Examples  ``` {   \"admin\": true } ```  ### Response Structure Details of the user - `id`: Unique identifier for the user (UUID)   - `email`: Email of the user   - `name`: Name of the user   - `surname`: Surname of the user   - `admin`: Boolean value indicating whether the user is an admin of the organization or not    #### Response Examples  ``` {   \"id\": \"332d7432-2742-4177-99a9-139e91e0110c\",   \"email\": \"test@example.com\",   \"name\": \"user\",   \"surname\": \"name\",   \"admin\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organization_users_update_with_http_info(organization_name, user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param str user_id: (required)
        :param OrganizationUserUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'user_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organization_users_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `organization_users_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organization_users_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/users/{user_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_create(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year.  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true,   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_create_with_http_info(data, **kwargs)  # noqa: E501

    def organizations_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create organizations  # noqa: E501

         ### Description  Create a new organization. When a user creates an organization, s/he will automatically become an organization admin.  ### Required Parameters  - `name`: Name of the organization. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `subscription`: Name of the subscription for the organization - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted  ### Optional Parameters  - `subscription_end_date`: End date of the subscription. The subscription will be cancelled on this date. A 'free' subscription cannot have a custom end_date as this subscription is always valid for a year.  #### Request Examples  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true } ```  ``` {   \"name\": \"test-organization\",   \"subscription\": \"professional\",   \"subscription_agreed\": true,   \"subscription_end_date\": \"2021-03-25\" } ```  ### Response Structure  Details of the created organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganizationCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_get(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_get_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_get_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """Get details of an organization  # noqa: E501

         ### Description  Get the details of an organization  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_get_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_list(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganizationList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_list_with_http_info(**kwargs)  # noqa: E501

    def organizations_list_with_http_info(self, **kwargs):  # noqa: E501
        """List organizations  # noqa: E501

         ### Description  List all organizations where the user making the request is a member  ### Response Structure A list of details of the organizations - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Date and time the organization was created    #### Response Examples ``` [   {     \"id\": \"45a1f903-4146-4f15-be4a-302455cd6f7e\",     \"name\": \"organization-name\",     \"creation_date\": \"2020-03-23T11:47:15.436240Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganizationList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_resource_usage(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - versions   - pipelines   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"versions\": 47,   \"pipelines\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_resource_usage_with_http_info(organization_name, **kwargs)  # noqa: E501

    def organizations_resource_usage_with_http_info(self, organization_name, **kwargs):  # noqa: E501
        """List resource usage of an organization  # noqa: E501

         ### Description  List the total number of resources used by this organization  ### Response Structure A list containing the number of - projects   - users   - deployments   - versions   - pipelines   currently used by the organization.  #### Response Examples ``` {   \"projects\": 5,   \"users\": 3,   \"deployments\": 30,   \"versions\": 47,   \"pipelines\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_resource_usage_with_http_info(organization_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceUsage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_resource_usage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_resource_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}/resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organizations_update(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted upon upgrading the subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If the subscription_end_date was previously set, but should be removed, give a null value for 'subscription_end_date'.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_agreed\": true } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_agreed\": true } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganizationDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organizations_update_with_http_info(organization_name, data, **kwargs)  # noqa: E501

    def organizations_update_with_http_info(self, organization_name, data, **kwargs):  # noqa: E501
        """Update details of an organization  # noqa: E501

         ### Description  Update an organization. The user making the request must be admin of the organization. Users are able to update the name of the organization, but changes to the subscription can only be done by Dutch Analytics. To delete the end date of the current subscription, give the 'subscription_end_date' parameter with value null.  ### Optional Parameters  - `name`: New organization name - `subscription`: New subscription - `subscription_agreed`: A boolean field indicating whether the Services Agreement and Terms & Conditions are accepted upon upgrading the subscription - `subscription_end_date`: End date of the new subscription. The required format is `YYYY-MM-DD`. The subscription will be cancelled on this date. If the subscription_end_date was previously set, but should be removed, give a null value for 'subscription_end_date'.  #### Request Examples   ``` {   \"name\": \"new-organization-name\" } ``` ``` {   \"subscription\": \"professional\",   \"subscription_agreed\": true } ``` ``` {   \"subscription_end_date\": \"2020-08-30\",   \"subscription_agreed\": true } ```  ### Response Structure  Details of the organization - `id`: Unique identifier for the organization (UUID)   - `name`: Name of the organization   - `creation_date`: Time the organization was created   - `subscription`: Name of the subscription    #### Response Examples  ``` {   \"id\": \"abe2e406-fae5-4bcf-a3bc-956d756e4ecb\",   \"name\": \"test-organization\",   \"creation_date\": \"2020-03-25T15:43:46.101877Z\",   \"subscription\": \"free\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organizations_update_with_http_info(organization_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organization_name: (required)
        :param OrganizationUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganizationDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['organization_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organizations_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_name` when calling `organizations_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `organizations_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in local_var_params:
            path_params['organization_name'] = local_var_params['organization_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_list(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PermissionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_list_with_http_info(**kwargs)  # noqa: E501

    def permissions_list_with_http_info(self, **kwargs):  # noqa: E501
        """List the available permissions  # noqa: E501

         ### Description  List all the available permissions which can be used to create custom roles.  ### Response Structure  A list of available permissions  - `name`: Name of the permission     # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PermissionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_audit_events_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 for pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object for pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_audit_events_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 for pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object for pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_attachments_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between two pipeline objects. An attachment can only be made between two objects that have already been added to the pipeline.  The object where the attachment starts is called the source object. The object that is linked is called the destination object. When attaching two objects, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all source object output fields need to be used in the mapping. It is also possible that one source output field may link to multiple destination input fields.  The *pipeline_start* object can only be a source object.  In case of plain type of objects, the mapping must be omitted or given as an empty list.  ### Required Parameters  - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two versions ``` {   \"source_name\": \"deployment-1-v1\",   \"destination_name\": \"deployment-2-v1\",   \"mapping\": [     {       \"source_field_name\": \"deployment-output-field-1\",       \"destination_field_name\": \"deployment-2-input-field-1\"     },     {       \"source_field_name\": \"deployment-output-field-2\",       \"destination_field_name\": \"deployment-2-input-field-2\"     },     {       \"source_field_name\": \"deployment-output-field-3\",       \"destination_field_name\": \"deployment-2-input-field-3\"     }   ] } ```  ``` {   \"source_name\": \"blob-deployment-v3\",   \"destination_name\": \"blob-deployment-v4\",   \"mapping\": [] } ```   An attachment between a pipeline and version ``` {   \"source_name\": \"pipeline_start\",   \"destination_name\": \"deployment-2-v2\",   \"mapping\": [     {       \"source_field_name\": \"pipeline-input-field-1\",       \"destination_field_name\": \"deployment-input-field-1\"     },     {       \"source_field_name\": \"pipeline-input-field-2\",       \"destination_field_name\": \"deployment-input-field-2\"     }   ] } ```  ### Response Structure  Details of the created attachment - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name  #### Response Examples  ``` {   \"source_name\": \"pipeline-1\",   \"destination_name\": \"deployment-2-v2\",   \"mapping\": [     {       \"source_field_name\": \"pipeline-input-field-1\",       \"destination_field_name\": \"deployment-input-field-1\"     },     {       \"source_field_name\": \"pipeline-input-field-2\",       \"destination_field_name\": \"deployment-input-field-2\"     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param AttachmentsCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Attachments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_attachments_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_object_attachments_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create object attachments  # noqa: E501

         ### Description  Create an attachment between two pipeline objects. An attachment can only be made between two objects that have already been added to the pipeline.  The object where the attachment starts is called the source object. The object that is linked is called the destination object. When attaching two objects, one must also define which source object output fields map to which destination object input fields. All the input fields in the destination object must be provided in the mapping. In contrast, not all source object output fields need to be used in the mapping. It is also possible that one source output field may link to multiple destination input fields.  The *pipeline_start* object can only be a source object.  In case of plain type of objects, the mapping must be omitted or given as an empty list.  ### Required Parameters  - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name keys. The source and destination fields should match in data type, e.g. integer source fields can only be mapped to integer type destination fields.  #### Request Examples  An attachment between two versions ``` {   \"source_name\": \"deployment-1-v1\",   \"destination_name\": \"deployment-2-v1\",   \"mapping\": [     {       \"source_field_name\": \"deployment-output-field-1\",       \"destination_field_name\": \"deployment-2-input-field-1\"     },     {       \"source_field_name\": \"deployment-output-field-2\",       \"destination_field_name\": \"deployment-2-input-field-2\"     },     {       \"source_field_name\": \"deployment-output-field-3\",       \"destination_field_name\": \"deployment-2-input-field-3\"     }   ] } ```  ``` {   \"source_name\": \"blob-deployment-v3\",   \"destination_name\": \"blob-deployment-v4\",   \"mapping\": [] } ```   An attachment between a pipeline and version ``` {   \"source_name\": \"pipeline_start\",   \"destination_name\": \"deployment-2-v2\",   \"mapping\": [     {       \"source_field_name\": \"pipeline-input-field-1\",       \"destination_field_name\": \"deployment-input-field-1\"     },     {       \"source_field_name\": \"pipeline-input-field-2\",       \"destination_field_name\": \"deployment-input-field-2\"     }   ] } ```  ### Response Structure  Details of the created attachment - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name  #### Response Examples  ``` {   \"source_name\": \"pipeline-1\",   \"destination_name\": \"deployment-2-v2\",   \"mapping\": [     {       \"source_field_name\": \"pipeline-input-field-1\",       \"destination_field_name\": \"deployment-input-field-1\"     },     {       \"source_field_name\": \"pipeline-input-field-2\",       \"destination_field_name\": \"deployment-input-field-2\"     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param AttachmentsCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Attachments, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_attachments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_attachments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_object_attachments_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/attachments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Attachments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_attachments_delete(self, project_name, destination_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """Delete attachment of a source and destination object  # noqa: E501

         ### Description  Delete an attachment in a pipeline. The referenced and original objects of the attachment still exist in the pipeline, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_delete(project_name, destination_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_attachments_delete_with_http_info(project_name, destination_name, pipeline_name, source_name, **kwargs)  # noqa: E501

    def pipeline_object_attachments_delete_with_http_info(self, project_name, destination_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """Delete attachment of a source and destination object  # noqa: E501

         ### Description  Delete an attachment in a pipeline. The referenced and original objects of the attachment still exist in the pipeline, only the link between them is deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_delete_with_http_info(project_name, destination_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'destination_name', 'pipeline_name', 'source_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_attachments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'destination_name' is set
        if self.api_client.client_side_validation and ('destination_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['destination_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `destination_name` when calling `pipeline_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_attachments_delete`")  # noqa: E501
        # verify the required parameter 'source_name' is set
        if self.api_client.client_side_validation and ('source_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['source_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `source_name` when calling `pipeline_object_attachments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'destination_name' in local_var_params:
            path_params['destination_name'] = local_var_params['destination_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'source_name' in local_var_params:
            path_params['source_name'] = local_var_params['source_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{source_name}/attachments/{destination_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_attachments_get(self, project_name, destination_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """Get an attachment of a source and destination object  # noqa: E501

         ### Description  Get the details of a single attachment between a source and destination object in a pipeline  ### Response Structure  Details of the attachment - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing the link between the source object output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"source_name\": \"deployment-2-v2\",   \"destination_name\": \"deployment-3-v1\",   \"mapping\": [     {       \"source_field_name\": \"deployment-2-output-field-1\",       \"destination_field_name\": \"deployment-3-input-field-1\"     },     {       \"source_field_name\": \"deployment-2-output-field-2\",       \"destination_field_name\": \"deployment-3-input-field-2\"     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_get(project_name, destination_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttachmentsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_attachments_get_with_http_info(project_name, destination_name, pipeline_name, source_name, **kwargs)  # noqa: E501

    def pipeline_object_attachments_get_with_http_info(self, project_name, destination_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """Get an attachment of a source and destination object  # noqa: E501

         ### Description  Get the details of a single attachment between a source and destination object in a pipeline  ### Response Structure  Details of the attachment - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing the link between the source object output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` {   \"source_name\": \"deployment-2-v2\",   \"destination_name\": \"deployment-3-v1\",   \"mapping\": [     {       \"source_field_name\": \"deployment-2-output-field-1\",       \"destination_field_name\": \"deployment-3-input-field-1\"     },     {       \"source_field_name\": \"deployment-2-output-field-2\",       \"destination_field_name\": \"deployment-3-input-field-2\"     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_get_with_http_info(project_name, destination_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str destination_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttachmentsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'destination_name', 'pipeline_name', 'source_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_attachments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'destination_name' is set
        if self.api_client.client_side_validation and ('destination_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['destination_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `destination_name` when calling `pipeline_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_attachments_get`")  # noqa: E501
        # verify the required parameter 'source_name' is set
        if self.api_client.client_side_validation and ('source_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['source_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `source_name` when calling `pipeline_object_attachments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'destination_name' in local_var_params:
            path_params['destination_name'] = local_var_params['destination_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'source_name' in local_var_params:
            path_params['source_name'] = local_var_params['source_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{source_name}/attachments/{destination_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttachmentsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_attachments_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline  ### Response Structure  A list of details of the attachments in the pipeline - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name  #### Response Examples  ``` [   {     \"source_name\": \"pipeline-1\",     \"destination_name\": \"deployment-2-v2\",     \"mapping\": [       {         \"source_field_name\": \"pipeline-input-field-1\",         \"destination_field_name\": \"deployment-input-field-1\"       },       {         \"source_field_name\": \"pipeline-input-field-2\",         \"destination_field_name\": \"deployment-input-field-2\"       }     ]   },   {     \"source_name\": \"deployment-2-v2\",     \"destination_name\": \"deployment-3-v1\",     \"mapping\": [       {         \"source_field_name\": \"deployment-output-field-1\",         \"destination_field_name\": \"deployment-3-input-field-1\"       },       {         \"source_field_name\": \"deployment-output-field-2\",         \"destination_field_name\": \"deployment-3-input-field-2\"       },       {         \"source_field_name\": \"deployment-output-field-3\",         \"destination_field_name\": \"deployment-3-input-field-3\"       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_attachments_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_object_attachments_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List object attachments  # noqa: E501

         ### Description  List all attachments in a pipeline  ### Response Structure  A list of details of the attachments in the pipeline - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing source_field_name and destination_field_name  #### Response Examples  ``` [   {     \"source_name\": \"pipeline-1\",     \"destination_name\": \"deployment-2-v2\",     \"mapping\": [       {         \"source_field_name\": \"pipeline-input-field-1\",         \"destination_field_name\": \"deployment-input-field-1\"       },       {         \"source_field_name\": \"pipeline-input-field-2\",         \"destination_field_name\": \"deployment-input-field-2\"       }     ]   },   {     \"source_name\": \"deployment-2-v2\",     \"destination_name\": \"deployment-3-v1\",     \"mapping\": [       {         \"source_field_name\": \"deployment-output-field-1\",         \"destination_field_name\": \"deployment-3-input-field-1\"       },       {         \"source_field_name\": \"deployment-output-field-2\",         \"destination_field_name\": \"deployment-3-input-field-2\"       },       {         \"source_field_name\": \"deployment-output-field-3\",         \"destination_field_name\": \"deployment-3-input-field-3\"       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_attachments_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_attachments_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_attachments_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_attachments_source_get(self, project_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """List the attachments of a source object  # noqa: E501

         ### Description  List attachments of a source object in a pipeline  ### Response Structure  A list of details of the attachments of the given source object in the pipeline - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing the link between the source object output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"source_name\": \"deployment-2-v2\",     \"destination_name\": \"deployment-3-v1\",     \"mapping\": [       {         \"source_field_name\": \"deployment-2-output-field-1\",         \"destination_field_name\": \"deployment-3-input-field-1\"       },       {         \"source_field_name\": \"deployment-2-output-field-2\",         \"destination_field_name\": \"deployment-3-input-field-2\"       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_source_get(project_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AttachmentsList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_attachments_source_get_with_http_info(project_name, pipeline_name, source_name, **kwargs)  # noqa: E501

    def pipeline_object_attachments_source_get_with_http_info(self, project_name, pipeline_name, source_name, **kwargs):  # noqa: E501
        """List the attachments of a source object  # noqa: E501

         ### Description  List attachments of a source object in a pipeline  ### Response Structure  A list of details of the attachments of the given source object in the pipeline - `source_name`: Name of the source pipeline object - `destination_name`: Name of the destination pipeline object - `mapping`: A list of dictionaries containing the link between the source object output field (source_field_name) and destination object input field (destination_field_name)  #### Response Examples  ``` [   {     \"source_name\": \"deployment-2-v2\",     \"destination_name\": \"deployment-3-v1\",     \"mapping\": [       {         \"source_field_name\": \"deployment-2-output-field-1\",         \"destination_field_name\": \"deployment-3-input-field-1\"       },       {         \"source_field_name\": \"deployment-2-output-field-2\",         \"destination_field_name\": \"deployment-3-input-field-2\"       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_attachments_source_get_with_http_info(project_name, pipeline_name, source_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str source_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AttachmentsList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'source_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_attachments_source_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_attachments_source_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_attachments_source_get`")  # noqa: E501
        # verify the required parameter 'source_name' is set
        if self.api_client.client_side_validation and ('source_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['source_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `source_name` when calling `pipeline_object_attachments_source_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'source_name' in local_var_params:
            path_params['source_name'] = local_var_params['source_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{source_name}/attachments/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AttachmentsList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_object_environment_variables_list(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_environment_variables_list(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_object_environment_variables_list_with_http_info(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_object_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_object_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_objects_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Add an object to a pipeline  # noqa: E501

         ### Description  Create a pipeline object. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineObjectCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_objects_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_objects_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Add an object to a pipeline  # noqa: E501

         ### Description  Create a pipeline object. The pipeline object that is added is a reference to the real object. In this way, multiple references to the same object may be added to a pipeline. The reference_name refers to the deployment name and the version is the version of the deployment which will be added to the pipeline as an object.  ### Required Parameters  - `name`: Name of the pipeline object. It is unique within a pipeline - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Request Examples  ``` {   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```  ### Response Structure  Details of the created pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it will reference - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineObjectCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_objects_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_objects_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_objects_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_objects_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_objects_delete(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """Delete object from pipeline  # noqa: E501

           ### Description  Delete a pipeline object. Only the reference in the pipeline is deleted. The original object (deployment and version) still exists. If the object is attached to another object, the attachment is also deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_delete(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_objects_delete_with_http_info(project_name, name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_objects_delete_with_http_info(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """Delete object from pipeline  # noqa: E501

           ### Description  Delete a pipeline object. Only the reference in the pipeline is deleted. The original object (deployment and version) still exists. If the object is attached to another object, the attachment is also deleted.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_delete_with_http_info(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_objects_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_objects_delete`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_objects_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_objects_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_objects_get(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """Get an object in a pipeline  # noqa: E501

         ### Description  Retrieve the details of a single pipeline object  ### Response Structure  Details of the pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A dictionary containing details of the pipeline object ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_get(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_objects_get_with_http_info(project_name, name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_objects_get_with_http_info(self, project_name, name, pipeline_name, **kwargs):  # noqa: E501
        """Get an object in a pipeline  # noqa: E501

         ### Description  Retrieve the details of a single pipeline object  ### Response Structure  Details of the pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A dictionary containing details of the pipeline object ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v1\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_get_with_http_info(project_name, name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_objects_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_objects_get`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_objects_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_objects_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_objects_list(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List objects in a pipeline  # noqa: E501

         ### Description  List all pipeline objects in a pipeline  ### Response Structure  A list of details of the pipeline objects in the pipeline - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A list of pipeline objects ``` [   {     \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",     \"name\": \"deployment-1-v1\",     \"reference_name\": \"deployment-1\",     \"version\": \"version-1\"   },   {     \"id\": \"1a4b0e28-3de1-442a-b1eb-947f22a69381\",     \"name\": \"deployment-2-v1\",     \"reference_name\": \"deployment-2\",     \"version\": \"v1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_list(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineObjectList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_objects_list_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipeline_objects_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List objects in a pipeline  # noqa: E501

         ### Description  List all pipeline objects in a pipeline  ### Response Structure  A list of details of the pipeline objects in the pipeline - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  A list of pipeline objects ``` [   {     \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",     \"name\": \"deployment-1-v1\",     \"reference_name\": \"deployment-1\",     \"version\": \"version-1\"   },   {     \"id\": \"1a4b0e28-3de1-442a-b1eb-947f22a69381\",     \"name\": \"deployment-2-v1\",     \"reference_name\": \"deployment-2\",     \"version\": \"v1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineObjectList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_objects_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_objects_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_objects_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineObjectList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_objects_update(self, project_name, name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update an object in a pipeline  # noqa: E501

         ### Description  Update a pipeline object. It is not possible to update the reference_name. All necessary fields are validated again.  ### Optional Parameters  - `name`: New name for the pipeline object - `version`: New version for the pipeline object. Since the input/output fields of different versions are the same, the version of a deployment pipeline object can be changed with another version of the same deployment.  #### Request Examples  ``` {   \"name\": \"new-pipeline-object-name\" } ```   ``` {   \"name\": \"deployment-1-v2\"   \"version\": \"version-2\" } ```  ### Response Structure  Details of the updated pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v2\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-2\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_update(project_name, name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param PipelineObjectUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineObjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_objects_update_with_http_info(project_name, name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_objects_update_with_http_info(self, project_name, name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update an object in a pipeline  # noqa: E501

         ### Description  Update a pipeline object. It is not possible to update the reference_name. All necessary fields are validated again.  ### Optional Parameters  - `name`: New name for the pipeline object - `version`: New version for the pipeline object. Since the input/output fields of different versions are the same, the version of a deployment pipeline object can be changed with another version of the same deployment.  #### Request Examples  ``` {   \"name\": \"new-pipeline-object-name\" } ```   ``` {   \"name\": \"deployment-1-v2\"   \"version\": \"version-2\" } ```  ### Response Structure  Details of the updated pipeline object - `id`: Unique identifier for the pipeline object (UUID) - `name`: Name of the pipeline object - `reference_name`: Name of the object it references - `version`: Version name of reference object  #### Response Examples  ``` {   \"id\": \"c91724b6-d73c-4933-b2aa-aefd9e34ce3e\",   \"name\": \"deployment-1-v2\",   \"reference_name\": \"deployment-1\",   \"version\": \"version-2\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_objects_update_with_http_info(project_name, name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param PipelineObjectUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineObjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_objects_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_objects_update`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_objects_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_objects_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_objects_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/objects/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineObjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_requests_create(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Make a request to a pipeline  # noqa: E501

         ### Description  Make a pipeline request. This method returns all the results of the deployment requests made within the pipeline.  ### Required Parameters  A dictionary which contains the input fields of the pipeline as keys  ### Optional Parameters These parameters should be given as GET parameters - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds.  The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineRequestCreate data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineRequestList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipeline_requests_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Make a request to a pipeline  # noqa: E501

         ### Description  Make a pipeline request. This method returns all the results of the deployment requests made within the pipeline.  ### Required Parameters  A dictionary which contains the input fields of the pipeline as keys  ### Optional Parameters These parameters should be given as GET parameters - `pipeline_timeout`: Timeout for the entire pipeline request in seconds. The maximum allowed value is 7200 and the default value is 3600. - `deployment_timeout`: Timeout for each deployment request in the pipeline in seconds.  The maximum allowed value is 3600 and the default value is 300. Maximum allowed value for both is 3600 seconds and the default value is 300 seconds.  #### Request Examples ``` {   \"pipeline-input-field-1\": 5.0,   \"pipeline-input-field-2\": \"N\" } ```  ### Response Structure  - `project`: Name of the project in which the request is made - `pipeline`: Name of the pipeline for which the request is made - `pipeline_request_id`: Unique identifier for the pipeline request - `deployment_requests`: A list of dictionaries containing the results of the deployment requests made for the version objects in the pipeline. The dictionaries contain the following fields:     - `request_id`: Unique identifier for the deployment request     - `pipeline_object`: Name of the object in the pipeline     - `success`: A boolean value that indicates whether the deployment request was successful     - `request_data`: Input data for the deployment request     - `result`: Deployment request result value. NULL if the request failed.     - `error_message`: An error message explaining why the request has failed. NULL if the request was successful.   #### Response Examples ``` {   \"project\": \"project-1\",   \"pipeline\": \"pipeline-1\",   \"pipeline_request_id\": \"286f771b-6617-4985-ab49-12ed720e62b1\",   \"deployment_requests\": [     {       \"request_id\": \"a7524614-bdb7-41e1-b4c1-653bb72c30b4\",       \"pipeline_object\": \"deployment-object-1\",       \"success\": true,       \"request_data\": {         \"deployment-1-input-field-1\": 5,         \"deployment-1-input-field-2\": 0.4       },       \"result\": {         \"deployment-1-output-field-1\": 0.23,         \"deployment-1-output-field-2\": 10       },       \"error_message\": None      },     {       \"request_id\": \"fe322c50-58f8-4e67-b7d6-cba14273874e\",       \"pipeline_object\": \"deployment-object-2\",       \"success\": false,       \"request_data\": {         \"deployment-2-input-field\": 10       },       \"result\": None,       \"error_message\": \"Invalid message format\"      }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_requests_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineRequestCreate data: (required)
        :param int pipeline_timeout:
        :param int deployment_timeout:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineRequestList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data', 'pipeline_timeout', 'deployment_timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_requests_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_requests_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_requests_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'pipeline_timeout' in local_var_params and local_var_params['pipeline_timeout'] is not None:  # noqa: E501
            query_params.append(('pipeline_timeout', local_var_params['pipeline_timeout']))  # noqa: E501
        if 'deployment_timeout' in local_var_params and local_var_params['deployment_timeout'] is not None:  # noqa: E501
            query_params.append(('deployment_timeout', local_var_params['deployment_timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineRequestList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline. It can be either structured or plain. - `input_fields`: A list of fields with name and data_type. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```   A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"description\": \"my description\" } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```   ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def pipelines_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline. It can be either structured or plain. - `input_fields`: A list of fields with name and data_type. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```   A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"description\": \"my description\" } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```   ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipelines_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_delete(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all objects and attachments in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_delete_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_delete_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all objects and attachments in the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_get(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_get_with_http_info(project_name, pipeline_name, **kwargs)  # noqa: E501

    def pipelines_get_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_list(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[PipelineList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def pipelines_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_update(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update pipeline  # noqa: E501

              ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline.  If the type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the type of pipeline is updated to structured, the old fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again.  **To delete the input fields of a pipeline**, provide an empty list for input_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```   ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PipelineList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pipelines_update_with_http_info(project_name, pipeline_name, data, **kwargs)  # noqa: E501

    def pipelines_update_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update pipeline  # noqa: E501

              ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline.  If the type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the type of pipeline is updated to structured, the old fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again.  **To delete the input fields of a pipeline**, provide an empty list for input_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```   ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline - `input_fields`: A list of pipeline fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\"     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\"     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipelines_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_audit_events_list(self, project_name, **kwargs):  # noqa: E501
        """List audit events in a project  # noqa: E501

         ### Description  List all audit events in a project including all objects  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events in the project - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"54c1ea23-5773-4821-8fd7-1b577cc301bc\",     \"date\": \"2020-05-23T11:53:02.873+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created project test-project\",     \"object_type\": \"project\",     \"object_name\": \"test-project\"   },   {     \"id\": \"764e254c-7402-4445-ac79-009d08b21caa\",     \"date\": \"2020-05-23T11:57:20.072+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_audit_events_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AuditList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_audit_events_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def project_audit_events_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List audit events in a project  # noqa: E501

         ### Description  List all audit events in a project including all objects  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events in the project - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"54c1ea23-5773-4821-8fd7-1b577cc301bc\",     \"date\": \"2020-05-23T11:53:02.873+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created project test-project\",     \"object_type\": \"project\",     \"object_name\": \"test-project\"   },   {     \"id\": \"764e254c-7402-4445-ac79-009d08b21caa\",     \"date\": \"2020-05-23T11:57:20.072+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created deployment deployment-1\",     \"object_type\": \"deployment\",     \"object_name\": \"deployment-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_audit_events_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_environment_variables_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create project environment variable  # noqa: E501

         ### Description Create an environment variable for the project. This variable will be inherited by all deployments in this project.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"name\": \"database_password\",   \"value\": \"password\",   \"secret\": true } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"database_password\",   \"value\": null,   \"secret\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_environment_variables_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def project_environment_variables_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create project environment variable  # noqa: E501

         ### Description Create an environment variable for the project. This variable will be inherited by all deployments in this project.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"name\": \"database_password\",   \"value\": \"password\",   \"secret\": true } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"public\",   \"secret\": false } ```  ``` {   \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",   \"name\": \"database_password\",   \"value\": null,   \"secret\": true } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `project_environment_variables_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_environment_variables_delete(self, project_name, id, **kwargs):  # noqa: E501
        """Delete project environment variable  # noqa: E501

         ### Description Delete an environment variable of the project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_delete(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_environment_variables_delete_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def project_environment_variables_delete_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Delete project environment variable  # noqa: E501

         ### Description Delete an environment variable of the project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_delete_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `project_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_environment_variables_get(self, project_name, id, **kwargs):  # noqa: E501
        """Get project environment variable  # noqa: E501

         ### Description Retrieve details of a project environment variable.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_get(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_environment_variables_get_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def project_environment_variables_get_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Get project environment variable  # noqa: E501

         ### Description Retrieve details of a project environment variable.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_get_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `project_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_environment_variables_list(self, project_name, **kwargs):  # noqa: E501
        """List project environment variables  # noqa: E501

         ### Description List the environment variables defined for the project. These are the variables that are inherited by all deployments in this project.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_environment_variables_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def project_environment_variables_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List project environment variables  # noqa: E501

         ### Description List the environment variables defined for the project. These are the variables that are inherited by all deployments in this project.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_environment_variables_update(self, project_name, id, data, **kwargs):  # noqa: E501
        """Update project environment variable  # noqa: E501

         ### Description Update an environment variable for the projects  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore.  - `value`: The value of the variable as a string. It may be an empty string.  - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).   #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"new+schema\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"new_schema\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_update(project_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_environment_variables_update_with_http_info(project_name, id, data, **kwargs)  # noqa: E501

    def project_environment_variables_update_with_http_info(self, project_name, id, data, **kwargs):  # noqa: E501
        """Update project environment variable  # noqa: E501

         ### Description Update an environment variable for the projects  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore.  - `value`: The value of the variable as a string. It may be an empty string.  - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).   #### Request Examples ``` {   \"name\": \"database_schema\",   \"value\": \"new+schema\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",   \"name\": \"database_schema\",   \"value\": \"new_schema\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_environment_variables_update_with_http_info(project_name, id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `project_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `project_environment_variables_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_usage_get(self, project_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the project. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_usage_get(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str start_month:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UsagePerMonth]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.project_usage_get_with_http_info(project_name, **kwargs)  # noqa: E501

    def project_usage_get_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Get resource usage  # noqa: E501

         ### Description  Get resource usage for the project. This returns a list of metrics that are used for billing, aggregated per month.  ### Optional Parameters  - `start_month`: date indicating the start month to fetch usage data from, formatted `YYYY-MM`. If omitted results are generated from one year ago.  ### Response Structure   - `metric`: The metric that was measured  - `object_type`: Type of object the metric was measured for (version or pipeline)  - `usage`: an array of objects each containing the following:      - `month`: Timestamp denoting the start of the month      - `value`: Aggregated metric value for the given unit over the given month  #### Response Examples ``` [   {     \"object_type\": \"pipeline\",     \"metric\": \"input_volume\",     \"usage\": [       {         \"month\": \"2019-08-01T00:00:00Z\",         \"value\": 1840       },       {         \"month\": \"2019-09-01T00:00:00Z\",         \"value\": 400       },       {         \"month\": \"2019-10-01T00:00:00Z\",         \"value\": 1204       },       {         \"month\": \"2019-11-01T00:00:00Z\",         \"value\": 1598       },       {         \"month\": \"2019-12-01T00:00:00Z\",         \"value\": 824       },       {         \"month\": \"2020-01-01T00:00:00Z\",         \"value\": 2036       },       {         \"month\": \"2020-02-01T00:00:00Z\",         \"value\": 1438       },       {         \"month\": \"2020-03-01T00:00:00Z\",         \"value\": 932       },       {         \"month\": \"2020-04-01T00:00:00Z\",         \"value\": 528       },       {         \"month\": \"2020-05-01T00:00:00Z\",         \"value\": 1484       },       {         \"month\": \"2020-06-01T00:00:00Z\",         \"value\": 1942       },       {         \"month\": \"2020-07-01T00:00:00Z\",         \"value\": 1332       }     ]   } ]  ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_usage_get_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str start_month:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UsagePerMonth], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'start_month']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_usage_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `project_usage_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'start_month' in local_var_params and local_var_params['start_month'] is not None:  # noqa: E501
            query_params.append(('start_month', local_var_params['start_month']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UsagePerMonth]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_create(self, data, **kwargs):  # noqa: E501
        """Create projects  # noqa: E501

         ### Description  Create a new project with the provided name. **Only the organization admins have permission to make this request.** When a new project is created, the current organization admins are assigned project-admin role for the created project.  ### Required Parameters  - `name`: Name of the project. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `organization_name`: Name of the organization in which the project is going to be created   #### Request Examples  ``` {   \"name\": \"project-1\",   \"organization_name\": \"organization-1\" } ```  ### Response Structure  Details of the created project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProjectCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_create_with_http_info(data, **kwargs)  # noqa: E501

    def projects_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create projects  # noqa: E501

         ### Description  Create a new project with the provided name. **Only the organization admins have permission to make this request.** When a new project is created, the current organization admins are assigned project-admin role for the created project.  ### Required Parameters  - `name`: Name of the project. The name is globally unique. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `organization_name`: Name of the organization in which the project is going to be created   #### Request Examples  ``` {   \"name\": \"project-1\",   \"organization_name\": \"organization-1\" } ```  ### Response Structure  Details of the created project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProjectCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `projects_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_delete(self, project_name, **kwargs):  # noqa: E501
        """Delete a project  # noqa: E501

         ### Description  Delete a project. The user making the request must have appropriate permissions. **When project is deleted, all the deployments and pipelines defined in it are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_delete(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_delete_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_delete_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Delete a project  # noqa: E501

         ### Description  Delete a project. The user making the request must have appropriate permissions. **When project is deleted, all the deployments and pipelines defined in it are also deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_delete_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `projects_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_get(self, project_name, **kwargs):  # noqa: E501
        """Get details of a project  # noqa: E501

         ### Description  Get the details of a single project. The user making the request must have appropriate permissions.  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_get(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_get_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_get_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Get details of a project  # noqa: E501

         ### Description  Get the details of a single project. The user making the request must have appropriate permissions.  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_get_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `projects_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_list(self, **kwargs):  # noqa: E501
        """List projects  # noqa: E501

         ### Description  List all projects to which the user making request has access. The projects in organizations to which the user belongs are shown.  ### Response Structure A list of details of the projects - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"name\": \"project-1\",     \"creation_date\": \"2018-10-26\",     \"organization_name\": \"organization-1\"   },   {     \"id\": \"e6a85cd7-94cc-44cf-9fa0-4b462d5a71ab\",     \"name\": \"project-2\",     \"creation_date\": \"2019-06-20\",     \"organization_name\": \"organization-2\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ProjectList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_list_with_http_info(**kwargs)  # noqa: E501

    def projects_list_with_http_info(self, **kwargs):  # noqa: E501
        """List projects  # noqa: E501

         ### Description  List all projects to which the user making request has access. The projects in organizations to which the user belongs are shown.  ### Response Structure A list of details of the projects - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"name\": \"project-1\",     \"creation_date\": \"2018-10-26\",     \"organization_name\": \"organization-1\"   },   {     \"id\": \"e6a85cd7-94cc-44cf-9fa0-4b462d5a71ab\",     \"name\": \"project-2\",     \"creation_date\": \"2019-06-20\",     \"organization_name\": \"organization-2\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ProjectList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProjectList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_log_list(self, project_name, data, **kwargs):  # noqa: E501
        """List logs for a project  # noqa: E501

         ### Description  Retrieve the logs of all objects in a project, including deployments, pipelines and requests. Using filters you can filter the logs on the objects and information of your choice.   ### Required Parameters  - `filters`: A dictionary containing information to filter logs on. It may contain zero or more of the following fields:       - `deployment_name`: name of a deployment       - `version`: a version name. If this field is present in the request, deployment_name must also be given. The versions are only meaningful in combination with the deployments they are defined for.       - `pipeline_name`: name of a pipeline       - `pipeline_object_name`: name of a pipeline object. If this field is present in the request, pipeline_name must also be given. The pipeline objects are only meaningful in combination with the pipelines they are defined in.       - `request_id`: the UUID of a deployment request       - `pipeline_request_id`: the UUID of a pipeline request       - `system`: whether the log was generated by the system or user code (true / false)    Any combination of filters may be given in the request. For example, if only a deployment_name is provided, all logs for that deployment are returned. These logs can contain information from all the pipelines that deployment is referenced in. If the filters dictionary is empty, all logs for all objects in the project are returned.  ### Optional Parameters  - `date`: Starting date for the logs. If it is not provided and the `id` parameter is not set, the most recent logs are returned. It should be provided in ISO 8601 format. The results are inclusive of the given date.   - `id`: identifier for log lines. If specified, it will act as a starting point for the interval in which to query the logs. This can be useful when making multiple queries to obtain consecutive logs      It will include the log having the log id equal to the id value in the response, regardless of whether the date_range is positive or negative. - `limit`: Limit for the logs response. If specified, it will limit the total number of logs returned from the query to the specified number. Defaults to 50, the maximum is 500.    - `date_range`: The date range parameter sets the interval of time in which to query the logs, specified in seconds. It may be a positive or a negative value.       If it is positive, logs starting from the specified date / log id (both inclusive) plus date range seconds towards the present time are returned.       Otherwise, logs starting from the specified date / log id (both inclusive) minus date range seconds towards the past are returned.        The default value is -21600 (6 hours). The maximum value is -/+ 86400 seconds (24 hours).      If no date or id is specified, the API will use the current time as a starting point and try to fetch the logs starting from now minus date range seconds into the past.  #### Request Examples  ``` {   \"filters\": {     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\" } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\"   },   \"id\": \"41d7a7c5cd025e3501a00000\",   \"date_range\": -100 } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\",   \"date_range\": -86400,   \"limit\": 5 } ```  ### Response Structure  A list of log details - `id`: Unique UUID of the log line   - `log`: Log line text   - `date`: Time the log line was created   The following fields will be returned on response if they are set for the log line: - `deployment_name`:  The deployment which the log is related to   - `version`:  The version which the log is related to   - `pipeline_name`:  The pipeline which the log is related to   - `pipeline_object_name`: The pipeline object which the log is related to   - `request_id`:  The deployment request the log is related to   - `pipeline_request_id`:  The pipeline request the log is related to   - `system`:  Whether the log was generated by the system (true / false)  #### Response Examples  Logs for a specific deployment and version ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f180\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Prediction result 0.14981\"   },   {     \"id\": \"5dcad12ba76a2c6e4331f181\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\",     \"pipeline_name\": \"pipeline-2\",     \"pipeline_object_name\": \"deployment-1-v1-object\",     \"pipeline_trace_id\": \"8bb6ed79-8606-4acf-acd2-90507130523c\",     \"date\": \"2020-01-01T00:00:01.000000Z\",     \"log\": \"[Error] Deployment call result (failed)\"   } ] ```   Logs for a specific pipeline ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f192\",     \"deployment_name\": \"deployment-2\",     \"version\": \"v2\",     \"pipeline_name\": \"pipeline-1\",     \"pipeline_object_name\": \"deployment-2-v2-object\",     \"pipeline_trace_id\": \"4f75b10d-6012-47ab-ae68-cc9e69f35841\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Deployment call result (success): 0.2316\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_log_list(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param LogsCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Logs]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_log_list_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def projects_log_list_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """List logs for a project  # noqa: E501

         ### Description  Retrieve the logs of all objects in a project, including deployments, pipelines and requests. Using filters you can filter the logs on the objects and information of your choice.   ### Required Parameters  - `filters`: A dictionary containing information to filter logs on. It may contain zero or more of the following fields:       - `deployment_name`: name of a deployment       - `version`: a version name. If this field is present in the request, deployment_name must also be given. The versions are only meaningful in combination with the deployments they are defined for.       - `pipeline_name`: name of a pipeline       - `pipeline_object_name`: name of a pipeline object. If this field is present in the request, pipeline_name must also be given. The pipeline objects are only meaningful in combination with the pipelines they are defined in.       - `request_id`: the UUID of a deployment request       - `pipeline_request_id`: the UUID of a pipeline request       - `system`: whether the log was generated by the system or user code (true / false)    Any combination of filters may be given in the request. For example, if only a deployment_name is provided, all logs for that deployment are returned. These logs can contain information from all the pipelines that deployment is referenced in. If the filters dictionary is empty, all logs for all objects in the project are returned.  ### Optional Parameters  - `date`: Starting date for the logs. If it is not provided and the `id` parameter is not set, the most recent logs are returned. It should be provided in ISO 8601 format. The results are inclusive of the given date.   - `id`: identifier for log lines. If specified, it will act as a starting point for the interval in which to query the logs. This can be useful when making multiple queries to obtain consecutive logs      It will include the log having the log id equal to the id value in the response, regardless of whether the date_range is positive or negative. - `limit`: Limit for the logs response. If specified, it will limit the total number of logs returned from the query to the specified number. Defaults to 50, the maximum is 500.    - `date_range`: The date range parameter sets the interval of time in which to query the logs, specified in seconds. It may be a positive or a negative value.       If it is positive, logs starting from the specified date / log id (both inclusive) plus date range seconds towards the present time are returned.       Otherwise, logs starting from the specified date / log id (both inclusive) minus date range seconds towards the past are returned.        The default value is -21600 (6 hours). The maximum value is -/+ 86400 seconds (24 hours).      If no date or id is specified, the API will use the current time as a starting point and try to fetch the logs starting from now minus date range seconds into the past.  #### Request Examples  ``` {   \"filters\": {     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\" } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\"   },   \"id\": \"41d7a7c5cd025e3501a00000\",   \"date_range\": -100 } ```  ``` {   \"filters\": {     \"pipeline_name\": \"pipeline-1\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\"   },   \"date\": \"2020-01-01T00:00:00.000000Z\",   \"date_range\": -86400,   \"limit\": 5 } ```  ### Response Structure  A list of log details - `id`: Unique UUID of the log line   - `log`: Log line text   - `date`: Time the log line was created   The following fields will be returned on response if they are set for the log line: - `deployment_name`:  The deployment which the log is related to   - `version`:  The version which the log is related to   - `pipeline_name`:  The pipeline which the log is related to   - `pipeline_object_name`: The pipeline object which the log is related to   - `request_id`:  The deployment request the log is related to   - `pipeline_request_id`:  The pipeline request the log is related to   - `system`:  Whether the log was generated by the system (true / false)  #### Response Examples  Logs for a specific deployment and version ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f180\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Prediction result 0.14981\"   },   {     \"id\": \"5dcad12ba76a2c6e4331f181\",     \"deployment_name\": \"deployment-1\",     \"version\": \"v1\",     \"pipeline_name\": \"pipeline-2\",     \"pipeline_object_name\": \"deployment-1-v1-object\",     \"pipeline_trace_id\": \"8bb6ed79-8606-4acf-acd2-90507130523c\",     \"date\": \"2020-01-01T00:00:01.000000Z\",     \"log\": \"[Error] Deployment call result (failed)\"   } ] ```   Logs for a specific pipeline ``` [   {     \"id\": \"5dcad12ba76a2c6e4331f192\",     \"deployment_name\": \"deployment-2\",     \"version\": \"v2\",     \"pipeline_name\": \"pipeline-1\",     \"pipeline_object_name\": \"deployment-2-v2-object\",     \"pipeline_trace_id\": \"4f75b10d-6012-47ab-ae68-cc9e69f35841\",     \"date\": \"2020-01-01T00:00:00.000000Z\",     \"log\": \"[Info] Deployment call result (success): 0.2316\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_log_list_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param LogsCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Logs], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_log_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `projects_log_list`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `projects_log_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Logs]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_resource_usage(self, project_name, **kwargs):  # noqa: E501
        """List resource usage of a project  # noqa: E501

         ### Description  List the total number of resources used in a project  ### Response Structure A list containing the number of - deployments   - versions   - pipelines   currently defined in the project.  #### Response Examples ``` {   \"deployments\": 30,   \"versions\": 47,   \"pipelines\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_resource_usage(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectResourceUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_resource_usage_with_http_info(project_name, **kwargs)  # noqa: E501

    def projects_resource_usage_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List resource usage of a project  # noqa: E501

         ### Description  List the total number of resources used in a project  ### Response Structure A list containing the number of - deployments   - versions   - pipelines   currently defined in the project.  #### Response Examples ``` {   \"deployments\": 30,   \"versions\": 47,   \"pipelines\": 2 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_resource_usage_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProjectResourceUsage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_resource_usage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `projects_resource_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectResourceUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def projects_update(self, project_name, data, **kwargs):  # noqa: E501
        """Update a project  # noqa: E501

         ### Description  Update the name of a single project. The user making the request must have appropriate permissions.  ### Optional Parameters  - `name`: New project name  #### Request Examples  ``` {   \"name\": \"project-name-example\" } ```  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_update(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ProjectUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.projects_update_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def projects_update_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Update a project  # noqa: E501

         ### Description  Update the name of a single project. The user making the request must have appropriate permissions.  ### Optional Parameters  - `name`: New project name  #### Request Examples  ``` {   \"name\": \"project-name-example\" } ```  ### Response Structure  Details of a project - `id`: Unique identifier for the project (UUID)   - `name`: Name of the project   - `creation_date`: Time the project was created   - `organization_name`: Name of the organization in which the project is created  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"name\": \"project-1\",   \"creation_date\": \"2018-10-26\",   \"organization_name\": \"organization-1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.projects_update_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ProjectUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProjectList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method projects_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `projects_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `projects_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_schedules_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create request schedules  # noqa: E501

         ### Description  Create a new request schedule with the provided name  ### Required Parameters  - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `object_type`: Type of object for which the request is made. Can be either 'deployment' or 'pipeline'.   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format    ### Optional Parameters - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary.   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds. This field is not used for batch requests.   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'.    #### Request Examples  ``` {   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 300,   \"enabled\": true } ```  ### Response Structure  Details of the created request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 300,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ScheduleCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def request_schedules_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create request schedules  # noqa: E501

         ### Description  Create a new request schedule with the provided name  ### Required Parameters  - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `object_type`: Type of object for which the request is made. Can be either 'deployment' or 'pipeline'.   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format    ### Optional Parameters - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary.   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds. This field is not used for batch requests.   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'.    #### Request Examples  ``` {   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 300,   \"enabled\": true } ```  ### Response Structure  Details of the created request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 300,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ScheduleCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_schedules_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `request_schedules_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `request_schedules_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_schedules_delete(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Delete a request schedule  # noqa: E501

         ### Description  Delete the request schedule from the project.   If you want to temporarily disable a request schedule, update the request with `enabled` set to False.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_delete(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules_delete_with_http_info(project_name, schedule_name, **kwargs)  # noqa: E501

    def request_schedules_delete_with_http_info(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Delete a request schedule  # noqa: E501

         ### Description  Delete the request schedule from the project.   If you want to temporarily disable a request schedule, update the request with `enabled` set to False.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_delete_with_http_info(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'schedule_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_schedules_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `request_schedules_delete`")  # noqa: E501
        # verify the required parameter 'schedule_name' is set
        if self.api_client.client_side_validation and ('schedule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['schedule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `schedule_name` when calling `request_schedules_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'schedule_name' in local_var_params:
            path_params['schedule_name'] = local_var_params['schedule_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/schedules/{schedule_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_schedules_get(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Get details of a request schedule  # noqa: E501

         ### Description  Retrieve details of a single request schedule  ### Response Structure  Details of a request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 200,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_get(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules_get_with_http_info(project_name, schedule_name, **kwargs)  # noqa: E501

    def request_schedules_get_with_http_info(self, project_name, schedule_name, **kwargs):  # noqa: E501
        """Get details of a request schedule  # noqa: E501

         ### Description  Retrieve details of a single request schedule  ### Response Structure  Details of a request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 200,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_get_with_http_info(project_name, schedule_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'schedule_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_schedules_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `request_schedules_get`")  # noqa: E501
        # verify the required parameter 'schedule_name' is set
        if self.api_client.client_side_validation and ('schedule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['schedule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `schedule_name` when calling `request_schedules_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'schedule_name' in local_var_params:
            path_params['schedule_name'] = local_var_params['schedule_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/schedules/{schedule_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_schedules_list(self, project_name, **kwargs):  # noqa: E501
        """List request schedules  # noqa: E501

         ### Description  List the request schedules in a project. The user has to have 'requests.list' permission on either 'deployments.versions' or 'pipelines' to list the request schedules.  ### Response Structure  A list of details of all request schedules in a project - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` [     {       \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",       \"name\": \"test-request\",       \"object_type\": \"deployment\",       \"object_name\": \"test-deployment\",       \"version\": \"v1\",       \"schedule\": \"0 * 3 * *\",       \"request_data\": {         \"input_field_1\": 2345,         \"input_field_2\": 8765       },       \"batch\": false,       \"timeout\": 200\",       \"enabled\": true,       \"creation_date\": \"2020-09-16T08:06:34.457679Z\"     } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ScheduleList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def request_schedules_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List request schedules  # noqa: E501

         ### Description  List the request schedules in a project. The user has to have 'requests.list' permission on either 'deployments.versions' or 'pipelines' to list the request schedules.  ### Response Structure  A list of details of all request schedules in a project - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` [     {       \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",       \"name\": \"test-request\",       \"object_type\": \"deployment\",       \"object_name\": \"test-deployment\",       \"version\": \"v1\",       \"schedule\": \"0 * 3 * *\",       \"request_data\": {         \"input_field_1\": 2345,         \"input_field_2\": 8765       },       \"batch\": false,       \"timeout\": 200\",       \"enabled\": true,       \"creation_date\": \"2020-09-16T08:06:34.457679Z\"     } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ScheduleList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_schedules_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `request_schedules_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScheduleList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_schedules_update(self, project_name, schedule_name, data, **kwargs):  # noqa: E501
        """Update a request schedule  # noqa: E501

         ### Description  Update a request schedule in a project. Create permissions on the object are necessary for this action.  ### Optional Parameters - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `schedule`: Schedule in crontab format   - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary.   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'.    #### Request Examples  ``` {   \"name\": \"test-request\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": true,   \"timeout\": 360,   \"enabled\": false } ```  ### Response Structure  Details of the updated request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 360,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_update(project_name, schedule_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param ScheduleUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.request_schedules_update_with_http_info(project_name, schedule_name, data, **kwargs)  # noqa: E501

    def request_schedules_update_with_http_info(self, project_name, schedule_name, data, **kwargs):  # noqa: E501
        """Update a request schedule  # noqa: E501

         ### Description  Update a request schedule in a project. Create permissions on the object are necessary for this action.  ### Optional Parameters - `name`: Name of the request. The name is unique per project. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `schedule`: Schedule in crontab format   - `request_data`: Input data for the request schedule. For structured deployments/pipelines, it must be a dictionary.   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled. Default is 'True'.    #### Request Examples  ``` {   \"name\": \"test-request\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": true,   \"timeout\": 360,   \"enabled\": false } ```  ### Response Structure  Details of the updated request schedule - `name`: Name of the request   - `object_type`: Type of object for which the request is made   - `object_name`: Name of deployment or pipeline for which the request is made    - `schedule`: Schedule in crontab format   - `version`: Name of version if type of object is 'deployment'   - `request_data`: Input data for the request schedule   - `batch`: Boolean value indicating whether the requests will be performed as batch requests (true) or as direct requests (false)   - `timeout`: Timeout in seconds   - `enabled`: Boolean value indicating whether the request schedule is enabled or disabled   - `creation_date`: The date when the request schedule was created  #### Response Examples  ``` {   \"id\": \"b4a06aed-f7ab-48b3-b579-b12b62db8058\",   \"name\": \"test-request\",   \"object_type\": \"deployment\",   \"object_name\": \"test-deployment\",   \"version\": \"v1\",   \"schedule\": \"0 * 3 * *\",   \"request_data\": {     \"input_field_1\": 2345,     \"input_field_2\": 8765   },   \"batch\": false,   \"timeout\": 360,   \"enabled\": true,   \"creation_date\": \"2020-09-16T08:06:34.457679Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_schedules_update_with_http_info(project_name, schedule_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str schedule_name: (required)
        :param ScheduleUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'schedule_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_schedules_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `request_schedules_update`")  # noqa: E501
        # verify the required parameter 'schedule_name' is set
        if self.api_client.client_side_validation and ('schedule_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['schedule_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `schedule_name` when calling `request_schedules_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `request_schedules_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'schedule_name' in local_var_params:
            path_params['schedule_name'] = local_var_params['schedule_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/schedules/{schedule_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_create(self, project_name, data, **kwargs):  # noqa: E501
        """Assign a role to a user in a project  # noqa: E501

         ### Description  Assign a role to a user in the scope of a project. This role can be assigned on either project level or on object level, which can be a deployment or pipeline. The user making the request must have appropriate permissions.  ### Required Parameters  - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role to be assigned to the user    ### Optional Parameters - `object_name`: Name of the object for which the role will be assigned   - `object_type`: Type of the object for which the role will be assigned. It can be project, deployment or pipeline.  **object_name and object_type must be provided together. If neither of them is provided, the role is set on project level.**  #### Request Examples Setting the role deployment-admin on project level for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-admin\" } ```  Setting the role deployment-viewer on deployment-1 for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```  ### Response Structure  Details of the created role assignment - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-admin\",   \"object_name\": \"project-1\",   \"object_type\": \"project\" } ```  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleAssignmentCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.role_assignments_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def role_assignments_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Assign a role to a user in a project  # noqa: E501

         ### Description  Assign a role to a user in the scope of a project. This role can be assigned on either project level or on object level, which can be a deployment or pipeline. The user making the request must have appropriate permissions.  ### Required Parameters  - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role to be assigned to the user    ### Optional Parameters - `object_name`: Name of the object for which the role will be assigned   - `object_type`: Type of the object for which the role will be assigned. It can be project, deployment or pipeline.  **object_name and object_type must be provided together. If neither of them is provided, the role is set on project level.**  #### Request Examples Setting the role deployment-admin on project level for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-admin\" } ```  Setting the role deployment-viewer on deployment-1 for user with id 02b77d8f-b312-47ef-990f-4685a7ab9363 ``` {   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```  ### Response Structure  Details of the created role assignment - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-admin\",   \"object_name\": \"project-1\",   \"object_type\": \"project\" } ```  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleAssignmentCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleAssignmentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `role_assignments_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_delete(self, project_name, id, **kwargs):  # noqa: E501
        """Delete a role from a user with the given role assignment id  # noqa: E501

         ### Description  Delete a role of a user. The user making the request must have appropriate permissions. It is possible for a user to delete their own role if they have permissions to do so.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_delete(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.role_assignments_delete_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def role_assignments_delete_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Delete a role from a user with the given role assignment id  # noqa: E501

         ### Description  Delete a role of a user. The user making the request must have appropriate permissions. It is possible for a user to delete their own role if they have permissions to do so.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_delete_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `role_assignments_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_get(self, project_name, id, **kwargs):  # noqa: E501
        """Get details of a role assignment  # noqa: E501

         ### Description  Get the details of a role assignment of a user. The user making the request must have appropriate permissions.  ### Response Structure  Details of the role assignment - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_get(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.role_assignments_get_with_http_info(project_name, id, **kwargs)  # noqa: E501

    def role_assignments_get_with_http_info(self, project_name, id, **kwargs):  # noqa: E501
        """Get details of a role assignment  # noqa: E501

         ### Description  Get the details of a role assignment of a user. The user making the request must have appropriate permissions.  ### Response Structure  Details of the role assignment - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples  ``` {   \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",   \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",   \"role\": \"deployment-viewer\",   \"object_name\": \"deployment-1\",   \"object_type\": \"deployment\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_get_with_http_info(project_name, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleAssignmentList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `role_assignments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/role-assignments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignmentList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_per_user_list(self, project_name, user_id, **kwargs):  # noqa: E501
        """List the roles assigned to a specific user in a project  # noqa: E501

         ### Description  List the roles assigned to a user in the scope of a project.   ### Response Structure - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"role\": \"deployment-viewer\",     \"object_name\": \"deployment-1\",     \"object_type\": \"deployment\"   },   {     \"id\": \"13cf9dd7-7356-4797-b453-e0cb6b416162\",     \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"role\": \"pipeline-admin\",     \"object_name\": \"pipeline-1\",     \"object_type\": \"pipeline\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_per_user_list(project_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RoleAssignmentList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.role_assignments_per_user_list_with_http_info(project_name, user_id, **kwargs)  # noqa: E501

    def role_assignments_per_user_list_with_http_info(self, project_name, user_id, **kwargs):  # noqa: E501
        """List the roles assigned to a specific user in a project  # noqa: E501

         ### Description  List the roles assigned to a user in the scope of a project.   ### Response Structure - `id`: Unique identifier for the role assignment (UUID)   - `user_id`: Unique identifier for the user (UUID)   - `role`: Name of the role assigned to the user   - `object_name`: Name of the object for which the role is assigned   - `object_type`: Type of the object for which the role is assigned. It can be project, deployment or pipeline.  #### Response Examples ``` [   {     \"id\": \"e988ddc0-3ef1-42d2-ab30-9f810a5e7063\",     \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"role\": \"deployment-viewer\",     \"object_name\": \"deployment-1\",     \"object_type\": \"deployment\"   },   {     \"id\": \"13cf9dd7-7356-4797-b453-e0cb6b416162\",     \"user_id\": \"02b77d8f-b312-47ef-990f-4685a7ab9363\",     \"role\": \"pipeline-admin\",     \"object_name\": \"pipeline-1\",     \"object_type\": \"pipeline\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.role_assignments_per_user_list_with_http_info(project_name, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RoleAssignmentList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_per_user_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `role_assignments_per_user_list`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `role_assignments_per_user_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['user_id'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/users/{user_id}/role-assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RoleAssignmentList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create a custom role scoped in a project  # noqa: E501

         ### Description  Create a custom role in the scope of a project. This role is not accessible from other projects.  The user making the request must have appropriate permissions.  ### Required Parameters  - `name`: Name of the role which will be created. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A list of permissions which the role will contain. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"custom-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```  ### Response Structure  Details of the created role - `id`: Unique identifier for the created role (UUID)   - `name`: Name of the created role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def roles_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create a custom role scoped in a project  # noqa: E501

         ### Description  Create a custom role in the scope of a project. This role is not accessible from other projects.  The user making the request must have appropriate permissions.  ### Required Parameters  - `name`: Name of the role which will be created. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A list of permissions which the role will contain. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"custom-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```  ### Response Structure  Details of the created role - `id`: Unique identifier for the created role (UUID)   - `name`: Name of the created role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param RoleCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `roles_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_delete(self, project_name, role_name, **kwargs):  # noqa: E501
        """Delete a role from a project  # noqa: E501

         ### Description  Delete a role from a project. The user making the request must have appropriate permissions. **Default roles cannot be deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_delete(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_delete_with_http_info(project_name, role_name, **kwargs)  # noqa: E501

    def roles_delete_with_http_info(self, project_name, role_name, **kwargs):  # noqa: E501
        """Delete a role from a project  # noqa: E501

         ### Description  Delete a role from a project. The user making the request must have appropriate permissions. **Default roles cannot be deleted.**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_delete_with_http_info(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_delete`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_get(self, project_name, role_name, **kwargs):  # noqa: E501
        """Get details of a role  # noqa: E501

         ### Description  Get the details of a role. The user making the request must have appropriate permissions.  ### Response Structure Details of the role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_get(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_get_with_http_info(project_name, role_name, **kwargs)  # noqa: E501

    def roles_get_with_http_info(self, project_name, role_name, **kwargs):  # noqa: E501
        """Get details of a role  # noqa: E501

         ### Description  Get the details of a role. The user making the request must have appropriate permissions.  ### Response Structure Details of the role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"custom-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\",     \"deployments.delete\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_get_with_http_info(project_name, role_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_get`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_list(self, project_name, **kwargs):  # noqa: E501
        """List the available roles in a project  # noqa: E501

         ### Description  List the roles available in the scope of a project. Information on which permissions each role contains, can be obtained with a call to get details of a single role.  ### Response Structure - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not    #### Response Examples ``` [   {     \"id\": \"34e53855-9b50-47bc-b516-6cb971b1949c\",     \"name\": \"project-admin\",     \"default\": true   },   {     \"id\": \"00132911-b5dd-4017-b399-85f3ffd2a7c3\",     \"name\": \"project-editor\",     \"default\": true   },   {     \"id\": \"bf0d5823-8062-40f6-bbd2-21bc732f3c3b\",     \"name\": \"project-viewer\",     \"default\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RoleList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def roles_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List the available roles in a project  # noqa: E501

         ### Description  List the roles available in the scope of a project. Information on which permissions each role contains, can be obtained with a call to get details of a single role.  ### Response Structure - `id`: Unique identifier for the role (UUID)   - `name`: Name of the role   - `default`: A boolean value that indicates whether the role is a default role or not    #### Response Examples ``` [   {     \"id\": \"34e53855-9b50-47bc-b516-6cb971b1949c\",     \"name\": \"project-admin\",     \"default\": true   },   {     \"id\": \"00132911-b5dd-4017-b399-85f3ffd2a7c3\",     \"name\": \"project-editor\",     \"default\": true   },   {     \"id\": \"bf0d5823-8062-40f6-bbd2-21bc732f3c3b\",     \"name\": \"project-viewer\",     \"default\": true   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RoleList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RoleList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_update(self, project_name, role_name, data, **kwargs):  # noqa: E501
        """Update a role in a project  # noqa: E501

         ### Description  Update a role in a project. The user making the request must have appropriate permissions. **Default roles cannot be updated.**  ### Optional Parameters  - `name`: New name for the role. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A new list of permissions which the role will contain. The previous permissions will be replaced with the given ones. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"new-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```  ### Response Structure  Details of the updated role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the updated role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"new-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_update(project_name, role_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param RoleUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RoleDetailList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_update_with_http_info(project_name, role_name, data, **kwargs)  # noqa: E501

    def roles_update_with_http_info(self, project_name, role_name, data, **kwargs):  # noqa: E501
        """Update a role in a project  # noqa: E501

         ### Description  Update a role in a project. The user making the request must have appropriate permissions. **Default roles cannot be updated.**  ### Optional Parameters  - `name`: New name for the role. It can only consist of lowercase letters, numbers and dashes (-), and must start with a lowercase letter.   - `permissions`: A new list of permissions which the role will contain. The previous permissions will be replaced with the given ones. The list of available permissions can be obtained with */permissions* endpoint.    #### Request Examples ``` {   \"name\": \"new-deployment-editor-role\",   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```  ### Response Structure  Details of the updated role - `id`: Unique identifier for the role (UUID)   - `name`: Name of the updated role   - `default`: A boolean value that indicates whether the role is a default role or not   - `permissions`: A list of permissions which the role contains  #### Response Examples ``` {   \"id\": \"18a4a60d-d5f0-4099-9c6e-543bf2fd5a1d\",   \"name\": \"new-deployment-editor-role\",   \"default\": false,   \"permissions\": [     \"deployments.list\",     \"deployments.get\"   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_update_with_http_info(project_name, role_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str role_name: (required)
        :param RoleUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RoleDetailList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'role_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `roles_update`")  # noqa: E501
        # verify the required parameter 'role_name' is set
        if self.api_client.client_side_validation and ('role_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_name` when calling `roles_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `roles_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'role_name' in local_var_params:
            path_params['role_name'] = local_var_params['role_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/roles/{role_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDetailList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_status(self, **kwargs):  # noqa: E501
        """Service status  # noqa: E501

         ### Description Request the API status. It can be used to determine whether the API is online. You do not have to be authenticated to access this method.  ### Response Structure - `status`: API status, either ok or fail. The database connection is tested at each status request, to make sure that the API is online.  #### Response Examples ```  {   \"status\": \"ok\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_status_with_http_info(**kwargs)  # noqa: E501

    def service_status_with_http_info(self, **kwargs):  # noqa: E501
        """Service status  # noqa: E501

         ### Description Request the API status. It can be used to determine whether the API is online. You do not have to be authenticated to access this method.  ### Response Structure - `status`: API status, either ok or fail. The database connection is tested at each status request, to make sure that the API is online.  #### Response Examples ```  {   \"status\": \"ok\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Status, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Status',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_create(self, project_name, data, **kwargs):  # noqa: E501
        """Create a new service user  # noqa: E501

         ### Description  Create a new service user. A unique email is generated for the service user. Additionally, a token for this service user is generated. This token can be used to authorize requests sent to our API.   The token is **ONLY** returned on creation and will not be accessible afterwards.  ### Optional Parameters - `name`: Name of the service user    #### Request Examples  ``` {   \"name\": \"service-user-1\" } ```  ### Response Structure  Details of the created service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `token`: The API token for the created service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\",   \"name\": \"service-user-1\",   \"creation_date\": \"2020-03-24T09:16:27.504+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_create(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ServiceUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_create_with_http_info(project_name, data, **kwargs)  # noqa: E501

    def service_users_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create a new service user  # noqa: E501

         ### Description  Create a new service user. A unique email is generated for the service user. Additionally, a token for this service user is generated. This token can be used to authorize requests sent to our API.   The token is **ONLY** returned on creation and will not be accessible afterwards.  ### Optional Parameters - `name`: Name of the service user    #### Request Examples  ``` {   \"name\": \"service-user-1\" } ```  ### Response Structure  Details of the created service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `token`: The API token for the created service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\",   \"name\": \"service-user-1\",   \"creation_date\": \"2020-03-24T09:16:27.504+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param ServiceUserCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ServiceUserDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `service_users_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceUserDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_delete(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Delete service user  # noqa: E501

         ### Description  Delete a service user from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_delete(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_delete_with_http_info(project_name, service_user_id, **kwargs)  # noqa: E501

    def service_users_delete_with_http_info(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Delete service user  # noqa: E501

         ### Description  Delete a service user from a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_delete_with_http_info(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'service_user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_delete`")  # noqa: E501
        # verify the required parameter 'service_user_id' is set
        if self.api_client.client_side_validation and ('service_user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['service_user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `service_user_id` when calling `service_users_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'service_user_id' in local_var_params:
            path_params['service_user_id'] = local_var_params['service_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users/{service_user_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_get(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Retrieve details of a service user  # noqa: E501

         ### Description  Retrieve details of a service user  ### Response Structure  Details of the service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_get(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_get_with_http_info(project_name, service_user_id, **kwargs)  # noqa: E501

    def service_users_get_with_http_info(self, project_name, service_user_id, **kwargs):  # noqa: E501
        """Retrieve details of a service user  # noqa: E501

         ### Description  Retrieve details of a service user  ### Response Structure  Details of the service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_get_with_http_info(project_name, service_user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ServiceUserList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'service_user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_get`")  # noqa: E501
        # verify the required parameter 'service_user_id' is set
        if self.api_client.client_side_validation and ('service_user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['service_user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `service_user_id` when calling `service_users_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'service_user_id' in local_var_params:
            path_params['service_user_id'] = local_var_params['service_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users/{service_user_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceUserList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_list(self, project_name, **kwargs):  # noqa: E501
        """List service users  # noqa: E501

         ### Description  List service users defined in a project  ### Response Structure  List of details of the service users: - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user   - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` [   {     \"id\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed\",     \"email\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-1\",     \"creation_date\": \"2020-03-24T09:16:27.504+00:00\"   },   {     \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",     \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-2\",     \"creation_date\": \"2020-03-26T12:18:43.123+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_list(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ServiceUserList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_list_with_http_info(project_name, **kwargs)  # noqa: E501

    def service_users_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List service users  # noqa: E501

         ### Description  List service users defined in a project  ### Response Structure  List of details of the service users: - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user   - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` [   {     \"id\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed\",     \"email\": \"537bca64-5ab6-43eb-a7ef-1638bc30b6ed.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-1\",     \"creation_date\": \"2020-03-24T09:16:27.504+00:00\"   },   {     \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",     \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",     \"name\": \"service-user-2\",     \"creation_date\": \"2020-03-26T12:18:43.123+00:00\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ServiceUserList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ServiceUserList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_token(self, project_name, service_user_id, data, **kwargs):  # noqa: E501
        """Reset the token of a service user  # noqa: E501

         ### Description  Reset the token of a service user. The old token will be deleted and a new one will be created for the service user. No data should be sent in the body of the request.  ### Response Structure  Details of the new token for the service user - `token`: The new API token for the service user  #### Response Examples ``` {   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_token(project_name, service_user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param object data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserTokenList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_token_with_http_info(project_name, service_user_id, data, **kwargs)  # noqa: E501

    def service_users_token_with_http_info(self, project_name, service_user_id, data, **kwargs):  # noqa: E501
        """Reset the token of a service user  # noqa: E501

         ### Description  Reset the token of a service user. The old token will be deleted and a new one will be created for the service user. No data should be sent in the body of the request.  ### Response Structure  Details of the new token for the service user - `token`: The new API token for the service user  #### Response Examples ``` {   \"token\": \"e962d9190348af7fa8d233d75cff7385b4335f81\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_token_with_http_info(project_name, service_user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param object data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ServiceUserTokenList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'service_user_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_token`")  # noqa: E501
        # verify the required parameter 'service_user_id' is set
        if self.api_client.client_side_validation and ('service_user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['service_user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `service_user_id` when calling `service_users_token`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `service_users_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'service_user_id' in local_var_params:
            path_params['service_user_id'] = local_var_params['service_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users/{service_user_id}/token', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceUserTokenList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def service_users_update(self, project_name, service_user_id, data, **kwargs):  # noqa: E501
        """Update service user details  # noqa: E501

          ### Description Update the name of a service user  ### Optional Parameters - `name`: Name of the service user    #### Request Examples   ``` {   \"name\": \"new-service-user-name\", } ```  ### Response Structure  Details of the updated service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_update(project_name, service_user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param ServiceUserCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ServiceUserList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.service_users_update_with_http_info(project_name, service_user_id, data, **kwargs)  # noqa: E501

    def service_users_update_with_http_info(self, project_name, service_user_id, data, **kwargs):  # noqa: E501
        """Update service user details  # noqa: E501

          ### Description Update the name of a service user  ### Optional Parameters - `name`: Name of the service user    #### Request Examples   ``` {   \"name\": \"new-service-user-name\", } ```  ### Response Structure  Details of the updated service user - `id`: Unique identifier for the service user (UUID)   - `email`: Email of the service user    - `name`: Name of the service user   - `creation_date`: Date when the service user was created  #### Response Examples  ``` {   \"id\": \"13a9ba27-6888-4528-826e-8e1002eab13d\",   \"email\": \"13a9ba27-6888-4528-826e-8e1002eab13d.project1@serviceuser.ubiops.com\",   \"name\": \"new-service-user-name\",   \"creation_date\": \"2020-03-26T12:18:43.123+00:00\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.service_users_update_with_http_info(project_name, service_user_id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str service_user_id: (required)
        :param ServiceUserCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ServiceUserList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'service_user_id', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_users_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `service_users_update`")  # noqa: E501
        # verify the required parameter 'service_user_id' is set
        if self.api_client.client_side_validation and ('service_user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['service_user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `service_user_id` when calling `service_users_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `service_users_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'service_user_id' in local_var_params:
            path_params['service_user_id'] = local_var_params['service_user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/service-users/{service_user_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceUserList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_create(self, data, **kwargs):  # noqa: E501
        """Create a new user  # noqa: E501

         ### Description  Create a new user with the given details - email, password, name and surname. After creation, an email is send to the email address to activate the acount. The user is required to accept the terms and conditions. The password needs to be at least 8 characters long.  ### Required Parameters - `email`: Email of the user. This is a unique field.   - `password`: Password of the user   - `terms_conditions`: Boolean field. Pass True to accept terms and conditions.    ### Optional Parameters - `name`: Name of the user   - `surname`: Surname of the user   - `newsletter`: Boolean field. Pass True to subscribe to the newsletters.    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"name\": \"User name\",   \"surname\": \"User surname\",   \"terms_conditions\": true,   \"newsletter\": false } ```  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"terms_conditions\": true,   \"newsletter\": false  } ```  ### Response Structure  Details of the created user  - `email`: Email of the user    - `name`: Name of the user    - `surname`: Surname of the user   #### Response Examples  ``` {   \"email\": \"test@example.com\",   \"name\": \"User name\",   \"surname\": \"User surname\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UserPendingCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UserPendingDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.user_create_with_http_info(data, **kwargs)  # noqa: E501

    def user_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create a new user  # noqa: E501

         ### Description  Create a new user with the given details - email, password, name and surname. After creation, an email is send to the email address to activate the acount. The user is required to accept the terms and conditions. The password needs to be at least 8 characters long.  ### Required Parameters - `email`: Email of the user. This is a unique field.   - `password`: Password of the user   - `terms_conditions`: Boolean field. Pass True to accept terms and conditions.    ### Optional Parameters - `name`: Name of the user   - `surname`: Surname of the user   - `newsletter`: Boolean field. Pass True to subscribe to the newsletters.    #### Request Examples  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"name\": \"User name\",   \"surname\": \"User surname\",   \"terms_conditions\": true,   \"newsletter\": false } ```  ``` {   \"email\": \"test@example.com\",   \"password\": \"secret-password\",   \"terms_conditions\": true,   \"newsletter\": false  } ```  ### Response Structure  Details of the created user  - `email`: Email of the user    - `name`: Name of the user    - `surname`: Surname of the user   #### Response Examples  ``` {   \"email\": \"test@example.com\",   \"name\": \"User name\",   \"surname\": \"User surname\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UserPendingCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UserPendingDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `user_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserPendingDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_delete(self, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

         ### Description  Delete the user that makes the request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.user_delete_with_http_info(**kwargs)  # noqa: E501

    def user_delete_with_http_info(self, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

         ### Description  Delete the user that makes the request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/user', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_copy(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the version. Variables of the version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the object from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_copy(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def version_environment_variables_copy_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Copy version environment variable  # noqa: E501

         ### Description Copy existing environment variables from a source object to the version. Variables of the version with the same name as ones from the source object will be overwritten with the new value. Only the copied variables are returned.  ### Required Parameters - `source_deployment`: The name of the deployment from which the variables will be copied  ### Optional Parameters - `source_version`: The version of the object from which the variables will be copied  #### Request Examples Copy the environment variables from a deployment ``` {   \"source_deployment\": \"example-deployment\" } ```  Copy the environment variables from a version ``` {   \"source_deployment\": \"example-deployment\",   \"source_version\": \"v1\" } ```  ### Response Structure  A list of the copied variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from. Will be null for copied environment variables. - `inheritance_name`: Name of the parent object that this variable is inherited from. Will be null for copied environment variables.  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": null,     \"inheritance_name\": null   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_copy_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCopy data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_copy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_copy`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `version_environment_variables_copy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/copy-environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_create(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create version environment variable  # noqa: E501

         ### Description Create an environment variable for the version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_create(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def version_environment_variables_create_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Create version environment variable  # noqa: E501

         ### Description Create an environment variable for the version. Variables inherited from the project or deployment can be shadowed by creating a variable with the same name.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users.  #### Request Examples ``` {   \"name\": \"version_variable\",   \"value\": \"another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"version_variable\",   \"value\": \"another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_create_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `version_environment_variables_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_delete(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete version environment variable  # noqa: E501

         ### Description Delete an environment variable of a version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_delete(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def version_environment_variables_delete_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Delete version environment variable  # noqa: E501

         ### Description Delete an environment variable of a version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_delete_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `version_environment_variables_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_get(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get version environment variable  # noqa: E501

         ### Description Retrieve details of a version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_get(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, **kwargs)  # noqa: E501

    def version_environment_variables_get_with_http_info(self, project_name, deployment_name, id, version, **kwargs):  # noqa: E501
        """Get version environment variable  # noqa: E501

         ### Description Retrieve details of a version environment variable. This cannot be used to retrieve details of inherited variables.  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_get_with_http_info(project_name, deployment_name, id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `version_environment_variables_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_list(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List version environment variables  # noqa: E501

         ### Description List the environment variables defined for the version. Includes environment variables defined at project level and deployment level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_list(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InheritedEnvironmentVariableList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_list_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def version_environment_variables_list_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """List version environment variables  # noqa: E501

         ### Description List the environment variables defined for the version. Includes environment variables defined at project level and deployment level.   ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or null if the variable was defined for the version directly - `inheritance_name`: Name of the parent object that this variable is inherited from - will be null if the variable was defined for the version directly  #### Response Examples  ``` [   {     \"id\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\",     \"name\": \"version_specific_variable\",     \"value\": \"some_value\",     \"secret\": false,     \"inheritance_type\": null,     \"inheritance_name\": null   },   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_list_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def version_environment_variables_update(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update version environment variable  # noqa: E501

         ### Description Update an environment variable for the version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_update(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentVariableList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, **kwargs)  # noqa: E501

    def version_environment_variables_update_with_http_info(self, project_name, deployment_name, id, version, data, **kwargs):  # noqa: E501
        """Update version environment variable  # noqa: E501

         ### Description Update an environment variable for the version. This cannot be used to update inherited variables; to change an inherited variable for a specific version you can create a variable with the same name for the version.  ### Required Parameters - `name`: The name of the variable. The variable will have this name when accessed from your deployment code. The variable name should contain only letters and underscores, and not start or end with an underscore. - `value`: The value of the variable as a string. It may be an empty string (\"\"). - `secret`: If this variable contains sensitive information, set this to true to hide it from other users. Can be updated from false to true, but not from true to false (i.e. secrets will stay secrets).  #### Request Examples ``` {   \"name\": \"version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information  #### Response Examples  ``` {   \"id\": \"54e94fbe-507e-4fae-981d-227c28a2dab0\",   \"name\": \"version_variable\",   \"value\": \"yet another one\",   \"secret\": false } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.version_environment_variables_update_with_http_info(project_name, deployment_name, id, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str id: (required)
        :param str version: (required)
        :param EnvironmentVariableCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentVariableList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'id', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method version_environment_variables_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `version_environment_variables_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `version_environment_variables_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/environment-variables/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentVariableList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_create(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create versions  # noqa: E501

         ### Description  Create a version for a deployment  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.5, python3.6, python3.7 or python3.8. The default value is python3.7 - `memory_allocation`: Reserved memory for the version in MB. This value determines the memory allocated to the version: it should to be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 32768 respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5, the maximum value is 20. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 and the maximum value is 3600. A high value means that the version stays active longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.6\" } ```   ``` {   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"memory_allocation\": 512 } ```   ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB   - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version. It is set to *initialised* state on creation. - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"description\": \"\",   \"status\": \"initialised\",   \"error_message\": \"\",   \"memory_allocation\": 512,   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"file_last_updated\": \"2020-05-12T16:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_create(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param VersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_create_with_http_info(project_name, deployment_name, data, **kwargs)  # noqa: E501

    def versions_create_with_http_info(self, project_name, deployment_name, data, **kwargs):  # noqa: E501
        """Create versions  # noqa: E501

         ### Description  Create a version for a deployment  ### Required Parameters  - `version`: Name of the version of the deployment  ### Optional Parameters  - `language`: Language in which the version is provided. It can be python3.5, python3.6, python3.7 or python3.8. The default value is python3.7 - `memory_allocation`: Reserved memory for the version in MB. This value determines the memory allocated to the version: it should to be enough to encompass the deployment file and all requirements that need to be installed. The default value is 2048. The minimum and maximum values are 256 and 32768 respectively. - `maximum_instances`: Upper bound of number of versions running. The default value is 5, the maximum value is 20. *Indicator of resource capacity:* if many deployment requests need to be handled in a short time, this number can be set higher to avoid long waiting times. - `minimum_instances`: Lower bound of number of versions running. The default value is 0. Set this value greater than 0 to always have a always running version. - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped. The default value is 300, the minimum value is 10 and the maximum value is 3600. A high value means that the version stays active longer. Sending requests to a running version means that it will be already initialized and thus take a shorter timer.   - `description`: Description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  If the time that a request takes does not matter, keep the default values.  #### Request Examples  ``` {   \"version\": \"version-1\",   \"language\": \"python3.6\" } ```   ``` {   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"memory_allocation\": 512 } ```   ``` {   \"version\": \"version-1\",   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the created version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB   - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version. It is set to *initialised* state on creation. - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"description\": \"\",   \"status\": \"initialised\",   \"error_message\": \"\",   \"memory_allocation\": 512,   \"maximum_instances\": 5,   \"minimum_instances\": 0,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\",   \"file_last_updated\": \"2020-05-12T16:23:15.456812Z\", } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_create_with_http_info(project_name, deployment_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param VersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_create`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `versions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_delete(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete version  # noqa: E501

          ### Description  Delete a deployment version. If the version is referenced from a pipeline, it cannot be deleted, it must be removed from the pipeline first.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_delete(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_delete_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def versions_delete_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Delete version  # noqa: E501

          ### Description  Delete a deployment version. If the version is referenced from a pipeline, it cannot be deleted, it must be removed from the pipeline first.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_delete_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_delete`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_file_download(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Download deployment files  # noqa: E501

         ### Description  Download the deployment file of a version of a deployment  ### Response Structure   - `file`: Deployment file of the version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_file_download(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_file_download_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def versions_file_download_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Download deployment files  # noqa: E501

         ### Description  Download the deployment file of a version of a deployment  ### Response Structure   - `file`: Deployment file of the version   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_file_download_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if True, the file will be downloaded in a
                                 folder, which can be defined by
                                 api_client.configuration.temp_folder_path.
                                 Default is False.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_file_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_file_download`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_file_download`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `versions_file_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', False),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_file_upload(self, project_name, deployment_name, version, file, **kwargs):  # noqa: E501
        """Upload deployment files  # noqa: E501

         ### Description  Upload a file for a deployment version. This file should contain the deployment that will be run. It should be provided as a zip and a template can be found on https://github.com/UbiOps/deployment-template. The file is saved under a directory in the storage specified in the settings.  ### Required Parameters - `file`: Deployment file  ### Response Structure - `success`: Boolean indicating whether the deployment file upload succeeded or not    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_file_upload(project_name, deployment_name, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param file file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_file_upload_with_http_info(project_name, deployment_name, version, file, **kwargs)  # noqa: E501

    def versions_file_upload_with_http_info(self, project_name, deployment_name, version, file, **kwargs):  # noqa: E501
        """Upload deployment files  # noqa: E501

         ### Description  Upload a file for a deployment version. This file should contain the deployment that will be run. It should be provided as a zip and a template can be found on https://github.com/UbiOps/deployment-template. The file is saved under a directory in the storage specified in the settings.  ### Required Parameters - `file`: Deployment file  ### Response Structure - `success`: Boolean indicating whether the deployment file upload succeeded or not    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_file_upload_with_http_info(project_name, deployment_name, version, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param file file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_file_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_file_upload`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_file_upload`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `versions_file_upload`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `versions_file_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}/upload', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_get(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB  - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"memory_allocation\": 512,   \"language\": \"python3.7\",   \"description\": \"\",   \"status\": \"active\",   \"error_message\": \"\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_get(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_get_with_http_info(project_name, deployment_name, version, **kwargs)  # noqa: E501

    def versions_get_with_http_info(self, project_name, deployment_name, version, **kwargs):  # noqa: E501
        """Get version  # noqa: E501

         ### Description  Retrieve details of a version of a deployment in a project  ### Response Structure  Details of a version - `id`: Unique identifier for the version (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB  - `maximum_instances`: Upper bound of number of deployment pods running in parallel - `minimum_instances`: Lower bound of number of deployment pods running in parallel - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"memory_allocation\": 512,   \"language\": \"python3.7\",   \"description\": \"\",   \"status\": \"active\",   \"error_message\": \"\",   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_get_with_http_info(project_name, deployment_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_get`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_list(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory usage for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"language\": \"python3.5\",     \"description\": \"\",     \"status\": \"active\",     \"error_message\": \"\",     \"memory_allocation\": 512,     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"file_last_updated\": \"2020-06-19T10:52:23.124784Z\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"language\": \"python3.6\",     \"description\": \"\",     \"status\": \"active\",     \"error_message\": \"\",     \"memory_allocation\": 256,     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_list(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[VersionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_list_with_http_info(project_name, deployment_name, **kwargs)  # noqa: E501

    def versions_list_with_http_info(self, project_name, deployment_name, **kwargs):  # noqa: E501
        """List versions  # noqa: E501

         ### Description  Versions can be filtered according to the labels they have by giving labels as a query parameter. Versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory usage for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples ``` [   {     \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",     \"deployment\": \"deployment-1\",     \"version\": \"version-1\",     \"language\": \"python3.5\",     \"description\": \"\",     \"status\": \"active\",     \"error_message\": \"\",     \"memory_allocation\": 512,     \"maximum_instances\": 4,     \"minimum_instances\": 1,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-06-18T08:32:14.876451Z\",     \"last_updated\": \"2020-06-19T10:52:23.124784Z\",     \"file_last_updated\": \"2020-06-19T10:52:23.124784Z\"   },   {     \"id\": \"24f6b80a-08c3-4d52-ac1a-2ea7e70f16a6\",     \"deployment\": \"deployment-1\",     \"version\": \"version-2\",     \"language\": \"python3.6\",     \"description\": \"\",     \"status\": \"active\",     \"error_message\": \"\",     \"memory_allocation\": 256,     \"maximum_instances\": 5,     \"minimum_instances\": 0,     \"maximum_idle_time\": 10,     \"labels\": {       \"type\": \"version\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_list_with_http_info(project_name, deployment_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[VersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_list`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def versions_update(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update version  # noqa: E501

         ### Description  Update a version of a deployment in a project. Updating the language field will cause the deployment to be build again. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `version`: New name for the version - `language`: New language for the version - `memory_allocation`: New reserved memory for the version in MB - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples  ``` {   \"version\": \"new-version\" } ```   ``` {   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"description\": \"\",   \"status\": \"active\",   \"error_message\": \"\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_update(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param VersionCreate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.versions_update_with_http_info(project_name, deployment_name, version, data, **kwargs)  # noqa: E501

    def versions_update_with_http_info(self, project_name, deployment_name, version, data, **kwargs):  # noqa: E501
        """Update version  # noqa: E501

         ### Description  Update a version of a deployment in a project. Updating the language field will cause the deployment to be build again. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `version`: New name for the version - `language`: New language for the version - `memory_allocation`: New reserved memory for the version in MB - `maximum_instances`: New upper bound of number of versions running - `minimum_instances`: New lower bound of number of versions running - `maximum_idle_time`: New maximum time in seconds a version stays idle before it is stopped - `description`: New description for the version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels.  #### Request Examples  ``` {   \"version\": \"new-version\" } ```   ``` {   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1 } ```  ### Response Structure  Details of the updated version - `id`: Unique identifier for the deployment (UUID) - `deployment`: Deployment name to which the version is associated - `version`: Version name - `language`: Language in which the version is provided - `memory_allocation`: Reserved memory for the version in MB - `maximum_instances`: Upper bound of number of versions running - `minimum_instances`: Lower bound of number of versions running - `maximum_idle_time`: Maximum time in seconds a version stays idle before it is stopped - `description`: Description of the version - `status`: The state of the version - `error_message`: The error message which explains why the version has failed building or deployment. It is empty if the version is available. - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the version was created - `last_updated`: The date when the version was last updated - `file_last_updated`: The date when a deployment file was last uploaded  #### Response Examples  ``` {   \"id\": \"4ae7d14b-4803-4e16-b96d-3b18caa4b605\",   \"deployment\": \"deployment-1\",   \"version\": \"version-1\",   \"language\": \"python3.5\",   \"description\": \"\",   \"status\": \"active\",   \"error_message\": \"\",   \"memory_allocation\": 512,   \"maximum_instances\": 4,   \"minimum_instances\": 1,   \"maximum_idle_time\": 10,   \"labels\": {     \"type\": \"version\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-23T18:04:76.123754Z\",   \"file_last_updated\": \"2020-06-23T11:17:28.128652Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.versions_update_with_http_info(project_name, deployment_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str deployment_name: (required)
        :param str version: (required)
        :param VersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'deployment_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `versions_update`")  # noqa: E501
        # verify the required parameter 'deployment_name' is set
        if self.api_client.client_side_validation and ('deployment_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['deployment_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deployment_name` when calling `versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `versions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'deployment_name' in local_var_params:
            path_params['deployment_name'] = local_var_params['deployment_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/deployments/{deployment_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
