import { ParsedIniData, SharedConfigFiles, SharedConfigInit } from "@aws-sdk/shared-ini-file-loader";
export declare const ENV_PROFILE = "AWS_PROFILE";
export declare const DEFAULT_PROFILE = "default";
export interface SourceProfileInit extends SharedConfigInit {
    /**
     * The configuration profile to use.
     */
    profile?: string;
    /**
     * A promise that will be resolved with loaded and parsed credentials files.
     * Used to avoid loading shared config files multiple times.
     *
     * @internal
     */
    loadedConfig?: Promise<SharedConfigFiles>;
}
/**
 * Load profiles from credentials and config INI files and normalize them into a
 * single profile list.
 *
 * @internal
 */
export declare const parseKnownFiles: (init: SourceProfileInit) => Promise<ParsedIniData>;
/**
 * @internal
 */
export declare const getMasterProfileName: (init: {
    profile?: string;
}) => string;
