"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMasterProfileName = exports.parseKnownFiles = exports.DEFAULT_PROFILE = exports.ENV_PROFILE = void 0;
const shared_ini_file_loader_1 = require("@aws-sdk/shared-ini-file-loader");
exports.ENV_PROFILE = "AWS_PROFILE";
exports.DEFAULT_PROFILE = "default";
const parseKnownFiles = async (init) => {
    const { loadedConfig = shared_ini_file_loader_1.loadSharedConfigFiles(init) } = init;
    const parsedFiles = await loadedConfig;
    return {
        ...parsedFiles.configFile,
        ...parsedFiles.credentialsFile,
    };
};
exports.parseKnownFiles = parseKnownFiles;
const getMasterProfileName = (init) => init.profile || process.env[exports.ENV_PROFILE] || exports.DEFAULT_PROFILE;
exports.getMasterProfileName = getMasterProfileName;
