"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializerMiddleware = void 0;
const deserializerMiddleware = (options, deserializer) => (next, context) => async (args) => {
    const { response } = await next(args);
    const parsed = await deserializer(response, options);
    return {
        response,
        output: parsed,
    };
};
exports.deserializerMiddleware = deserializerMiddleware;
