"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.credentials = exports.endpoint = exports.region = exports.MockSha256 = void 0;
class MockSha256 {
    constructor(secret) { }
    update(data) { }
    digest() {
        return Promise.resolve(new Uint8Array(5));
    }
}
exports.MockSha256 = MockSha256;
const region = () => Promise.resolve("mock-region");
exports.region = region;
const endpoint = () => Promise.resolve({
    protocol: "https:",
    path: "/",
    hostname: "ec2.mock-region.amazonaws.com",
});
exports.endpoint = endpoint;
const credentials = () => Promise.resolve({
    accessKeyId: "akid",
    secretAccessKey: "secret",
    sessionToken: "session",
});
exports.credentials = credentials;
