"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultRetryDecider = void 0;
const service_error_classification_1 = require("@aws-sdk/service-error-classification");
const defaultRetryDecider = (error) => {
    if (!error) {
        return false;
    }
    return service_error_classification_1.isRetryableByTrait(error) || service_error_classification_1.isClockSkewError(error) || service_error_classification_1.isThrottlingError(error) || service_error_classification_1.isTransientError(error);
};
exports.defaultRetryDecider = defaultRetryDecider;
