import { SSOClient } from "@aws-sdk/client-sso";
import { Profile } from "@aws-sdk/shared-ini-file-loader";
import { CredentialProvider } from "@aws-sdk/types";
import { SourceProfileInit } from "@aws-sdk/util-credentials";
/**
 * The time window (15 mins) that SDK will treat the SSO token expires in before the defined expiration date in token.
 * This is needed because server side may have invalidated the token before the defined expiration date.
 *
 * @internal
 */
export declare const EXPIRE_WINDOW_MS: number;
export interface SsoCredentialsParameters {
    /**
     * The URL to the AWS SSO service.
     */
    ssoStartUrl: string;
    /**
     * The ID of the AWS account to use for temporary credentials.
     */
    ssoAccountId: string;
    /**
     * The AWS region to use for temporary credentials.
     */
    ssoRegion: string;
    /**
     * The name of the AWS role to assume.
     */
    ssoRoleName: string;
}
export interface FromSSOInit extends SourceProfileInit {
    ssoClient?: SSOClient;
}
/**
 * Creates a credential provider that will read from a credential_process specified
 * in ini files.
 */
export declare const fromSSO: (init?: FromSSOInit & Partial<SsoCredentialsParameters>) => CredentialProvider;
/**
 * @internal
 */
export interface SsoProfile extends Profile {
    sso_start_url: string;
    sso_account_id: string;
    sso_region: string;
    sso_role_name: string;
}
/**
 * @internal
 */
export declare const validateSsoProfile: (profile: Partial<SsoProfile>) => SsoProfile;
/**
 * @internal
 */
export declare const isSsoProfile: (arg: Profile) => arg is Partial<SsoProfile>;
