import { __awaiter, __generator } from "tslib";
import { GetRoleCredentialsCommand, SSOClient } from "@aws-sdk/client-sso";
import { CredentialsProviderError } from "@aws-sdk/property-provider";
import { getHomeDir } from "@aws-sdk/shared-ini-file-loader";
import { getMasterProfileName, parseKnownFiles } from "@aws-sdk/util-credentials";
import { createHash } from "crypto";
import { readFileSync } from "fs";
import { join } from "path";
export var EXPIRE_WINDOW_MS = 15 * 60 * 1000;
var SHOULD_FAIL_CREDENTIAL_CHAIN = false;
export var fromSSO = function (init) {
    if (init === void 0) { init = {}; }
    return function () { return __awaiter(void 0, void 0, void 0, function () {
        var ssoStartUrl, ssoAccountId, ssoRegion, ssoRoleName, ssoClient, profiles, profileName, profile, _a, sso_start_url, sso_account_id, sso_region, sso_role_name;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    ssoStartUrl = init.ssoStartUrl, ssoAccountId = init.ssoAccountId, ssoRegion = init.ssoRegion, ssoRoleName = init.ssoRoleName, ssoClient = init.ssoClient;
                    if (!(!ssoStartUrl && !ssoAccountId && !ssoRegion && !ssoRoleName)) return [3, 2];
                    return [4, parseKnownFiles(init)];
                case 1:
                    profiles = _b.sent();
                    profileName = getMasterProfileName(init);
                    profile = profiles[profileName];
                    if (!isSsoProfile(profile)) {
                        throw new CredentialsProviderError("Profile " + profileName + " is not configured with SSO credentials.");
                    }
                    _a = validateSsoProfile(profile), sso_start_url = _a.sso_start_url, sso_account_id = _a.sso_account_id, sso_region = _a.sso_region, sso_role_name = _a.sso_role_name;
                    return [2, resolveSSOCredentials({
                            ssoStartUrl: sso_start_url,
                            ssoAccountId: sso_account_id,
                            ssoRegion: sso_region,
                            ssoRoleName: sso_role_name,
                            ssoClient: ssoClient,
                        })];
                case 2:
                    if (!ssoStartUrl || !ssoAccountId || !ssoRegion || !ssoRoleName) {
                        throw new CredentialsProviderError('Incomplete configuration. The fromSSO() argument hash must include "ssoStartUrl",' +
                            ' "ssoAccountId", "ssoRegion", "ssoRoleName"');
                    }
                    else {
                        return [2, resolveSSOCredentials({ ssoStartUrl: ssoStartUrl, ssoAccountId: ssoAccountId, ssoRegion: ssoRegion, ssoRoleName: ssoRoleName, ssoClient: ssoClient })];
                    }
                    _b.label = 3;
                case 3: return [2];
            }
        });
    }); };
};
var resolveSSOCredentials = function (_a) {
    var ssoStartUrl = _a.ssoStartUrl, ssoAccountId = _a.ssoAccountId, ssoRegion = _a.ssoRegion, ssoRoleName = _a.ssoRoleName, ssoClient = _a.ssoClient;
    return __awaiter(void 0, void 0, void 0, function () {
        var hasher, cacheName, tokenFile, token, accessToken, sso, ssoResp, e_1, _b, _c, accessKeyId, secretAccessKey, sessionToken, expiration;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    hasher = createHash("sha1");
                    cacheName = hasher.update(ssoStartUrl).digest("hex");
                    tokenFile = join(getHomeDir(), ".aws", "sso", "cache", cacheName + ".json");
                    try {
                        token = JSON.parse(readFileSync(tokenFile, { encoding: "utf-8" }));
                        if (new Date(token.expiresAt).getTime() - Date.now() <= EXPIRE_WINDOW_MS) {
                            throw new Error("SSO token is expired.");
                        }
                    }
                    catch (e) {
                        throw new CredentialsProviderError("The SSO session associated with this profile has expired or is otherwise invalid. To refresh this SSO session " +
                            "run aws sso login with the corresponding profile.", SHOULD_FAIL_CREDENTIAL_CHAIN);
                    }
                    accessToken = token.accessToken;
                    sso = ssoClient || new SSOClient({ region: ssoRegion });
                    _d.label = 1;
                case 1:
                    _d.trys.push([1, 3, , 4]);
                    return [4, sso.send(new GetRoleCredentialsCommand({
                            accountId: ssoAccountId,
                            roleName: ssoRoleName,
                            accessToken: accessToken,
                        }))];
                case 2:
                    ssoResp = _d.sent();
                    return [3, 4];
                case 3:
                    e_1 = _d.sent();
                    throw CredentialsProviderError.from(e_1, SHOULD_FAIL_CREDENTIAL_CHAIN);
                case 4:
                    _b = ssoResp.roleCredentials, _c = _b === void 0 ? {} : _b, accessKeyId = _c.accessKeyId, secretAccessKey = _c.secretAccessKey, sessionToken = _c.sessionToken, expiration = _c.expiration;
                    if (!accessKeyId || !secretAccessKey || !sessionToken || !expiration) {
                        throw new CredentialsProviderError("SSO returns an invalid temporary credential.", SHOULD_FAIL_CREDENTIAL_CHAIN);
                    }
                    return [2, { accessKeyId: accessKeyId, secretAccessKey: secretAccessKey, sessionToken: sessionToken, expiration: new Date(expiration) }];
            }
        });
    });
};
export var validateSsoProfile = function (profile) {
    var sso_start_url = profile.sso_start_url, sso_account_id = profile.sso_account_id, sso_region = profile.sso_region, sso_role_name = profile.sso_role_name;
    if (!sso_start_url || !sso_account_id || !sso_region || !sso_role_name) {
        throw new CredentialsProviderError("Profile is configured with invalid SSO credentials. Required parameters \"sso_account_id\", \"sso_region\", " +
            ("\"sso_role_name\", \"sso_start_url\". Got " + Object.keys(profile).join(", ") + "\nReference: https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sso.html"), SHOULD_FAIL_CREDENTIAL_CHAIN);
    }
    return profile;
};
export var isSsoProfile = function (arg) {
    return arg &&
        (typeof arg.sso_start_url === "string" ||
            typeof arg.sso_account_id === "string" ||
            typeof arg.sso_region === "string" ||
            typeof arg.sso_role_name === "string");
};
