"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultProvider = exports.ENV_IMDS_DISABLED = void 0;
const credential_provider_env_1 = require("@aws-sdk/credential-provider-env");
const credential_provider_imds_1 = require("@aws-sdk/credential-provider-imds");
const credential_provider_ini_1 = require("@aws-sdk/credential-provider-ini");
const credential_provider_process_1 = require("@aws-sdk/credential-provider-process");
const credential_provider_sso_1 = require("@aws-sdk/credential-provider-sso");
const credential_provider_web_identity_1 = require("@aws-sdk/credential-provider-web-identity");
const property_provider_1 = require("@aws-sdk/property-provider");
const shared_ini_file_loader_1 = require("@aws-sdk/shared-ini-file-loader");
const util_credentials_1 = require("@aws-sdk/util-credentials");
exports.ENV_IMDS_DISABLED = "AWS_EC2_METADATA_DISABLED";
const defaultProvider = (init = {}) => {
    const options = { profile: process.env[util_credentials_1.ENV_PROFILE], ...init };
    if (!options.loadedConfig)
        options.loadedConfig = shared_ini_file_loader_1.loadSharedConfigFiles(init);
    const providers = [
        credential_provider_sso_1.fromSSO(options),
        credential_provider_ini_1.fromIni(options),
        credential_provider_process_1.fromProcess(options),
        credential_provider_web_identity_1.fromTokenFile(options),
        remoteProvider(options),
        async () => {
            throw new property_provider_1.CredentialsProviderError("Could not load credentials from any providers", false);
        },
    ];
    if (!options.profile)
        providers.unshift(credential_provider_env_1.fromEnv());
    const providerChain = property_provider_1.chain(...providers);
    return property_provider_1.memoize(providerChain, (credentials) => credentials.expiration !== undefined && credentials.expiration.getTime() - Date.now() < 300000, (credentials) => credentials.expiration !== undefined);
};
exports.defaultProvider = defaultProvider;
const remoteProvider = (init) => {
    if (process.env[credential_provider_imds_1.ENV_CMDS_RELATIVE_URI] || process.env[credential_provider_imds_1.ENV_CMDS_FULL_URI]) {
        return credential_provider_imds_1.fromContainerMetadata(init);
    }
    if (process.env[exports.ENV_IMDS_DISABLED]) {
        return () => Promise.reject(new property_provider_1.CredentialsProviderError("EC2 Instance Metadata Service access disabled"));
    }
    return credential_provider_imds_1.fromInstanceMetadata(init);
};
