import { AssumeRoleWithWebIdentityParams } from "@aws-sdk/credential-provider-web-identity";
import { CredentialProvider, Credentials } from "@aws-sdk/types";
import { SourceProfileInit } from "@aws-sdk/util-credentials";

export interface AssumeRoleParams {
    
    RoleArn: string;
    
    RoleSessionName: string;
    
    ExternalId?: string;
    
    SerialNumber?: string;
    
    TokenCode?: string;
}
export interface FromIniInit extends SourceProfileInit {
    
    mfaCodeProvider?: (mfaSerial: string) => Promise<string>;
    
    roleAssumer?: (sourceCreds: Credentials, params: AssumeRoleParams) => Promise<Credentials>;
    
    roleAssumerWithWebIdentity?: (params: AssumeRoleWithWebIdentityParams) => Promise<Credentials>;
}

export declare const fromIni: (init?: FromIniInit) => CredentialProvider;
