import { __assign, __awaiter, __generator } from "tslib";
import { fromEnv } from "@aws-sdk/credential-provider-env";
import { fromContainerMetadata, fromInstanceMetadata } from "@aws-sdk/credential-provider-imds";
import { fromSSO, isSsoProfile, validateSsoProfile } from "@aws-sdk/credential-provider-sso";
import { fromTokenFile } from "@aws-sdk/credential-provider-web-identity";
import { CredentialsProviderError } from "@aws-sdk/property-provider";
import { getMasterProfileName, parseKnownFiles } from "@aws-sdk/util-credentials";
var isStaticCredsProfile = function (arg) {
    return Boolean(arg) &&
        typeof arg === "object" &&
        typeof arg.aws_access_key_id === "string" &&
        typeof arg.aws_secret_access_key === "string" &&
        ["undefined", "string"].indexOf(typeof arg.aws_session_token) > -1;
};
var isWebIdentityProfile = function (arg) {
    return Boolean(arg) &&
        typeof arg === "object" &&
        typeof arg.web_identity_token_file === "string" &&
        typeof arg.role_arn === "string" &&
        ["undefined", "string"].indexOf(typeof arg.role_session_name) > -1;
};
var isAssumeRoleProfile = function (arg) {
    return Boolean(arg) &&
        typeof arg === "object" &&
        typeof arg.role_arn === "string" &&
        ["undefined", "string"].indexOf(typeof arg.role_session_name) > -1 &&
        ["undefined", "string"].indexOf(typeof arg.external_id) > -1 &&
        ["undefined", "string"].indexOf(typeof arg.mfa_serial) > -1;
};
var isAssumeRoleWithSourceProfile = function (arg) {
    return isAssumeRoleProfile(arg) && typeof arg.source_profile === "string" && typeof arg.credential_source === "undefined";
};
var isAssumeRoleWithProviderProfile = function (arg) {
    return isAssumeRoleProfile(arg) && typeof arg.credential_source === "string" && typeof arg.source_profile === "undefined";
};
export var fromIni = function (init) {
    if (init === void 0) { init = {}; }
    return function () { return __awaiter(void 0, void 0, void 0, function () {
        var profiles;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, parseKnownFiles(init)];
                case 1:
                    profiles = _a.sent();
                    return [2, resolveProfileData(getMasterProfileName(init), profiles, init)];
            }
        });
    }); };
};
var resolveProfileData = function (profileName, profiles, options, visitedProfiles) {
    if (visitedProfiles === void 0) { visitedProfiles = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var data, ExternalId, mfa_serial, RoleArn, _a, RoleSessionName, source_profile, credential_source, sourceCreds, params, _b, _c, _d, _e, sso_start_url, sso_account_id, sso_region, sso_role_name;
        var _f;
        return __generator(this, function (_g) {
            switch (_g.label) {
                case 0:
                    data = profiles[profileName];
                    if (Object.keys(visitedProfiles).length > 0 && isStaticCredsProfile(data)) {
                        return [2, resolveStaticCredentials(data)];
                    }
                    if (!(isAssumeRoleWithSourceProfile(data) || isAssumeRoleWithProviderProfile(data))) return [3, 4];
                    ExternalId = data.external_id, mfa_serial = data.mfa_serial, RoleArn = data.role_arn, _a = data.role_session_name, RoleSessionName = _a === void 0 ? "aws-sdk-js-" + Date.now() : _a, source_profile = data.source_profile, credential_source = data.credential_source;
                    if (!options.roleAssumer) {
                        throw new CredentialsProviderError("Profile " + profileName + " requires a role to be assumed, but no" + " role assumption callback was provided.", false);
                    }
                    if (source_profile && source_profile in visitedProfiles) {
                        throw new CredentialsProviderError("Detected a cycle attempting to resolve credentials for profile" +
                            (" " + getMasterProfileName(options) + ". Profiles visited: ") +
                            Object.keys(visitedProfiles).join(", "), false);
                    }
                    sourceCreds = source_profile
                        ? resolveProfileData(source_profile, profiles, options, __assign(__assign({}, visitedProfiles), (_f = {}, _f[source_profile] = true, _f)))
                        : resolveCredentialSource(credential_source, profileName)();
                    params = { RoleArn: RoleArn, RoleSessionName: RoleSessionName, ExternalId: ExternalId };
                    if (!mfa_serial) return [3, 2];
                    if (!options.mfaCodeProvider) {
                        throw new CredentialsProviderError("Profile " + profileName + " requires multi-factor authentication," + " but no MFA code callback was provided.", false);
                    }
                    params.SerialNumber = mfa_serial;
                    _b = params;
                    return [4, options.mfaCodeProvider(mfa_serial)];
                case 1:
                    _b.TokenCode = _g.sent();
                    _g.label = 2;
                case 2:
                    _d = (_c = options).roleAssumer;
                    return [4, sourceCreds];
                case 3: return [2, _d.apply(_c, [_g.sent(), params])];
                case 4:
                    if (isStaticCredsProfile(data)) {
                        return [2, resolveStaticCredentials(data)];
                    }
                    if (isWebIdentityProfile(data)) {
                        return [2, resolveWebIdentityCredentials(data, options)];
                    }
                    if (isSsoProfile(data)) {
                        _e = validateSsoProfile(data), sso_start_url = _e.sso_start_url, sso_account_id = _e.sso_account_id, sso_region = _e.sso_region, sso_role_name = _e.sso_role_name;
                        return [2, fromSSO({
                                ssoStartUrl: sso_start_url,
                                ssoAccountId: sso_account_id,
                                ssoRegion: sso_region,
                                ssoRoleName: sso_role_name,
                            })()];
                    }
                    throw new CredentialsProviderError("Profile " + profileName + " could not be found or parsed in shared" + " credentials file.");
            }
        });
    });
};
var resolveCredentialSource = function (credentialSource, profileName) {
    var sourceProvidersMap = {
        EcsContainer: fromContainerMetadata,
        Ec2InstanceMetadata: fromInstanceMetadata,
        Environment: fromEnv,
    };
    if (credentialSource in sourceProvidersMap) {
        return sourceProvidersMap[credentialSource]();
    }
    else {
        throw new CredentialsProviderError("Unsupported credential source in profile " + profileName + ". Got " + credentialSource + ", " +
            "expected EcsContainer or Ec2InstanceMetadata or Environment.");
    }
};
var resolveStaticCredentials = function (profile) {
    return Promise.resolve({
        accessKeyId: profile.aws_access_key_id,
        secretAccessKey: profile.aws_secret_access_key,
        sessionToken: profile.aws_session_token,
    });
};
var resolveWebIdentityCredentials = function (profile, options) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, fromTokenFile({
                webIdentityTokenFile: profile.web_identity_token_file,
                roleArn: profile.role_arn,
                roleSessionName: profile.role_session_name,
                roleAssumerWithWebIdentity: options.roleAssumerWithWebIdentity,
            })()];
    });
}); };
