"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeEndpoint = void 0;
const normalizeEndpoint = ({ endpoint, urlParser }) => {
    if (typeof endpoint === "string") {
        const promisified = Promise.resolve(urlParser(endpoint));
        return () => promisified;
    }
    else if (typeof endpoint === "object") {
        const promisified = Promise.resolve(endpoint);
        return () => promisified;
    }
    return endpoint;
};
exports.normalizeEndpoint = normalizeEndpoint;
