"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEndpointsConfig = void 0;
const getEndpointFromRegion_1 = require("./utils/getEndpointFromRegion");
const normalizeBoolean_1 = require("./utils/normalizeBoolean");
const normalizeEndpoint_1 = require("./utils/normalizeEndpoint");
const resolveEndpointsConfig = (input) => {
    var _a;
    const useDualstackEndpoint = normalizeBoolean_1.normalizeBoolean(input.useDualstackEndpoint);
    const { endpoint, useFipsEndpoint } = input;
    return {
        ...input,
        tls: (_a = input.tls) !== null && _a !== void 0 ? _a : true,
        endpoint: endpoint
            ? normalizeEndpoint_1.normalizeEndpoint({ ...input, endpoint })
            : () => getEndpointFromRegion_1.getEndpointFromRegion({ ...input, useDualstackEndpoint, useFipsEndpoint }),
        isCustomEndpoint: endpoint ? true : false,
        useDualstackEndpoint,
    };
};
exports.resolveEndpointsConfig = resolveEndpointsConfig;
