import { _InstanceType, AccessScopeAnalysisFinding, AddIpamOperatingRegion, AddPrefixListEntry, AddressAttribute, AddressAttributeName, Affinity, ApplianceModeSupportValue, AttributeValue, AutoPlacement, ByoipCidr, ClientConnectOptions, ClientVpnAuthorizationRuleStatus, ConnectionLogOptions, CurrencyCodeValues, DnsSupportValue, EndDateType, FleetExcessCapacityTerminationPolicy, HostnameType, HostRecovery, IamInstanceProfileAssociation, IamInstanceProfileSpecification, InstanceEventWindow, IpPermission, Ipv6SupportValue, PortRange, RouteTableAssociationState, SelfServicePortal, SubnetAssociation, Tag, TagSpecification, TargetConfigurationRequest, TransitGatewayAssociationState, TransitGatewayAttachmentResourceType, TransitGatewayMulticastDomainAssociations, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, UnsuccessfulItem } from "./models_0";
import { AutoAcceptSharedAttachmentsValue, BlockDeviceMapping, CapacityReservationPreference, CapacityReservationTarget, DefaultRouteTableAssociationValue, DefaultRouteTablePropagationValue, DiskImageFormat, FleetLaunchTemplateConfigRequest, IcmpTypeCode, InstanceEventWindowTimeRangeRequest, InstanceInterruptionBehavior, InstanceRequirementsRequest, Ipam, IpamPool, IpamScope, LaunchTemplate, ManagedPrefixList, MarketType, NetworkInsightsAccessScopeContent, Placement, PlatformValues, RequestIpamResourceTag, ResponseLaunchTemplateData, RuleAction, ShutdownBehavior, SnapshotState, SpotInstanceType, SubnetCidrReservation, TargetCapacitySpecificationRequest, TargetCapacityUnitType, TrafficDirection, TrafficMirrorFilter, TrafficMirrorFilterRule, TrafficMirrorNetworkService, TrafficMirrorPortRangeRequest, TrafficMirrorRuleAction, TrafficMirrorSession, TransitGateway, VolumeType, VpnEcmpSupportValue } from "./models_1";
import { Filter, IKEVersionsRequestListValue, InstanceTagNotificationAttribute, IpamPoolCidr, Phase1DHGroupNumbersRequestListValue, Phase1EncryptionAlgorithmsRequestListValue, Phase1IntegrityAlgorithmsRequestListValue, Phase2DHGroupNumbersRequestListValue, Phase2EncryptionAlgorithmsRequestListValue, Phase2IntegrityAlgorithmsRequestListValue, TransitGatewayPrefixListReference, TransitGatewayRoute, VpnConnection } from "./models_2";
import { AnalysisStatus, ArchitectureType, ArchitectureValues, AttributeBooleanValue, BootModeValues, ConversionTask, FpgaImageAttribute, FpgaImageAttributeName, HttpTokensState, ImportImageLicenseConfigurationResponse, InstanceAttributeName, InstanceMetadataEndpointState, InstanceMetadataOptionsResponse, InstanceMetadataProtocolState, InstanceStatusEvent, LaunchPermission, Monitoring, PermissionGroup, PublicIpv4PoolRange, ReservedInstancesConfiguration, SnapshotDetail, SnapshotTaskDetail, VirtualizationType } from "./models_3";
import { CreateVolumePermission, ExcessCapacityTerminationPolicy, InstanceFamilyCreditSpecification, InstanceNetworkInterfaceSpecification, IpamResourceCidr, LaunchTemplateConfig, Purchase, RunInstancesMonitoringEnabled, ScheduledInstance, SnapshotAttributeName, SpotFleetRequestConfigData, SpotInstanceRequest, SpotPlacement, TransitGatewayPropagationState, UnlimitedSupportedInstanceFamily, VolumeModification } from "./models_4";
export interface GetLaunchTemplateDataResult {
    
    LaunchTemplateData?: ResponseLaunchTemplateData;
}
export declare namespace GetLaunchTemplateDataResult {
    
    const filterSensitiveLog: (obj: GetLaunchTemplateDataResult) => any;
}
export interface GetManagedPrefixListAssociationsRequest {
    
    DryRun?: boolean;
    
    PrefixListId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetManagedPrefixListAssociationsRequest {
    
    const filterSensitiveLog: (obj: GetManagedPrefixListAssociationsRequest) => any;
}

export interface PrefixListAssociation {
    
    ResourceId?: string;
    
    ResourceOwner?: string;
}
export declare namespace PrefixListAssociation {
    
    const filterSensitiveLog: (obj: PrefixListAssociation) => any;
}
export interface GetManagedPrefixListAssociationsResult {
    
    PrefixListAssociations?: PrefixListAssociation[];
    
    NextToken?: string;
}
export declare namespace GetManagedPrefixListAssociationsResult {
    
    const filterSensitiveLog: (obj: GetManagedPrefixListAssociationsResult) => any;
}
export interface GetManagedPrefixListEntriesRequest {
    
    DryRun?: boolean;
    
    PrefixListId: string | undefined;
    
    TargetVersion?: number;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetManagedPrefixListEntriesRequest {
    
    const filterSensitiveLog: (obj: GetManagedPrefixListEntriesRequest) => any;
}

export interface PrefixListEntry {
    
    Cidr?: string;
    
    Description?: string;
}
export declare namespace PrefixListEntry {
    
    const filterSensitiveLog: (obj: PrefixListEntry) => any;
}
export interface GetManagedPrefixListEntriesResult {
    
    Entries?: PrefixListEntry[];
    
    NextToken?: string;
}
export declare namespace GetManagedPrefixListEntriesResult {
    
    const filterSensitiveLog: (obj: GetManagedPrefixListEntriesResult) => any;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
    
    NetworkInsightsAccessScopeAnalysisId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
    
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeAnalysisFindingsRequest) => any;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
    
    NetworkInsightsAccessScopeAnalysisId?: string;
    
    AnalysisStatus?: AnalysisStatus | string;
    
    AnalysisFindings?: AccessScopeAnalysisFinding[];
    
    NextToken?: string;
}
export declare namespace GetNetworkInsightsAccessScopeAnalysisFindingsResult {
    
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeAnalysisFindingsResult) => any;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
    
    NetworkInsightsAccessScopeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace GetNetworkInsightsAccessScopeContentRequest {
    
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeContentRequest) => any;
}
export interface GetNetworkInsightsAccessScopeContentResult {
    
    NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export declare namespace GetNetworkInsightsAccessScopeContentResult {
    
    const filterSensitiveLog: (obj: GetNetworkInsightsAccessScopeContentResult) => any;
}
export interface GetPasswordDataRequest {
    
    InstanceId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace GetPasswordDataRequest {
    
    const filterSensitiveLog: (obj: GetPasswordDataRequest) => any;
}
export interface GetPasswordDataResult {
    
    InstanceId?: string;
    
    PasswordData?: string;
    
    Timestamp?: Date;
}
export declare namespace GetPasswordDataResult {
    
    const filterSensitiveLog: (obj: GetPasswordDataResult) => any;
}

export interface GetReservedInstancesExchangeQuoteRequest {
    
    DryRun?: boolean;
    
    ReservedInstanceIds: string[] | undefined;
    
    TargetConfigurations?: TargetConfigurationRequest[];
}
export declare namespace GetReservedInstancesExchangeQuoteRequest {
    
    const filterSensitiveLog: (obj: GetReservedInstancesExchangeQuoteRequest) => any;
}

export interface ReservationValue {
    
    HourlyPrice?: string;
    
    RemainingTotalValue?: string;
    
    RemainingUpfrontValue?: string;
}
export declare namespace ReservationValue {
    
    const filterSensitiveLog: (obj: ReservationValue) => any;
}

export interface ReservedInstanceReservationValue {
    
    ReservationValue?: ReservationValue;
    
    ReservedInstanceId?: string;
}
export declare namespace ReservedInstanceReservationValue {
    
    const filterSensitiveLog: (obj: ReservedInstanceReservationValue) => any;
}

export interface TargetConfiguration {
    
    InstanceCount?: number;
    
    OfferingId?: string;
}
export declare namespace TargetConfiguration {
    
    const filterSensitiveLog: (obj: TargetConfiguration) => any;
}

export interface TargetReservationValue {
    
    ReservationValue?: ReservationValue;
    
    TargetConfiguration?: TargetConfiguration;
}
export declare namespace TargetReservationValue {
    
    const filterSensitiveLog: (obj: TargetReservationValue) => any;
}

export interface GetReservedInstancesExchangeQuoteResult {
    
    CurrencyCode?: string;
    
    IsValidExchange?: boolean;
    
    OutputReservedInstancesWillExpireAt?: Date;
    
    PaymentDue?: string;
    
    ReservedInstanceValueRollup?: ReservationValue;
    
    ReservedInstanceValueSet?: ReservedInstanceReservationValue[];
    
    TargetConfigurationValueRollup?: ReservationValue;
    
    TargetConfigurationValueSet?: TargetReservationValue[];
    
    ValidationFailureReason?: string;
}
export declare namespace GetReservedInstancesExchangeQuoteResult {
    
    const filterSensitiveLog: (obj: GetReservedInstancesExchangeQuoteResult) => any;
}
export interface GetSerialConsoleAccessStatusRequest {
    
    DryRun?: boolean;
}
export declare namespace GetSerialConsoleAccessStatusRequest {
    
    const filterSensitiveLog: (obj: GetSerialConsoleAccessStatusRequest) => any;
}
export interface GetSerialConsoleAccessStatusResult {
    
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace GetSerialConsoleAccessStatusResult {
    
    const filterSensitiveLog: (obj: GetSerialConsoleAccessStatusResult) => any;
}

export interface InstanceRequirementsWithMetadataRequest {
    
    ArchitectureTypes?: (ArchitectureType | string)[];
    
    VirtualizationTypes?: (VirtualizationType | string)[];
    
    InstanceRequirements?: InstanceRequirementsRequest;
}
export declare namespace InstanceRequirementsWithMetadataRequest {
    
    const filterSensitiveLog: (obj: InstanceRequirementsWithMetadataRequest) => any;
}
export interface GetSpotPlacementScoresRequest {
    
    InstanceTypes?: string[];
    
    TargetCapacity: number | undefined;
    
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
    
    SingleAvailabilityZone?: boolean;
    
    RegionNames?: string[];
    
    InstanceRequirementsWithMetadata?: InstanceRequirementsWithMetadataRequest;
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetSpotPlacementScoresRequest {
    
    const filterSensitiveLog: (obj: GetSpotPlacementScoresRequest) => any;
}

export interface SpotPlacementScore {
    
    Region?: string;
    
    AvailabilityZoneId?: string;
    
    Score?: number;
}
export declare namespace SpotPlacementScore {
    
    const filterSensitiveLog: (obj: SpotPlacementScore) => any;
}
export interface GetSpotPlacementScoresResult {
    
    SpotPlacementScores?: SpotPlacementScore[];
    
    NextToken?: string;
}
export declare namespace GetSpotPlacementScoresResult {
    
    const filterSensitiveLog: (obj: GetSpotPlacementScoresResult) => any;
}
export interface GetSubnetCidrReservationsRequest {
    
    Filters?: Filter[];
    
    SubnetId: string | undefined;
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace GetSubnetCidrReservationsRequest {
    
    const filterSensitiveLog: (obj: GetSubnetCidrReservationsRequest) => any;
}
export interface GetSubnetCidrReservationsResult {
    
    SubnetIpv4CidrReservations?: SubnetCidrReservation[];
    
    SubnetIpv6CidrReservations?: SubnetCidrReservation[];
    
    NextToken?: string;
}
export declare namespace GetSubnetCidrReservationsResult {
    
    const filterSensitiveLog: (obj: GetSubnetCidrReservationsResult) => any;
}
export interface GetTransitGatewayAttachmentPropagationsRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayAttachmentPropagationsRequest {
    
    const filterSensitiveLog: (obj: GetTransitGatewayAttachmentPropagationsRequest) => any;
}

export interface TransitGatewayAttachmentPropagation {
    
    TransitGatewayRouteTableId?: string;
    
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayAttachmentPropagation {
    
    const filterSensitiveLog: (obj: TransitGatewayAttachmentPropagation) => any;
}
export interface GetTransitGatewayAttachmentPropagationsResult {
    
    TransitGatewayAttachmentPropagations?: TransitGatewayAttachmentPropagation[];
    
    NextToken?: string;
}
export declare namespace GetTransitGatewayAttachmentPropagationsResult {
    
    const filterSensitiveLog: (obj: GetTransitGatewayAttachmentPropagationsResult) => any;
}
export interface GetTransitGatewayMulticastDomainAssociationsRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayMulticastDomainAssociationsRequest {
    
    const filterSensitiveLog: (obj: GetTransitGatewayMulticastDomainAssociationsRequest) => any;
}

export interface TransitGatewayMulticastDomainAssociation {
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    ResourceOwnerId?: string;
    
    Subnet?: SubnetAssociation;
}
export declare namespace TransitGatewayMulticastDomainAssociation {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomainAssociation) => any;
}
export interface GetTransitGatewayMulticastDomainAssociationsResult {
    
    MulticastDomainAssociations?: TransitGatewayMulticastDomainAssociation[];
    
    NextToken?: string;
}
export declare namespace GetTransitGatewayMulticastDomainAssociationsResult {
    
    const filterSensitiveLog: (obj: GetTransitGatewayMulticastDomainAssociationsResult) => any;
}
export interface GetTransitGatewayPrefixListReferencesRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayPrefixListReferencesRequest {
    
    const filterSensitiveLog: (obj: GetTransitGatewayPrefixListReferencesRequest) => any;
}
export interface GetTransitGatewayPrefixListReferencesResult {
    
    TransitGatewayPrefixListReferences?: TransitGatewayPrefixListReference[];
    
    NextToken?: string;
}
export declare namespace GetTransitGatewayPrefixListReferencesResult {
    
    const filterSensitiveLog: (obj: GetTransitGatewayPrefixListReferencesResult) => any;
}
export interface GetTransitGatewayRouteTableAssociationsRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayRouteTableAssociationsRequest {
    
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTableAssociationsRequest) => any;
}

export interface TransitGatewayRouteTableAssociation {
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    State?: TransitGatewayAssociationState | string;
}
export declare namespace TransitGatewayRouteTableAssociation {
    
    const filterSensitiveLog: (obj: TransitGatewayRouteTableAssociation) => any;
}
export interface GetTransitGatewayRouteTableAssociationsResult {
    
    Associations?: TransitGatewayRouteTableAssociation[];
    
    NextToken?: string;
}
export declare namespace GetTransitGatewayRouteTableAssociationsResult {
    
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTableAssociationsResult) => any;
}
export interface GetTransitGatewayRouteTablePropagationsRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetTransitGatewayRouteTablePropagationsRequest {
    
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTablePropagationsRequest) => any;
}

export interface TransitGatewayRouteTablePropagation {
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayRouteTablePropagation {
    
    const filterSensitiveLog: (obj: TransitGatewayRouteTablePropagation) => any;
}
export interface GetTransitGatewayRouteTablePropagationsResult {
    
    TransitGatewayRouteTablePropagations?: TransitGatewayRouteTablePropagation[];
    
    NextToken?: string;
}
export declare namespace GetTransitGatewayRouteTablePropagationsResult {
    
    const filterSensitiveLog: (obj: GetTransitGatewayRouteTablePropagationsResult) => any;
}
export interface GetVpnConnectionDeviceSampleConfigurationRequest {
    
    VpnConnectionId: string | undefined;
    
    VpnConnectionDeviceTypeId: string | undefined;
    
    InternetKeyExchangeVersion?: string;
    
    DryRun?: boolean;
}
export declare namespace GetVpnConnectionDeviceSampleConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceSampleConfigurationRequest) => any;
}
export interface GetVpnConnectionDeviceSampleConfigurationResult {
    
    VpnConnectionDeviceSampleConfiguration?: string;
}
export declare namespace GetVpnConnectionDeviceSampleConfigurationResult {
    
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceSampleConfigurationResult) => any;
}
export interface GetVpnConnectionDeviceTypesRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetVpnConnectionDeviceTypesRequest {
    
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceTypesRequest) => any;
}

export interface VpnConnectionDeviceType {
    
    VpnConnectionDeviceTypeId?: string;
    
    Vendor?: string;
    
    Platform?: string;
    
    Software?: string;
}
export declare namespace VpnConnectionDeviceType {
    
    const filterSensitiveLog: (obj: VpnConnectionDeviceType) => any;
}
export interface GetVpnConnectionDeviceTypesResult {
    
    VpnConnectionDeviceTypes?: VpnConnectionDeviceType[];
    
    NextToken?: string;
}
export declare namespace GetVpnConnectionDeviceTypesResult {
    
    const filterSensitiveLog: (obj: GetVpnConnectionDeviceTypesResult) => any;
}
export interface ImportClientVpnClientCertificateRevocationListRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    CertificateRevocationList: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ImportClientVpnClientCertificateRevocationListRequest {
    
    const filterSensitiveLog: (obj: ImportClientVpnClientCertificateRevocationListRequest) => any;
}
export interface ImportClientVpnClientCertificateRevocationListResult {
    
    Return?: boolean;
}
export declare namespace ImportClientVpnClientCertificateRevocationListResult {
    
    const filterSensitiveLog: (obj: ImportClientVpnClientCertificateRevocationListResult) => any;
}

export interface ClientData {
    
    Comment?: string;
    
    UploadEnd?: Date;
    
    UploadSize?: number;
    
    UploadStart?: Date;
}
export declare namespace ClientData {
    
    const filterSensitiveLog: (obj: ClientData) => any;
}

export interface UserBucket {
    
    S3Bucket?: string;
    
    S3Key?: string;
}
export declare namespace UserBucket {
    
    const filterSensitiveLog: (obj: UserBucket) => any;
}

export interface ImageDiskContainer {
    
    Description?: string;
    
    DeviceName?: string;
    
    Format?: string;
    
    SnapshotId?: string;
    
    Url?: string;
    
    UserBucket?: UserBucket;
}
export declare namespace ImageDiskContainer {
    
    const filterSensitiveLog: (obj: ImageDiskContainer) => any;
}

export interface ImportImageLicenseConfigurationRequest {
    
    LicenseConfigurationArn?: string;
}
export declare namespace ImportImageLicenseConfigurationRequest {
    
    const filterSensitiveLog: (obj: ImportImageLicenseConfigurationRequest) => any;
}
export interface ImportImageRequest {
    
    Architecture?: string;
    
    ClientData?: ClientData;
    
    ClientToken?: string;
    
    Description?: string;
    
    DiskContainers?: ImageDiskContainer[];
    
    DryRun?: boolean;
    
    Encrypted?: boolean;
    
    Hypervisor?: string;
    
    KmsKeyId?: string;
    
    LicenseType?: string;
    
    Platform?: string;
    
    RoleName?: string;
    
    LicenseSpecifications?: ImportImageLicenseConfigurationRequest[];
    
    TagSpecifications?: TagSpecification[];
    
    UsageOperation?: string;
    
    BootMode?: BootModeValues | string;
}
export declare namespace ImportImageRequest {
    
    const filterSensitiveLog: (obj: ImportImageRequest) => any;
}
export interface ImportImageResult {
    
    Architecture?: string;
    
    Description?: string;
    
    Encrypted?: boolean;
    
    Hypervisor?: string;
    
    ImageId?: string;
    
    ImportTaskId?: string;
    
    KmsKeyId?: string;
    
    LicenseType?: string;
    
    Platform?: string;
    
    Progress?: string;
    
    SnapshotDetails?: SnapshotDetail[];
    
    Status?: string;
    
    StatusMessage?: string;
    
    LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
    
    Tags?: Tag[];
    
    UsageOperation?: string;
}
export declare namespace ImportImageResult {
    
    const filterSensitiveLog: (obj: ImportImageResult) => any;
}

export interface DiskImageDetail {
    
    Bytes: number | undefined;
    
    Format: DiskImageFormat | string | undefined;
    
    ImportManifestUrl: string | undefined;
}
export declare namespace DiskImageDetail {
    
    const filterSensitiveLog: (obj: DiskImageDetail) => any;
}

export interface VolumeDetail {
    
    Size: number | undefined;
}
export declare namespace VolumeDetail {
    
    const filterSensitiveLog: (obj: VolumeDetail) => any;
}

export interface DiskImage {
    
    Description?: string;
    
    Image?: DiskImageDetail;
    
    Volume?: VolumeDetail;
}
export declare namespace DiskImage {
    
    const filterSensitiveLog: (obj: DiskImage) => any;
}

export interface UserData {
    
    Data?: string;
}
export declare namespace UserData {
    
    const filterSensitiveLog: (obj: UserData) => any;
}

export interface ImportInstanceLaunchSpecification {
    
    AdditionalInfo?: string;
    
    Architecture?: ArchitectureValues | string;
    
    GroupIds?: string[];
    
    GroupNames?: string[];
    
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
    
    InstanceType?: _InstanceType | string;
    
    Monitoring?: boolean;
    
    Placement?: Placement;
    
    PrivateIpAddress?: string;
    
    SubnetId?: string;
    
    UserData?: UserData;
}
export declare namespace ImportInstanceLaunchSpecification {
    
    const filterSensitiveLog: (obj: ImportInstanceLaunchSpecification) => any;
}
export interface ImportInstanceRequest {
    
    Description?: string;
    
    DiskImages?: DiskImage[];
    
    DryRun?: boolean;
    
    LaunchSpecification?: ImportInstanceLaunchSpecification;
    
    Platform: PlatformValues | string | undefined;
}
export declare namespace ImportInstanceRequest {
    
    const filterSensitiveLog: (obj: ImportInstanceRequest) => any;
}
export interface ImportInstanceResult {
    
    ConversionTask?: ConversionTask;
}
export declare namespace ImportInstanceResult {
    
    const filterSensitiveLog: (obj: ImportInstanceResult) => any;
}
export interface ImportKeyPairRequest {
    
    DryRun?: boolean;
    
    KeyName: string | undefined;
    
    PublicKeyMaterial: Uint8Array | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace ImportKeyPairRequest {
    
    const filterSensitiveLog: (obj: ImportKeyPairRequest) => any;
}
export interface ImportKeyPairResult {
    
    KeyFingerprint?: string;
    
    KeyName?: string;
    
    KeyPairId?: string;
    
    Tags?: Tag[];
}
export declare namespace ImportKeyPairResult {
    
    const filterSensitiveLog: (obj: ImportKeyPairResult) => any;
}

export interface SnapshotDiskContainer {
    
    Description?: string;
    
    Format?: string;
    
    Url?: string;
    
    UserBucket?: UserBucket;
}
export declare namespace SnapshotDiskContainer {
    
    const filterSensitiveLog: (obj: SnapshotDiskContainer) => any;
}
export interface ImportSnapshotRequest {
    
    ClientData?: ClientData;
    
    ClientToken?: string;
    
    Description?: string;
    
    DiskContainer?: SnapshotDiskContainer;
    
    DryRun?: boolean;
    
    Encrypted?: boolean;
    
    KmsKeyId?: string;
    
    RoleName?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace ImportSnapshotRequest {
    
    const filterSensitiveLog: (obj: ImportSnapshotRequest) => any;
}
export interface ImportSnapshotResult {
    
    Description?: string;
    
    ImportTaskId?: string;
    
    SnapshotTaskDetail?: SnapshotTaskDetail;
    
    Tags?: Tag[];
}
export declare namespace ImportSnapshotResult {
    
    const filterSensitiveLog: (obj: ImportSnapshotResult) => any;
}
export interface ImportVolumeRequest {
    
    AvailabilityZone: string | undefined;
    
    Description?: string;
    
    DryRun?: boolean;
    
    Image: DiskImageDetail | undefined;
    
    Volume: VolumeDetail | undefined;
}
export declare namespace ImportVolumeRequest {
    
    const filterSensitiveLog: (obj: ImportVolumeRequest) => any;
}
export interface ImportVolumeResult {
    
    ConversionTask?: ConversionTask;
}
export declare namespace ImportVolumeResult {
    
    const filterSensitiveLog: (obj: ImportVolumeResult) => any;
}
export interface ListSnapshotsInRecycleBinRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
    
    SnapshotIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace ListSnapshotsInRecycleBinRequest {
    
    const filterSensitiveLog: (obj: ListSnapshotsInRecycleBinRequest) => any;
}

export interface SnapshotRecycleBinInfo {
    
    SnapshotId?: string;
    
    RecycleBinEnterTime?: Date;
    
    RecycleBinExitTime?: Date;
    
    Description?: string;
    
    VolumeId?: string;
}
export declare namespace SnapshotRecycleBinInfo {
    
    const filterSensitiveLog: (obj: SnapshotRecycleBinInfo) => any;
}
export interface ListSnapshotsInRecycleBinResult {
    
    Snapshots?: SnapshotRecycleBinInfo[];
    
    NextToken?: string;
}
export declare namespace ListSnapshotsInRecycleBinResult {
    
    const filterSensitiveLog: (obj: ListSnapshotsInRecycleBinResult) => any;
}
export interface ModifyAddressAttributeRequest {
    
    AllocationId: string | undefined;
    
    DomainName?: string;
    
    DryRun?: boolean;
}
export declare namespace ModifyAddressAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyAddressAttributeRequest) => any;
}
export interface ModifyAddressAttributeResult {
    
    Address?: AddressAttribute;
}
export declare namespace ModifyAddressAttributeResult {
    
    const filterSensitiveLog: (obj: ModifyAddressAttributeResult) => any;
}
export declare type ModifyAvailabilityZoneOptInStatus = "not-opted-in" | "opted-in";
export interface ModifyAvailabilityZoneGroupRequest {
    
    GroupName: string | undefined;
    
    OptInStatus: ModifyAvailabilityZoneOptInStatus | string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyAvailabilityZoneGroupRequest {
    
    const filterSensitiveLog: (obj: ModifyAvailabilityZoneGroupRequest) => any;
}
export interface ModifyAvailabilityZoneGroupResult {
    
    Return?: boolean;
}
export declare namespace ModifyAvailabilityZoneGroupResult {
    
    const filterSensitiveLog: (obj: ModifyAvailabilityZoneGroupResult) => any;
}
export interface ModifyCapacityReservationRequest {
    
    CapacityReservationId: string | undefined;
    
    InstanceCount?: number;
    
    EndDate?: Date;
    
    EndDateType?: EndDateType | string;
    
    Accept?: boolean;
    
    DryRun?: boolean;
    
    AdditionalInfo?: string;
}
export declare namespace ModifyCapacityReservationRequest {
    
    const filterSensitiveLog: (obj: ModifyCapacityReservationRequest) => any;
}
export interface ModifyCapacityReservationResult {
    
    Return?: boolean;
}
export declare namespace ModifyCapacityReservationResult {
    
    const filterSensitiveLog: (obj: ModifyCapacityReservationResult) => any;
}
export interface ModifyCapacityReservationFleetRequest {
    
    CapacityReservationFleetId: string | undefined;
    
    TotalTargetCapacity?: number;
    
    EndDate?: Date;
    
    DryRun?: boolean;
    
    RemoveEndDate?: boolean;
}
export declare namespace ModifyCapacityReservationFleetRequest {
    
    const filterSensitiveLog: (obj: ModifyCapacityReservationFleetRequest) => any;
}
export interface ModifyCapacityReservationFleetResult {
    
    Return?: boolean;
}
export declare namespace ModifyCapacityReservationFleetResult {
    
    const filterSensitiveLog: (obj: ModifyCapacityReservationFleetResult) => any;
}

export interface DnsServersOptionsModifyStructure {
    
    CustomDnsServers?: string[];
    
    Enabled?: boolean;
}
export declare namespace DnsServersOptionsModifyStructure {
    
    const filterSensitiveLog: (obj: DnsServersOptionsModifyStructure) => any;
}
export interface ModifyClientVpnEndpointRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    ServerCertificateArn?: string;
    
    ConnectionLogOptions?: ConnectionLogOptions;
    
    DnsServers?: DnsServersOptionsModifyStructure;
    
    VpnPort?: number;
    
    Description?: string;
    
    SplitTunnel?: boolean;
    
    DryRun?: boolean;
    
    SecurityGroupIds?: string[];
    
    VpcId?: string;
    
    SelfServicePortal?: SelfServicePortal | string;
    
    ClientConnectOptions?: ClientConnectOptions;
}
export declare namespace ModifyClientVpnEndpointRequest {
    
    const filterSensitiveLog: (obj: ModifyClientVpnEndpointRequest) => any;
}
export interface ModifyClientVpnEndpointResult {
    
    Return?: boolean;
}
export declare namespace ModifyClientVpnEndpointResult {
    
    const filterSensitiveLog: (obj: ModifyClientVpnEndpointResult) => any;
}
export interface ModifyDefaultCreditSpecificationRequest {
    
    DryRun?: boolean;
    
    InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
    
    CpuCredits: string | undefined;
}
export declare namespace ModifyDefaultCreditSpecificationRequest {
    
    const filterSensitiveLog: (obj: ModifyDefaultCreditSpecificationRequest) => any;
}
export interface ModifyDefaultCreditSpecificationResult {
    
    InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export declare namespace ModifyDefaultCreditSpecificationResult {
    
    const filterSensitiveLog: (obj: ModifyDefaultCreditSpecificationResult) => any;
}
export interface ModifyEbsDefaultKmsKeyIdRequest {
    
    KmsKeyId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyEbsDefaultKmsKeyIdRequest {
    
    const filterSensitiveLog: (obj: ModifyEbsDefaultKmsKeyIdRequest) => any;
}
export interface ModifyEbsDefaultKmsKeyIdResult {
    
    KmsKeyId?: string;
}
export declare namespace ModifyEbsDefaultKmsKeyIdResult {
    
    const filterSensitiveLog: (obj: ModifyEbsDefaultKmsKeyIdResult) => any;
}
export interface ModifyFleetRequest {
    
    DryRun?: boolean;
    
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy | string;
    
    LaunchTemplateConfigs?: FleetLaunchTemplateConfigRequest[];
    
    FleetId: string | undefined;
    
    TargetCapacitySpecification?: TargetCapacitySpecificationRequest;
    
    Context?: string;
}
export declare namespace ModifyFleetRequest {
    
    const filterSensitiveLog: (obj: ModifyFleetRequest) => any;
}
export interface ModifyFleetResult {
    
    Return?: boolean;
}
export declare namespace ModifyFleetResult {
    
    const filterSensitiveLog: (obj: ModifyFleetResult) => any;
}

export interface LoadPermissionRequest {
    
    Group?: PermissionGroup | string;
    
    UserId?: string;
}
export declare namespace LoadPermissionRequest {
    
    const filterSensitiveLog: (obj: LoadPermissionRequest) => any;
}

export interface LoadPermissionModifications {
    
    Add?: LoadPermissionRequest[];
    
    Remove?: LoadPermissionRequest[];
}
export declare namespace LoadPermissionModifications {
    
    const filterSensitiveLog: (obj: LoadPermissionModifications) => any;
}
export declare type OperationType = "add" | "remove";
export interface ModifyFpgaImageAttributeRequest {
    
    DryRun?: boolean;
    
    FpgaImageId: string | undefined;
    
    Attribute?: FpgaImageAttributeName | string;
    
    OperationType?: OperationType | string;
    
    UserIds?: string[];
    
    UserGroups?: string[];
    
    ProductCodes?: string[];
    
    LoadPermission?: LoadPermissionModifications;
    
    Description?: string;
    
    Name?: string;
}
export declare namespace ModifyFpgaImageAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyFpgaImageAttributeRequest) => any;
}
export interface ModifyFpgaImageAttributeResult {
    
    FpgaImageAttribute?: FpgaImageAttribute;
}
export declare namespace ModifyFpgaImageAttributeResult {
    
    const filterSensitiveLog: (obj: ModifyFpgaImageAttributeResult) => any;
}
export interface ModifyHostsRequest {
    
    AutoPlacement?: AutoPlacement | string;
    
    HostIds: string[] | undefined;
    
    HostRecovery?: HostRecovery | string;
    
    InstanceType?: string;
    
    InstanceFamily?: string;
}
export declare namespace ModifyHostsRequest {
    
    const filterSensitiveLog: (obj: ModifyHostsRequest) => any;
}
export interface ModifyHostsResult {
    
    Successful?: string[];
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace ModifyHostsResult {
    
    const filterSensitiveLog: (obj: ModifyHostsResult) => any;
}
export interface ModifyIdentityIdFormatRequest {
    
    PrincipalArn: string | undefined;
    
    Resource: string | undefined;
    
    UseLongIds: boolean | undefined;
}
export declare namespace ModifyIdentityIdFormatRequest {
    
    const filterSensitiveLog: (obj: ModifyIdentityIdFormatRequest) => any;
}
export interface ModifyIdFormatRequest {
    
    Resource: string | undefined;
    
    UseLongIds: boolean | undefined;
}
export declare namespace ModifyIdFormatRequest {
    
    const filterSensitiveLog: (obj: ModifyIdFormatRequest) => any;
}

export interface LaunchPermissionModifications {
    
    Add?: LaunchPermission[];
    
    Remove?: LaunchPermission[];
}
export declare namespace LaunchPermissionModifications {
    
    const filterSensitiveLog: (obj: LaunchPermissionModifications) => any;
}

export interface ModifyImageAttributeRequest {
    
    Attribute?: string;
    
    Description?: AttributeValue;
    
    ImageId: string | undefined;
    
    LaunchPermission?: LaunchPermissionModifications;
    
    OperationType?: OperationType | string;
    
    ProductCodes?: string[];
    
    UserGroups?: string[];
    
    UserIds?: string[];
    
    Value?: string;
    
    DryRun?: boolean;
    
    OrganizationArns?: string[];
    
    OrganizationalUnitArns?: string[];
}
export declare namespace ModifyImageAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyImageAttributeRequest) => any;
}

export interface EbsInstanceBlockDeviceSpecification {
    
    DeleteOnTermination?: boolean;
    
    VolumeId?: string;
}
export declare namespace EbsInstanceBlockDeviceSpecification {
    
    const filterSensitiveLog: (obj: EbsInstanceBlockDeviceSpecification) => any;
}

export interface InstanceBlockDeviceMappingSpecification {
    
    DeviceName?: string;
    
    Ebs?: EbsInstanceBlockDeviceSpecification;
    
    NoDevice?: string;
    
    VirtualName?: string;
}
export declare namespace InstanceBlockDeviceMappingSpecification {
    
    const filterSensitiveLog: (obj: InstanceBlockDeviceMappingSpecification) => any;
}
export interface BlobAttributeValue {
    Value?: Uint8Array;
}
export declare namespace BlobAttributeValue {
    
    const filterSensitiveLog: (obj: BlobAttributeValue) => any;
}
export interface ModifyInstanceAttributeRequest {
    
    SourceDestCheck?: AttributeBooleanValue;
    
    Attribute?: InstanceAttributeName | string;
    
    BlockDeviceMappings?: InstanceBlockDeviceMappingSpecification[];
    
    DisableApiTermination?: AttributeBooleanValue;
    
    DryRun?: boolean;
    
    EbsOptimized?: AttributeBooleanValue;
    
    EnaSupport?: AttributeBooleanValue;
    
    Groups?: string[];
    
    InstanceId: string | undefined;
    
    InstanceInitiatedShutdownBehavior?: AttributeValue;
    
    InstanceType?: AttributeValue;
    
    Kernel?: AttributeValue;
    
    Ramdisk?: AttributeValue;
    
    SriovNetSupport?: AttributeValue;
    
    UserData?: BlobAttributeValue;
    
    Value?: string;
}
export declare namespace ModifyInstanceAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceAttributeRequest) => any;
}

export interface CapacityReservationSpecification {
    
    CapacityReservationPreference?: CapacityReservationPreference | string;
    
    CapacityReservationTarget?: CapacityReservationTarget;
}
export declare namespace CapacityReservationSpecification {
    
    const filterSensitiveLog: (obj: CapacityReservationSpecification) => any;
}
export interface ModifyInstanceCapacityReservationAttributesRequest {
    
    InstanceId: string | undefined;
    
    CapacityReservationSpecification: CapacityReservationSpecification | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyInstanceCapacityReservationAttributesRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceCapacityReservationAttributesRequest) => any;
}
export interface ModifyInstanceCapacityReservationAttributesResult {
    
    Return?: boolean;
}
export declare namespace ModifyInstanceCapacityReservationAttributesResult {
    
    const filterSensitiveLog: (obj: ModifyInstanceCapacityReservationAttributesResult) => any;
}

export interface InstanceCreditSpecificationRequest {
    
    InstanceId?: string;
    
    CpuCredits?: string;
}
export declare namespace InstanceCreditSpecificationRequest {
    
    const filterSensitiveLog: (obj: InstanceCreditSpecificationRequest) => any;
}
export interface ModifyInstanceCreditSpecificationRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    InstanceCreditSpecifications: InstanceCreditSpecificationRequest[] | undefined;
}
export declare namespace ModifyInstanceCreditSpecificationRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceCreditSpecificationRequest) => any;
}

export interface SuccessfulInstanceCreditSpecificationItem {
    
    InstanceId?: string;
}
export declare namespace SuccessfulInstanceCreditSpecificationItem {
    
    const filterSensitiveLog: (obj: SuccessfulInstanceCreditSpecificationItem) => any;
}
export declare enum UnsuccessfulInstanceCreditSpecificationErrorCode {
    INCORRECT_INSTANCE_STATE = "IncorrectInstanceState",
    INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED = "InstanceCreditSpecification.NotSupported",
    INSTANCE_NOT_FOUND = "InvalidInstanceID.NotFound",
    INVALID_INSTANCE_ID = "InvalidInstanceID.Malformed"
}

export interface UnsuccessfulInstanceCreditSpecificationItemError {
    
    Code?: UnsuccessfulInstanceCreditSpecificationErrorCode | string;
    
    Message?: string;
}
export declare namespace UnsuccessfulInstanceCreditSpecificationItemError {
    
    const filterSensitiveLog: (obj: UnsuccessfulInstanceCreditSpecificationItemError) => any;
}

export interface UnsuccessfulInstanceCreditSpecificationItem {
    
    InstanceId?: string;
    
    Error?: UnsuccessfulInstanceCreditSpecificationItemError;
}
export declare namespace UnsuccessfulInstanceCreditSpecificationItem {
    
    const filterSensitiveLog: (obj: UnsuccessfulInstanceCreditSpecificationItem) => any;
}
export interface ModifyInstanceCreditSpecificationResult {
    
    SuccessfulInstanceCreditSpecifications?: SuccessfulInstanceCreditSpecificationItem[];
    
    UnsuccessfulInstanceCreditSpecifications?: UnsuccessfulInstanceCreditSpecificationItem[];
}
export declare namespace ModifyInstanceCreditSpecificationResult {
    
    const filterSensitiveLog: (obj: ModifyInstanceCreditSpecificationResult) => any;
}
export interface ModifyInstanceEventStartTimeRequest {
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
    
    InstanceEventId: string | undefined;
    
    NotBefore: Date | undefined;
}
export declare namespace ModifyInstanceEventStartTimeRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceEventStartTimeRequest) => any;
}
export interface ModifyInstanceEventStartTimeResult {
    
    Event?: InstanceStatusEvent;
}
export declare namespace ModifyInstanceEventStartTimeResult {
    
    const filterSensitiveLog: (obj: ModifyInstanceEventStartTimeResult) => any;
}
export interface ModifyInstanceEventWindowRequest {
    
    DryRun?: boolean;
    
    Name?: string;
    
    InstanceEventWindowId: string | undefined;
    
    TimeRanges?: InstanceEventWindowTimeRangeRequest[];
    
    CronExpression?: string;
}
export declare namespace ModifyInstanceEventWindowRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceEventWindowRequest) => any;
}
export interface ModifyInstanceEventWindowResult {
    
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace ModifyInstanceEventWindowResult {
    
    const filterSensitiveLog: (obj: ModifyInstanceEventWindowResult) => any;
}
export interface ModifyInstanceMetadataOptionsRequest {
    
    InstanceId: string | undefined;
    
    HttpTokens?: HttpTokensState | string;
    
    HttpPutResponseHopLimit?: number;
    
    HttpEndpoint?: InstanceMetadataEndpointState | string;
    
    DryRun?: boolean;
    
    HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
}
export declare namespace ModifyInstanceMetadataOptionsRequest {
    
    const filterSensitiveLog: (obj: ModifyInstanceMetadataOptionsRequest) => any;
}
export interface ModifyInstanceMetadataOptionsResult {
    
    InstanceId?: string;
    
    InstanceMetadataOptions?: InstanceMetadataOptionsResponse;
}
export declare namespace ModifyInstanceMetadataOptionsResult {
    
    const filterSensitiveLog: (obj: ModifyInstanceMetadataOptionsResult) => any;
}
export declare type HostTenancy = "dedicated" | "host";
export interface ModifyInstancePlacementRequest {
    
    Affinity?: Affinity | string;
    
    GroupName?: string;
    
    HostId?: string;
    
    InstanceId: string | undefined;
    
    Tenancy?: HostTenancy | string;
    
    PartitionNumber?: number;
    
    HostResourceGroupArn?: string;
}
export declare namespace ModifyInstancePlacementRequest {
    
    const filterSensitiveLog: (obj: ModifyInstancePlacementRequest) => any;
}
export interface ModifyInstancePlacementResult {
    
    Return?: boolean;
}
export declare namespace ModifyInstancePlacementResult {
    
    const filterSensitiveLog: (obj: ModifyInstancePlacementResult) => any;
}

export interface RemoveIpamOperatingRegion {
    
    RegionName?: string;
}
export declare namespace RemoveIpamOperatingRegion {
    
    const filterSensitiveLog: (obj: RemoveIpamOperatingRegion) => any;
}
export interface ModifyIpamRequest {
    
    DryRun?: boolean;
    
    IpamId: string | undefined;
    
    Description?: string;
    
    AddOperatingRegions?: AddIpamOperatingRegion[];
    
    RemoveOperatingRegions?: RemoveIpamOperatingRegion[];
}
export declare namespace ModifyIpamRequest {
    
    const filterSensitiveLog: (obj: ModifyIpamRequest) => any;
}
export interface ModifyIpamResult {
    
    Ipam?: Ipam;
}
export declare namespace ModifyIpamResult {
    
    const filterSensitiveLog: (obj: ModifyIpamResult) => any;
}
export interface ModifyIpamPoolRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Description?: string;
    
    AutoImport?: boolean;
    
    AllocationMinNetmaskLength?: number;
    
    AllocationMaxNetmaskLength?: number;
    
    AllocationDefaultNetmaskLength?: number;
    
    ClearAllocationDefaultNetmaskLength?: boolean;
    
    AddAllocationResourceTags?: RequestIpamResourceTag[];
    
    RemoveAllocationResourceTags?: RequestIpamResourceTag[];
}
export declare namespace ModifyIpamPoolRequest {
    
    const filterSensitiveLog: (obj: ModifyIpamPoolRequest) => any;
}
export interface ModifyIpamPoolResult {
    
    IpamPool?: IpamPool;
}
export declare namespace ModifyIpamPoolResult {
    
    const filterSensitiveLog: (obj: ModifyIpamPoolResult) => any;
}
export interface ModifyIpamResourceCidrRequest {
    
    DryRun?: boolean;
    
    ResourceId: string | undefined;
    
    ResourceCidr: string | undefined;
    
    ResourceRegion: string | undefined;
    
    CurrentIpamScopeId: string | undefined;
    
    DestinationIpamScopeId?: string;
    
    Monitored: boolean | undefined;
}
export declare namespace ModifyIpamResourceCidrRequest {
    
    const filterSensitiveLog: (obj: ModifyIpamResourceCidrRequest) => any;
}
export interface ModifyIpamResourceCidrResult {
    
    IpamResourceCidr?: IpamResourceCidr;
}
export declare namespace ModifyIpamResourceCidrResult {
    
    const filterSensitiveLog: (obj: ModifyIpamResourceCidrResult) => any;
}
export interface ModifyIpamScopeRequest {
    
    DryRun?: boolean;
    
    IpamScopeId: string | undefined;
    
    Description?: string;
}
export declare namespace ModifyIpamScopeRequest {
    
    const filterSensitiveLog: (obj: ModifyIpamScopeRequest) => any;
}
export interface ModifyIpamScopeResult {
    
    IpamScope?: IpamScope;
}
export declare namespace ModifyIpamScopeResult {
    
    const filterSensitiveLog: (obj: ModifyIpamScopeResult) => any;
}
export interface ModifyLaunchTemplateRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    DefaultVersion?: string;
}
export declare namespace ModifyLaunchTemplateRequest {
    
    const filterSensitiveLog: (obj: ModifyLaunchTemplateRequest) => any;
}
export interface ModifyLaunchTemplateResult {
    
    LaunchTemplate?: LaunchTemplate;
}
export declare namespace ModifyLaunchTemplateResult {
    
    const filterSensitiveLog: (obj: ModifyLaunchTemplateResult) => any;
}

export interface RemovePrefixListEntry {
    
    Cidr: string | undefined;
}
export declare namespace RemovePrefixListEntry {
    
    const filterSensitiveLog: (obj: RemovePrefixListEntry) => any;
}
export interface ModifyManagedPrefixListRequest {
    
    DryRun?: boolean;
    
    PrefixListId: string | undefined;
    
    CurrentVersion?: number;
    
    PrefixListName?: string;
    
    AddEntries?: AddPrefixListEntry[];
    
    RemoveEntries?: RemovePrefixListEntry[];
    
    MaxEntries?: number;
}
export declare namespace ModifyManagedPrefixListRequest {
    
    const filterSensitiveLog: (obj: ModifyManagedPrefixListRequest) => any;
}
export interface ModifyManagedPrefixListResult {
    
    PrefixList?: ManagedPrefixList;
}
export declare namespace ModifyManagedPrefixListResult {
    
    const filterSensitiveLog: (obj: ModifyManagedPrefixListResult) => any;
}

export interface NetworkInterfaceAttachmentChanges {
    
    AttachmentId?: string;
    
    DeleteOnTermination?: boolean;
}
export declare namespace NetworkInterfaceAttachmentChanges {
    
    const filterSensitiveLog: (obj: NetworkInterfaceAttachmentChanges) => any;
}

export interface ModifyNetworkInterfaceAttributeRequest {
    
    Attachment?: NetworkInterfaceAttachmentChanges;
    
    Description?: AttributeValue;
    
    DryRun?: boolean;
    
    Groups?: string[];
    
    NetworkInterfaceId: string | undefined;
    
    SourceDestCheck?: AttributeBooleanValue;
}
export declare namespace ModifyNetworkInterfaceAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyNetworkInterfaceAttributeRequest) => any;
}
export interface ModifyPrivateDnsNameOptionsRequest {
    
    DryRun?: boolean;
    
    InstanceId?: string;
    
    PrivateDnsHostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace ModifyPrivateDnsNameOptionsRequest {
    
    const filterSensitiveLog: (obj: ModifyPrivateDnsNameOptionsRequest) => any;
}
export interface ModifyPrivateDnsNameOptionsResult {
    
    Return?: boolean;
}
export declare namespace ModifyPrivateDnsNameOptionsResult {
    
    const filterSensitiveLog: (obj: ModifyPrivateDnsNameOptionsResult) => any;
}

export interface ModifyReservedInstancesRequest {
    
    ReservedInstancesIds: string[] | undefined;
    
    ClientToken?: string;
    
    TargetConfigurations: ReservedInstancesConfiguration[] | undefined;
}
export declare namespace ModifyReservedInstancesRequest {
    
    const filterSensitiveLog: (obj: ModifyReservedInstancesRequest) => any;
}

export interface ModifyReservedInstancesResult {
    
    ReservedInstancesModificationId?: string;
}
export declare namespace ModifyReservedInstancesResult {
    
    const filterSensitiveLog: (obj: ModifyReservedInstancesResult) => any;
}

export interface SecurityGroupRuleRequest {
    
    IpProtocol?: string;
    
    FromPort?: number;
    
    ToPort?: number;
    
    CidrIpv4?: string;
    
    CidrIpv6?: string;
    
    PrefixListId?: string;
    
    ReferencedGroupId?: string;
    
    Description?: string;
}
export declare namespace SecurityGroupRuleRequest {
    
    const filterSensitiveLog: (obj: SecurityGroupRuleRequest) => any;
}

export interface SecurityGroupRuleUpdate {
    
    SecurityGroupRuleId?: string;
    
    SecurityGroupRule?: SecurityGroupRuleRequest;
}
export declare namespace SecurityGroupRuleUpdate {
    
    const filterSensitiveLog: (obj: SecurityGroupRuleUpdate) => any;
}
export interface ModifySecurityGroupRulesRequest {
    
    GroupId: string | undefined;
    
    SecurityGroupRules: SecurityGroupRuleUpdate[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifySecurityGroupRulesRequest {
    
    const filterSensitiveLog: (obj: ModifySecurityGroupRulesRequest) => any;
}
export interface ModifySecurityGroupRulesResult {
    
    Return?: boolean;
}
export declare namespace ModifySecurityGroupRulesResult {
    
    const filterSensitiveLog: (obj: ModifySecurityGroupRulesResult) => any;
}

export interface CreateVolumePermissionModifications {
    
    Add?: CreateVolumePermission[];
    
    Remove?: CreateVolumePermission[];
}
export declare namespace CreateVolumePermissionModifications {
    
    const filterSensitiveLog: (obj: CreateVolumePermissionModifications) => any;
}
export interface ModifySnapshotAttributeRequest {
    
    Attribute?: SnapshotAttributeName | string;
    
    CreateVolumePermission?: CreateVolumePermissionModifications;
    
    GroupNames?: string[];
    
    OperationType?: OperationType | string;
    
    SnapshotId: string | undefined;
    
    UserIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace ModifySnapshotAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifySnapshotAttributeRequest) => any;
}
export declare enum TargetStorageTier {
    archive = "archive"
}
export interface ModifySnapshotTierRequest {
    
    SnapshotId: string | undefined;
    
    StorageTier?: TargetStorageTier | string;
    
    DryRun?: boolean;
}
export declare namespace ModifySnapshotTierRequest {
    
    const filterSensitiveLog: (obj: ModifySnapshotTierRequest) => any;
}
export interface ModifySnapshotTierResult {
    
    SnapshotId?: string;
    
    TieringStartTime?: Date;
}
export declare namespace ModifySnapshotTierResult {
    
    const filterSensitiveLog: (obj: ModifySnapshotTierResult) => any;
}

export interface ModifySpotFleetRequestRequest {
    
    ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
    
    LaunchTemplateConfigs?: LaunchTemplateConfig[];
    
    SpotFleetRequestId: string | undefined;
    
    TargetCapacity?: number;
    
    OnDemandTargetCapacity?: number;
    
    Context?: string;
}
export declare namespace ModifySpotFleetRequestRequest {
    
    const filterSensitiveLog: (obj: ModifySpotFleetRequestRequest) => any;
}

export interface ModifySpotFleetRequestResponse {
    
    Return?: boolean;
}
export declare namespace ModifySpotFleetRequestResponse {
    
    const filterSensitiveLog: (obj: ModifySpotFleetRequestResponse) => any;
}
export interface ModifySubnetAttributeRequest {
    
    AssignIpv6AddressOnCreation?: AttributeBooleanValue;
    
    MapPublicIpOnLaunch?: AttributeBooleanValue;
    
    SubnetId: string | undefined;
    
    MapCustomerOwnedIpOnLaunch?: AttributeBooleanValue;
    
    CustomerOwnedIpv4Pool?: string;
    
    EnableDns64?: AttributeBooleanValue;
    
    PrivateDnsHostnameTypeOnLaunch?: HostnameType | string;
    
    EnableResourceNameDnsARecordOnLaunch?: AttributeBooleanValue;
    
    EnableResourceNameDnsAAAARecordOnLaunch?: AttributeBooleanValue;
    
    EnableLniAtDeviceIndex?: number;
    
    DisableLniAtDeviceIndex?: AttributeBooleanValue;
}
export declare namespace ModifySubnetAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifySubnetAttributeRequest) => any;
}
export interface ModifyTrafficMirrorFilterNetworkServicesRequest {
    
    TrafficMirrorFilterId: string | undefined;
    
    AddNetworkServices?: (TrafficMirrorNetworkService | string)[];
    
    RemoveNetworkServices?: (TrafficMirrorNetworkService | string)[];
    
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorFilterNetworkServicesRequest {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterNetworkServicesRequest) => any;
}
export interface ModifyTrafficMirrorFilterNetworkServicesResult {
    
    TrafficMirrorFilter?: TrafficMirrorFilter;
}
export declare namespace ModifyTrafficMirrorFilterNetworkServicesResult {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterNetworkServicesResult) => any;
}
export declare type TrafficMirrorFilterRuleField = "description" | "destination-port-range" | "protocol" | "source-port-range";
export interface ModifyTrafficMirrorFilterRuleRequest {
    
    TrafficMirrorFilterRuleId: string | undefined;
    
    TrafficDirection?: TrafficDirection | string;
    
    RuleNumber?: number;
    
    RuleAction?: TrafficMirrorRuleAction | string;
    
    DestinationPortRange?: TrafficMirrorPortRangeRequest;
    
    SourcePortRange?: TrafficMirrorPortRangeRequest;
    
    Protocol?: number;
    
    DestinationCidrBlock?: string;
    
    SourceCidrBlock?: string;
    
    Description?: string;
    
    RemoveFields?: (TrafficMirrorFilterRuleField | string)[];
    
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorFilterRuleRequest {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterRuleRequest) => any;
}
export interface ModifyTrafficMirrorFilterRuleResult {
    
    TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
}
export declare namespace ModifyTrafficMirrorFilterRuleResult {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorFilterRuleResult) => any;
}
export declare type TrafficMirrorSessionField = "description" | "packet-length" | "virtual-network-id";
export interface ModifyTrafficMirrorSessionRequest {
    
    TrafficMirrorSessionId: string | undefined;
    
    TrafficMirrorTargetId?: string;
    
    TrafficMirrorFilterId?: string;
    
    PacketLength?: number;
    
    SessionNumber?: number;
    
    VirtualNetworkId?: number;
    
    Description?: string;
    
    RemoveFields?: (TrafficMirrorSessionField | string)[];
    
    DryRun?: boolean;
}
export declare namespace ModifyTrafficMirrorSessionRequest {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorSessionRequest) => any;
}
export interface ModifyTrafficMirrorSessionResult {
    
    TrafficMirrorSession?: TrafficMirrorSession;
}
export declare namespace ModifyTrafficMirrorSessionResult {
    
    const filterSensitiveLog: (obj: ModifyTrafficMirrorSessionResult) => any;
}

export interface ModifyTransitGatewayOptions {
    
    AddTransitGatewayCidrBlocks?: string[];
    
    RemoveTransitGatewayCidrBlocks?: string[];
    
    VpnEcmpSupport?: VpnEcmpSupportValue | string;
    
    DnsSupport?: DnsSupportValue | string;
    
    AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
    
    DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
    
    AssociationDefaultRouteTableId?: string;
    
    DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
    
    PropagationDefaultRouteTableId?: string;
}
export declare namespace ModifyTransitGatewayOptions {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayOptions) => any;
}
export interface ModifyTransitGatewayRequest {
    
    TransitGatewayId: string | undefined;
    
    Description?: string;
    
    Options?: ModifyTransitGatewayOptions;
    
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayRequest {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayRequest) => any;
}
export interface ModifyTransitGatewayResult {
    
    TransitGateway?: TransitGateway;
}
export declare namespace ModifyTransitGatewayResult {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayResult) => any;
}
export interface ModifyTransitGatewayPrefixListReferenceRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    PrefixListId: string | undefined;
    
    TransitGatewayAttachmentId?: string;
    
    Blackhole?: boolean;
    
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayPrefixListReferenceRequest {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayPrefixListReferenceRequest) => any;
}
export interface ModifyTransitGatewayPrefixListReferenceResult {
    
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace ModifyTransitGatewayPrefixListReferenceResult {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayPrefixListReferenceResult) => any;
}

export interface ModifyTransitGatewayVpcAttachmentRequestOptions {
    
    DnsSupport?: DnsSupportValue | string;
    
    Ipv6Support?: Ipv6SupportValue | string;
    
    ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export declare namespace ModifyTransitGatewayVpcAttachmentRequestOptions {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentRequestOptions) => any;
}
export interface ModifyTransitGatewayVpcAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    AddSubnetIds?: string[];
    
    RemoveSubnetIds?: string[];
    
    Options?: ModifyTransitGatewayVpcAttachmentRequestOptions;
    
    DryRun?: boolean;
}
export declare namespace ModifyTransitGatewayVpcAttachmentRequest {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentRequest) => any;
}
export interface ModifyTransitGatewayVpcAttachmentResult {
    
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace ModifyTransitGatewayVpcAttachmentResult {
    
    const filterSensitiveLog: (obj: ModifyTransitGatewayVpcAttachmentResult) => any;
}
export interface ModifyVolumeRequest {
    
    DryRun?: boolean;
    
    VolumeId: string | undefined;
    
    Size?: number;
    
    VolumeType?: VolumeType | string;
    
    Iops?: number;
    
    Throughput?: number;
    
    MultiAttachEnabled?: boolean;
}
export declare namespace ModifyVolumeRequest {
    
    const filterSensitiveLog: (obj: ModifyVolumeRequest) => any;
}
export interface ModifyVolumeResult {
    
    VolumeModification?: VolumeModification;
}
export declare namespace ModifyVolumeResult {
    
    const filterSensitiveLog: (obj: ModifyVolumeResult) => any;
}
export interface ModifyVolumeAttributeRequest {
    
    AutoEnableIO?: AttributeBooleanValue;
    
    VolumeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyVolumeAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyVolumeAttributeRequest) => any;
}
export interface ModifyVpcAttributeRequest {
    
    EnableDnsHostnames?: AttributeBooleanValue;
    
    EnableDnsSupport?: AttributeBooleanValue;
    
    VpcId: string | undefined;
}
export declare namespace ModifyVpcAttributeRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcAttributeRequest) => any;
}

export interface ModifyVpcEndpointRequest {
    
    DryRun?: boolean;
    
    VpcEndpointId: string | undefined;
    
    ResetPolicy?: boolean;
    
    PolicyDocument?: string;
    
    AddRouteTableIds?: string[];
    
    RemoveRouteTableIds?: string[];
    
    AddSubnetIds?: string[];
    
    RemoveSubnetIds?: string[];
    
    AddSecurityGroupIds?: string[];
    
    RemoveSecurityGroupIds?: string[];
    
    PrivateDnsEnabled?: boolean;
}
export declare namespace ModifyVpcEndpointRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointRequest) => any;
}
export interface ModifyVpcEndpointResult {
    
    Return?: boolean;
}
export declare namespace ModifyVpcEndpointResult {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointResult) => any;
}
export interface ModifyVpcEndpointConnectionNotificationRequest {
    
    DryRun?: boolean;
    
    ConnectionNotificationId: string | undefined;
    
    ConnectionNotificationArn?: string;
    
    ConnectionEvents?: string[];
}
export declare namespace ModifyVpcEndpointConnectionNotificationRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointConnectionNotificationRequest) => any;
}
export interface ModifyVpcEndpointConnectionNotificationResult {
    
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcEndpointConnectionNotificationResult {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointConnectionNotificationResult) => any;
}
export interface ModifyVpcEndpointServiceConfigurationRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
    
    PrivateDnsName?: string;
    
    RemovePrivateDnsName?: boolean;
    
    AcceptanceRequired?: boolean;
    
    AddNetworkLoadBalancerArns?: string[];
    
    RemoveNetworkLoadBalancerArns?: string[];
    
    AddGatewayLoadBalancerArns?: string[];
    
    RemoveGatewayLoadBalancerArns?: string[];
}
export declare namespace ModifyVpcEndpointServiceConfigurationRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointServiceConfigurationRequest) => any;
}
export interface ModifyVpcEndpointServiceConfigurationResult {
    
    Return?: boolean;
}
export declare namespace ModifyVpcEndpointServiceConfigurationResult {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointServiceConfigurationResult) => any;
}
export interface ModifyVpcEndpointServicePermissionsRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
    
    AddAllowedPrincipals?: string[];
    
    RemoveAllowedPrincipals?: string[];
}
export declare namespace ModifyVpcEndpointServicePermissionsRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointServicePermissionsRequest) => any;
}
export interface ModifyVpcEndpointServicePermissionsResult {
    
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcEndpointServicePermissionsResult {
    
    const filterSensitiveLog: (obj: ModifyVpcEndpointServicePermissionsResult) => any;
}

export interface PeeringConnectionOptionsRequest {
    
    AllowDnsResolutionFromRemoteVpc?: boolean;
    
    AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
    
    AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export declare namespace PeeringConnectionOptionsRequest {
    
    const filterSensitiveLog: (obj: PeeringConnectionOptionsRequest) => any;
}
export interface ModifyVpcPeeringConnectionOptionsRequest {
    
    AccepterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
    
    DryRun?: boolean;
    
    RequesterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
    
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace ModifyVpcPeeringConnectionOptionsRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcPeeringConnectionOptionsRequest) => any;
}

export interface PeeringConnectionOptions {
    
    AllowDnsResolutionFromRemoteVpc?: boolean;
    
    AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
    
    AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export declare namespace PeeringConnectionOptions {
    
    const filterSensitiveLog: (obj: PeeringConnectionOptions) => any;
}
export interface ModifyVpcPeeringConnectionOptionsResult {
    
    AccepterPeeringConnectionOptions?: PeeringConnectionOptions;
    
    RequesterPeeringConnectionOptions?: PeeringConnectionOptions;
}
export declare namespace ModifyVpcPeeringConnectionOptionsResult {
    
    const filterSensitiveLog: (obj: ModifyVpcPeeringConnectionOptionsResult) => any;
}
export declare type VpcTenancy = "default";
export interface ModifyVpcTenancyRequest {
    
    VpcId: string | undefined;
    
    InstanceTenancy: VpcTenancy | string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyVpcTenancyRequest {
    
    const filterSensitiveLog: (obj: ModifyVpcTenancyRequest) => any;
}
export interface ModifyVpcTenancyResult {
    
    ReturnValue?: boolean;
}
export declare namespace ModifyVpcTenancyResult {
    
    const filterSensitiveLog: (obj: ModifyVpcTenancyResult) => any;
}
export interface ModifyVpnConnectionRequest {
    
    VpnConnectionId: string | undefined;
    
    TransitGatewayId?: string;
    
    CustomerGatewayId?: string;
    
    VpnGatewayId?: string;
    
    DryRun?: boolean;
}
export declare namespace ModifyVpnConnectionRequest {
    
    const filterSensitiveLog: (obj: ModifyVpnConnectionRequest) => any;
}
export interface ModifyVpnConnectionResult {
    
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnConnectionResult {
    
    const filterSensitiveLog: (obj: ModifyVpnConnectionResult) => any;
}
export interface ModifyVpnConnectionOptionsRequest {
    
    VpnConnectionId: string | undefined;
    
    LocalIpv4NetworkCidr?: string;
    
    RemoteIpv4NetworkCidr?: string;
    
    LocalIpv6NetworkCidr?: string;
    
    RemoteIpv6NetworkCidr?: string;
    
    DryRun?: boolean;
}
export declare namespace ModifyVpnConnectionOptionsRequest {
    
    const filterSensitiveLog: (obj: ModifyVpnConnectionOptionsRequest) => any;
}
export interface ModifyVpnConnectionOptionsResult {
    
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnConnectionOptionsResult {
    
    const filterSensitiveLog: (obj: ModifyVpnConnectionOptionsResult) => any;
}
export interface ModifyVpnTunnelCertificateRequest {
    
    VpnConnectionId: string | undefined;
    
    VpnTunnelOutsideIpAddress: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyVpnTunnelCertificateRequest {
    
    const filterSensitiveLog: (obj: ModifyVpnTunnelCertificateRequest) => any;
}
export interface ModifyVpnTunnelCertificateResult {
    
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnTunnelCertificateResult {
    
    const filterSensitiveLog: (obj: ModifyVpnTunnelCertificateResult) => any;
}

export interface ModifyVpnTunnelOptionsSpecification {
    
    TunnelInsideCidr?: string;
    
    TunnelInsideIpv6Cidr?: string;
    
    PreSharedKey?: string;
    
    Phase1LifetimeSeconds?: number;
    
    Phase2LifetimeSeconds?: number;
    
    RekeyMarginTimeSeconds?: number;
    
    RekeyFuzzPercentage?: number;
    
    ReplayWindowSize?: number;
    
    DPDTimeoutSeconds?: number;
    
    DPDTimeoutAction?: string;
    
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
    
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
    
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
    
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
    
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
    
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
    
    IKEVersions?: IKEVersionsRequestListValue[];
    
    StartupAction?: string;
}
export declare namespace ModifyVpnTunnelOptionsSpecification {
    
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsSpecification) => any;
}
export interface ModifyVpnTunnelOptionsRequest {
    
    VpnConnectionId: string | undefined;
    
    VpnTunnelOutsideIpAddress: string | undefined;
    
    TunnelOptions: ModifyVpnTunnelOptionsSpecification | undefined;
    
    DryRun?: boolean;
}
export declare namespace ModifyVpnTunnelOptionsRequest {
    
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsRequest) => any;
}
export interface ModifyVpnTunnelOptionsResult {
    
    VpnConnection?: VpnConnection;
}
export declare namespace ModifyVpnTunnelOptionsResult {
    
    const filterSensitiveLog: (obj: ModifyVpnTunnelOptionsResult) => any;
}
export interface MonitorInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace MonitorInstancesRequest {
    
    const filterSensitiveLog: (obj: MonitorInstancesRequest) => any;
}

export interface InstanceMonitoring {
    
    InstanceId?: string;
    
    Monitoring?: Monitoring;
}
export declare namespace InstanceMonitoring {
    
    const filterSensitiveLog: (obj: InstanceMonitoring) => any;
}
export interface MonitorInstancesResult {
    
    InstanceMonitorings?: InstanceMonitoring[];
}
export declare namespace MonitorInstancesResult {
    
    const filterSensitiveLog: (obj: MonitorInstancesResult) => any;
}
export interface MoveAddressToVpcRequest {
    
    DryRun?: boolean;
    
    PublicIp: string | undefined;
}
export declare namespace MoveAddressToVpcRequest {
    
    const filterSensitiveLog: (obj: MoveAddressToVpcRequest) => any;
}
export declare enum Status {
    inClassic = "InClassic",
    inVpc = "InVpc",
    moveInProgress = "MoveInProgress"
}
export interface MoveAddressToVpcResult {
    
    AllocationId?: string;
    
    Status?: Status | string;
}
export declare namespace MoveAddressToVpcResult {
    
    const filterSensitiveLog: (obj: MoveAddressToVpcResult) => any;
}
export interface MoveByoipCidrToIpamRequest {
    
    DryRun?: boolean;
    
    Cidr?: string;
    
    IpamPoolId?: string;
    
    IpamPoolOwner?: string;
}
export declare namespace MoveByoipCidrToIpamRequest {
    
    const filterSensitiveLog: (obj: MoveByoipCidrToIpamRequest) => any;
}
export interface MoveByoipCidrToIpamResult {
    
    ByoipCidr?: ByoipCidr;
}
export declare namespace MoveByoipCidrToIpamResult {
    
    const filterSensitiveLog: (obj: MoveByoipCidrToIpamResult) => any;
}

export interface CidrAuthorizationContext {
    
    Message: string | undefined;
    
    Signature: string | undefined;
}
export declare namespace CidrAuthorizationContext {
    
    const filterSensitiveLog: (obj: CidrAuthorizationContext) => any;
}
export interface ProvisionByoipCidrRequest {
    
    Cidr: string | undefined;
    
    CidrAuthorizationContext?: CidrAuthorizationContext;
    
    PubliclyAdvertisable?: boolean;
    
    Description?: string;
    
    DryRun?: boolean;
    
    PoolTagSpecifications?: TagSpecification[];
    
    MultiRegion?: boolean;
}
export declare namespace ProvisionByoipCidrRequest {
    
    const filterSensitiveLog: (obj: ProvisionByoipCidrRequest) => any;
}
export interface ProvisionByoipCidrResult {
    
    ByoipCidr?: ByoipCidr;
}
export declare namespace ProvisionByoipCidrResult {
    
    const filterSensitiveLog: (obj: ProvisionByoipCidrResult) => any;
}

export interface IpamCidrAuthorizationContext {
    
    Message?: string;
    
    Signature?: string;
}
export declare namespace IpamCidrAuthorizationContext {
    
    const filterSensitiveLog: (obj: IpamCidrAuthorizationContext) => any;
}
export interface ProvisionIpamPoolCidrRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Cidr?: string;
    
    CidrAuthorizationContext?: IpamCidrAuthorizationContext;
}
export declare namespace ProvisionIpamPoolCidrRequest {
    
    const filterSensitiveLog: (obj: ProvisionIpamPoolCidrRequest) => any;
}
export interface ProvisionIpamPoolCidrResult {
    
    IpamPoolCidr?: IpamPoolCidr;
}
export declare namespace ProvisionIpamPoolCidrResult {
    
    const filterSensitiveLog: (obj: ProvisionIpamPoolCidrResult) => any;
}
export interface ProvisionPublicIpv4PoolCidrRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    PoolId: string | undefined;
    
    NetmaskLength: number | undefined;
}
export declare namespace ProvisionPublicIpv4PoolCidrRequest {
    
    const filterSensitiveLog: (obj: ProvisionPublicIpv4PoolCidrRequest) => any;
}
export interface ProvisionPublicIpv4PoolCidrResult {
    
    PoolId?: string;
    
    PoolAddressRange?: PublicIpv4PoolRange;
}
export declare namespace ProvisionPublicIpv4PoolCidrResult {
    
    const filterSensitiveLog: (obj: ProvisionPublicIpv4PoolCidrResult) => any;
}
export interface PurchaseHostReservationRequest {
    
    ClientToken?: string;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    HostIdSet: string[] | undefined;
    
    LimitPrice?: string;
    
    OfferingId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace PurchaseHostReservationRequest {
    
    const filterSensitiveLog: (obj: PurchaseHostReservationRequest) => any;
}
export interface PurchaseHostReservationResult {
    
    ClientToken?: string;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Purchase?: Purchase[];
    
    TotalHourlyPrice?: string;
    
    TotalUpfrontPrice?: string;
}
export declare namespace PurchaseHostReservationResult {
    
    const filterSensitiveLog: (obj: PurchaseHostReservationResult) => any;
}

export interface ReservedInstanceLimitPrice {
    
    Amount?: number;
    
    CurrencyCode?: CurrencyCodeValues | string;
}
export declare namespace ReservedInstanceLimitPrice {
    
    const filterSensitiveLog: (obj: ReservedInstanceLimitPrice) => any;
}

export interface PurchaseReservedInstancesOfferingRequest {
    
    InstanceCount: number | undefined;
    
    ReservedInstancesOfferingId: string | undefined;
    
    DryRun?: boolean;
    
    LimitPrice?: ReservedInstanceLimitPrice;
    
    PurchaseTime?: Date;
}
export declare namespace PurchaseReservedInstancesOfferingRequest {
    
    const filterSensitiveLog: (obj: PurchaseReservedInstancesOfferingRequest) => any;
}

export interface PurchaseReservedInstancesOfferingResult {
    
    ReservedInstancesId?: string;
}
export declare namespace PurchaseReservedInstancesOfferingResult {
    
    const filterSensitiveLog: (obj: PurchaseReservedInstancesOfferingResult) => any;
}

export interface PurchaseRequest {
    
    InstanceCount: number | undefined;
    
    PurchaseToken: string | undefined;
}
export declare namespace PurchaseRequest {
    
    const filterSensitiveLog: (obj: PurchaseRequest) => any;
}

export interface PurchaseScheduledInstancesRequest {
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    PurchaseRequests: PurchaseRequest[] | undefined;
}
export declare namespace PurchaseScheduledInstancesRequest {
    
    const filterSensitiveLog: (obj: PurchaseScheduledInstancesRequest) => any;
}

export interface PurchaseScheduledInstancesResult {
    
    ScheduledInstanceSet?: ScheduledInstance[];
}
export declare namespace PurchaseScheduledInstancesResult {
    
    const filterSensitiveLog: (obj: PurchaseScheduledInstancesResult) => any;
}
export interface RebootInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace RebootInstancesRequest {
    
    const filterSensitiveLog: (obj: RebootInstancesRequest) => any;
}

export interface RegisterImageRequest {
    
    ImageLocation?: string;
    
    Architecture?: ArchitectureValues | string;
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    Description?: string;
    
    DryRun?: boolean;
    
    EnaSupport?: boolean;
    
    KernelId?: string;
    
    Name: string | undefined;
    
    BillingProducts?: string[];
    
    RamdiskId?: string;
    
    RootDeviceName?: string;
    
    SriovNetSupport?: string;
    
    VirtualizationType?: string;
    
    BootMode?: BootModeValues | string;
}
export declare namespace RegisterImageRequest {
    
    const filterSensitiveLog: (obj: RegisterImageRequest) => any;
}

export interface RegisterImageResult {
    
    ImageId?: string;
}
export declare namespace RegisterImageResult {
    
    const filterSensitiveLog: (obj: RegisterImageResult) => any;
}

export interface RegisterInstanceTagAttributeRequest {
    
    IncludeAllTagsOfInstance?: boolean;
    
    InstanceTagKeys?: string[];
}
export declare namespace RegisterInstanceTagAttributeRequest {
    
    const filterSensitiveLog: (obj: RegisterInstanceTagAttributeRequest) => any;
}
export interface RegisterInstanceEventNotificationAttributesRequest {
    
    DryRun?: boolean;
    
    InstanceTagAttribute?: RegisterInstanceTagAttributeRequest;
}
export declare namespace RegisterInstanceEventNotificationAttributesRequest {
    
    const filterSensitiveLog: (obj: RegisterInstanceEventNotificationAttributesRequest) => any;
}
export interface RegisterInstanceEventNotificationAttributesResult {
    
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export declare namespace RegisterInstanceEventNotificationAttributesResult {
    
    const filterSensitiveLog: (obj: RegisterInstanceEventNotificationAttributesResult) => any;
}
export interface RegisterTransitGatewayMulticastGroupMembersRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    GroupIpAddress?: string;
    
    NetworkInterfaceIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace RegisterTransitGatewayMulticastGroupMembersRequest {
    
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupMembersRequest) => any;
}

export interface TransitGatewayMulticastRegisteredGroupMembers {
    
    TransitGatewayMulticastDomainId?: string;
    
    RegisteredNetworkInterfaceIds?: string[];
    
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastRegisteredGroupMembers {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastRegisteredGroupMembers) => any;
}
export interface RegisterTransitGatewayMulticastGroupMembersResult {
    
    RegisteredMulticastGroupMembers?: TransitGatewayMulticastRegisteredGroupMembers;
}
export declare namespace RegisterTransitGatewayMulticastGroupMembersResult {
    
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupMembersResult) => any;
}
export interface RegisterTransitGatewayMulticastGroupSourcesRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    GroupIpAddress?: string;
    
    NetworkInterfaceIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace RegisterTransitGatewayMulticastGroupSourcesRequest {
    
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupSourcesRequest) => any;
}

export interface TransitGatewayMulticastRegisteredGroupSources {
    
    TransitGatewayMulticastDomainId?: string;
    
    RegisteredNetworkInterfaceIds?: string[];
    
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastRegisteredGroupSources {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastRegisteredGroupSources) => any;
}
export interface RegisterTransitGatewayMulticastGroupSourcesResult {
    
    RegisteredMulticastGroupSources?: TransitGatewayMulticastRegisteredGroupSources;
}
export declare namespace RegisterTransitGatewayMulticastGroupSourcesResult {
    
    const filterSensitiveLog: (obj: RegisterTransitGatewayMulticastGroupSourcesResult) => any;
}
export interface RejectTransitGatewayMulticastDomainAssociationsRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    SubnetIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayMulticastDomainAssociationsRequest {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayMulticastDomainAssociationsRequest) => any;
}
export interface RejectTransitGatewayMulticastDomainAssociationsResult {
    
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace RejectTransitGatewayMulticastDomainAssociationsResult {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayMulticastDomainAssociationsResult) => any;
}
export interface RejectTransitGatewayPeeringAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayPeeringAttachmentRequest {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayPeeringAttachmentRequest) => any;
}
export interface RejectTransitGatewayPeeringAttachmentResult {
    
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace RejectTransitGatewayPeeringAttachmentResult {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayPeeringAttachmentResult) => any;
}
export interface RejectTransitGatewayVpcAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace RejectTransitGatewayVpcAttachmentRequest {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayVpcAttachmentRequest) => any;
}
export interface RejectTransitGatewayVpcAttachmentResult {
    
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace RejectTransitGatewayVpcAttachmentResult {
    
    const filterSensitiveLog: (obj: RejectTransitGatewayVpcAttachmentResult) => any;
}
export interface RejectVpcEndpointConnectionsRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
    
    VpcEndpointIds: string[] | undefined;
}
export declare namespace RejectVpcEndpointConnectionsRequest {
    
    const filterSensitiveLog: (obj: RejectVpcEndpointConnectionsRequest) => any;
}
export interface RejectVpcEndpointConnectionsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace RejectVpcEndpointConnectionsResult {
    
    const filterSensitiveLog: (obj: RejectVpcEndpointConnectionsResult) => any;
}
export interface RejectVpcPeeringConnectionRequest {
    
    DryRun?: boolean;
    
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace RejectVpcPeeringConnectionRequest {
    
    const filterSensitiveLog: (obj: RejectVpcPeeringConnectionRequest) => any;
}
export interface RejectVpcPeeringConnectionResult {
    
    Return?: boolean;
}
export declare namespace RejectVpcPeeringConnectionResult {
    
    const filterSensitiveLog: (obj: RejectVpcPeeringConnectionResult) => any;
}
export interface ReleaseAddressRequest {
    
    AllocationId?: string;
    
    PublicIp?: string;
    
    NetworkBorderGroup?: string;
    
    DryRun?: boolean;
}
export declare namespace ReleaseAddressRequest {
    
    const filterSensitiveLog: (obj: ReleaseAddressRequest) => any;
}
export interface ReleaseHostsRequest {
    
    HostIds: string[] | undefined;
}
export declare namespace ReleaseHostsRequest {
    
    const filterSensitiveLog: (obj: ReleaseHostsRequest) => any;
}
export interface ReleaseHostsResult {
    
    Successful?: string[];
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace ReleaseHostsResult {
    
    const filterSensitiveLog: (obj: ReleaseHostsResult) => any;
}
export interface ReleaseIpamPoolAllocationRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Cidr: string | undefined;
    
    IpamPoolAllocationId?: string;
}
export declare namespace ReleaseIpamPoolAllocationRequest {
    
    const filterSensitiveLog: (obj: ReleaseIpamPoolAllocationRequest) => any;
}
export interface ReleaseIpamPoolAllocationResult {
    
    Success?: boolean;
}
export declare namespace ReleaseIpamPoolAllocationResult {
    
    const filterSensitiveLog: (obj: ReleaseIpamPoolAllocationResult) => any;
}
export interface ReplaceIamInstanceProfileAssociationRequest {
    
    IamInstanceProfile: IamInstanceProfileSpecification | undefined;
    
    AssociationId: string | undefined;
}
export declare namespace ReplaceIamInstanceProfileAssociationRequest {
    
    const filterSensitiveLog: (obj: ReplaceIamInstanceProfileAssociationRequest) => any;
}
export interface ReplaceIamInstanceProfileAssociationResult {
    
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export declare namespace ReplaceIamInstanceProfileAssociationResult {
    
    const filterSensitiveLog: (obj: ReplaceIamInstanceProfileAssociationResult) => any;
}
export interface ReplaceNetworkAclAssociationRequest {
    
    AssociationId: string | undefined;
    
    DryRun?: boolean;
    
    NetworkAclId: string | undefined;
}
export declare namespace ReplaceNetworkAclAssociationRequest {
    
    const filterSensitiveLog: (obj: ReplaceNetworkAclAssociationRequest) => any;
}
export interface ReplaceNetworkAclAssociationResult {
    
    NewAssociationId?: string;
}
export declare namespace ReplaceNetworkAclAssociationResult {
    
    const filterSensitiveLog: (obj: ReplaceNetworkAclAssociationResult) => any;
}
export interface ReplaceNetworkAclEntryRequest {
    
    CidrBlock?: string;
    
    DryRun?: boolean;
    
    Egress: boolean | undefined;
    
    IcmpTypeCode?: IcmpTypeCode;
    
    Ipv6CidrBlock?: string;
    
    NetworkAclId: string | undefined;
    
    PortRange?: PortRange;
    
    Protocol: string | undefined;
    
    RuleAction: RuleAction | string | undefined;
    
    RuleNumber: number | undefined;
}
export declare namespace ReplaceNetworkAclEntryRequest {
    
    const filterSensitiveLog: (obj: ReplaceNetworkAclEntryRequest) => any;
}
export interface ReplaceRouteRequest {
    
    DestinationCidrBlock?: string;
    
    DestinationIpv6CidrBlock?: string;
    
    DestinationPrefixListId?: string;
    
    DryRun?: boolean;
    
    VpcEndpointId?: string;
    
    EgressOnlyInternetGatewayId?: string;
    
    GatewayId?: string;
    
    InstanceId?: string;
    
    LocalTarget?: boolean;
    
    NatGatewayId?: string;
    
    TransitGatewayId?: string;
    
    LocalGatewayId?: string;
    
    CarrierGatewayId?: string;
    
    NetworkInterfaceId?: string;
    
    RouteTableId: string | undefined;
    
    VpcPeeringConnectionId?: string;
    
    CoreNetworkArn?: string;
}
export declare namespace ReplaceRouteRequest {
    
    const filterSensitiveLog: (obj: ReplaceRouteRequest) => any;
}
export interface ReplaceRouteTableAssociationRequest {
    
    AssociationId: string | undefined;
    
    DryRun?: boolean;
    
    RouteTableId: string | undefined;
}
export declare namespace ReplaceRouteTableAssociationRequest {
    
    const filterSensitiveLog: (obj: ReplaceRouteTableAssociationRequest) => any;
}
export interface ReplaceRouteTableAssociationResult {
    
    NewAssociationId?: string;
    
    AssociationState?: RouteTableAssociationState;
}
export declare namespace ReplaceRouteTableAssociationResult {
    
    const filterSensitiveLog: (obj: ReplaceRouteTableAssociationResult) => any;
}
export interface ReplaceTransitGatewayRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId?: string;
    
    Blackhole?: boolean;
    
    DryRun?: boolean;
}
export declare namespace ReplaceTransitGatewayRouteRequest {
    
    const filterSensitiveLog: (obj: ReplaceTransitGatewayRouteRequest) => any;
}
export interface ReplaceTransitGatewayRouteResult {
    
    Route?: TransitGatewayRoute;
}
export declare namespace ReplaceTransitGatewayRouteResult {
    
    const filterSensitiveLog: (obj: ReplaceTransitGatewayRouteResult) => any;
}
export declare type ReportInstanceReasonCodes = "instance-stuck-in-state" | "not-accepting-credentials" | "other" | "password-not-available" | "performance-ebs-volume" | "performance-instance-store" | "performance-network" | "performance-other" | "unresponsive";
export declare type ReportStatusType = "impaired" | "ok";
export interface ReportInstanceStatusRequest {
    
    Description?: string;
    
    DryRun?: boolean;
    
    EndTime?: Date;
    
    Instances: string[] | undefined;
    
    ReasonCodes: (ReportInstanceReasonCodes | string)[] | undefined;
    
    StartTime?: Date;
    
    Status: ReportStatusType | string | undefined;
}
export declare namespace ReportInstanceStatusRequest {
    
    const filterSensitiveLog: (obj: ReportInstanceStatusRequest) => any;
}

export interface RequestSpotFleetRequest {
    
    DryRun?: boolean;
    
    SpotFleetRequestConfig: SpotFleetRequestConfigData | undefined;
}
export declare namespace RequestSpotFleetRequest {
    
    const filterSensitiveLog: (obj: RequestSpotFleetRequest) => any;
}

export interface RequestSpotFleetResponse {
    
    SpotFleetRequestId?: string;
}
export declare namespace RequestSpotFleetResponse {
    
    const filterSensitiveLog: (obj: RequestSpotFleetResponse) => any;
}

export interface RequestSpotLaunchSpecification {
    
    SecurityGroupIds?: string[];
    
    SecurityGroups?: string[];
    
    AddressingType?: string;
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: IamInstanceProfileSpecification;
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KernelId?: string;
    
    KeyName?: string;
    
    Monitoring?: RunInstancesMonitoringEnabled;
    
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    
    Placement?: SpotPlacement;
    
    RamdiskId?: string;
    
    SubnetId?: string;
    
    UserData?: string;
}
export declare namespace RequestSpotLaunchSpecification {
    
    const filterSensitiveLog: (obj: RequestSpotLaunchSpecification) => any;
}

export interface RequestSpotInstancesRequest {
    
    AvailabilityZoneGroup?: string;
    
    BlockDurationMinutes?: number;
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    InstanceCount?: number;
    
    LaunchGroup?: string;
    
    LaunchSpecification?: RequestSpotLaunchSpecification;
    
    SpotPrice?: string;
    
    Type?: SpotInstanceType | string;
    
    ValidFrom?: Date;
    
    ValidUntil?: Date;
    
    TagSpecifications?: TagSpecification[];
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace RequestSpotInstancesRequest {
    
    const filterSensitiveLog: (obj: RequestSpotInstancesRequest) => any;
}

export interface RequestSpotInstancesResult {
    
    SpotInstanceRequests?: SpotInstanceRequest[];
}
export declare namespace RequestSpotInstancesResult {
    
    const filterSensitiveLog: (obj: RequestSpotInstancesResult) => any;
}
export interface ResetAddressAttributeRequest {
    
    AllocationId: string | undefined;
    
    Attribute: AddressAttributeName | string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ResetAddressAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetAddressAttributeRequest) => any;
}
export interface ResetAddressAttributeResult {
    
    Address?: AddressAttribute;
}
export declare namespace ResetAddressAttributeResult {
    
    const filterSensitiveLog: (obj: ResetAddressAttributeResult) => any;
}
export interface ResetEbsDefaultKmsKeyIdRequest {
    
    DryRun?: boolean;
}
export declare namespace ResetEbsDefaultKmsKeyIdRequest {
    
    const filterSensitiveLog: (obj: ResetEbsDefaultKmsKeyIdRequest) => any;
}
export interface ResetEbsDefaultKmsKeyIdResult {
    
    KmsKeyId?: string;
}
export declare namespace ResetEbsDefaultKmsKeyIdResult {
    
    const filterSensitiveLog: (obj: ResetEbsDefaultKmsKeyIdResult) => any;
}
export declare type ResetFpgaImageAttributeName = "loadPermission";
export interface ResetFpgaImageAttributeRequest {
    
    DryRun?: boolean;
    
    FpgaImageId: string | undefined;
    
    Attribute?: ResetFpgaImageAttributeName | string;
}
export declare namespace ResetFpgaImageAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetFpgaImageAttributeRequest) => any;
}
export interface ResetFpgaImageAttributeResult {
    
    Return?: boolean;
}
export declare namespace ResetFpgaImageAttributeResult {
    
    const filterSensitiveLog: (obj: ResetFpgaImageAttributeResult) => any;
}
export declare type ResetImageAttributeName = "launchPermission";

export interface ResetImageAttributeRequest {
    
    Attribute: ResetImageAttributeName | string | undefined;
    
    ImageId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ResetImageAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetImageAttributeRequest) => any;
}
export interface ResetInstanceAttributeRequest {
    
    Attribute: InstanceAttributeName | string | undefined;
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
}
export declare namespace ResetInstanceAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetInstanceAttributeRequest) => any;
}

export interface ResetNetworkInterfaceAttributeRequest {
    
    DryRun?: boolean;
    
    NetworkInterfaceId: string | undefined;
    
    SourceDestCheck?: string;
}
export declare namespace ResetNetworkInterfaceAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetNetworkInterfaceAttributeRequest) => any;
}
export interface ResetSnapshotAttributeRequest {
    
    Attribute: SnapshotAttributeName | string | undefined;
    
    SnapshotId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ResetSnapshotAttributeRequest {
    
    const filterSensitiveLog: (obj: ResetSnapshotAttributeRequest) => any;
}
export interface RestoreAddressToClassicRequest {
    
    DryRun?: boolean;
    
    PublicIp: string | undefined;
}
export declare namespace RestoreAddressToClassicRequest {
    
    const filterSensitiveLog: (obj: RestoreAddressToClassicRequest) => any;
}
export interface RestoreAddressToClassicResult {
    
    PublicIp?: string;
    
    Status?: Status | string;
}
export declare namespace RestoreAddressToClassicResult {
    
    const filterSensitiveLog: (obj: RestoreAddressToClassicResult) => any;
}
export interface RestoreManagedPrefixListVersionRequest {
    
    DryRun?: boolean;
    
    PrefixListId: string | undefined;
    
    PreviousVersion: number | undefined;
    
    CurrentVersion: number | undefined;
}
export declare namespace RestoreManagedPrefixListVersionRequest {
    
    const filterSensitiveLog: (obj: RestoreManagedPrefixListVersionRequest) => any;
}
export interface RestoreManagedPrefixListVersionResult {
    
    PrefixList?: ManagedPrefixList;
}
export declare namespace RestoreManagedPrefixListVersionResult {
    
    const filterSensitiveLog: (obj: RestoreManagedPrefixListVersionResult) => any;
}
export interface RestoreSnapshotFromRecycleBinRequest {
    
    SnapshotId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace RestoreSnapshotFromRecycleBinRequest {
    
    const filterSensitiveLog: (obj: RestoreSnapshotFromRecycleBinRequest) => any;
}
export interface RestoreSnapshotFromRecycleBinResult {
    
    SnapshotId?: string;
    
    OutpostArn?: string;
    
    Description?: string;
    
    Encrypted?: boolean;
    
    OwnerId?: string;
    
    Progress?: string;
    
    StartTime?: Date;
    
    State?: SnapshotState | string;
    
    VolumeId?: string;
    
    VolumeSize?: number;
}
export declare namespace RestoreSnapshotFromRecycleBinResult {
    
    const filterSensitiveLog: (obj: RestoreSnapshotFromRecycleBinResult) => any;
}
export interface RestoreSnapshotTierRequest {
    
    SnapshotId: string | undefined;
    
    TemporaryRestoreDays?: number;
    
    PermanentRestore?: boolean;
    
    DryRun?: boolean;
}
export declare namespace RestoreSnapshotTierRequest {
    
    const filterSensitiveLog: (obj: RestoreSnapshotTierRequest) => any;
}
export interface RestoreSnapshotTierResult {
    
    SnapshotId?: string;
    
    RestoreStartTime?: Date;
    
    RestoreDuration?: number;
    
    IsPermanentRestore?: boolean;
}
export declare namespace RestoreSnapshotTierResult {
    
    const filterSensitiveLog: (obj: RestoreSnapshotTierResult) => any;
}
export interface RevokeClientVpnIngressRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    TargetNetworkCidr: string | undefined;
    
    AccessGroupId?: string;
    
    RevokeAllGroups?: boolean;
    
    DryRun?: boolean;
}
export declare namespace RevokeClientVpnIngressRequest {
    
    const filterSensitiveLog: (obj: RevokeClientVpnIngressRequest) => any;
}
export interface RevokeClientVpnIngressResult {
    
    Status?: ClientVpnAuthorizationRuleStatus;
}
export declare namespace RevokeClientVpnIngressResult {
    
    const filterSensitiveLog: (obj: RevokeClientVpnIngressResult) => any;
}
export interface RevokeSecurityGroupEgressRequest {
    
    DryRun?: boolean;
    
    GroupId: string | undefined;
    
    IpPermissions?: IpPermission[];
    
    SecurityGroupRuleIds?: string[];
    
    CidrIp?: string;
    
    FromPort?: number;
    
    IpProtocol?: string;
    
    ToPort?: number;
    
    SourceSecurityGroupName?: string;
    
    SourceSecurityGroupOwnerId?: string;
}
export declare namespace RevokeSecurityGroupEgressRequest {
    
    const filterSensitiveLog: (obj: RevokeSecurityGroupEgressRequest) => any;
}
export interface RevokeSecurityGroupEgressResult {
    
    Return?: boolean;
    
    UnknownIpPermissions?: IpPermission[];
}
export declare namespace RevokeSecurityGroupEgressResult {
    
    const filterSensitiveLog: (obj: RevokeSecurityGroupEgressResult) => any;
}
export interface RevokeSecurityGroupIngressRequest {
    
    CidrIp?: string;
    
    FromPort?: number;
    
    GroupId?: string;
    
    GroupName?: string;
    
    IpPermissions?: IpPermission[];
    
    IpProtocol?: string;
    
    SourceSecurityGroupName?: string;
    
    SourceSecurityGroupOwnerId?: string;
    
    ToPort?: number;
    
    DryRun?: boolean;
    
    SecurityGroupRuleIds?: string[];
}
export declare namespace RevokeSecurityGroupIngressRequest {
    
    const filterSensitiveLog: (obj: RevokeSecurityGroupIngressRequest) => any;
}
export interface RevokeSecurityGroupIngressResult {
    
    Return?: boolean;
    
    UnknownIpPermissions?: IpPermission[];
}
export declare namespace RevokeSecurityGroupIngressResult {
    
    const filterSensitiveLog: (obj: RevokeSecurityGroupIngressResult) => any;
}

export interface CpuOptionsRequest {
    
    CoreCount?: number;
    
    ThreadsPerCore?: number;
}
export declare namespace CpuOptionsRequest {
    
    const filterSensitiveLog: (obj: CpuOptionsRequest) => any;
}

export interface ElasticInferenceAccelerator {
    
    Type: string | undefined;
    
    Count?: number;
}
export declare namespace ElasticInferenceAccelerator {
    
    const filterSensitiveLog: (obj: ElasticInferenceAccelerator) => any;
}

export interface EnclaveOptionsRequest {
    
    Enabled?: boolean;
}
export declare namespace EnclaveOptionsRequest {
    
    const filterSensitiveLog: (obj: EnclaveOptionsRequest) => any;
}

export interface HibernationOptionsRequest {
    
    Configured?: boolean;
}
export declare namespace HibernationOptionsRequest {
    
    const filterSensitiveLog: (obj: HibernationOptionsRequest) => any;
}

export interface SpotMarketOptions {
    
    MaxPrice?: string;
    
    SpotInstanceType?: SpotInstanceType | string;
    
    BlockDurationMinutes?: number;
    
    ValidUntil?: Date;
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace SpotMarketOptions {
    
    const filterSensitiveLog: (obj: SpotMarketOptions) => any;
}

export interface InstanceMarketOptionsRequest {
    
    MarketType?: MarketType | string;
    
    SpotOptions?: SpotMarketOptions;
}
export declare namespace InstanceMarketOptionsRequest {
    
    const filterSensitiveLog: (obj: InstanceMarketOptionsRequest) => any;
}
