import { _InstanceType, AcceleratorCount, AcceleratorCountRequest, AcceleratorManufacturer, AcceleratorName, AcceleratorTotalMemoryMiB, AcceleratorTotalMemoryMiBRequest, AcceleratorType, AccessScopePath, AccessScopePathRequest, AddIpamOperatingRegion, AddPrefixListEntry, AddressFamily, AttachmentStatus, BareMetal, BaselineEbsBandwidthMbpsRequest, BurstablePerformance, CpuManufacturer, CurrencyCodeValues, DnsSupportValue, FleetExcessCapacityTerminationPolicy, FleetLaunchTemplateSpecificationRequest, HostnameType, InstanceEventWindow, InstanceGeneration, InternetGatewayAttachment, Ipv4PrefixSpecification, LocalStorage, LocalStorageType, PortRange, Protocol, ReservedInstancesListing, ResourceType, RouteTableAssociationState, Subnet, Tag, TagSpecification, Tenancy, TransitGatewayAttachmentState, UnsuccessfulItem, WeekDay } from "./models_0";

export interface MemoryGiBPerVCpuRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace MemoryGiBPerVCpuRequest {
    
    const filterSensitiveLog: (obj: MemoryGiBPerVCpuRequest) => any;
}

export interface MemoryMiBRequest {
    
    Min: number | undefined;
    
    Max?: number;
}
export declare namespace MemoryMiBRequest {
    
    const filterSensitiveLog: (obj: MemoryMiBRequest) => any;
}

export interface NetworkInterfaceCountRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace NetworkInterfaceCountRequest {
    
    const filterSensitiveLog: (obj: NetworkInterfaceCountRequest) => any;
}

export interface TotalLocalStorageGBRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace TotalLocalStorageGBRequest {
    
    const filterSensitiveLog: (obj: TotalLocalStorageGBRequest) => any;
}

export interface VCpuCountRangeRequest {
    
    Min: number | undefined;
    
    Max?: number;
}
export declare namespace VCpuCountRangeRequest {
    
    const filterSensitiveLog: (obj: VCpuCountRangeRequest) => any;
}

export interface InstanceRequirementsRequest {
    
    VCpuCount: VCpuCountRangeRequest | undefined;
    
    MemoryMiB: MemoryMiBRequest | undefined;
    
    CpuManufacturers?: (CpuManufacturer | string)[];
    
    MemoryGiBPerVCpu?: MemoryGiBPerVCpuRequest;
    
    ExcludedInstanceTypes?: string[];
    
    InstanceGenerations?: (InstanceGeneration | string)[];
    
    SpotMaxPricePercentageOverLowestPrice?: number;
    
    OnDemandMaxPricePercentageOverLowestPrice?: number;
    
    BareMetal?: BareMetal | string;
    
    BurstablePerformance?: BurstablePerformance | string;
    
    RequireHibernateSupport?: boolean;
    
    NetworkInterfaceCount?: NetworkInterfaceCountRequest;
    
    LocalStorage?: LocalStorage | string;
    
    LocalStorageTypes?: (LocalStorageType | string)[];
    
    TotalLocalStorageGB?: TotalLocalStorageGBRequest;
    
    BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbpsRequest;
    
    AcceleratorTypes?: (AcceleratorType | string)[];
    
    AcceleratorCount?: AcceleratorCountRequest;
    
    AcceleratorManufacturers?: (AcceleratorManufacturer | string)[];
    
    AcceleratorNames?: (AcceleratorName | string)[];
    
    AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiBRequest;
}
export declare namespace InstanceRequirementsRequest {
    
    const filterSensitiveLog: (obj: InstanceRequirementsRequest) => any;
}

export interface Placement {
    
    AvailabilityZone?: string;
    
    Affinity?: string;
    
    GroupName?: string;
    
    PartitionNumber?: number;
    
    HostId?: string;
    
    Tenancy?: Tenancy | string;
    
    SpreadDomain?: string;
    
    HostResourceGroupArn?: string;
}
export declare namespace Placement {
    
    const filterSensitiveLog: (obj: Placement) => any;
}

export interface FleetLaunchTemplateOverridesRequest {
    
    InstanceType?: _InstanceType | string;
    
    MaxPrice?: string;
    
    SubnetId?: string;
    
    AvailabilityZone?: string;
    
    WeightedCapacity?: number;
    
    Priority?: number;
    
    Placement?: Placement;
    
    InstanceRequirements?: InstanceRequirementsRequest;
}
export declare namespace FleetLaunchTemplateOverridesRequest {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateOverridesRequest) => any;
}

export interface FleetLaunchTemplateConfigRequest {
    
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecificationRequest;
    
    Overrides?: FleetLaunchTemplateOverridesRequest[];
}
export declare namespace FleetLaunchTemplateConfigRequest {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateConfigRequest) => any;
}
export declare enum FleetOnDemandAllocationStrategy {
    LOWEST_PRICE = "lowest-price",
    PRIORITIZED = "prioritized"
}
export declare enum FleetCapacityReservationUsageStrategy {
    USE_CAPACITY_RESERVATIONS_FIRST = "use-capacity-reservations-first"
}

export interface CapacityReservationOptionsRequest {
    
    UsageStrategy?: FleetCapacityReservationUsageStrategy | string;
}
export declare namespace CapacityReservationOptionsRequest {
    
    const filterSensitiveLog: (obj: CapacityReservationOptionsRequest) => any;
}

export interface OnDemandOptionsRequest {
    
    AllocationStrategy?: FleetOnDemandAllocationStrategy | string;
    
    CapacityReservationOptions?: CapacityReservationOptionsRequest;
    
    SingleInstanceType?: boolean;
    
    SingleAvailabilityZone?: boolean;
    
    MinTargetCapacity?: number;
    
    MaxTotalPrice?: string;
}
export declare namespace OnDemandOptionsRequest {
    
    const filterSensitiveLog: (obj: OnDemandOptionsRequest) => any;
}
export declare enum SpotAllocationStrategy {
    CAPACITY_OPTIMIZED = "capacity-optimized",
    CAPACITY_OPTIMIZED_PRIORITIZED = "capacity-optimized-prioritized",
    DIVERSIFIED = "diversified",
    LOWEST_PRICE = "lowest-price"
}
export declare type SpotInstanceInterruptionBehavior = "hibernate" | "stop" | "terminate";
export declare enum FleetReplacementStrategy {
    LAUNCH = "launch",
    LAUNCH_BEFORE_TERMINATE = "launch-before-terminate"
}

export interface FleetSpotCapacityRebalanceRequest {
    
    ReplacementStrategy?: FleetReplacementStrategy | string;
    
    TerminationDelay?: number;
}
export declare namespace FleetSpotCapacityRebalanceRequest {
    
    const filterSensitiveLog: (obj: FleetSpotCapacityRebalanceRequest) => any;
}

export interface FleetSpotMaintenanceStrategiesRequest {
    
    CapacityRebalance?: FleetSpotCapacityRebalanceRequest;
}
export declare namespace FleetSpotMaintenanceStrategiesRequest {
    
    const filterSensitiveLog: (obj: FleetSpotMaintenanceStrategiesRequest) => any;
}

export interface SpotOptionsRequest {
    
    AllocationStrategy?: SpotAllocationStrategy | string;
    
    MaintenanceStrategies?: FleetSpotMaintenanceStrategiesRequest;
    
    InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | string;
    
    InstancePoolsToUseCount?: number;
    
    SingleInstanceType?: boolean;
    
    SingleAvailabilityZone?: boolean;
    
    MinTargetCapacity?: number;
    
    MaxTotalPrice?: string;
}
export declare namespace SpotOptionsRequest {
    
    const filterSensitiveLog: (obj: SpotOptionsRequest) => any;
}
export declare enum DefaultTargetCapacityType {
    ON_DEMAND = "on-demand",
    SPOT = "spot"
}
export declare enum TargetCapacityUnitType {
    MEMORY_MIB = "memory-mib",
    UNITS = "units",
    VCPU = "vcpu"
}

export interface TargetCapacitySpecificationRequest {
    
    TotalTargetCapacity: number | undefined;
    
    OnDemandTargetCapacity?: number;
    
    SpotTargetCapacity?: number;
    
    DefaultTargetCapacityType?: DefaultTargetCapacityType | string;
    
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
}
export declare namespace TargetCapacitySpecificationRequest {
    
    const filterSensitiveLog: (obj: TargetCapacitySpecificationRequest) => any;
}
export declare enum FleetType {
    INSTANT = "instant",
    MAINTAIN = "maintain",
    REQUEST = "request"
}
export interface CreateFleetRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    SpotOptions?: SpotOptionsRequest;
    
    OnDemandOptions?: OnDemandOptionsRequest;
    
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy | string;
    
    LaunchTemplateConfigs: FleetLaunchTemplateConfigRequest[] | undefined;
    
    TargetCapacitySpecification: TargetCapacitySpecificationRequest | undefined;
    
    TerminateInstancesWithExpiration?: boolean;
    
    Type?: FleetType | string;
    
    ValidFrom?: Date;
    
    ValidUntil?: Date;
    
    ReplaceUnhealthyInstances?: boolean;
    
    TagSpecifications?: TagSpecification[];
    
    Context?: string;
}
export declare namespace CreateFleetRequest {
    
    const filterSensitiveLog: (obj: CreateFleetRequest) => any;
}

export interface FleetLaunchTemplateSpecification {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    Version?: string;
}
export declare namespace FleetLaunchTemplateSpecification {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateSpecification) => any;
}

export interface BaselineEbsBandwidthMbps {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace BaselineEbsBandwidthMbps {
    
    const filterSensitiveLog: (obj: BaselineEbsBandwidthMbps) => any;
}

export interface MemoryGiBPerVCpu {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace MemoryGiBPerVCpu {
    
    const filterSensitiveLog: (obj: MemoryGiBPerVCpu) => any;
}

export interface MemoryMiB {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace MemoryMiB {
    
    const filterSensitiveLog: (obj: MemoryMiB) => any;
}

export interface NetworkInterfaceCount {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace NetworkInterfaceCount {
    
    const filterSensitiveLog: (obj: NetworkInterfaceCount) => any;
}

export interface TotalLocalStorageGB {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace TotalLocalStorageGB {
    
    const filterSensitiveLog: (obj: TotalLocalStorageGB) => any;
}

export interface VCpuCountRange {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace VCpuCountRange {
    
    const filterSensitiveLog: (obj: VCpuCountRange) => any;
}

export interface InstanceRequirements {
    
    VCpuCount?: VCpuCountRange;
    
    MemoryMiB?: MemoryMiB;
    
    CpuManufacturers?: (CpuManufacturer | string)[];
    
    MemoryGiBPerVCpu?: MemoryGiBPerVCpu;
    
    ExcludedInstanceTypes?: string[];
    
    InstanceGenerations?: (InstanceGeneration | string)[];
    
    SpotMaxPricePercentageOverLowestPrice?: number;
    
    OnDemandMaxPricePercentageOverLowestPrice?: number;
    
    BareMetal?: BareMetal | string;
    
    BurstablePerformance?: BurstablePerformance | string;
    
    RequireHibernateSupport?: boolean;
    
    NetworkInterfaceCount?: NetworkInterfaceCount;
    
    LocalStorage?: LocalStorage | string;
    
    LocalStorageTypes?: (LocalStorageType | string)[];
    
    TotalLocalStorageGB?: TotalLocalStorageGB;
    
    BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbps;
    
    AcceleratorTypes?: (AcceleratorType | string)[];
    
    AcceleratorCount?: AcceleratorCount;
    
    AcceleratorManufacturers?: (AcceleratorManufacturer | string)[];
    
    AcceleratorNames?: (AcceleratorName | string)[];
    
    AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiB;
}
export declare namespace InstanceRequirements {
    
    const filterSensitiveLog: (obj: InstanceRequirements) => any;
}

export interface PlacementResponse {
    
    GroupName?: string;
}
export declare namespace PlacementResponse {
    
    const filterSensitiveLog: (obj: PlacementResponse) => any;
}

export interface FleetLaunchTemplateOverrides {
    
    InstanceType?: _InstanceType | string;
    
    MaxPrice?: string;
    
    SubnetId?: string;
    
    AvailabilityZone?: string;
    
    WeightedCapacity?: number;
    
    Priority?: number;
    
    Placement?: PlacementResponse;
    
    InstanceRequirements?: InstanceRequirements;
}
export declare namespace FleetLaunchTemplateOverrides {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateOverrides) => any;
}

export interface LaunchTemplateAndOverridesResponse {
    
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
    
    Overrides?: FleetLaunchTemplateOverrides;
}
export declare namespace LaunchTemplateAndOverridesResponse {
    
    const filterSensitiveLog: (obj: LaunchTemplateAndOverridesResponse) => any;
}
export declare enum InstanceLifecycle {
    ON_DEMAND = "on-demand",
    SPOT = "spot"
}

export interface CreateFleetError {
    
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    
    Lifecycle?: InstanceLifecycle | string;
    
    ErrorCode?: string;
    
    ErrorMessage?: string;
}
export declare namespace CreateFleetError {
    
    const filterSensitiveLog: (obj: CreateFleetError) => any;
}
export declare type PlatformValues = "Windows";

export interface CreateFleetInstance {
    
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    
    Lifecycle?: InstanceLifecycle | string;
    
    InstanceIds?: string[];
    
    InstanceType?: _InstanceType | string;
    
    Platform?: PlatformValues | string;
}
export declare namespace CreateFleetInstance {
    
    const filterSensitiveLog: (obj: CreateFleetInstance) => any;
}
export interface CreateFleetResult {
    
    FleetId?: string;
    
    Errors?: CreateFleetError[];
    
    Instances?: CreateFleetInstance[];
}
export declare namespace CreateFleetResult {
    
    const filterSensitiveLog: (obj: CreateFleetResult) => any;
}
export declare enum DestinationFileFormat {
    parquet = "parquet",
    plain_text = "plain-text"
}

export interface DestinationOptionsRequest {
    
    FileFormat?: DestinationFileFormat | string;
    
    HiveCompatiblePartitions?: boolean;
    
    PerHourPartition?: boolean;
}
export declare namespace DestinationOptionsRequest {
    
    const filterSensitiveLog: (obj: DestinationOptionsRequest) => any;
}
export declare type LogDestinationType = "cloud-watch-logs" | "s3";
export declare type FlowLogsResourceType = "NetworkInterface" | "Subnet" | "VPC";
export declare type TrafficType = "ACCEPT" | "ALL" | "REJECT";
export interface CreateFlowLogsRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    DeliverLogsPermissionArn?: string;
    
    LogGroupName?: string;
    
    ResourceIds: string[] | undefined;
    
    ResourceType: FlowLogsResourceType | string | undefined;
    
    TrafficType: TrafficType | string | undefined;
    
    LogDestinationType?: LogDestinationType | string;
    
    LogDestination?: string;
    
    LogFormat?: string;
    
    TagSpecifications?: TagSpecification[];
    
    MaxAggregationInterval?: number;
    
    DestinationOptions?: DestinationOptionsRequest;
}
export declare namespace CreateFlowLogsRequest {
    
    const filterSensitiveLog: (obj: CreateFlowLogsRequest) => any;
}
export interface CreateFlowLogsResult {
    
    ClientToken?: string;
    
    FlowLogIds?: string[];
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace CreateFlowLogsResult {
    
    const filterSensitiveLog: (obj: CreateFlowLogsResult) => any;
}

export interface StorageLocation {
    
    Bucket?: string;
    
    Key?: string;
}
export declare namespace StorageLocation {
    
    const filterSensitiveLog: (obj: StorageLocation) => any;
}
export interface CreateFpgaImageRequest {
    
    DryRun?: boolean;
    
    InputStorageLocation: StorageLocation | undefined;
    
    LogsStorageLocation?: StorageLocation;
    
    Description?: string;
    
    Name?: string;
    
    ClientToken?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateFpgaImageRequest {
    
    const filterSensitiveLog: (obj: CreateFpgaImageRequest) => any;
}
export interface CreateFpgaImageResult {
    
    FpgaImageId?: string;
    
    FpgaImageGlobalId?: string;
}
export declare namespace CreateFpgaImageResult {
    
    const filterSensitiveLog: (obj: CreateFpgaImageResult) => any;
}
export declare type VolumeType = "gp2" | "gp3" | "io1" | "io2" | "sc1" | "st1" | "standard";

export interface EbsBlockDevice {
    
    DeleteOnTermination?: boolean;
    
    Iops?: number;
    
    SnapshotId?: string;
    
    VolumeSize?: number;
    
    VolumeType?: VolumeType | string;
    
    KmsKeyId?: string;
    
    Throughput?: number;
    
    OutpostArn?: string;
    
    Encrypted?: boolean;
}
export declare namespace EbsBlockDevice {
    
    const filterSensitiveLog: (obj: EbsBlockDevice) => any;
}

export interface BlockDeviceMapping {
    
    DeviceName?: string;
    
    VirtualName?: string;
    
    Ebs?: EbsBlockDevice;
    
    NoDevice?: string;
}
export declare namespace BlockDeviceMapping {
    
    const filterSensitiveLog: (obj: BlockDeviceMapping) => any;
}
export interface CreateImageRequest {
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    Description?: string;
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
    
    Name: string | undefined;
    
    NoReboot?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateImageRequest {
    
    const filterSensitiveLog: (obj: CreateImageRequest) => any;
}
export interface CreateImageResult {
    
    ImageId?: string;
}
export declare namespace CreateImageResult {
    
    const filterSensitiveLog: (obj: CreateImageResult) => any;
}

export interface InstanceEventWindowTimeRangeRequest {
    
    StartWeekDay?: WeekDay | string;
    
    StartHour?: number;
    
    EndWeekDay?: WeekDay | string;
    
    EndHour?: number;
}
export declare namespace InstanceEventWindowTimeRangeRequest {
    
    const filterSensitiveLog: (obj: InstanceEventWindowTimeRangeRequest) => any;
}
export interface CreateInstanceEventWindowRequest {
    
    DryRun?: boolean;
    
    Name?: string;
    
    TimeRanges?: InstanceEventWindowTimeRangeRequest[];
    
    CronExpression?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateInstanceEventWindowRequest {
    
    const filterSensitiveLog: (obj: CreateInstanceEventWindowRequest) => any;
}
export interface CreateInstanceEventWindowResult {
    
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace CreateInstanceEventWindowResult {
    
    const filterSensitiveLog: (obj: CreateInstanceEventWindowResult) => any;
}
export declare type ContainerFormat = "ova";
export declare type DiskImageFormat = "RAW" | "VHD" | "VMDK";

export interface ExportToS3TaskSpecification {
    
    ContainerFormat?: ContainerFormat | string;
    
    DiskImageFormat?: DiskImageFormat | string;
    
    S3Bucket?: string;
    
    S3Prefix?: string;
}
export declare namespace ExportToS3TaskSpecification {
    
    const filterSensitiveLog: (obj: ExportToS3TaskSpecification) => any;
}
export declare type ExportEnvironment = "citrix" | "microsoft" | "vmware";
export interface CreateInstanceExportTaskRequest {
    
    Description?: string;
    
    ExportToS3Task: ExportToS3TaskSpecification | undefined;
    
    InstanceId: string | undefined;
    
    TargetEnvironment: ExportEnvironment | string | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateInstanceExportTaskRequest {
    
    const filterSensitiveLog: (obj: CreateInstanceExportTaskRequest) => any;
}

export interface ExportToS3Task {
    
    ContainerFormat?: ContainerFormat | string;
    
    DiskImageFormat?: DiskImageFormat | string;
    
    S3Bucket?: string;
    
    S3Key?: string;
}
export declare namespace ExportToS3Task {
    
    const filterSensitiveLog: (obj: ExportToS3Task) => any;
}

export interface InstanceExportDetails {
    
    InstanceId?: string;
    
    TargetEnvironment?: ExportEnvironment | string;
}
export declare namespace InstanceExportDetails {
    
    const filterSensitiveLog: (obj: InstanceExportDetails) => any;
}
export declare type ExportTaskState = "active" | "cancelled" | "cancelling" | "completed";

export interface ExportTask {
    
    Description?: string;
    
    ExportTaskId?: string;
    
    ExportToS3Task?: ExportToS3Task;
    
    InstanceExportDetails?: InstanceExportDetails;
    
    State?: ExportTaskState | string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
}
export declare namespace ExportTask {
    
    const filterSensitiveLog: (obj: ExportTask) => any;
}
export interface CreateInstanceExportTaskResult {
    
    ExportTask?: ExportTask;
}
export declare namespace CreateInstanceExportTaskResult {
    
    const filterSensitiveLog: (obj: CreateInstanceExportTaskResult) => any;
}
export interface CreateInternetGatewayRequest {
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateInternetGatewayRequest) => any;
}

export interface InternetGateway {
    
    Attachments?: InternetGatewayAttachment[];
    
    InternetGatewayId?: string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace InternetGateway {
    
    const filterSensitiveLog: (obj: InternetGateway) => any;
}
export interface CreateInternetGatewayResult {
    
    InternetGateway?: InternetGateway;
}
export declare namespace CreateInternetGatewayResult {
    
    const filterSensitiveLog: (obj: CreateInternetGatewayResult) => any;
}
export interface CreateIpamRequest {
    
    DryRun?: boolean;
    
    Description?: string;
    
    OperatingRegions?: AddIpamOperatingRegion[];
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
}
export declare namespace CreateIpamRequest {
    
    const filterSensitiveLog: (obj: CreateIpamRequest) => any;
}

export interface IpamOperatingRegion {
    
    RegionName?: string;
}
export declare namespace IpamOperatingRegion {
    
    const filterSensitiveLog: (obj: IpamOperatingRegion) => any;
}
export declare enum IpamState {
    create_complete = "create-complete",
    create_failed = "create-failed",
    create_in_progress = "create-in-progress",
    delete_complete = "delete-complete",
    delete_failed = "delete-failed",
    delete_in_progress = "delete-in-progress",
    modify_complete = "modify-complete",
    modify_failed = "modify-failed",
    modify_in_progress = "modify-in-progress"
}

export interface Ipam {
    
    OwnerId?: string;
    
    IpamId?: string;
    
    IpamArn?: string;
    
    IpamRegion?: string;
    
    PublicDefaultScopeId?: string;
    
    PrivateDefaultScopeId?: string;
    
    ScopeCount?: number;
    
    Description?: string;
    
    OperatingRegions?: IpamOperatingRegion[];
    
    State?: IpamState | string;
    
    Tags?: Tag[];
}
export declare namespace Ipam {
    
    const filterSensitiveLog: (obj: Ipam) => any;
}
export interface CreateIpamResult {
    
    Ipam?: Ipam;
}
export declare namespace CreateIpamResult {
    
    const filterSensitiveLog: (obj: CreateIpamResult) => any;
}

export interface RequestIpamResourceTag {
    
    Key?: string;
    
    Value?: string;
}
export declare namespace RequestIpamResourceTag {
    
    const filterSensitiveLog: (obj: RequestIpamResourceTag) => any;
}
export declare enum IpamPoolAwsService {
    ec2 = "ec2"
}
export interface CreateIpamPoolRequest {
    
    DryRun?: boolean;
    
    IpamScopeId: string | undefined;
    
    Locale?: string;
    
    SourceIpamPoolId?: string;
    
    Description?: string;
    
    AddressFamily?: AddressFamily | string;
    
    AutoImport?: boolean;
    
    PubliclyAdvertisable?: boolean;
    
    AllocationMinNetmaskLength?: number;
    
    AllocationMaxNetmaskLength?: number;
    
    AllocationDefaultNetmaskLength?: number;
    
    AllocationResourceTags?: RequestIpamResourceTag[];
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
    
    AwsService?: IpamPoolAwsService | string;
}
export declare namespace CreateIpamPoolRequest {
    
    const filterSensitiveLog: (obj: CreateIpamPoolRequest) => any;
}

export interface IpamResourceTag {
    
    Key?: string;
    
    Value?: string;
}
export declare namespace IpamResourceTag {
    
    const filterSensitiveLog: (obj: IpamResourceTag) => any;
}
export declare enum IpamScopeType {
    private = "private",
    public = "public"
}
export declare enum IpamPoolState {
    create_complete = "create-complete",
    create_failed = "create-failed",
    create_in_progress = "create-in-progress",
    delete_complete = "delete-complete",
    delete_failed = "delete-failed",
    delete_in_progress = "delete-in-progress",
    modify_complete = "modify-complete",
    modify_failed = "modify-failed",
    modify_in_progress = "modify-in-progress"
}

export interface IpamPool {
    
    OwnerId?: string;
    
    IpamPoolId?: string;
    
    SourceIpamPoolId?: string;
    
    IpamPoolArn?: string;
    
    IpamScopeArn?: string;
    
    IpamScopeType?: IpamScopeType | string;
    
    IpamArn?: string;
    
    IpamRegion?: string;
    
    Locale?: string;
    
    PoolDepth?: number;
    
    State?: IpamPoolState | string;
    
    StateMessage?: string;
    
    Description?: string;
    
    AutoImport?: boolean;
    
    PubliclyAdvertisable?: boolean;
    
    AddressFamily?: AddressFamily | string;
    
    AllocationMinNetmaskLength?: number;
    
    AllocationMaxNetmaskLength?: number;
    
    AllocationDefaultNetmaskLength?: number;
    
    AllocationResourceTags?: IpamResourceTag[];
    
    Tags?: Tag[];
    
    AwsService?: IpamPoolAwsService | string;
}
export declare namespace IpamPool {
    
    const filterSensitiveLog: (obj: IpamPool) => any;
}
export interface CreateIpamPoolResult {
    
    IpamPool?: IpamPool;
}
export declare namespace CreateIpamPoolResult {
    
    const filterSensitiveLog: (obj: CreateIpamPoolResult) => any;
}
export interface CreateIpamScopeRequest {
    
    DryRun?: boolean;
    
    IpamId: string | undefined;
    
    Description?: string;
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
}
export declare namespace CreateIpamScopeRequest {
    
    const filterSensitiveLog: (obj: CreateIpamScopeRequest) => any;
}
export declare enum IpamScopeState {
    create_complete = "create-complete",
    create_failed = "create-failed",
    create_in_progress = "create-in-progress",
    delete_complete = "delete-complete",
    delete_failed = "delete-failed",
    delete_in_progress = "delete-in-progress",
    modify_complete = "modify-complete",
    modify_failed = "modify-failed",
    modify_in_progress = "modify-in-progress"
}

export interface IpamScope {
    
    OwnerId?: string;
    
    IpamScopeId?: string;
    
    IpamScopeArn?: string;
    
    IpamArn?: string;
    
    IpamRegion?: string;
    
    IpamScopeType?: IpamScopeType | string;
    
    IsDefault?: boolean;
    
    Description?: string;
    
    PoolCount?: number;
    
    State?: IpamScopeState | string;
    
    Tags?: Tag[];
}
export declare namespace IpamScope {
    
    const filterSensitiveLog: (obj: IpamScope) => any;
}
export interface CreateIpamScopeResult {
    
    IpamScope?: IpamScope;
}
export declare namespace CreateIpamScopeResult {
    
    const filterSensitiveLog: (obj: CreateIpamScopeResult) => any;
}
export declare enum KeyType {
    ed25519 = "ed25519",
    rsa = "rsa"
}
export interface CreateKeyPairRequest {
    
    KeyName: string | undefined;
    
    DryRun?: boolean;
    
    KeyType?: KeyType | string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateKeyPairRequest {
    
    const filterSensitiveLog: (obj: CreateKeyPairRequest) => any;
}

export interface KeyPair {
    
    KeyFingerprint?: string;
    
    KeyMaterial?: string;
    
    KeyName?: string;
    
    KeyPairId?: string;
    
    Tags?: Tag[];
}
export declare namespace KeyPair {
    
    const filterSensitiveLog: (obj: KeyPair) => any;
}

export interface LaunchTemplateEbsBlockDeviceRequest {
    
    Encrypted?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Iops?: number;
    
    KmsKeyId?: string;
    
    SnapshotId?: string;
    
    VolumeSize?: number;
    
    VolumeType?: VolumeType | string;
    
    Throughput?: number;
}
export declare namespace LaunchTemplateEbsBlockDeviceRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateEbsBlockDeviceRequest) => any;
}

export interface LaunchTemplateBlockDeviceMappingRequest {
    
    DeviceName?: string;
    
    VirtualName?: string;
    
    Ebs?: LaunchTemplateEbsBlockDeviceRequest;
    
    NoDevice?: string;
}
export declare namespace LaunchTemplateBlockDeviceMappingRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateBlockDeviceMappingRequest) => any;
}
export declare type CapacityReservationPreference = "none" | "open";

export interface CapacityReservationTarget {
    
    CapacityReservationId?: string;
    
    CapacityReservationResourceGroupArn?: string;
}
export declare namespace CapacityReservationTarget {
    
    const filterSensitiveLog: (obj: CapacityReservationTarget) => any;
}

export interface LaunchTemplateCapacityReservationSpecificationRequest {
    
    CapacityReservationPreference?: CapacityReservationPreference | string;
    
    CapacityReservationTarget?: CapacityReservationTarget;
}
export declare namespace LaunchTemplateCapacityReservationSpecificationRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateCapacityReservationSpecificationRequest) => any;
}

export interface LaunchTemplateCpuOptionsRequest {
    
    CoreCount?: number;
    
    ThreadsPerCore?: number;
}
export declare namespace LaunchTemplateCpuOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateCpuOptionsRequest) => any;
}

export interface CreditSpecificationRequest {
    
    CpuCredits: string | undefined;
}
export declare namespace CreditSpecificationRequest {
    
    const filterSensitiveLog: (obj: CreditSpecificationRequest) => any;
}

export interface ElasticGpuSpecification {
    
    Type: string | undefined;
}
export declare namespace ElasticGpuSpecification {
    
    const filterSensitiveLog: (obj: ElasticGpuSpecification) => any;
}

export interface LaunchTemplateElasticInferenceAccelerator {
    
    Type: string | undefined;
    
    Count?: number;
}
export declare namespace LaunchTemplateElasticInferenceAccelerator {
    
    const filterSensitiveLog: (obj: LaunchTemplateElasticInferenceAccelerator) => any;
}

export interface LaunchTemplateEnclaveOptionsRequest {
    
    Enabled?: boolean;
}
export declare namespace LaunchTemplateEnclaveOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateEnclaveOptionsRequest) => any;
}

export interface LaunchTemplateHibernationOptionsRequest {
    
    Configured?: boolean;
}
export declare namespace LaunchTemplateHibernationOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateHibernationOptionsRequest) => any;
}

export interface LaunchTemplateIamInstanceProfileSpecificationRequest {
    
    Arn?: string;
    
    Name?: string;
}
export declare namespace LaunchTemplateIamInstanceProfileSpecificationRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateIamInstanceProfileSpecificationRequest) => any;
}
export declare type ShutdownBehavior = "stop" | "terminate";
export declare type MarketType = "spot";
export declare type InstanceInterruptionBehavior = "hibernate" | "stop" | "terminate";
export declare type SpotInstanceType = "one-time" | "persistent";

export interface LaunchTemplateSpotMarketOptionsRequest {
    
    MaxPrice?: string;
    
    SpotInstanceType?: SpotInstanceType | string;
    
    BlockDurationMinutes?: number;
    
    ValidUntil?: Date;
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace LaunchTemplateSpotMarketOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateSpotMarketOptionsRequest) => any;
}

export interface LaunchTemplateInstanceMarketOptionsRequest {
    
    MarketType?: MarketType | string;
    
    SpotOptions?: LaunchTemplateSpotMarketOptionsRequest;
}
export declare namespace LaunchTemplateInstanceMarketOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceMarketOptionsRequest) => any;
}

export interface LaunchTemplateLicenseConfigurationRequest {
    
    LicenseConfigurationArn?: string;
}
export declare namespace LaunchTemplateLicenseConfigurationRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateLicenseConfigurationRequest) => any;
}
export declare type LaunchTemplateInstanceMetadataEndpointState = "disabled" | "enabled";
export declare enum LaunchTemplateInstanceMetadataProtocolIpv6 {
    disabled = "disabled",
    enabled = "enabled"
}
export declare enum LaunchTemplateHttpTokensState {
    optional = "optional",
    required = "required"
}

export interface LaunchTemplateInstanceMetadataOptionsRequest {
    
    HttpTokens?: LaunchTemplateHttpTokensState | string;
    
    HttpPutResponseHopLimit?: number;
    
    HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | string;
    
    HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | string;
}
export declare namespace LaunchTemplateInstanceMetadataOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceMetadataOptionsRequest) => any;
}

export interface LaunchTemplatesMonitoringRequest {
    
    Enabled?: boolean;
}
export declare namespace LaunchTemplatesMonitoringRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplatesMonitoringRequest) => any;
}

export interface Ipv4PrefixSpecificationRequest {
    
    Ipv4Prefix?: string;
}
export declare namespace Ipv4PrefixSpecificationRequest {
    
    const filterSensitiveLog: (obj: Ipv4PrefixSpecificationRequest) => any;
}

export interface InstanceIpv6AddressRequest {
    
    Ipv6Address?: string;
}
export declare namespace InstanceIpv6AddressRequest {
    
    const filterSensitiveLog: (obj: InstanceIpv6AddressRequest) => any;
}

export interface Ipv6PrefixSpecificationRequest {
    
    Ipv6Prefix?: string;
}
export declare namespace Ipv6PrefixSpecificationRequest {
    
    const filterSensitiveLog: (obj: Ipv6PrefixSpecificationRequest) => any;
}

export interface PrivateIpAddressSpecification {
    
    Primary?: boolean;
    
    PrivateIpAddress?: string;
}
export declare namespace PrivateIpAddressSpecification {
    
    const filterSensitiveLog: (obj: PrivateIpAddressSpecification) => any;
}

export interface LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
    
    AssociateCarrierIpAddress?: boolean;
    
    AssociatePublicIpAddress?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Description?: string;
    
    DeviceIndex?: number;
    
    Groups?: string[];
    
    InterfaceType?: string;
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: InstanceIpv6AddressRequest[];
    
    NetworkInterfaceId?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: PrivateIpAddressSpecification[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    SubnetId?: string;
    
    NetworkCardIndex?: number;
    
    Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
    
    Ipv4PrefixCount?: number;
    
    Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
    
    Ipv6PrefixCount?: number;
}
export declare namespace LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceNetworkInterfaceSpecificationRequest) => any;
}

export interface LaunchTemplatePlacementRequest {
    
    AvailabilityZone?: string;
    
    Affinity?: string;
    
    GroupName?: string;
    
    HostId?: string;
    
    Tenancy?: Tenancy | string;
    
    SpreadDomain?: string;
    
    HostResourceGroupArn?: string;
    
    PartitionNumber?: number;
}
export declare namespace LaunchTemplatePlacementRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplatePlacementRequest) => any;
}

export interface LaunchTemplatePrivateDnsNameOptionsRequest {
    
    HostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace LaunchTemplatePrivateDnsNameOptionsRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplatePrivateDnsNameOptionsRequest) => any;
}

export interface LaunchTemplateTagSpecificationRequest {
    
    ResourceType?: ResourceType | string;
    
    Tags?: Tag[];
}
export declare namespace LaunchTemplateTagSpecificationRequest {
    
    const filterSensitiveLog: (obj: LaunchTemplateTagSpecificationRequest) => any;
}

export interface RequestLaunchTemplateData {
    
    KernelId?: string;
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecificationRequest;
    
    BlockDeviceMappings?: LaunchTemplateBlockDeviceMappingRequest[];
    
    NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[];
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KeyName?: string;
    
    Monitoring?: LaunchTemplatesMonitoringRequest;
    
    Placement?: LaunchTemplatePlacementRequest;
    
    RamDiskId?: string;
    
    DisableApiTermination?: boolean;
    
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
    
    UserData?: string;
    
    TagSpecifications?: LaunchTemplateTagSpecificationRequest[];
    
    ElasticGpuSpecifications?: ElasticGpuSpecification[];
    
    ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAccelerator[];
    
    SecurityGroupIds?: string[];
    
    SecurityGroups?: string[];
    
    InstanceMarketOptions?: LaunchTemplateInstanceMarketOptionsRequest;
    
    CreditSpecification?: CreditSpecificationRequest;
    
    CpuOptions?: LaunchTemplateCpuOptionsRequest;
    
    CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationRequest;
    
    LicenseSpecifications?: LaunchTemplateLicenseConfigurationRequest[];
    
    HibernationOptions?: LaunchTemplateHibernationOptionsRequest;
    
    MetadataOptions?: LaunchTemplateInstanceMetadataOptionsRequest;
    
    EnclaveOptions?: LaunchTemplateEnclaveOptionsRequest;
    
    InstanceRequirements?: InstanceRequirementsRequest;
    
    PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptionsRequest;
}
export declare namespace RequestLaunchTemplateData {
    
    const filterSensitiveLog: (obj: RequestLaunchTemplateData) => any;
}
export interface CreateLaunchTemplateRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    LaunchTemplateName: string | undefined;
    
    VersionDescription?: string;
    
    LaunchTemplateData: RequestLaunchTemplateData | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateLaunchTemplateRequest {
    
    const filterSensitiveLog: (obj: CreateLaunchTemplateRequest) => any;
}

export interface LaunchTemplate {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    CreateTime?: Date;
    
    CreatedBy?: string;
    
    DefaultVersionNumber?: number;
    
    LatestVersionNumber?: number;
    
    Tags?: Tag[];
}
export declare namespace LaunchTemplate {
    
    const filterSensitiveLog: (obj: LaunchTemplate) => any;
}

export interface ValidationError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace ValidationError {
    
    const filterSensitiveLog: (obj: ValidationError) => any;
}

export interface ValidationWarning {
    
    Errors?: ValidationError[];
}
export declare namespace ValidationWarning {
    
    const filterSensitiveLog: (obj: ValidationWarning) => any;
}
export interface CreateLaunchTemplateResult {
    
    LaunchTemplate?: LaunchTemplate;
    
    Warning?: ValidationWarning;
}
export declare namespace CreateLaunchTemplateResult {
    
    const filterSensitiveLog: (obj: CreateLaunchTemplateResult) => any;
}
export interface CreateLaunchTemplateVersionRequest {
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    SourceVersion?: string;
    
    VersionDescription?: string;
    
    LaunchTemplateData: RequestLaunchTemplateData | undefined;
}
export declare namespace CreateLaunchTemplateVersionRequest {
    
    const filterSensitiveLog: (obj: CreateLaunchTemplateVersionRequest) => any;
}

export interface LaunchTemplateEbsBlockDevice {
    
    Encrypted?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Iops?: number;
    
    KmsKeyId?: string;
    
    SnapshotId?: string;
    
    VolumeSize?: number;
    
    VolumeType?: VolumeType | string;
    
    Throughput?: number;
}
export declare namespace LaunchTemplateEbsBlockDevice {
    
    const filterSensitiveLog: (obj: LaunchTemplateEbsBlockDevice) => any;
}

export interface LaunchTemplateBlockDeviceMapping {
    
    DeviceName?: string;
    
    VirtualName?: string;
    
    Ebs?: LaunchTemplateEbsBlockDevice;
    
    NoDevice?: string;
}
export declare namespace LaunchTemplateBlockDeviceMapping {
    
    const filterSensitiveLog: (obj: LaunchTemplateBlockDeviceMapping) => any;
}

export interface CapacityReservationTargetResponse {
    
    CapacityReservationId?: string;
    
    CapacityReservationResourceGroupArn?: string;
}
export declare namespace CapacityReservationTargetResponse {
    
    const filterSensitiveLog: (obj: CapacityReservationTargetResponse) => any;
}

export interface LaunchTemplateCapacityReservationSpecificationResponse {
    
    CapacityReservationPreference?: CapacityReservationPreference | string;
    
    CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export declare namespace LaunchTemplateCapacityReservationSpecificationResponse {
    
    const filterSensitiveLog: (obj: LaunchTemplateCapacityReservationSpecificationResponse) => any;
}

export interface LaunchTemplateCpuOptions {
    
    CoreCount?: number;
    
    ThreadsPerCore?: number;
}
export declare namespace LaunchTemplateCpuOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateCpuOptions) => any;
}

export interface CreditSpecification {
    
    CpuCredits?: string;
}
export declare namespace CreditSpecification {
    
    const filterSensitiveLog: (obj: CreditSpecification) => any;
}

export interface ElasticGpuSpecificationResponse {
    
    Type?: string;
}
export declare namespace ElasticGpuSpecificationResponse {
    
    const filterSensitiveLog: (obj: ElasticGpuSpecificationResponse) => any;
}

export interface LaunchTemplateElasticInferenceAcceleratorResponse {
    
    Type?: string;
    
    Count?: number;
}
export declare namespace LaunchTemplateElasticInferenceAcceleratorResponse {
    
    const filterSensitiveLog: (obj: LaunchTemplateElasticInferenceAcceleratorResponse) => any;
}

export interface LaunchTemplateEnclaveOptions {
    
    Enabled?: boolean;
}
export declare namespace LaunchTemplateEnclaveOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateEnclaveOptions) => any;
}

export interface LaunchTemplateHibernationOptions {
    
    Configured?: boolean;
}
export declare namespace LaunchTemplateHibernationOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateHibernationOptions) => any;
}

export interface LaunchTemplateIamInstanceProfileSpecification {
    
    Arn?: string;
    
    Name?: string;
}
export declare namespace LaunchTemplateIamInstanceProfileSpecification {
    
    const filterSensitiveLog: (obj: LaunchTemplateIamInstanceProfileSpecification) => any;
}

export interface LaunchTemplateSpotMarketOptions {
    
    MaxPrice?: string;
    
    SpotInstanceType?: SpotInstanceType | string;
    
    BlockDurationMinutes?: number;
    
    ValidUntil?: Date;
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace LaunchTemplateSpotMarketOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateSpotMarketOptions) => any;
}

export interface LaunchTemplateInstanceMarketOptions {
    
    MarketType?: MarketType | string;
    
    SpotOptions?: LaunchTemplateSpotMarketOptions;
}
export declare namespace LaunchTemplateInstanceMarketOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceMarketOptions) => any;
}

export interface LaunchTemplateLicenseConfiguration {
    
    LicenseConfigurationArn?: string;
}
export declare namespace LaunchTemplateLicenseConfiguration {
    
    const filterSensitiveLog: (obj: LaunchTemplateLicenseConfiguration) => any;
}
export declare type LaunchTemplateInstanceMetadataOptionsState = "applied" | "pending";

export interface LaunchTemplateInstanceMetadataOptions {
    
    State?: LaunchTemplateInstanceMetadataOptionsState | string;
    
    HttpTokens?: LaunchTemplateHttpTokensState | string;
    
    HttpPutResponseHopLimit?: number;
    
    HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | string;
    
    HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | string;
}
export declare namespace LaunchTemplateInstanceMetadataOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceMetadataOptions) => any;
}

export interface LaunchTemplatesMonitoring {
    
    Enabled?: boolean;
}
export declare namespace LaunchTemplatesMonitoring {
    
    const filterSensitiveLog: (obj: LaunchTemplatesMonitoring) => any;
}

export interface Ipv4PrefixSpecificationResponse {
    
    Ipv4Prefix?: string;
}
export declare namespace Ipv4PrefixSpecificationResponse {
    
    const filterSensitiveLog: (obj: Ipv4PrefixSpecificationResponse) => any;
}

export interface InstanceIpv6Address {
    
    Ipv6Address?: string;
}
export declare namespace InstanceIpv6Address {
    
    const filterSensitiveLog: (obj: InstanceIpv6Address) => any;
}

export interface Ipv6PrefixSpecificationResponse {
    
    Ipv6Prefix?: string;
}
export declare namespace Ipv6PrefixSpecificationResponse {
    
    const filterSensitiveLog: (obj: Ipv6PrefixSpecificationResponse) => any;
}

export interface LaunchTemplateInstanceNetworkInterfaceSpecification {
    
    AssociateCarrierIpAddress?: boolean;
    
    AssociatePublicIpAddress?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Description?: string;
    
    DeviceIndex?: number;
    
    Groups?: string[];
    
    InterfaceType?: string;
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: InstanceIpv6Address[];
    
    NetworkInterfaceId?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: PrivateIpAddressSpecification[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    SubnetId?: string;
    
    NetworkCardIndex?: number;
    
    Ipv4Prefixes?: Ipv4PrefixSpecificationResponse[];
    
    Ipv4PrefixCount?: number;
    
    Ipv6Prefixes?: Ipv6PrefixSpecificationResponse[];
    
    Ipv6PrefixCount?: number;
}
export declare namespace LaunchTemplateInstanceNetworkInterfaceSpecification {
    
    const filterSensitiveLog: (obj: LaunchTemplateInstanceNetworkInterfaceSpecification) => any;
}

export interface LaunchTemplatePlacement {
    
    AvailabilityZone?: string;
    
    Affinity?: string;
    
    GroupName?: string;
    
    HostId?: string;
    
    Tenancy?: Tenancy | string;
    
    SpreadDomain?: string;
    
    HostResourceGroupArn?: string;
    
    PartitionNumber?: number;
}
export declare namespace LaunchTemplatePlacement {
    
    const filterSensitiveLog: (obj: LaunchTemplatePlacement) => any;
}

export interface LaunchTemplatePrivateDnsNameOptions {
    
    HostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace LaunchTemplatePrivateDnsNameOptions {
    
    const filterSensitiveLog: (obj: LaunchTemplatePrivateDnsNameOptions) => any;
}

export interface LaunchTemplateTagSpecification {
    
    ResourceType?: ResourceType | string;
    
    Tags?: Tag[];
}
export declare namespace LaunchTemplateTagSpecification {
    
    const filterSensitiveLog: (obj: LaunchTemplateTagSpecification) => any;
}

export interface ResponseLaunchTemplateData {
    
    KernelId?: string;
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecification;
    
    BlockDeviceMappings?: LaunchTemplateBlockDeviceMapping[];
    
    NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecification[];
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KeyName?: string;
    
    Monitoring?: LaunchTemplatesMonitoring;
    
    Placement?: LaunchTemplatePlacement;
    
    RamDiskId?: string;
    
    DisableApiTermination?: boolean;
    
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
    
    UserData?: string;
    
    TagSpecifications?: LaunchTemplateTagSpecification[];
    
    ElasticGpuSpecifications?: ElasticGpuSpecificationResponse[];
    
    ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAcceleratorResponse[];
    
    SecurityGroupIds?: string[];
    
    SecurityGroups?: string[];
    
    InstanceMarketOptions?: LaunchTemplateInstanceMarketOptions;
    
    CreditSpecification?: CreditSpecification;
    
    CpuOptions?: LaunchTemplateCpuOptions;
    
    CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationResponse;
    
    LicenseSpecifications?: LaunchTemplateLicenseConfiguration[];
    
    HibernationOptions?: LaunchTemplateHibernationOptions;
    
    MetadataOptions?: LaunchTemplateInstanceMetadataOptions;
    
    EnclaveOptions?: LaunchTemplateEnclaveOptions;
    
    InstanceRequirements?: InstanceRequirements;
    
    PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptions;
}
export declare namespace ResponseLaunchTemplateData {
    
    const filterSensitiveLog: (obj: ResponseLaunchTemplateData) => any;
}

export interface LaunchTemplateVersion {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    VersionNumber?: number;
    
    VersionDescription?: string;
    
    CreateTime?: Date;
    
    CreatedBy?: string;
    
    DefaultVersion?: boolean;
    
    LaunchTemplateData?: ResponseLaunchTemplateData;
}
export declare namespace LaunchTemplateVersion {
    
    const filterSensitiveLog: (obj: LaunchTemplateVersion) => any;
}
export interface CreateLaunchTemplateVersionResult {
    
    LaunchTemplateVersion?: LaunchTemplateVersion;
    
    Warning?: ValidationWarning;
}
export declare namespace CreateLaunchTemplateVersionResult {
    
    const filterSensitiveLog: (obj: CreateLaunchTemplateVersionResult) => any;
}
export interface CreateLocalGatewayRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    LocalGatewayRouteTableId: string | undefined;
    
    LocalGatewayVirtualInterfaceGroupId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace CreateLocalGatewayRouteRequest {
    
    const filterSensitiveLog: (obj: CreateLocalGatewayRouteRequest) => any;
}
export declare type LocalGatewayRouteState = "active" | "blackhole" | "deleted" | "deleting" | "pending";
export declare type LocalGatewayRouteType = "propagated" | "static";

export interface LocalGatewayRoute {
    
    DestinationCidrBlock?: string;
    
    LocalGatewayVirtualInterfaceGroupId?: string;
    
    Type?: LocalGatewayRouteType | string;
    
    State?: LocalGatewayRouteState | string;
    
    LocalGatewayRouteTableId?: string;
    
    LocalGatewayRouteTableArn?: string;
    
    OwnerId?: string;
}
export declare namespace LocalGatewayRoute {
    
    const filterSensitiveLog: (obj: LocalGatewayRoute) => any;
}
export interface CreateLocalGatewayRouteResult {
    
    Route?: LocalGatewayRoute;
}
export declare namespace CreateLocalGatewayRouteResult {
    
    const filterSensitiveLog: (obj: CreateLocalGatewayRouteResult) => any;
}
export interface CreateLocalGatewayRouteTableVpcAssociationRequest {
    
    LocalGatewayRouteTableId: string | undefined;
    
    VpcId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateLocalGatewayRouteTableVpcAssociationRequest {
    
    const filterSensitiveLog: (obj: CreateLocalGatewayRouteTableVpcAssociationRequest) => any;
}

export interface LocalGatewayRouteTableVpcAssociation {
    
    LocalGatewayRouteTableVpcAssociationId?: string;
    
    LocalGatewayRouteTableId?: string;
    
    LocalGatewayRouteTableArn?: string;
    
    LocalGatewayId?: string;
    
    VpcId?: string;
    
    OwnerId?: string;
    
    State?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGatewayRouteTableVpcAssociation {
    
    const filterSensitiveLog: (obj: LocalGatewayRouteTableVpcAssociation) => any;
}
export interface CreateLocalGatewayRouteTableVpcAssociationResult {
    
    LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export declare namespace CreateLocalGatewayRouteTableVpcAssociationResult {
    
    const filterSensitiveLog: (obj: CreateLocalGatewayRouteTableVpcAssociationResult) => any;
}
export interface CreateManagedPrefixListRequest {
    
    DryRun?: boolean;
    
    PrefixListName: string | undefined;
    
    Entries?: AddPrefixListEntry[];
    
    MaxEntries: number | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    AddressFamily: string | undefined;
    
    ClientToken?: string;
}
export declare namespace CreateManagedPrefixListRequest {
    
    const filterSensitiveLog: (obj: CreateManagedPrefixListRequest) => any;
}
export declare type PrefixListState = "create-complete" | "create-failed" | "create-in-progress" | "delete-complete" | "delete-failed" | "delete-in-progress" | "modify-complete" | "modify-failed" | "modify-in-progress" | "restore-complete" | "restore-failed" | "restore-in-progress";

export interface ManagedPrefixList {
    
    PrefixListId?: string;
    
    AddressFamily?: string;
    
    State?: PrefixListState | string;
    
    StateMessage?: string;
    
    PrefixListArn?: string;
    
    PrefixListName?: string;
    
    MaxEntries?: number;
    
    Version?: number;
    
    Tags?: Tag[];
    
    OwnerId?: string;
}
export declare namespace ManagedPrefixList {
    
    const filterSensitiveLog: (obj: ManagedPrefixList) => any;
}
export interface CreateManagedPrefixListResult {
    
    PrefixList?: ManagedPrefixList;
}
export declare namespace CreateManagedPrefixListResult {
    
    const filterSensitiveLog: (obj: CreateManagedPrefixListResult) => any;
}
export declare enum ConnectivityType {
    PRIVATE = "private",
    PUBLIC = "public"
}
export interface CreateNatGatewayRequest {
    
    AllocationId?: string;
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    SubnetId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    ConnectivityType?: ConnectivityType | string;
}
export declare namespace CreateNatGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateNatGatewayRequest) => any;
}

export interface NatGatewayAddress {
    
    AllocationId?: string;
    
    NetworkInterfaceId?: string;
    
    PrivateIp?: string;
    
    PublicIp?: string;
}
export declare namespace NatGatewayAddress {
    
    const filterSensitiveLog: (obj: NatGatewayAddress) => any;
}

export interface ProvisionedBandwidth {
    
    ProvisionTime?: Date;
    
    Provisioned?: string;
    
    RequestTime?: Date;
    
    Requested?: string;
    
    Status?: string;
}
export declare namespace ProvisionedBandwidth {
    
    const filterSensitiveLog: (obj: ProvisionedBandwidth) => any;
}
export declare enum NatGatewayState {
    AVAILABLE = "available",
    DELETED = "deleted",
    DELETING = "deleting",
    FAILED = "failed",
    PENDING = "pending"
}

export interface NatGateway {
    
    CreateTime?: Date;
    
    DeleteTime?: Date;
    
    FailureCode?: string;
    
    FailureMessage?: string;
    
    NatGatewayAddresses?: NatGatewayAddress[];
    
    NatGatewayId?: string;
    
    ProvisionedBandwidth?: ProvisionedBandwidth;
    
    State?: NatGatewayState | string;
    
    SubnetId?: string;
    
    VpcId?: string;
    
    Tags?: Tag[];
    
    ConnectivityType?: ConnectivityType | string;
}
export declare namespace NatGateway {
    
    const filterSensitiveLog: (obj: NatGateway) => any;
}
export interface CreateNatGatewayResult {
    
    ClientToken?: string;
    
    NatGateway?: NatGateway;
}
export declare namespace CreateNatGatewayResult {
    
    const filterSensitiveLog: (obj: CreateNatGatewayResult) => any;
}
export interface CreateNetworkAclRequest {
    
    DryRun?: boolean;
    
    VpcId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateNetworkAclRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkAclRequest) => any;
}

export interface NetworkAclAssociation {
    
    NetworkAclAssociationId?: string;
    
    NetworkAclId?: string;
    
    SubnetId?: string;
}
export declare namespace NetworkAclAssociation {
    
    const filterSensitiveLog: (obj: NetworkAclAssociation) => any;
}

export interface IcmpTypeCode {
    
    Code?: number;
    
    Type?: number;
}
export declare namespace IcmpTypeCode {
    
    const filterSensitiveLog: (obj: IcmpTypeCode) => any;
}
export declare type RuleAction = "allow" | "deny";

export interface NetworkAclEntry {
    
    CidrBlock?: string;
    
    Egress?: boolean;
    
    IcmpTypeCode?: IcmpTypeCode;
    
    Ipv6CidrBlock?: string;
    
    PortRange?: PortRange;
    
    Protocol?: string;
    
    RuleAction?: RuleAction | string;
    
    RuleNumber?: number;
}
export declare namespace NetworkAclEntry {
    
    const filterSensitiveLog: (obj: NetworkAclEntry) => any;
}

export interface NetworkAcl {
    
    Associations?: NetworkAclAssociation[];
    
    Entries?: NetworkAclEntry[];
    
    IsDefault?: boolean;
    
    NetworkAclId?: string;
    
    Tags?: Tag[];
    
    VpcId?: string;
    
    OwnerId?: string;
}
export declare namespace NetworkAcl {
    
    const filterSensitiveLog: (obj: NetworkAcl) => any;
}
export interface CreateNetworkAclResult {
    
    NetworkAcl?: NetworkAcl;
}
export declare namespace CreateNetworkAclResult {
    
    const filterSensitiveLog: (obj: CreateNetworkAclResult) => any;
}
export interface CreateNetworkAclEntryRequest {
    
    CidrBlock?: string;
    
    DryRun?: boolean;
    
    Egress: boolean | undefined;
    
    IcmpTypeCode?: IcmpTypeCode;
    
    Ipv6CidrBlock?: string;
    
    NetworkAclId: string | undefined;
    
    PortRange?: PortRange;
    
    Protocol: string | undefined;
    
    RuleAction: RuleAction | string | undefined;
    
    RuleNumber: number | undefined;
}
export declare namespace CreateNetworkAclEntryRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkAclEntryRequest) => any;
}
export interface CreateNetworkInsightsAccessScopeRequest {
    
    MatchPaths?: AccessScopePathRequest[];
    
    ExcludePaths?: AccessScopePathRequest[];
    
    ClientToken?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateNetworkInsightsAccessScopeRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkInsightsAccessScopeRequest) => any;
}

export interface NetworkInsightsAccessScope {
    
    NetworkInsightsAccessScopeId?: string;
    
    NetworkInsightsAccessScopeArn?: string;
    
    CreatedDate?: Date;
    
    UpdatedDate?: Date;
    
    Tags?: Tag[];
}
export declare namespace NetworkInsightsAccessScope {
    
    const filterSensitiveLog: (obj: NetworkInsightsAccessScope) => any;
}

export interface NetworkInsightsAccessScopeContent {
    
    NetworkInsightsAccessScopeId?: string;
    
    MatchPaths?: AccessScopePath[];
    
    ExcludePaths?: AccessScopePath[];
}
export declare namespace NetworkInsightsAccessScopeContent {
    
    const filterSensitiveLog: (obj: NetworkInsightsAccessScopeContent) => any;
}
export interface CreateNetworkInsightsAccessScopeResult {
    
    NetworkInsightsAccessScope?: NetworkInsightsAccessScope;
    
    NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export declare namespace CreateNetworkInsightsAccessScopeResult {
    
    const filterSensitiveLog: (obj: CreateNetworkInsightsAccessScopeResult) => any;
}
export interface CreateNetworkInsightsPathRequest {
    
    SourceIp?: string;
    
    DestinationIp?: string;
    
    Source: string | undefined;
    
    Destination: string | undefined;
    
    Protocol: Protocol | string | undefined;
    
    DestinationPort?: number;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateNetworkInsightsPathRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkInsightsPathRequest) => any;
}

export interface NetworkInsightsPath {
    
    NetworkInsightsPathId?: string;
    
    NetworkInsightsPathArn?: string;
    
    CreatedDate?: Date;
    
    Source?: string;
    
    Destination?: string;
    
    SourceIp?: string;
    
    DestinationIp?: string;
    
    Protocol?: Protocol | string;
    
    DestinationPort?: number;
    
    Tags?: Tag[];
}
export declare namespace NetworkInsightsPath {
    
    const filterSensitiveLog: (obj: NetworkInsightsPath) => any;
}
export interface CreateNetworkInsightsPathResult {
    
    NetworkInsightsPath?: NetworkInsightsPath;
}
export declare namespace CreateNetworkInsightsPathResult {
    
    const filterSensitiveLog: (obj: CreateNetworkInsightsPathResult) => any;
}
export declare type NetworkInterfaceCreationType = "branch" | "efa" | "trunk";

export interface CreateNetworkInterfaceRequest {
    
    Description?: string;
    
    DryRun?: boolean;
    
    Groups?: string[];
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: InstanceIpv6Address[];
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: PrivateIpAddressSpecification[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
    
    Ipv4PrefixCount?: number;
    
    Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
    
    Ipv6PrefixCount?: number;
    
    InterfaceType?: NetworkInterfaceCreationType | string;
    
    SubnetId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
}
export declare namespace CreateNetworkInterfaceRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkInterfaceRequest) => any;
}

export interface NetworkInterfaceAssociation {
    
    AllocationId?: string;
    
    AssociationId?: string;
    
    IpOwnerId?: string;
    
    PublicDnsName?: string;
    
    PublicIp?: string;
    
    CustomerOwnedIp?: string;
    
    CarrierIp?: string;
}
export declare namespace NetworkInterfaceAssociation {
    
    const filterSensitiveLog: (obj: NetworkInterfaceAssociation) => any;
}

export interface NetworkInterfaceAttachment {
    
    AttachTime?: Date;
    
    AttachmentId?: string;
    
    DeleteOnTermination?: boolean;
    
    DeviceIndex?: number;
    
    NetworkCardIndex?: number;
    
    InstanceId?: string;
    
    InstanceOwnerId?: string;
    
    Status?: AttachmentStatus | string;
}
export declare namespace NetworkInterfaceAttachment {
    
    const filterSensitiveLog: (obj: NetworkInterfaceAttachment) => any;
}

export interface GroupIdentifier {
    
    GroupName?: string;
    
    GroupId?: string;
}
export declare namespace GroupIdentifier {
    
    const filterSensitiveLog: (obj: GroupIdentifier) => any;
}
export declare type NetworkInterfaceType = "efa" | "interface" | "natGateway" | "trunk";

export interface NetworkInterfaceIpv6Address {
    
    Ipv6Address?: string;
}
export declare namespace NetworkInterfaceIpv6Address {
    
    const filterSensitiveLog: (obj: NetworkInterfaceIpv6Address) => any;
}

export interface Ipv6PrefixSpecification {
    
    Ipv6Prefix?: string;
}
export declare namespace Ipv6PrefixSpecification {
    
    const filterSensitiveLog: (obj: Ipv6PrefixSpecification) => any;
}

export interface NetworkInterfacePrivateIpAddress {
    
    Association?: NetworkInterfaceAssociation;
    
    Primary?: boolean;
    
    PrivateDnsName?: string;
    
    PrivateIpAddress?: string;
}
export declare namespace NetworkInterfacePrivateIpAddress {
    
    const filterSensitiveLog: (obj: NetworkInterfacePrivateIpAddress) => any;
}
export declare type NetworkInterfaceStatus = "associated" | "attaching" | "available" | "detaching" | "in-use";

export interface NetworkInterface {
    
    Association?: NetworkInterfaceAssociation;
    
    Attachment?: NetworkInterfaceAttachment;
    
    AvailabilityZone?: string;
    
    Description?: string;
    
    Groups?: GroupIdentifier[];
    
    InterfaceType?: NetworkInterfaceType | string;
    
    Ipv6Addresses?: NetworkInterfaceIpv6Address[];
    
    MacAddress?: string;
    
    NetworkInterfaceId?: string;
    
    OutpostArn?: string;
    
    OwnerId?: string;
    
    PrivateDnsName?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: NetworkInterfacePrivateIpAddress[];
    
    Ipv4Prefixes?: Ipv4PrefixSpecification[];
    
    Ipv6Prefixes?: Ipv6PrefixSpecification[];
    
    RequesterId?: string;
    
    RequesterManaged?: boolean;
    
    SourceDestCheck?: boolean;
    
    Status?: NetworkInterfaceStatus | string;
    
    SubnetId?: string;
    
    TagSet?: Tag[];
    
    VpcId?: string;
    
    DenyAllIgwTraffic?: boolean;
    
    Ipv6Native?: boolean;
    
    Ipv6Address?: string;
}
export declare namespace NetworkInterface {
    
    const filterSensitiveLog: (obj: NetworkInterface) => any;
}

export interface CreateNetworkInterfaceResult {
    
    NetworkInterface?: NetworkInterface;
    
    ClientToken?: string;
}
export declare namespace CreateNetworkInterfaceResult {
    
    const filterSensitiveLog: (obj: CreateNetworkInterfaceResult) => any;
}
export declare type InterfacePermissionType = "EIP-ASSOCIATE" | "INSTANCE-ATTACH";

export interface CreateNetworkInterfacePermissionRequest {
    
    NetworkInterfaceId: string | undefined;
    
    AwsAccountId?: string;
    
    AwsService?: string;
    
    Permission: InterfacePermissionType | string | undefined;
    
    DryRun?: boolean;
}
export declare namespace CreateNetworkInterfacePermissionRequest {
    
    const filterSensitiveLog: (obj: CreateNetworkInterfacePermissionRequest) => any;
}
export declare type NetworkInterfacePermissionStateCode = "granted" | "pending" | "revoked" | "revoking";

export interface NetworkInterfacePermissionState {
    
    State?: NetworkInterfacePermissionStateCode | string;
    
    StatusMessage?: string;
}
export declare namespace NetworkInterfacePermissionState {
    
    const filterSensitiveLog: (obj: NetworkInterfacePermissionState) => any;
}

export interface NetworkInterfacePermission {
    
    NetworkInterfacePermissionId?: string;
    
    NetworkInterfaceId?: string;
    
    AwsAccountId?: string;
    
    AwsService?: string;
    
    Permission?: InterfacePermissionType | string;
    
    PermissionState?: NetworkInterfacePermissionState;
}
export declare namespace NetworkInterfacePermission {
    
    const filterSensitiveLog: (obj: NetworkInterfacePermission) => any;
}

export interface CreateNetworkInterfacePermissionResult {
    
    InterfacePermission?: NetworkInterfacePermission;
}
export declare namespace CreateNetworkInterfacePermissionResult {
    
    const filterSensitiveLog: (obj: CreateNetworkInterfacePermissionResult) => any;
}
export declare type PlacementStrategy = "cluster" | "partition" | "spread";
export interface CreatePlacementGroupRequest {
    
    DryRun?: boolean;
    
    GroupName?: string;
    
    Strategy?: PlacementStrategy | string;
    
    PartitionCount?: number;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreatePlacementGroupRequest {
    
    const filterSensitiveLog: (obj: CreatePlacementGroupRequest) => any;
}
export declare type PlacementGroupState = "available" | "deleted" | "deleting" | "pending";

export interface PlacementGroup {
    
    GroupName?: string;
    
    State?: PlacementGroupState | string;
    
    Strategy?: PlacementStrategy | string;
    
    PartitionCount?: number;
    
    GroupId?: string;
    
    Tags?: Tag[];
}
export declare namespace PlacementGroup {
    
    const filterSensitiveLog: (obj: PlacementGroup) => any;
}
export interface CreatePlacementGroupResult {
    
    PlacementGroup?: PlacementGroup;
}
export declare namespace CreatePlacementGroupResult {
    
    const filterSensitiveLog: (obj: CreatePlacementGroupResult) => any;
}
export interface CreatePublicIpv4PoolRequest {
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreatePublicIpv4PoolRequest {
    
    const filterSensitiveLog: (obj: CreatePublicIpv4PoolRequest) => any;
}
export interface CreatePublicIpv4PoolResult {
    
    PoolId?: string;
}
export declare namespace CreatePublicIpv4PoolResult {
    
    const filterSensitiveLog: (obj: CreatePublicIpv4PoolResult) => any;
}
export interface CreateReplaceRootVolumeTaskRequest {
    
    InstanceId: string | undefined;
    
    SnapshotId?: string;
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateReplaceRootVolumeTaskRequest {
    
    const filterSensitiveLog: (obj: CreateReplaceRootVolumeTaskRequest) => any;
}
export declare enum ReplaceRootVolumeTaskState {
    failed = "failed",
    failed_detached = "failed-detached",
    failing = "failing",
    in_progress = "in-progress",
    pending = "pending",
    succeeded = "succeeded"
}

export interface ReplaceRootVolumeTask {
    
    ReplaceRootVolumeTaskId?: string;
    
    InstanceId?: string;
    
    TaskState?: ReplaceRootVolumeTaskState | string;
    
    StartTime?: string;
    
    CompleteTime?: string;
    
    Tags?: Tag[];
}
export declare namespace ReplaceRootVolumeTask {
    
    const filterSensitiveLog: (obj: ReplaceRootVolumeTask) => any;
}
export interface CreateReplaceRootVolumeTaskResult {
    
    ReplaceRootVolumeTask?: ReplaceRootVolumeTask;
}
export declare namespace CreateReplaceRootVolumeTaskResult {
    
    const filterSensitiveLog: (obj: CreateReplaceRootVolumeTaskResult) => any;
}

export interface PriceScheduleSpecification {
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Price?: number;
    
    Term?: number;
}
export declare namespace PriceScheduleSpecification {
    
    const filterSensitiveLog: (obj: PriceScheduleSpecification) => any;
}

export interface CreateReservedInstancesListingRequest {
    
    ClientToken: string | undefined;
    
    InstanceCount: number | undefined;
    
    PriceSchedules: PriceScheduleSpecification[] | undefined;
    
    ReservedInstancesId: string | undefined;
}
export declare namespace CreateReservedInstancesListingRequest {
    
    const filterSensitiveLog: (obj: CreateReservedInstancesListingRequest) => any;
}

export interface CreateReservedInstancesListingResult {
    
    ReservedInstancesListings?: ReservedInstancesListing[];
}
export declare namespace CreateReservedInstancesListingResult {
    
    const filterSensitiveLog: (obj: CreateReservedInstancesListingResult) => any;
}
export interface CreateRestoreImageTaskRequest {
    
    Bucket: string | undefined;
    
    ObjectKey: string | undefined;
    
    Name?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateRestoreImageTaskRequest {
    
    const filterSensitiveLog: (obj: CreateRestoreImageTaskRequest) => any;
}
export interface CreateRestoreImageTaskResult {
    
    ImageId?: string;
}
export declare namespace CreateRestoreImageTaskResult {
    
    const filterSensitiveLog: (obj: CreateRestoreImageTaskResult) => any;
}
export interface CreateRouteRequest {
    
    DestinationCidrBlock?: string;
    
    DestinationIpv6CidrBlock?: string;
    
    DestinationPrefixListId?: string;
    
    DryRun?: boolean;
    
    VpcEndpointId?: string;
    
    EgressOnlyInternetGatewayId?: string;
    
    GatewayId?: string;
    
    InstanceId?: string;
    
    NatGatewayId?: string;
    
    TransitGatewayId?: string;
    
    LocalGatewayId?: string;
    
    CarrierGatewayId?: string;
    
    NetworkInterfaceId?: string;
    
    RouteTableId: string | undefined;
    
    VpcPeeringConnectionId?: string;
    
    CoreNetworkArn?: string;
}
export declare namespace CreateRouteRequest {
    
    const filterSensitiveLog: (obj: CreateRouteRequest) => any;
}
export interface CreateRouteResult {
    
    Return?: boolean;
}
export declare namespace CreateRouteResult {
    
    const filterSensitiveLog: (obj: CreateRouteResult) => any;
}
export interface CreateRouteTableRequest {
    
    DryRun?: boolean;
    
    VpcId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateRouteTableRequest {
    
    const filterSensitiveLog: (obj: CreateRouteTableRequest) => any;
}

export interface RouteTableAssociation {
    
    Main?: boolean;
    
    RouteTableAssociationId?: string;
    
    RouteTableId?: string;
    
    SubnetId?: string;
    
    GatewayId?: string;
    
    AssociationState?: RouteTableAssociationState;
}
export declare namespace RouteTableAssociation {
    
    const filterSensitiveLog: (obj: RouteTableAssociation) => any;
}

export interface PropagatingVgw {
    
    GatewayId?: string;
}
export declare namespace PropagatingVgw {
    
    const filterSensitiveLog: (obj: PropagatingVgw) => any;
}
export declare type RouteOrigin = "CreateRoute" | "CreateRouteTable" | "EnableVgwRoutePropagation";
export declare type RouteState = "active" | "blackhole";

export interface Route {
    
    DestinationCidrBlock?: string;
    
    DestinationIpv6CidrBlock?: string;
    
    DestinationPrefixListId?: string;
    
    EgressOnlyInternetGatewayId?: string;
    
    GatewayId?: string;
    
    InstanceId?: string;
    
    InstanceOwnerId?: string;
    
    NatGatewayId?: string;
    
    TransitGatewayId?: string;
    
    LocalGatewayId?: string;
    
    CarrierGatewayId?: string;
    
    NetworkInterfaceId?: string;
    
    Origin?: RouteOrigin | string;
    
    State?: RouteState | string;
    
    VpcPeeringConnectionId?: string;
    
    CoreNetworkArn?: string;
}
export declare namespace Route {
    
    const filterSensitiveLog: (obj: Route) => any;
}

export interface RouteTable {
    
    Associations?: RouteTableAssociation[];
    
    PropagatingVgws?: PropagatingVgw[];
    
    RouteTableId?: string;
    
    Routes?: Route[];
    
    Tags?: Tag[];
    
    VpcId?: string;
    
    OwnerId?: string;
}
export declare namespace RouteTable {
    
    const filterSensitiveLog: (obj: RouteTable) => any;
}
export interface CreateRouteTableResult {
    
    RouteTable?: RouteTable;
}
export declare namespace CreateRouteTableResult {
    
    const filterSensitiveLog: (obj: CreateRouteTableResult) => any;
}
export interface CreateSecurityGroupRequest {
    
    Description: string | undefined;
    
    GroupName: string | undefined;
    
    VpcId?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateSecurityGroupRequest {
    
    const filterSensitiveLog: (obj: CreateSecurityGroupRequest) => any;
}
export interface CreateSecurityGroupResult {
    
    GroupId?: string;
    
    Tags?: Tag[];
}
export declare namespace CreateSecurityGroupResult {
    
    const filterSensitiveLog: (obj: CreateSecurityGroupResult) => any;
}
export interface CreateSnapshotRequest {
    
    Description?: string;
    
    OutpostArn?: string;
    
    VolumeId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateSnapshotRequest {
    
    const filterSensitiveLog: (obj: CreateSnapshotRequest) => any;
}
export declare type SnapshotState = "completed" | "error" | "pending" | "recoverable" | "recovering";
export declare enum StorageTier {
    archive = "archive",
    standard = "standard"
}

export interface Snapshot {
    
    DataEncryptionKeyId?: string;
    
    Description?: string;
    
    Encrypted?: boolean;
    
    KmsKeyId?: string;
    
    OwnerId?: string;
    
    Progress?: string;
    
    SnapshotId?: string;
    
    StartTime?: Date;
    
    State?: SnapshotState | string;
    
    StateMessage?: string;
    
    VolumeId?: string;
    
    VolumeSize?: number;
    
    OwnerAlias?: string;
    
    OutpostArn?: string;
    
    Tags?: Tag[];
    
    StorageTier?: StorageTier | string;
    
    RestoreExpiryTime?: Date;
}
export declare namespace Snapshot {
    
    const filterSensitiveLog: (obj: Snapshot) => any;
}
export declare type CopyTagsFromSource = "volume";

export interface InstanceSpecification {
    
    InstanceId?: string;
    
    ExcludeBootVolume?: boolean;
}
export declare namespace InstanceSpecification {
    
    const filterSensitiveLog: (obj: InstanceSpecification) => any;
}
export interface CreateSnapshotsRequest {
    
    Description?: string;
    
    InstanceSpecification: InstanceSpecification | undefined;
    
    OutpostArn?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    CopyTagsFromSource?: CopyTagsFromSource | string;
}
export declare namespace CreateSnapshotsRequest {
    
    const filterSensitiveLog: (obj: CreateSnapshotsRequest) => any;
}

export interface SnapshotInfo {
    
    Description?: string;
    
    Tags?: Tag[];
    
    Encrypted?: boolean;
    
    VolumeId?: string;
    
    State?: SnapshotState | string;
    
    VolumeSize?: number;
    
    StartTime?: Date;
    
    Progress?: string;
    
    OwnerId?: string;
    
    SnapshotId?: string;
    
    OutpostArn?: string;
}
export declare namespace SnapshotInfo {
    
    const filterSensitiveLog: (obj: SnapshotInfo) => any;
}
export interface CreateSnapshotsResult {
    
    Snapshots?: SnapshotInfo[];
}
export declare namespace CreateSnapshotsResult {
    
    const filterSensitiveLog: (obj: CreateSnapshotsResult) => any;
}

export interface CreateSpotDatafeedSubscriptionRequest {
    
    Bucket: string | undefined;
    
    DryRun?: boolean;
    
    Prefix?: string;
}
export declare namespace CreateSpotDatafeedSubscriptionRequest {
    
    const filterSensitiveLog: (obj: CreateSpotDatafeedSubscriptionRequest) => any;
}

export interface SpotInstanceStateFault {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace SpotInstanceStateFault {
    
    const filterSensitiveLog: (obj: SpotInstanceStateFault) => any;
}
export declare type DatafeedSubscriptionState = "Active" | "Inactive";

export interface SpotDatafeedSubscription {
    
    Bucket?: string;
    
    Fault?: SpotInstanceStateFault;
    
    OwnerId?: string;
    
    Prefix?: string;
    
    State?: DatafeedSubscriptionState | string;
}
export declare namespace SpotDatafeedSubscription {
    
    const filterSensitiveLog: (obj: SpotDatafeedSubscription) => any;
}

export interface CreateSpotDatafeedSubscriptionResult {
    
    SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export declare namespace CreateSpotDatafeedSubscriptionResult {
    
    const filterSensitiveLog: (obj: CreateSpotDatafeedSubscriptionResult) => any;
}

export interface S3ObjectTag {
    
    Key?: string;
    
    Value?: string;
}
export declare namespace S3ObjectTag {
    
    const filterSensitiveLog: (obj: S3ObjectTag) => any;
}
export interface CreateStoreImageTaskRequest {
    
    ImageId: string | undefined;
    
    Bucket: string | undefined;
    
    S3ObjectTags?: S3ObjectTag[];
    
    DryRun?: boolean;
}
export declare namespace CreateStoreImageTaskRequest {
    
    const filterSensitiveLog: (obj: CreateStoreImageTaskRequest) => any;
}
export interface CreateStoreImageTaskResult {
    
    ObjectKey?: string;
}
export declare namespace CreateStoreImageTaskResult {
    
    const filterSensitiveLog: (obj: CreateStoreImageTaskResult) => any;
}
export interface CreateSubnetRequest {
    
    TagSpecifications?: TagSpecification[];
    
    AvailabilityZone?: string;
    
    AvailabilityZoneId?: string;
    
    CidrBlock?: string;
    
    Ipv6CidrBlock?: string;
    
    OutpostArn?: string;
    
    VpcId: string | undefined;
    
    DryRun?: boolean;
    
    Ipv6Native?: boolean;
}
export declare namespace CreateSubnetRequest {
    
    const filterSensitiveLog: (obj: CreateSubnetRequest) => any;
}
export interface CreateSubnetResult {
    
    Subnet?: Subnet;
}
export declare namespace CreateSubnetResult {
    
    const filterSensitiveLog: (obj: CreateSubnetResult) => any;
}
export declare enum SubnetCidrReservationType {
    explicit = "explicit",
    prefix = "prefix"
}
export interface CreateSubnetCidrReservationRequest {
    
    TagSpecifications?: TagSpecification[];
    
    SubnetId: string | undefined;
    
    Cidr: string | undefined;
    
    ReservationType: SubnetCidrReservationType | string | undefined;
    
    Description?: string;
    
    DryRun?: boolean;
}
export declare namespace CreateSubnetCidrReservationRequest {
    
    const filterSensitiveLog: (obj: CreateSubnetCidrReservationRequest) => any;
}

export interface SubnetCidrReservation {
    
    SubnetCidrReservationId?: string;
    
    SubnetId?: string;
    
    Cidr?: string;
    
    ReservationType?: SubnetCidrReservationType | string;
    
    OwnerId?: string;
    
    Description?: string;
    
    Tags?: Tag[];
}
export declare namespace SubnetCidrReservation {
    
    const filterSensitiveLog: (obj: SubnetCidrReservation) => any;
}
export interface CreateSubnetCidrReservationResult {
    
    SubnetCidrReservation?: SubnetCidrReservation;
}
export declare namespace CreateSubnetCidrReservationResult {
    
    const filterSensitiveLog: (obj: CreateSubnetCidrReservationResult) => any;
}
export interface CreateTagsRequest {
    
    DryRun?: boolean;
    
    Resources: string[] | undefined;
    
    Tags: Tag[] | undefined;
}
export declare namespace CreateTagsRequest {
    
    const filterSensitiveLog: (obj: CreateTagsRequest) => any;
}
export interface CreateTrafficMirrorFilterRequest {
    
    Description?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorFilterRequest {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorFilterRequest) => any;
}

export interface TrafficMirrorPortRange {
    
    FromPort?: number;
    
    ToPort?: number;
}
export declare namespace TrafficMirrorPortRange {
    
    const filterSensitiveLog: (obj: TrafficMirrorPortRange) => any;
}
export declare type TrafficMirrorRuleAction = "accept" | "reject";
export declare type TrafficDirection = "egress" | "ingress";

export interface TrafficMirrorFilterRule {
    
    TrafficMirrorFilterRuleId?: string;
    
    TrafficMirrorFilterId?: string;
    
    TrafficDirection?: TrafficDirection | string;
    
    RuleNumber?: number;
    
    RuleAction?: TrafficMirrorRuleAction | string;
    
    Protocol?: number;
    
    DestinationPortRange?: TrafficMirrorPortRange;
    
    SourcePortRange?: TrafficMirrorPortRange;
    
    DestinationCidrBlock?: string;
    
    SourceCidrBlock?: string;
    
    Description?: string;
}
export declare namespace TrafficMirrorFilterRule {
    
    const filterSensitiveLog: (obj: TrafficMirrorFilterRule) => any;
}
export declare type TrafficMirrorNetworkService = "amazon-dns";

export interface TrafficMirrorFilter {
    
    TrafficMirrorFilterId?: string;
    
    IngressFilterRules?: TrafficMirrorFilterRule[];
    
    EgressFilterRules?: TrafficMirrorFilterRule[];
    
    NetworkServices?: (TrafficMirrorNetworkService | string)[];
    
    Description?: string;
    
    Tags?: Tag[];
}
export declare namespace TrafficMirrorFilter {
    
    const filterSensitiveLog: (obj: TrafficMirrorFilter) => any;
}
export interface CreateTrafficMirrorFilterResult {
    
    TrafficMirrorFilter?: TrafficMirrorFilter;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorFilterResult {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorFilterResult) => any;
}

export interface TrafficMirrorPortRangeRequest {
    
    FromPort?: number;
    
    ToPort?: number;
}
export declare namespace TrafficMirrorPortRangeRequest {
    
    const filterSensitiveLog: (obj: TrafficMirrorPortRangeRequest) => any;
}
export interface CreateTrafficMirrorFilterRuleRequest {
    
    TrafficMirrorFilterId: string | undefined;
    
    TrafficDirection: TrafficDirection | string | undefined;
    
    RuleNumber: number | undefined;
    
    RuleAction: TrafficMirrorRuleAction | string | undefined;
    
    DestinationPortRange?: TrafficMirrorPortRangeRequest;
    
    SourcePortRange?: TrafficMirrorPortRangeRequest;
    
    Protocol?: number;
    
    DestinationCidrBlock: string | undefined;
    
    SourceCidrBlock: string | undefined;
    
    Description?: string;
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorFilterRuleRequest {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorFilterRuleRequest) => any;
}
export interface CreateTrafficMirrorFilterRuleResult {
    
    TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorFilterRuleResult {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorFilterRuleResult) => any;
}
export interface CreateTrafficMirrorSessionRequest {
    
    NetworkInterfaceId: string | undefined;
    
    TrafficMirrorTargetId: string | undefined;
    
    TrafficMirrorFilterId: string | undefined;
    
    PacketLength?: number;
    
    SessionNumber: number | undefined;
    
    VirtualNetworkId?: number;
    
    Description?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorSessionRequest {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorSessionRequest) => any;
}

export interface TrafficMirrorSession {
    
    TrafficMirrorSessionId?: string;
    
    TrafficMirrorTargetId?: string;
    
    TrafficMirrorFilterId?: string;
    
    NetworkInterfaceId?: string;
    
    OwnerId?: string;
    
    PacketLength?: number;
    
    SessionNumber?: number;
    
    VirtualNetworkId?: number;
    
    Description?: string;
    
    Tags?: Tag[];
}
export declare namespace TrafficMirrorSession {
    
    const filterSensitiveLog: (obj: TrafficMirrorSession) => any;
}
export interface CreateTrafficMirrorSessionResult {
    
    TrafficMirrorSession?: TrafficMirrorSession;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorSessionResult {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorSessionResult) => any;
}
export interface CreateTrafficMirrorTargetRequest {
    
    NetworkInterfaceId?: string;
    
    NetworkLoadBalancerArn?: string;
    
    Description?: string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorTargetRequest {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorTargetRequest) => any;
}
export declare type TrafficMirrorTargetType = "network-interface" | "network-load-balancer";

export interface TrafficMirrorTarget {
    
    TrafficMirrorTargetId?: string;
    
    NetworkInterfaceId?: string;
    
    NetworkLoadBalancerArn?: string;
    
    Type?: TrafficMirrorTargetType | string;
    
    Description?: string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace TrafficMirrorTarget {
    
    const filterSensitiveLog: (obj: TrafficMirrorTarget) => any;
}
export interface CreateTrafficMirrorTargetResult {
    
    TrafficMirrorTarget?: TrafficMirrorTarget;
    
    ClientToken?: string;
}
export declare namespace CreateTrafficMirrorTargetResult {
    
    const filterSensitiveLog: (obj: CreateTrafficMirrorTargetResult) => any;
}
export declare type AutoAcceptSharedAttachmentsValue = "disable" | "enable";
export declare type DefaultRouteTableAssociationValue = "disable" | "enable";
export declare type DefaultRouteTablePropagationValue = "disable" | "enable";
export declare type MulticastSupportValue = "disable" | "enable";
export declare type VpnEcmpSupportValue = "disable" | "enable";

export interface TransitGatewayRequestOptions {
    
    AmazonSideAsn?: number;
    
    AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
    
    DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
    
    DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
    
    VpnEcmpSupport?: VpnEcmpSupportValue | string;
    
    DnsSupport?: DnsSupportValue | string;
    
    MulticastSupport?: MulticastSupportValue | string;
    
    TransitGatewayCidrBlocks?: string[];
}
export declare namespace TransitGatewayRequestOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayRequestOptions) => any;
}
export interface CreateTransitGatewayRequest {
    
    Description?: string;
    
    Options?: TransitGatewayRequestOptions;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayRequest) => any;
}

export interface TransitGatewayOptions {
    
    AmazonSideAsn?: number;
    
    TransitGatewayCidrBlocks?: string[];
    
    AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | string;
    
    DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | string;
    
    AssociationDefaultRouteTableId?: string;
    
    DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | string;
    
    PropagationDefaultRouteTableId?: string;
    
    VpnEcmpSupport?: VpnEcmpSupportValue | string;
    
    DnsSupport?: DnsSupportValue | string;
    
    MulticastSupport?: MulticastSupportValue | string;
}
export declare namespace TransitGatewayOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayOptions) => any;
}
export declare type TransitGatewayState = "available" | "deleted" | "deleting" | "modifying" | "pending";

export interface TransitGateway {
    
    TransitGatewayId?: string;
    
    TransitGatewayArn?: string;
    
    State?: TransitGatewayState | string;
    
    OwnerId?: string;
    
    Description?: string;
    
    CreationTime?: Date;
    
    Options?: TransitGatewayOptions;
    
    Tags?: Tag[];
}
export declare namespace TransitGateway {
    
    const filterSensitiveLog: (obj: TransitGateway) => any;
}
export interface CreateTransitGatewayResult {
    
    TransitGateway?: TransitGateway;
}
export declare namespace CreateTransitGatewayResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayResult) => any;
}
export declare type ProtocolValue = "gre";

export interface CreateTransitGatewayConnectRequestOptions {
    
    Protocol: ProtocolValue | string | undefined;
}
export declare namespace CreateTransitGatewayConnectRequestOptions {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectRequestOptions) => any;
}
export interface CreateTransitGatewayConnectRequest {
    
    TransportTransitGatewayAttachmentId: string | undefined;
    
    Options: CreateTransitGatewayConnectRequestOptions | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayConnectRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectRequest) => any;
}

export interface TransitGatewayConnectOptions {
    
    Protocol?: ProtocolValue | string;
}
export declare namespace TransitGatewayConnectOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayConnectOptions) => any;
}

export interface TransitGatewayConnect {
    
    TransitGatewayAttachmentId?: string;
    
    TransportTransitGatewayAttachmentId?: string;
    
    TransitGatewayId?: string;
    
    State?: TransitGatewayAttachmentState | string;
    
    CreationTime?: Date;
    
    Options?: TransitGatewayConnectOptions;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayConnect {
    
    const filterSensitiveLog: (obj: TransitGatewayConnect) => any;
}
export interface CreateTransitGatewayConnectResult {
    
    TransitGatewayConnect?: TransitGatewayConnect;
}
export declare namespace CreateTransitGatewayConnectResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectResult) => any;
}

export interface TransitGatewayConnectRequestBgpOptions {
    
    PeerAsn?: number;
}
export declare namespace TransitGatewayConnectRequestBgpOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayConnectRequestBgpOptions) => any;
}
export interface CreateTransitGatewayConnectPeerRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    TransitGatewayAddress?: string;
    
    PeerAddress: string | undefined;
    
    BgpOptions?: TransitGatewayConnectRequestBgpOptions;
    
    InsideCidrBlocks: string[] | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayConnectPeerRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectPeerRequest) => any;
}
export declare type BgpStatus = "down" | "up";

export interface TransitGatewayAttachmentBgpConfiguration {
    
    TransitGatewayAsn?: number;
    
    PeerAsn?: number;
    
    TransitGatewayAddress?: string;
    
    PeerAddress?: string;
    
    BgpStatus?: BgpStatus | string;
}
export declare namespace TransitGatewayAttachmentBgpConfiguration {
    
    const filterSensitiveLog: (obj: TransitGatewayAttachmentBgpConfiguration) => any;
}
