import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { TerminateInstancesRequest, TerminateInstancesResult } from "../models/models_6";
export interface TerminateInstancesCommandInput extends TerminateInstancesRequest {
}
export interface TerminateInstancesCommandOutput extends TerminateInstancesResult, __MetadataBearer {
}

export declare class TerminateInstancesCommand extends $Command<TerminateInstancesCommandInput, TerminateInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: TerminateInstancesCommandInput;
    constructor(input: TerminateInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<TerminateInstancesCommandInput, TerminateInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
