import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ReleaseIpamPoolAllocationRequest, ReleaseIpamPoolAllocationResult } from "../models/models_5";
export interface ReleaseIpamPoolAllocationCommandInput extends ReleaseIpamPoolAllocationRequest {
}
export interface ReleaseIpamPoolAllocationCommandOutput extends ReleaseIpamPoolAllocationResult, __MetadataBearer {
}

export declare class ReleaseIpamPoolAllocationCommand extends $Command<ReleaseIpamPoolAllocationCommandInput, ReleaseIpamPoolAllocationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ReleaseIpamPoolAllocationCommandInput;
    constructor(input: ReleaseIpamPoolAllocationCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ReleaseIpamPoolAllocationCommandInput, ReleaseIpamPoolAllocationCommandOutput>;
    private serialize;
    private deserialize;
}
