import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ReleaseHostsRequest, ReleaseHostsResult } from "../models/models_5";
export interface ReleaseHostsCommandInput extends ReleaseHostsRequest {
}
export interface ReleaseHostsCommandOutput extends ReleaseHostsResult, __MetadataBearer {
}

export declare class ReleaseHostsCommand extends $Command<ReleaseHostsCommandInput, ReleaseHostsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ReleaseHostsCommandInput;
    constructor(input: ReleaseHostsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ReleaseHostsCommandInput, ReleaseHostsCommandOutput>;
    private serialize;
    private deserialize;
}
